<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::get('/',['as'=>'home','uses'=>'HomeController@getHome']);
Route::get('/menu/{id}/{name}','HomeController@menu');
Route::get('contact-us',['as'=>'contact-us','uses'=>'HomeController@getContact']);
Route::post('contact-send',['as'=>'contact-send','uses'=>'HomeController@postContact']);

Route::get('user-login',['as'=>'user-login','uses'=>'HomeController@getLogIn']);
Route::post('user-login',['as'=>'user-login','uses'=>'MemberAuthController@postLogIn']);
Route::get('user-registration',['as'=>'user-registration','uses'=>'HomeController@getRegistration']);
Route::post('user-registration',['as'=>'registration-post','uses'=>'HomeController@postRegistration']);
Route::get('user-logout',['as'=>'user-logout','uses'=>'MemberAuthController@logout']);

//Authentication Route List
Route::get('/admin', ['as'=>'login', 'uses'=>'AdminAuthController@getLogin']);
Route::post('/admin', ['as'=>'admin-login', 'uses'=>'AdminAuthController@postLogin']);
Route::get('/logout', ['as'=>'logout','uses'=>'AdminAuthController@logout']);

/* Admin password Change*/
Route::get('changepass', ['as'=>'change-pass', 'uses'=>'WebSettingController@getChangePass']);
Route::post('changepass', ['as'=>'change-pass', 'uses'=>'WebSettingController@postChangePass']);

/* Admin Dashboard Route List */
Route::get('dashboard',['as'=>'dashboard','uses'=>'DashboardController@getDashboard']);
/*WebSetting Route List*/
Route::get('general-setting', ['as'=>'general-setting', 'uses'=>'WebSettingController@getGeneralSetting']);
Route::put('general-setting/{id}', ['as'=>'update_general', 'uses'=>'WebSettingController@putGeneralSetting']);

/*Currency Route List */
Route::get('currency-create',['as'=>'currency-create','uses'=>'DashboardController@createCurrency']);
Route::post('currency-create', ['as'=>'currency_store','uses'=>'DashboardController@storeCurrency']);
Route::get('currency', ['as'=>'currency_show','uses'=>'DashboardController@showCurrency']);
Route::get('currency-edit/{id}', ['as'=>'currency_edit','uses'=>'DashboardController@editCurrency']);
Route::put('currency-edit/{id}', ['as'=>'currency_update','uses'=>'DashboardController@updateCurrency']);
Route::delete('currency-delete', ['as'=>'currency_delete','uses'=>'DashboardController@deleteCurrency']);

/* Menu Route List*/
Route::get('menu-create',['as'=>'menu_create','uses'=>'WebSettingController@getMenuCreate']);
Route::post('menu-create',['as'=>'menu_create','uses'=>'WebSettingController@postMenuCreate']);
Route::get('menu-show',['as'=>'menu_show','uses'=>'WebSettingController@showMenuCreate']);
Route::get('menu-edit/{id}',['as'=>'menu-edit','uses'=>'WebSettingController@editMenuCreate']);
Route::put('menu-edit/{id}',['as'=>'menu-update','uses'=>'WebSettingController@updateMenuCreate']);
Route::delete('menu-delete/{id}',['as'=>'menu-delete','uses'=>'WebSettingController@deleteMenuCreate']);

/* Testimonial Route List */
Route::get('manage-testimonial',['as'=>'manage-testimonial','uses'=>'DashboardController@mangeTestimonial']);
Route::post('manage-testimonial',['as'=>'manage-testimonial','uses'=>'DashboardController@storeTestimonial']);
Route::get('testimonial-edit/{id}',['as'=>'testimonial-edit','uses'=>'DashboardController@editTestimonial']);
Route::put('testimonial-edit/{id}',['as'=>'testimonial-update','uses'=>'DashboardController@updateTestimonial']);
Route::delete('testimonial-delete',['as'=>'testimonial-delete','uses'=>'DashboardController@deleteTestimonial']);

/* Slider Setting */
Route::get('slider', ['as'=>'slider', 'uses' =>'WebSettingController@getSlider']);
Route::post('slider', ['as'=>'post_slider', 'uses' =>'WebSettingController@postSlider']);
Route::delete('slider-delete', ['as'=>'slider-delete', 'uses' =>'WebSettingController@deleteSlider']);


/* Ad Route List */
Route::get('ad-create',['as'=>'ad-create','uses'=>'DashboardController@createAd']);
Route::post('ad-create',['as'=>'ad-create','uses'=>'DashboardController@storeAd']);
Route::get('ad-show',['as'=>'ad-show','uses'=>'DashboardController@showAd']);
Route::get('ad-edit/{id}',['as'=>'ad-edit','uses'=>'DashboardController@editAd']);
Route::put('ad-edit/{id}',['as'=>'ad-update','uses'=>'DashboardController@updateAd']);

/* Video Advertisement Route List */
Route::get('video-create',['as'=>'video-create','uses'=>'DashboardController@createVideo']);
Route::post('video-create',['as'=>'video-create','uses'=>'DashboardController@storeVideo']);
Route::get('video-show',['as'=>'video-show','uses'=>'DashboardController@showVideo']);
Route::get('video-edit/{id}',['as'=>'video-edit','uses'=>'DashboardController@editVideo']);
Route::put('video-edit/{id}',['as'=>'video-update','uses'=>'DashboardController@updateVideo']);


/* Limitation Route List */
Route::get('manage-limit',['as'=>'manage-limit','uses'=>'DashboardController@showLimit']);
Route::put('manage-limit/{id}',['as'=>'manage-limit-update','uses'=>'DashboardController@updateLimit']);

/* Withdraw Method Create*/
Route::get('method-create',['as'=>'method-create','uses'=>'DashboardController@createMethod']);
Route::post('method-create',['as'=>'method-create','uses'=>'DashboardController@storeMethod']);
Route::get('method-show',['as'=>'method-show','uses'=>'DashboardController@showMethod']);
Route::get('method-edit/{id}',['as'=>'method-edit','uses'=>'DashboardController@editMethod']);
Route::put('method-edit/{id}',['as'=>'method-update','uses'=>'DashboardController@updateMethod']);

/* Withdraw Request */
Route::get('withdraw-request',['as'=>'withdraw-request','uses'=>'DashboardController@requestWithdraw']);
Route::post('withdraw-request',['as'=>'withdraw-request','uses'=>'DashboardController@changeRequestWithdraw']);

/* ------------------ User Route List ------------*/

/* User Dashboard Controller */
Route::get('user-dashboard',['as'=>'user-dashboard','uses'=>'MemberController@getDashboard']);
Route::get('user-change-pass',['as'=>'user-change-pass','uses'=>'MemberController@changePassword']);
Route::post('user-change-pass',['as'=>'user-change-pass','uses'=>'MemberController@postPassword']);

/* User Advertisement Route List */
Route::get('user-advertisement',['as'=>'user-advertisement','uses'=>'MemberController@memberAdvertisement']);
Route::get('user-advert-show/{id}',['as'=>'user-advert-show','uses'=>'MemberController@showMemberAdvert']);
Route::put('user-advert-show/{id}',['as'=>'advert-confirm','uses'=>'MemberController@confirmAdvertisement']);

/* Video Advertisement Route List */
Route::get('video-advertisement',['as'=>'video-advertisement','uses'=>'MemberController@memberVideoAdvertisement']);
Route::get('video-advert-show/{id}',['as'=>'video-advert-show','uses'=>'MemberController@showMemberVideoAdvert']);
Route::put('video-advert-show/{id}',['as'=>'video-advert-confirm','uses'=>'MemberController@confirmVideoAdvertisement']);

/* user payment Withdraw*/

Route::get('withdraw-create',['as'=>'withdraw-create','uses'=>'MemberController@createWithdraw']);
Route::post('withdraw-create',['as'=>'withdraw-create','uses'=>'MemberController@storeWithdraw']);
Route::get('withdraw-show',['as'=>'withdraw-show','uses'=>'MemberController@showWithdraw']);


Route::get('home2',['as'=>'home2','uses'=>'HomeController@getHome2']);


/* user Forget Password */
Route::get('user-forget-password',['as'=>'user-forget-password','uses'=>'HomeController@getForgetPassword']);
Route::get('user-password-reset/{token}',['as'=>'user-password-reset','uses'=>'HomeController@resetForgetPassword']);
Route::post('user-forget-password-submit',['as'=>'user-forget-password-submit','uses'=>'HomeController@submitForgetPassword']);
Route::post('user-reset-password-submit',['as'=>'user-reset-password-submit','uses'=>'HomeController@ResetSubmitPassword']);

/* Plan Route List */
Route::get('plan-create',['as'=>'plan-create','uses'=>'DashboardController@createPlan']);
Route::post('plan-create',['as'=>'plan-create','uses'=>'DashboardController@storePlan']);
Route::get('plan-show',['as'=>'plan-show','uses'=>'DashboardController@showPlan']);
Route::get('plan-edit/{id}',['as'=>'plan-edit','uses'=>'DashboardController@editPlan']);
Route::put('plan-edit/{id}',['as'=>'plan-update','uses'=>'DashboardController@updatePlan']);

/* Admin _Payment Method*/
Route::get('payment-method',['as'=>'payment-method','uses'=>'DashboardController@getPaymentMethod']);
Route::post('payment-method',['as'=>'payment-method','uses'=>'DashboardController@updatePaymentMethod']);

/* Route deposit Fund */

Route::get('deposit-fund',['as'=>'deposit-fund','uses'=>'MemberController@depositFund']);
Route::post('deposit-fund',['as'=>'deposit-fund','uses'=>'MemberController@submitDepositFund']);
Route::get('deposit-history',['as'=>'deposit-history','uses'=>'MemberController@depositHistory']);

Route::post('paypal-ipn',['as'=>'paypal-ipn','uses'=>'HomeController@paypalIpn']);
Route::post('perfect-ipn',['as'=>'perfect-ipn','uses'=>'HomeController@perfectIPN']);
Route::post('stripe-preview',['as'=>'stripe-preview','uses'=>'HomeController@stripePreview']);
Route::post('stripe-submit',['as'=>'stripe-submit','uses'=>'HomeController@submitStripe']);
Route::post('btc-preview',['as'=>'btc-preview','uses'=>'HomeController@btcPreview']);
Route::get('btc_ipn/{invoice_id}/{secret}',['as'=>'btc_ipn','uses'=>'HomeController@btcIPN']);


/* Route manage Advertisement */
Route::get('advert-plan',['as'=>'advert-plan','uses'=>'MemberController@advertPlan']);
Route::post('advert-start',['as'=>'advert-start','uses'=>'MemberController@advertStart']);

Route::post('member-create-advert',['as'=>'member-create-advert','uses'=>'MemberController@MemberCreateAdvert']);

Route::get('advert-history',['as'=>'advert-history','uses'=>'MemberController@advertHistory']);

Route::get('member-ptc-advert',['as'=>'member-ptc-advert','uses'=>'MemberController@ptcAdvert']);
Route::get('member-video-advert',['as'=>'member-video-advert','uses'=>'MemberController@videoAdvert']);

Route::get('ptc-advert',['as'=>'ptc-advert','uses'=>'DashboardController@ptcAdvert']);

Route::post('ptc-accept',['as'=>'ptc-accept','uses'=>'DashboardController@ptcAccept']);
Route::post('ptc-reject',['as'=>'ptc-reject','uses'=>'DashboardController@ptcReject']);

Route::get('video-advert',['as'=>'video-advert','uses'=>'DashboardController@videoAdvert']);
Route::post('video-accept',['as'=>'video-accept','uses'=>'DashboardController@videoAccept']);
Route::post('video-reject',['as'=>'video-reject','uses'=>'DashboardController@videoReject']);



