<?php

namespace App\Http\Controllers;

use App\Advert;
use App\Advertisement;
use App\Deposit;
use App\GeneralSetting;
use App\Limit;
use App\Member;
use App\Method;
use App\PaymentLog;
use App\PaymentMethod;
use App\Plan;
use App\VideoAd;
use App\VideoAdvert;
use App\Withdraw;
use Illuminate\Http\Request;

use App\Http\Requests;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

class MemberController extends Controller
{
    public function __construct()
    {
        $data = [];
        $this->middleware('auth:member');
        $general_all = GeneralSetting::first();
        $this->site_title = $general_all->title;
        $this->gen_phone = $general_all->number;
        $this->gen_email = $general_all->email;
        $this->site_currency = $general_all->currency;
    }
    public function getDashboard()
    {
        session()->forget('message');
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Member Dashboard";
        $data['total_ad'] = Advertisement::all()->count();
        $data['total_video'] = VideoAd::all()->count();
        $data['total_user'] = Member::all()->count();
        return view('member.dashboard',$data);
    }
    public function changePassword()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Member Password Change";
        return view('member.change-pass',$data);
    }
    public function postPassword(Request $request)
    {
        
        $this->validate($request, [
            'current_password' =>'required',
            'password' => 'required|min:5|confirmed'
        ]);

        try {
            $c_password = Auth::guard('member')->user()->password;
            $c_id = Auth::guard('member')->user()->id;

            $user = Member::findOrFail($c_id);

            if(Hash::check($request->current_password, $c_password)){

                $password = Hash::make($request->password);
                $user->password = $password;
                $user->save();
                session()->flash('message', 'Password Changes Successfully.');
                Session::flash('type', 'success');
                return redirect()->back();
            }else{
                session()->flash('message', 'Password Not Match.');
                Session::flash('type', 'warning');
                return redirect()->back();
            }

        } catch (\PDOException $e) {
            session()->flash('message', 'Some Problem Occurs, Please Try Again!');
            Session::flash('type', 'danger');
            return redirect()->back();
        }
    }
    public function memberAdvertisement()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "User Advertisement";
        $data['site_currency'] = $this->site_currency;
        $user_id = Auth::guard('member')->user()->id;
        $ad = Advert::whereMember_id($user_id)->where('date','=',date('d-m-Y'))->count();
        $limit = Limit::first();
        $ad_limit = $limit->ad;
        if ($ad == 0)
        {
            $ads = Advertisement::inRandomOrder()->take($ad_limit)->whereStatus(0)->whereP_status(1)->get();
            foreach ($ads as $ab)
            {
                $a['member_id'] = $user_id;
                $a['date'] = date('d-m-Y');
                $a['advertisement_id'] = $ab->id;
                Advert::create($a);
            }
            $data['ad'] = Advert::whereMember_id($user_id)->where('date','=',date('d-m-Y'))->get();
            return view('member.user-advertisement',$data);
        }else{
            $data['ad'] = Advert::whereMember_id($user_id)->where('date','=',date('d-m-Y'))->get();
            return view('member.user-advertisement',$data);
        }

    }

    public function showMemberAdvert($id)
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Show Advertisement";
        $data['ad'] = Advert::findOrFail($id);
        return view('member.ptc-view',$data);
    }
    public function confirmAdvertisement(Request $request,$id)
    {
        $this->validate($request,[
            'result' => 'required'
        ]);
        $result = $request->num1 + $request->num2;

        if ($result != $request->result)
        {
            session()->flash('message', 'Your Imputed Summation Result Not Correct.');
            Session::flash('type', 'warning');
            return redirect()->back();
        }
        $ad = Advert::findOrFail($id);
        $ad->status = 1;
        $ad->save();

        $a = Advertisement::where('id','=',$ad->advertisement_id)->first();
        $a->hit = $a->hit + 1;
        if ($a->hit == $a->limit)
        {
            $a->status = 1;
            $a->save();
        }
        $u = Member::whereId(Auth::guard('member')->user()->id)->first();
        $u->balance = $u->balance + $a->price;
        $a->save();
        $u->save();
        session()->flash('message', 'Advertisement View Successfully Confirmed.');
        Session::flash('type', 'success');
        Session::flash('title', 'Success');
        $data['site_title'] = $this->site_title;
        $data['site_currency'] = $this->site_currency;
        $data['page_title'] = "User Advertisement";
        $user_id = Auth::guard('member')->user()->id;
        $data['ad'] = Advert::whereMember_id($user_id)->where('date','=',date('d-m-Y'))->get();
        return view('member.user-advertisement',$data);
    }
    public function memberVideoAdvertisement()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "User Video Advertisement";
        $data['site_currency'] = $this->site_currency;
        $user_id = Auth::guard('member')->user()->id;
        $ad = VideoAdvert::whereMember_id($user_id)->where('date','=',date('d-m-Y'))->count();
        $limit = Limit::first();
        $ad_limit = $limit->video;
        if ($ad == 0)
        {
            $ads = VideoAd::inRandomOrder()->take($ad_limit)->whereStatus(0)->whereP_status(1)->get();
            foreach ($ads as $ab)
            {
                $a['member_id'] = $user_id;
                $a['date'] = date('d-m-Y');
                $a['video_ad_id'] = $ab->id;
                VideoAdvert::create($a);
            }
            $data['ad'] = VideoAdvert::whereMember_id($user_id)->where('date','=',date('d-m-Y'))->get();
            return view('member.video-advertisement',$data);
        }else{
            $data['ad'] = VideoAdvert::whereMember_id($user_id)->where('date','=',date('d-m-Y'))->get();
            return view('member.video-advertisement',$data);
        }
    }
    public function showMemberVideoAdvert($id)
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Show Advertisement";
        $data['ad'] = VideoAdvert::findOrFail($id);
        return view('member.video-view',$data);
    }
    public function confirmVideoAdvertisement(Request $request,$id)
    {
        $this->validate($request,[
            'result' => 'required'
        ]);
        $result = $request->num1 + $request->num2;

        if ($result != $request->result)
        {
            session()->flash('message', 'Your Imputed Summation Result Not Correct.');
            Session::flash('type', 'warning');
            return redirect()->back();
        }
        $ad = VideoAdvert::findOrFail($id);
        $ad->status = 1;
        $ad->save();

        $a = VideoAd::where('id','=',$ad->video_ad_id)->first();
        $a->hit = $a->hit + 1;
        if ($a->hit == $a->limit)
        {
            $a->status = 1;
            $a->save();
        }
        $u = Member::whereId(Auth::guard('member')->user()->id)->first();
        $u->balance = $u->balance + $a->price;
        $a->save();
        $u->save();
        session()->flash('message', 'Advertisement View Successfully Confirmed.');
        Session::flash('type', 'success');
        Session::flash('title', 'Success');
        $data['site_title'] = $this->site_title;
        $data['site_currency'] = $this->site_currency;
        $data['page_title'] = "User Advertisement";
        $user_id = Auth::guard('member')->user()->id;
        $data['ad'] = VideoAdvert::whereMember_id($user_id)->where('date','=',date('d-m-Y'))->get();
        return view('member.video-advertisement',$data);
    }



    public function createWithdraw()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "User Payment Withdraw";
        $data['method'] = Method::all();
        return view('member.withdraw-create',$data);
    }
    public function storeWithdraw(Request $request)
    {
        
        
        $this->validate($request,[
           'method_id' => 'required',
            'balance' => 'required',
            'details' => 'required'
        ]);
        $limit = Limit::first();

        if ($limit->payment > $request->balance)
        {
            session()->flash('message', 'Withdraw is Lower Then Withdraw Minimum Balance.');
            Session::flash('type', 'warning');
            return redirect()->back();
        }elseif ($request->balance > Auth::guard('member')->user()->balance){
            session()->flash('message', 'Withdraw Balance is Large Then Your Current Balance.');
            Session::flash('type', 'warning');
            return redirect()->back();
        }
        else{
            $lim = Input::except('_method','_token');
            $lim['member_id'] = Auth::guard('member')->user()->id;
            Withdraw::create($lim);
            $a = Member::findOrFail(Auth::guard('member')->user()->id);
            $a->balance = $a->balance - $request->balance;
            $a->save();
            session()->flash('message', 'Withdraw Request Completed.Wait For Confirmation.');
            Session::flash('type', 'success');
            return redirect()->back();
        }

    }
    public function showWithdraw()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "User Withdraw History";
        $data['withdraw'] = Withdraw::orderBy('id','DESC')->whereMember_id(Auth::guard('member')->user()->id)->get();
        return view('member.withdraw-show',$data);
    }
    public function depositFund()
    {
        $data['site_title'] = $this->site_title;
        $data['site_currency'] = $this->site_currency;
        $data['page_title'] = "User Deposit Fund";
        $data['paypal'] = PaymentMethod::whereId(1)->first();
        $data['perfect'] = PaymentMethod::whereId(2)->first();
        $data['btc'] = PaymentMethod::whereId(3)->first();
        $data['stripe'] = PaymentMethod::whereId(4)->first();
        return view('member.deposit-fund',$data);
    }
    public function submitDepositFund(Request $request)
    {
        $this->validate($request,[
           'amount' => 'required',
        ]);

        $lo['member_id'] = Auth::guard('member')->user()->id;
        $lo['custom'] = Str::random(40);
        $lo['amount'] = $request->amount;
        $lo['payment_type'] = $request->payment_type;
        $yy = PaymentLog::whereMember_id($lo['member_id'])->whereAmount($lo['amount'])->whereStatus(0)->count();
        if ($yy == 0) {
            $data['fund'] = PaymentLog::create($lo);
        }else{
            $data['fund'] = PaymentLog::whereMember_id($lo['member_id'])->whereAmount($lo['amount'])->whereStatus(0)->first();
        }
        $data['site_title'] = $this->site_title;
        $data['site_currency'] = $this->site_currency;
        $data['page_title'] = "User Deposit Preview";
        $data['paypal'] = PaymentMethod::whereId(1)->first();
        $data['perfect'] = PaymentMethod::whereId(2)->first();
        $data['btc'] = PaymentMethod::whereId(3)->first();
        $data['stripe'] = PaymentMethod::whereId(4)->first();
        return view('member.deposit-preview',$data);
    }
    public function depositHistory()
    {
        $data['site_title'] = $this->site_title;
        $data['site_currency'] = $this->site_currency;
        $data['page_title'] = "User Deposit History";
        $data['deposit'] = Deposit::orderBy('id','DESC')->whereMember_id(Auth::guard('member')->user()->id)->get();
        return view('member.deposit-history',$data);
    }

    public function advertPlan()
    {
        $data['site_title'] = $this->site_title;
        $data['site_currency'] = $this->site_currency;
        $data['page_title'] = "User Advertisement";
        $data['plan'] = Plan::orderBy('id','desc')->whereStatus(1)->get();
        return view('member.advert-plan',$data);
    }
    public function advertStart(Request $request)
    {
        $data['site_title'] = $this->site_title;
        $data['site_currency'] = $this->site_currency;
        $data['page_title'] = "User Advertisement";
        $data['type'] = $request->ad_type;
        $data['plan'] = $request->id;
        return view('member.advert-create',$data);
    }
    public function MemberCreateAdvert(Request $request)
    {
        
        
        $this->validate($request,[
           'type' => 'required',
            'plan' => 'required',
        ]);
        $mem = Member::findOrFail(Auth::guard('member')->user()->id);
        $plan = Plan::findOrFail($request->plan);
        if (Auth::guard('member')->user()->balance < $plan->price){
            session()->flash('message', 'Sorry You have Insufficient Balance.');
            Session::flash('type', 'warning');
            Session::flash('title', 'Opps');
            return redirect()->route('deposit-fund');
        }else{
            $type = $request->type;
            if($type == 1) {
                $pp['title'] = $request->title;
                $pp['link'] = $request->link;
                $pp['limit'] = $plan->click;
                $pp['plan_id'] = $plan->id;
                $pp['p_status'] = 0;
                $pp['member_id'] = Auth::guard('member')->user()->id;
                Advertisement::create($pp);
                $mem->balance = $mem->balance - $plan->price;
                $mem->save();
                session()->flash('message', 'Advertisement Successfully Created.Wait for Confirmation');
                Session::flash('type', 'success');
                Session::flash('title', 'Well Done.');
                return redirect()->route('advert-plan');
            }elseif ($type == 2){
                $pp['title'] = $request->title;
                $pp['code'] = $request->code;
                $pp['limit'] = $plan->click;
                $pp['plan_id'] = $plan->id;
                $pp['p_status'] = 0;
                $pp['member_id'] = Auth::guard('member')->user()->id;
                VideoAd::create($pp);
                $mem->balance = $mem->balance - $plan->price;
                $mem->save();
                session()->flash('message', 'Advertisement Successfully Created.Wait for Confirmation');
                Session::flash('type', 'success');
                Session::flash('title', 'Well Done.');
                return redirect()->route('advert-plan');
            }
        }

    }
    public function advertHistory()
    {
        $data['site_title'] = $this->site_title;
        $data['site_currency'] = $this->site_currency;
        $data['page_title'] = "User Advertisement History";
        $data['advert'] = Plan::orderBy('id','desc')->whereStatus(1)->get();
        return view('member.advert-plan',$data);
    }
    public function ptcAdvert()
    {
        $data['site_title'] = $this->site_title;
        $data['site_currency'] = $this->site_currency;
        $data['page_title'] = "User PTC Advertisement History";
        $data['advert'] = Advertisement::orderBy('id','desc')->whereMember_id(Auth::guard('member')->user()->id)->get();
        return view('member.advert-ptc',$data);
    }
    public function videoAdvert()
    {
        $data['site_title'] = $this->site_title;
        $data['site_currency'] = $this->site_currency;
        $data['page_title'] = "User Video Advertisement History";
        $data['advert'] = VideoAd::orderBy('id','desc')->whereMember_id(Auth::guard('member')->user()->id)->get();
        return view('member.advert-video',$data);
    }






}
