<?php

namespace App\Http\Controllers;

use App\Advertisement;
use App\Category;
use App\Currency;
use App\File;
use App\Limit;
use App\Member;
use App\Method;
use App\PaymentMethod;
use App\Plan;
use App\SubCategory;
use App\Testimonial;
use App\VideoAd;
use App\Withdraw;
use Illuminate\Http\Request;
use App\GeneralSetting;
use Illuminate\Support\Facades\Session;
use Intervention\Image\Facades\Image;
use Validator;
use Response;
use Illuminate\Support\Facades\Input;

class DashboardController extends Controller
{
    public function __construct()
    {
        $data = [];
        $this->middleware('auth:admin');
        $general_all = GeneralSetting::first();
        $this->site_title = $general_all->title;
        $this->gen_phone = $general_all->number;
        $this->gen_email = $general_all->email;
        $this->site_currency = $general_all->currency;

    }
    public function getDashboard()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Dashboard";
        $data['total_ad'] = Advertisement::all()->count();
        $data['total_video'] = VideoAd::all()->count();
        $data['total_user'] = Member::all()->count();
        $data['total_ad_view'] = Advertisement::selectRaw('SUM(hit) as total')->first();
        $data['total_video_view'] = VideoAd::selectRaw('SUM(hit) as total')->first();
        return view('dashboard.dashboard',$data);
    }
    public function createCurrency()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Create Currency";
        return view('dashboard.currency-create',$data);
    }

    public function storeCurrency(Request $request)
    {
        
        $this->validate($request,[
            'name' => 'required|unique:currencies,name',
            'rate' => 'required'
        ]);
        try {
            $curr = Input::except('_method','_token');
            Currency::create($curr);
            session()->flash('message', 'Currency Create Successfully.');
            Session::flash('type', 'success');
            return redirect()->back();
        } catch (\PDOException $e) {
            session()->flash('message', 'Some Problem Occurs, Please Try Again!');
            Session::flash('type', 'danger');
            return redirect()->back();
        }
    }

    public function showCurrency()
    {
        $general = GeneralSetting::first();
        $data['site_title'] = $general->title;
        $data['page_title'] = "All Currency";
        $data['currency'] = Currency::orderBy('id','ASC')->paginate(100);
        return view('dashboard.currency-show',$data);
    }

    public function editCurrency($id)
    {
        $general = GeneralSetting::first();
        $data['site_title'] = $general->title;
        $data['page_title'] = "Edit Currency";
        $data['currency'] = Currency::findOrFail($id);
        return view('dashboard.currency-edit',$data);

    }

    public function updateCurrency(Request $request,$id)
    {
        
        $curr = Currency::findOrFail($id);
        $this->validate($request,[
            'name' => 'required|unique:currencies,name,'.$curr->id,
            'rate' =>'required'
        ]);
        try {
            $currency = Input::except('_method','_token');
            $curr->fill($currency)->save();
            session()->flash('message', 'Currency Updated Successfully.');
            Session::flash('type', 'success');
            return redirect()->back();
        } catch (\PDOException $e) {
            session()->flash('message', 'Some Problem Occurs, Please Try Again!');
            Session::flash('type', 'danger');
            return redirect()->back();
        }
    }
    public function deleteCurrency(Request $request)
    {
        
        
        try {
            if ($request->input('id') === '') {
                session()->flash('message', 'Oops, bad request!');
                Session::flash('type', 'danger');
                return redirect()->back();
            }else{
                $currency = Currency::findOrFail($request->input('id'));
                $currency->delete();
                session()->flash('message', 'Currency Deleted Successfully.');
                Session::flash('type', 'success');
                return redirect()->back();
            }

        } catch (\PDOException $e) {
            session()->flash('message', 'Some Problem Occurs, Please Try Again!');
            Session::flash('type', 'danger');
            return redirect()->back();
        }
    }
    public function createAd()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Create New PTC Advertisement";
        $data['currency'] = Currency::all();
        $data['site_currency'] = $this->site_currency;
        return view('dashboard.ad-create',$data);
    }
    public function storeAd(Request $request)
    {
    
        
        $this->validate($request,[
           'title' => 'required',
            'link' => 'required',
            'image' => 'mimes:png,jpg,jpeg',
            'price' => 'required|numeric',
            'limit' => 'required'
        ]);
        /*if ($request->image == null and $request->iframe ==null)
        {
            session()->flash('message', 'Please Select Image Or iFrame.!');
            Session::flash('type', 'warning');
            return redirect()->back();
        }*/
        $ad = Input::except('_method','_token');
        /*if($request->hasFile('image')){
            $image = $request->file('image');
            $filename = time().'.'.$image->getClientOriginalExtension();
            $location = 'images/' . $filename;
            Image::make($image)->save($location);
            $ad['image'] = $filename;
        }*/
        Advertisement::create($ad);
        session()->flash('message', 'Advertisement Created Successfully.');
        Session::flash('title', 'Success');
        Session::flash('type', 'success');
        return redirect()->back();
    }
    public function showAd()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Show All PTC Advertisement";
        $data['site_currency'] = $this->site_currency;
        $data['ad'] = Advertisement::orderBy('id','DESC')->whereP_status(1)->paginate(100);
        return view('dashboard.ad-show',$data);
    }
    public function editAd($id)
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Edit PTC Advertisement";
        $data['ad'] = Advertisement::findOrFail($id);
        $data['currency'] = Currency::all();
        $data['site_currency'] = $this->site_currency;
        return view('dashboard.ad-edit',$data);
    }
    public function updateAd(Request $request,$id)
    {
        
        
        $ad = Advertisement::findOrFail($id);
        $this->validate($request,[
            'title' => 'required',
            'link' => 'required',
            'image' => 'mimes:png,jpg,jpeg',
            'price' => 'required|numeric',
            'limit' => 'required'
        ]);
        $a = Input::except('_method','_token');
        /*if($request->hasFile('image')){
            $image = $request->file('image');
            $filename = time().'.'.$image->getClientOriginalExtension();
            $location = 'images/' . $filename;
            Image::make($image)->save($location);
            $a['image'] = $filename;
        }*/
        $ad->fill($a)->save();
        session()->flash('message', 'Advertisement Updated Successfully.');
        Session::flash('title', 'success');
        Session::flash('type', 'success');
        return redirect()->back();
    }
    public function createVideo()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Create New Video Advertisement";
        $data['site_currency'] = $this->site_currency;
        return view('dashboard.video-create',$data);
    }
    public function storeVideo(Request $request)
    {
        
        
        $this->validate($request,[
            'title' => 'required',
            'code' => 'required',
            'price' => 'required|numeric',
            'limit' => 'required'
        ]);

        $ad = Input::except('_method','_token');
        VideoAd::create($ad);
        session()->flash('message', 'Advertisement Created Successfully.');
        Session::flash('title', 'Success');
        Session::flash('type', 'success');
        return redirect()->back();
    }
    public function showVideo()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Show All Video Advertisement";
        $data['site_currency'] = $this->site_currency;
        $data['ad'] = VideoAd::orderBy('id','DESC')->whereP_status(1)->paginate(100);
        return view('dashboard.video-show',$data);
    }
    public function editVideo($id)
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Edit Video Advertisement";
        $data['ad'] = VideoAd::findOrFail($id);
        $data['site_currency'] = $this->site_currency;
        return view('dashboard.video-edit',$data);
    }
    public function updateVideo(Request $request,$id)
    {
        
        $ad = VideoAd::findOrFail($id);
        $this->validate($request,[
            'title' => 'required',
            'code' => 'required',
            'price' => 'required|numeric',
            'limit' => 'required'
        ]);
        $a = Input::except('_method','_token');
        $ad->fill($a)->save();
        session()->flash('message', 'Advertisement Updated Successfully.');
        Session::flash('title', 'success');
        Session::flash('type', 'success');
        return redirect()->back();
    }

    public function mangeTestimonial()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Mange Testimonial";
        $data['test'] = Testimonial::all();
        return view('dashboard.testimonial-manage',$data);
    }
    public function storeTestimonial(Request $request)
    {
        
        $this->validate($request,[
            'name' => 'required',
            'description' => 'required'
        ]);
        Testimonial::create($request->all());
        session()->flash('message', 'Testimonial Created Successfully.');
        Session::flash('type', 'success');
        return redirect()->back();
    }
    public function editTestimonial($id)
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = "Mange Testimonial";
        $data['testimonial'] = Testimonial::findOrFail($id);
        $data['test'] = Testimonial::all();
        return view('dashboard.testimonial-edit',$data);
    }
    public function updateTestimonial(Request $request,$id)
    {
        
        
        $this->validate($request,[
            'name' => 'required',
            'description' => 'required'
        ]);
        $test = Testimonial::findOrFail($id);
        $test->fill($request->all())->save();
        session()->flash('message', 'Testimonial Updated Successfully.');
        Session::flash('type', 'success');
        return redirect()->back();
    }
    public function deleteTestimonial(Request $request)
    {
        
        
        try {
            if ($request->input('id') === '') {
                session()->flash('message', 'Oops, bad request!');
                Session::flash('type', 'danger');
                return redirect()->back();
            }else{
                Testimonial::destroy($request->input('id'));
                session()->flash('message', 'Testimonial Deleted Successfully.');
                Session::flash('type', 'success');
                return redirect()->back();
            }

        } catch (\PDOException $e) {
            session()->flash('message', 'Some Problem Occurs, Please Try Again!');
            Session::flash('type', 'danger');
            return redirect()->back();
        }
    }
    public function showLimit()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = 'Limitation';
        $data['limit'] = Limit::first();
        return view('dashboard.limit-show',$data);
    }
    public function updateLimit(Request $request,$id)
    {
        
        
        $this->validate($request,[
           'payment' => 'required|numeric',
           'ad' => 'required|numeric',
           'video' => 'required|numeric'
        ]);
        $limit = Limit::findOrFail($id);
        $limit->fill($request->all())->save();
        session()->flash('message', 'Limitation Updated Successfully.');
        Session::flash('type', 'success');
        return redirect()->back();
    }
    public function createMethod()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = 'Withdraw Method';
        return view('dashboard.method-create',$data);
    }
    public function storeMethod(Request $request)
    {
        $this->validate($request,[
           'name' => 'required'
        ]);
        Method::create($request->all());
        session()->flash('message', 'Method Created Successfully.');
        Session::flash('type', 'success');
        return redirect()->back();
    }
    public function showMethod()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = 'All Withdraw Method';
        $data['method'] = Method::all();
        return view('dashboard.method-show',$data);
    }
    public function editMethod($id)
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = 'Edit Withdraw Method';
        $data['method'] = Method::findOrfail($id);
        return view('dashboard.method-edit',$data);
    }
    public function updateMethod(Request $request,$id)
    {
        
        $this->validate($request,[
           'name' => 'required'
        ]);
        $method = Method::findOrFail($id);
        $method->fill($request->all())->save();
        session()->flash('message', 'Method Updated Successfully.');
        Session::flash('type', 'success');
        return redirect()->back();
    }
    public function requestWithdraw()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = 'All Withdraw Request';
        $data['withdraw'] = Withdraw::orderBy('id','DESC')->get();
        $data['site_currency'] = $this->site_currency;
        return view('dashboard.withdraw-request',$data);
    }
    public function changeRequestWithdraw(Request $request)
    {
        
        $this->validate($request,[
           'status' => 'required',
           'withdraw_id' => 'required'
        ]);
        if($request->status == 1)
        {
            $w = Withdraw::findOrFail($request->withdraw_id);
            $w->status = 1;
            $w->save();
            session()->flash('message', 'Withdraw Completed Successfully.');
            Session::flash('type', 'success');
            return redirect()->back();
        }else{
            $w = Withdraw::findOrFail($request->withdraw_id);
            $w->status = 2;
            $member = Member::findOrFail($w->member_id);
            $member->balance = $member->balance + $w->balance;
            $w->save();
            $member->save();
            session()->flash('message', 'Withdraw Refunded Successfully.');
            Session::flash('type', 'success');
            return redirect()->back();
        }

    }
    public function createPlan()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = 'Plan Create';
        $data['site_currency'] = $this->site_currency;
        return view('dashboard.plan-create',$data);
    }
    public function storePlan(Request $request)
    {
        
        $this->validate($request,[
           'name' => 'required|unique:plans,name',
            'price' => 'required',
            'click' => 'required',
        ]);
        $in = Input::except('_method','_token');
        $in['status'] = $request->status == 'on' ? '1' : '0';
        Plan::create($in);
        session()->flash('message', 'Plan Created Successfully.');
        Session::flash('type', 'success');
        Session::flash('title', 'Success');
        return redirect()->back();
    }
    public function showPlan()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = 'All Plan';
        $data['site_currency'] = $this->site_currency;
        $data['plan'] = Plan::orderBy('id','desc')->get();
        return view('dashboard.plan-show',$data);
    }
    public function editPlan($id)
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = 'Plan Edit';
        $data['site_currency'] = $this->site_currency;
        $data['plan'] = Plan::findOrFail($id);
        return view('dashboard.plan-edit',$data);
    }
    public function updatePlan(Request $request,$id)
    {
    
        
        $ii = Plan::findOrFail($id);
        $this->validate($request,[
           'name' => 'required|unique:plans,name,'.$ii->id,
            'price' => 'required',
            'click' => 'required',
        ]);
        $in = Input::except('_method','_token');
        $in['status'] = $request->status == 'on' ? '1' : '0';
        $ii->fill($in)->save();
        session()->flash('message', 'Plan Updated Successfully.');
        Session::flash('type', 'success');
        Session::flash('title', 'Success');
        return redirect()->back();
    }
    public function getPaymentMethod()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = 'Deposit Method';
        $data['site_currency'] = $this->site_currency;
        $data['paypal'] = PaymentMethod::whereId(1)->first();
        $data['perfect'] = PaymentMethod::whereId(2)->first();
        $data['btc'] = PaymentMethod::whereId(3)->first();
        $data['stripe'] = PaymentMethod::whereId(4)->first();
        return view('dashboard.payment-method',$data);
    }
    public function updatePaymentMethod(Request $request)
    {
        

        $this->validate($request,[
            'paypal_name' => 'required',
            'paypal_image' => 'mimes:png,jpeg,jpg',
            'paypal_email' => 'required',
            'perfect_name' => 'required',
            'perfect_image' => 'mimes:png,jpeg,jpg',
            'perfect_account' => 'required',
            'perfect_alternate' => 'required',
            'btc_name' => 'required',
            'btc_image' => 'mimes:png,jpeg,jpg',
            'btc_api' => 'required',
            'btc_xpub' => 'required',
            'stripe_name' => 'required',
            'stripe_image' => 'mimes:png,jpeg,jpg',
            'stripe_secret' => 'required',
            'stripe_publishable' => 'required',
        ]);

        $paypal = PaymentMethod::whereId(1)->first();
        $perfect = PaymentMethod::whereId(2)->first();
        $btc = PaymentMethod::whereId(3)->first();
        $stripe = PaymentMethod::whereId(4)->first();

        $paypal->name = $request->paypal_name;
        $paypal->val1 = $request->paypal_email;
        $paypal->status = $request->paypal_status == 'on' ? '1' : '0';
        if($request->hasFile('paypal_image')){
            $image3 = $request->file('paypal_image');
            $filename3 = time().'h3'.'.'.$image3->getClientOriginalExtension();
            $location = 'images/' . $filename3;
            Image::make($image3)->resize(400,400)->save($location);
            $paypal->image = $filename3;
        }

        $perfect->name = $request->perfect_name;
        $perfect->val1 = $request->perfect_account;
        $perfect->val2 = $request->perfect_alternate;
        $perfect->status = $request->perfect_status == 'on' ? '1' : '0';
        if($request->hasFile('perfect_image')){
            $image3 = $request->file('perfect_image');
            $filename3 = time().'h4'.'.'.$image3->getClientOriginalExtension();
            $location = 'images/' . $filename3;
            Image::make($image3)->resize(400,400)->save($location);
            $perfect->image = $filename3;
        }

        $btc->name = $request->btc_name;
        $btc->val1 = $request->btc_api;
        $btc->val2 = $request->btc_xpub;
        $btc->status = $request->btc_status == 'on' ? '1' : '0';
        if($request->hasFile('btc_image')){
            $image3 = $request->file('btc_image');
            $filename3 = time().'h5'.'.'.$image3->getClientOriginalExtension();
            $location = 'images/' . $filename3;
            Image::make($image3)->resize(400,400)->save($location);
            $btc->image = $filename3;
        }

        $stripe->name = $request->stripe_name;
        $stripe->val1 = $request->stripe_secret;
        $stripe->val2 = $request->stripe_publishable;
        $stripe->status = $request->stripe_status == 'on' ? '1' : '0';
        if($request->hasFile('stripe_image')){
            $image3 = $request->file('stripe_image');
            $filename3 = time().'h6'.'.'.$image3->getClientOriginalExtension();
            $location = 'images/' . $filename3;
            Image::make($image3)->resize(400,400)->save($location);
            $stripe->image = $filename3;
        }

        $paypal->save();
        $perfect->save();
        $btc->save();
        $stripe->save();

        session()->flash('message', 'Payment Method Updated Successfully.');
        Session::flash('type', 'success');
        Session::flash('title', 'Success');
        return redirect()->back();

    }
    public function ptcAdvert()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = 'PTC Advert';
        $data['site_currency'] = $this->site_currency;
        $data['advert'] = Advertisement::orderBy('id','desc')->whereP_status(0)->get();
        return view('dashboard.advert-ptc',$data);
    }
    public function ptcAccept(Request $request)
    {
        
        
        $this->validate($request,[
            'id' => 'required',
            'price' => 'required'
        ]);
        $ad = Advertisement::findorFail($request->id);
        $ad->p_status = 1;
        $ad->price = $request->price;
        $ad->save();
        session()->flash('message', 'Advertisement Successfully Accepted.');
        Session::flash('type', 'success');
        Session::flash('title', 'Success');
        return redirect()->back();
    }
    public function ptcReject(Request $request)
    {
       
        
        $this->validate($request,[
            'id' => 'required',
        ]);
        $ad = Advertisement::findorFail($request->id);
        $mem = Member::findOrFail($ad->member_id);
        $plan = Plan::findOrFail($ad->plan_id);
        $mem->balance = $mem->balance + $plan->price;
        $mem->save();
        $ad->p_status = 2;
        $ad->save();
        session()->flash('message', 'Advertisement Successfully Rejected.');
        Session::flash('type', 'success');
        Session::flash('title', 'Success');
        return redirect()->back();
    }
    public function VideoAdvert()
    {
        $data['site_title'] = $this->site_title;
        $data['page_title'] = 'Video Advert';
        $data['site_currency'] = $this->site_currency;
        $data['advert'] = VideoAd::orderBy('id','desc')->whereP_status(0)->get();
        return view('dashboard.advert-video',$data);
    }
    public function videoAccept(Request $request)
    {
        
        
        $this->validate($request,[
            'id' => 'required',
            'price' => 'required'
        ]);
        $ad = VideoAd::findorFail($request->id);
        $ad->p_status = 1;
        $ad->price = $request->price;
        $ad->save();
        session()->flash('message', 'Advertisement Successfully Accepted.');
        Session::flash('type', 'success');
        Session::flash('title', 'Success');
        return redirect()->back();
    }
    public function videoReject(Request $request)
    {
        
        
        $this->validate($request,[
            'id' => 'required',
        ]);
        $ad = VideoAd::findorFail($request->id);
        $mem = Member::findOrFail($ad->member_id);
        $plan = Plan::findOrFail($ad->plan_id);
        $mem->balance = $mem->balance + $plan->price;
        $mem->save();
        $ad->p_status = 2;
        $ad->save();
        session()->flash('message', 'Advertisement Successfully Rejected.');
        Session::flash('type', 'success');
        Session::flash('title', 'Success');
        return redirect()->back();
    }


}
