<?php
/**
 * Plugin Name: Progress Map by CodeSpacing
 * Plugin URI: http://codecanyon.net/item/progress-map-wordpress-plugin/5581719?ref=codespacing
 * Description: <strong>Progress Map</strong> is a Wordpress plugin for location listings. With this plugin, your locations will be listed on both Google map (as markers) and a carousel (as locations details), this one will be related to the map, which means that the selected item in the carousel will target its location in the map and vice versa.
 * Version: 3.8
 * Author: اسکریپت دات کام
 * Author URI: http://www.اسکریپت.com
 * Text Domain: cspm
 * Domain Path: /languages
 */
 
if(!defined('ABSPATH')){
    exit; // Exit if accessed directly
}

if(!class_exists('CSProgressMap')){
	
	class CSProgressMap{
		
		private static $_this;
		
		public $plugin_version = '3.8';
			
		private $plugin_path;
		private $plugin_url;
			
		public $cspm_plugin_path;
		public $cspm_plugin_url;
			
		public $prefix;
		public $metafield_prefix;
		
		private $plugin_get_var = 'cs_progress_map_plugin';
		
		private $cspm_wpsf;
	
		public $plugin_settings = array();
		public $shared_plugin_settings = array();
		
		/**
		 * The name of the post to which we'll add the metaboxes
		 * @since 1.0 */
		 
		public $object_type;
				
		/**
		 * Plugin settings */
		 
		public $post_types = array('post');
		public $outer_links_field_name = ''; //@since 2.5				
		public $custom_list_columns = 'no'; //@since 2.6.3
		public $use_with_wpml = 'no'; //@since 2.6.3
		public $latitude_field_name = 'codespacing_progress_map_lat'; // @since 2.5		
		public $longitude_field_name = 'codespacing_progress_map_lng'; // @since 2.5

		/**
		 * Default Map settings */
		
		public $api_key = ''; //@since 2.8
		public $map_language = 'en';
		public $center = '51.53096,-0.121064';			
		public $wrong_center_point = false;
		public $initial_map_style = 'ROADMAP';
		public $zoom = '12';
		public $useClustring = 'true';
		public $gridSize = '60';
		public $mapTypeControl = 'true';
		public $streetViewControl = 'false';
		public $scrollwheel = 'false';
		public $zoomControl = 'true';
		public $zoomControlType = 'customize';
		public $marker_icon = '';			
		public $big_cluster_icon = '';
		public $medium_cluster_icon = '';
		public $small_cluster_icon = ''; 
		public $cluster_text_color = '#ffffff';			
		public $zoom_in_icon = '';	
		public $zoom_in_css = '';
		public $zoom_out_icon = '';
		public $zoom_out_css = '';
		public $defaultMarker = '';
		public $retinaSupport = 'false';
		public $geoIpControl = 'false';	
		public $pulsating_circle = 'pulsating_circle'; // @since 2.5		
		public $marker_anchor_point_option = 'disable'; //@since 2.6.1
		public $marker_anchor_point = ''; //@since 2.6.1
		public $map_draggable = 'true'; //@since 2.6.3
		public $max_zoom = 19; //@since 2.6.3
		public $min_zoom = 0; //@since 2.6.3		
		public $zoom_on_doubleclick = 'false'; //@since 2.6.4
		public $autofit = 'false'; //@since 2.7
		public $traffic_layer = 'false'; //@since 2.7
		public $transit_layer = 'false'; //@since 2.7.4
		public $show_user = 'false'; //@since 2.7.4
		public $user_marker_icon = ''; //@since 2.7.4
		public $user_map_zoom = 12; //@since 2.7.4
		public $user_circle = 0; //@since 2.7.4
		public $user_circle_fillColor = '#189AC9'; // @since 3.0
		public $user_circle_fillOpacity = '0.1'; // @since 3.0
		public $user_circle_strokeColor = '#189AC9'; // @since 3.0				
		public $user_circle_strokeOpacity = '1'; // @since 3.0
		public $user_circle_strokeWeight = '1'; // @since 3.0
		public $recenter_map = 'true'; //@since 3.0						
		
		/**
		 * Default Map style settings */
		
		public $style_option = 'progress-map';
		public $map_style = 'google-map';	
		public $js_style_array = '';
		public $custom_style_name = 'Custom style'; //@since 2.6.1
		 		 		
		/**
		 * Default infobox settings */
		 
		public $show_infobox = 'true'; // @since 2.5		
		public $infobox_type = 'rounded_bubble'; // @since 2.5		
		public $infobox_display_event = 'onload'; // @since 2.5		
		public $infobox_external_link = 'same_window'; // @since 2.5	
		public $remove_infobox_on_mouseout = 'false'; //@since 2.7.4	
		
		/**
		 * Troubleshooting & configs */
		 
		public $combine_files = 'combine'; // @since 2.5		
		public $loading_scripts = 'entire_site'; // @since 2.5
		public $include_or_remove_option = 'include'; //@since 2.6.1		
		public $load_on_page_ids = ''; // @since 2.5		
		public $load_on_post_ids = ''; // @since 2.5
		public $load_on_page_templates = ''; // @since 2.6.1
		public $custom_css = ''; //@since 2.6.1
		public $remove_bootstrap = 'enable'; //@since 2.8.2
		public $remove_gmaps_api = array(); //@since 2.8.2 //updated 2.8.5	
		public $remove_google_fonts = 'enable'; //@since 2.8.2		
		public $new_pin_method = 'beta_method'; //@since 3.5 | Should be removed once the beta function works well!!
		
		/**
		 * Styling options 
		 * @since 3.8 */
		
		public $main_rgb_color = 'rgba(224,11,11,.97)'; //'rgba(0,134,237,.97)';
		public $main_rgb_hover_color = 'rgba(176,5,5,0.97)'; //'rgba(0,133,220,.97)';
		public $main_hex_color = '#e00b0b'; //#008fed';
		public $main_hex_hover_color = '#b00505'; //#009bfd';					
						
		function __construct(){				
			
			self::$_this = $this;  
			     
			$this->plugin_path = $this->cspm_plugin_path = plugin_dir_path( __FILE__ );
			$this->plugin_url = $this->cspm_plugin_url =  plugin_dir_url( __FILE__ );
			
			/**
			 * Our metabox custom fields prefix */
			 
			$this->metafield_prefix = '_cspm';
			
			/**
			 * Our custom post type for adding new maps */
			 
			$this->object_type = 'cspm_post_type';
			
			/**
			 * Include and create a new WordPressSettingsFramework */
			 
			require_once( $this->plugin_path .'wp-settings-framework.php' );
			$this->cspm_wpsf = new CsPm_WordPressSettingsFramework( $this->plugin_path .'settings/cspm.php' );

			/**
			 * Call the plugin settings */
			 
			$this->plugin_settings = cspm_wpsf_get_settings( $this->plugin_path .'settings/cspm.php' );
			
			/** 
			 * Plugin settings */
			
			$this->post_types = $this->cspm_get_setting('pluginsettings', 'post_types', array());
			
			$this->latitude_field_name = str_replace(' ', '', $this->cspm_get_setting('pluginsettings', 'latitude_field_name', 'codespacing_progress_map_lat'));
			$this->longitude_field_name = str_replace(' ', '', $this->cspm_get_setting('pluginsettings', 'longitude_field_name', 'codespacing_progress_map_lng'));
			
			/** 
			 * Define all custom fields used in the "Add locations" widget */
			 
			if (!defined('CSPM_ADDRESS_FIELD')) define('CSPM_ADDRESS_FIELD', 'codespacing_progress_map_address');
			if (!defined('CSPM_LATITUDE_FIELD')) define('CSPM_LATITUDE_FIELD', $this->latitude_field_name);
			if (!defined('CSPM_LONGITUDE_FIELD')) define('CSPM_LONGITUDE_FIELD', $this->longitude_field_name);	
			if (!defined('CSPM_SECONDARY_LAT_LNG_FIELD')) define('CSPM_SECONDARY_LAT_LNG_FIELD', 'codespacing_progress_map_secondary_lat_lng');												
			if (!defined('CSPM_MARKER_ICON_FIELD')) define('CSPM_MARKER_ICON_FIELD', 'cspm_primary_marker_image'); /* @since 2.8 */
			if (!defined('CSPM_SINGLE_POST_IMG_ONLY_FIELD')) define('CSPM_SINGLE_POST_IMG_ONLY_FIELD', 'cspm_single_post_marker_img_only'); /* @since 3.0 */
			if (!defined('CSPM_FORMAT_FIELD')) define('CSPM_FORMAT_FIELD', $this->metafield_prefix.'_post_format'); //@since 3.5
			if (!defined('CSPM_AUDIO_FIELD')) define('CSPM_AUDIO_FIELD', $this->metafield_prefix.'_post_audio'); //@since 3.5
			if (!defined('CSPM_IMAGE_FIELD')) define('CSPM_IMAGE_FIELD', $this->metafield_prefix.'_post_image'); //@since 3.5
			if (!defined('CSPM_EMBED_FIELD')) define('CSPM_EMBED_FIELD', $this->metafield_prefix.'_post_embed'); //@since 3.5
			if (!defined('CSPM_GALLERY_FIELD')) define('CSPM_GALLERY_FIELD', $this->metafield_prefix.'_post_gallery'); //@since 3.5
			
			$this->use_with_wpml = $this->cspm_get_setting('pluginsettings', 'use_with_wpml', 'no');
			$this->outer_links_field_name = str_replace(' ', '', $this->cspm_get_setting('pluginsettings', 'outer_links_field_name', ''));
			$this->custom_list_columns = $this->cspm_get_setting('pluginsettings', 'custom_list_columns', 'no');
			 	
			/**
			 * Default map settings */
			 
			$this->api_key = $this->cspm_get_setting('mapsettings', 'api_key', '');
			$this->map_language = str_replace(' ', '', $this->cspm_get_setting('mapsettings', 'map_language', 'en'));
			$this->center = $this->cspm_get_setting('mapsettings', 'map_center', '51.53096,-0.121064');			
			$this->initial_map_style = $this->cspm_get_setting('mapsettings', 'initial_map_style', 'ROADMAP');
			$this->zoom = $this->cspm_get_setting('mapsettings', 'map_zoom', '12');
			$this->useClustring = $this->cspm_get_setting('mapsettings', 'useClustring', 'true');
			$this->gridSize = $this->cspm_get_setting('mapsettings', 'gridSize', '60');
			$this->mapTypeControl = $this->cspm_get_setting('mapsettings', 'mapTypeControl', 'true');
			$this->streetViewControl = $this->cspm_get_setting('mapsettings', 'streetViewControl', 'false');
			$this->scrollwheel = $this->cspm_get_setting('mapsettings', 'scrollwheel', 'false');
			$this->zoomControl = $this->cspm_get_setting('mapsettings', 'zoomControl', 'true');
			$this->zoomControlType = $this->cspm_get_setting('mapsettings', 'zoomControlType', 'customize');
			$this->marker_icon = $this->cspm_get_setting('mapsettings', 'marker_icon', $this->plugin_url.'img/pin-blue.png');			
			$this->big_cluster_icon = $this->cspm_get_setting('mapsettings', 'big_cluster_icon', $this->plugin_url.'img/big-cluster.png');
			$this->medium_cluster_icon = $this->cspm_get_setting('mapsettings', 'medium_cluster_icon', $this->plugin_url.'img/medium-cluster.png');
			$this->small_cluster_icon = $this->cspm_get_setting('mapsettings', 'small_cluster_icon', $this->plugin_url.'img/small-cluster.png'); 
			$this->cluster_text_color = $this->cspm_get_setting('mapsettings', 'cluster_text_color', '#ffffff');			
			$this->zoom_in_icon = $this->cspm_get_setting('mapsettings', 'zoom_in_icon', $this->plugin_url.'img/svg/addition-sign.svg');	
			$this->zoom_in_css = $this->cspm_get_setting('mapsettings', 'zoom_in_css');	
			$this->zoom_out_icon = $this->cspm_get_setting('mapsettings', 'zoom_out_icon', $this->plugin_url.'img/svg/minus-sign.svg');	
			$this->zoom_out_css = $this->cspm_get_setting('mapsettings', 'zoom_out_css');
			$this->defaultMarker = $this->cspm_get_setting('mapsettings', 'defaultMarker');
			$this->retinaSupport = $this->cspm_get_setting('mapsettings', 'retinaSupport', 'false');
			$this->geoIpControl = $this->cspm_get_setting('mapsettings', 'geoIpControl', 'false');			
			$this->markerAnimation = $this->cspm_get_setting('mapsettings', 'markerAnimation', 'pulsating_circle'); // @since 2.5
			$this->marker_anchor_point_option = $this->cspm_get_setting('mapsettings', 'marker_anchor_point_option', 'disable'); // @since 2.6.1
			$this->marker_anchor_point = $this->cspm_get_setting('mapsettings', 'marker_anchor_point', ''); // @since 2.6.1				
			$this->map_draggable = $this->cspm_get_setting('mapsettings', 'map_draggable', 'true'); // @since 2.6.3				
			$this->max_zoom = $this->cspm_get_setting('mapsettings', 'max_zoom', 19); // @since 2.6.3
			$this->min_zoom = $this->cspm_get_setting('mapsettings', 'min_zoom', 0); // @since 2.6.3
			$this->zoom_on_doubleclick = $this->cspm_get_setting('mapsettings', 'zoom_on_doubleclick', 'false'); // @since 2.6.3												
			$this->autofit = $this->cspm_get_setting('mapsettings', 'autofit', 'false'); // @since 2.7												
			$this->traffic_layer = $this->cspm_get_setting('mapsettings', 'traffic_layer', 'false'); // @since 2.7
			$this->transit_layer = $this->cspm_get_setting('mapsettings', 'transit_layer', 'false'); // @since 2.7.4
			$this->show_user = $this->cspm_get_setting('mapsettings', 'show_user', 'false'); // @since 2.7.4
			$this->user_marker_icon = $this->cspm_get_setting('mapsettings', 'user_marker_icon', ''); // @since 2.7.4
			$this->user_map_zoom = $this->cspm_get_setting('mapsettings', 'user_map_zoom', '12'); // @since 2.7.4
			$this->user_circle = $this->cspm_get_setting('mapsettings', 'user_circle', '0'); // @since 2.7.4
			$this->user_circle_fillColor = $this->cspm_get_setting('mapsettings', 'user_circle_fillColor', '#189AC9'); // @since 3.0
			$this->user_circle_fillOpacity = $this->cspm_get_setting('mapsettings', 'user_circle_fillOpacity', '0.1'); // @since 3.0
			$this->user_circle_strokeColor = $this->cspm_get_setting('mapsettings', 'user_circle_strokeColor', '#189AC9'); // @since 3.0				
			$this->user_circle_strokeOpacity = $this->cspm_get_setting('mapsettings', 'user_circle_strokeOpacity', '1'); // @since 3.0
			$this->user_circle_strokeWeight = $this->cspm_get_setting('mapsettings', 'user_circle_strokeWeight', '1'); // @since 3.0						
			$this->recenter_map = $this->cspm_get_setting('mapsettings', 'recenter_map', 'true'); // @since 3.0						
					
			/**
			 * Default map styles section */
			 
			$this->style_option = $this->cspm_get_setting('mapstylesettings', 'style_option', 'progress-map');
			$this->map_style = $this->cspm_get_setting('mapstylesettings', 'map_style', 'google-map');
			$this->js_style_array = $this->cspm_get_setting('mapstylesettings', 'js_style_array', '');
			$this->custom_style_name = $this->cspm_get_setting('mapstylesettings', 'custom_style_name', 'Custom style'); //@since 2.6.1
		
			/**
			 * Default Infobox settings
			 * @since 2.5 */
			
			$this->show_infobox = $this->cspm_get_setting('infoboxsettings', 'show_infobox', 'true');
			$this->infobox_type = $this->cspm_get_setting('infoboxsettings', 'infobox_type', 'rounded_bubble');
			$this->infobox_display_event = $this->cspm_get_setting('infoboxsettings', 'infobox_display_event', 'onload');
			$this->infobox_external_link = $this->cspm_get_setting('infoboxsettings', 'infobox_external_link', 'same_window');
			$this->remove_infobox_on_mouseout = $this->cspm_get_setting('infoboxsettings', 'remove_infobox_on_mouseout', 'false'); //@since 2.7.4
					
			/**
			 * Troubleshooting & Configs
			 * @since 2.5
			 */
			 
			$this->combine_files = $this->cspm_get_setting('troubleshooting', 'combine_files', 'combine');
			$this->custom_css = $this->cspm_get_setting('troubleshooting', 'custom_css', ''); //@since 2.6.1
			$this->remove_bootstrap = $this->cspm_get_setting('troubleshooting', 'remove_bootstrap', 'enable'); //@since 2.8.2
			$this->remove_google_fonts = $this->cspm_get_setting('troubleshooting', 'remove_google_fonts', 'enable'); //@since 2.8.2	
				
			$remove_frontend_gmaps_api = isset($this->plugin_settings['cspm_troubleshooting_remove_gmaps_api_disable_frontend'])
												? $this->plugin_settings['cspm_troubleshooting_remove_gmaps_api_disable_frontend'] : ''; //@since 2.8.5
			$remove_backend_gmaps_api = isset($this->plugin_settings['cspm_troubleshooting_remove_gmaps_api_disable_backend'])
												? $this->plugin_settings['cspm_troubleshooting_remove_gmaps_api_disable_backend'] : ''; //@since 2.8.5
					
			$this->remove_gmaps_api = array(
				$remove_frontend_gmaps_api,
				$remove_backend_gmaps_api,
			); //@since 2.8.5
			
			$this->new_pin_method = $this->cspm_get_setting('troubleshooting', 'new_pin_method', 'beta_method'); //@since 3.5
			
			/**
			 * Styling options 
			 * @since 3.8 */
			 
			$this->main_hex_color = $this->cspm_get_setting('customize', 'main_hex_color', '#008fed');
			$this->main_hex_hover_color = $this->cspm_get_setting('customize', 'main_hex_hover_color', '#009bfd');							
			$this->main_rgb_color = 'rgba('.$this->cspm_hex2RGB($this->main_hex_color).',.97)'; //'rgba(0,134,237,.97)';
			$this->main_rgb_hover_color = 'rgba('.$this->cspm_hex2RGB($this->main_hex_hover_color).',0.97)'; //'rgba(0,133,220,.97)';

			/**
			 * [@shared_plugin_settings] | Build an array containing the plugin settings that we can share with other classes.
			 * The idea is to use the shared settings as default settings in other classes. */
			 
			$this->shared_plugin_settings = apply_filters('cspm_shared_plugin_settings', array(
			 
				'post_types' => $this->post_types,
				
				/**
				 * Default map settings */
			 	
				'api_key' => $this->api_key, //@since 3.5		
				'map_center' => $this->center,			
				'initial_map_style' => $this->initial_map_style,
				'map_zoom' => $this->zoom,
				'useClustring' => $this->useClustring,
				'gridSize' => $this->gridSize,
				'mapTypeControl' => $this->mapTypeControl,
				'streetViewControl' => $this->streetViewControl,
				'scrollwheel' => $this->scrollwheel,
				'zoomControl' => $this->zoomControl,
				'zoomControlType' => $this->zoomControlType,
				'marker_icon' => $this->marker_icon,		
				'big_cluster_icon' => $this->big_cluster_icon,
				'medium_cluster_icon' => $this->medium_cluster_icon,
				'small_cluster_icon' => $this->small_cluster_icon,
				'cluster_text_color' => $this->cluster_text_color,			
				'zoom_in_icon' => $this->zoom_in_icon,	
				'zoom_in_css' => $this->zoom_in_css,	
				'zoom_out_icon' => $this->zoom_out_icon,
				'zoom_out_css' => $this->zoom_out_css,
				'defaultMarker' => $this->defaultMarker,
				'retinaSupport' => $this->retinaSupport,
				'geoIpControl' => $this->geoIpControl,		
				'markerAnimation' => $this->markerAnimation,
				'marker_anchor_point_option' => $this->marker_anchor_point_option,
				'marker_anchor_point' => $this->marker_anchor_point,				
				'map_draggable' => $this->map_draggable,			
				'max_zoom' => $this->max_zoom,
				'min_zoom' => $this->min_zoom,
				'zoom_on_doubleclick' => $this->zoom_on_doubleclick,											
				'autofit' => $this->autofit,											
				'traffic_layer' => $this->traffic_layer,
				'transit_layer' => $this->transit_layer,
				'show_user' => $this->show_user,
				'user_marker_icon' => $this->user_marker_icon,
				'user_map_zoom' => $this->user_map_zoom,
				'user_circle' => $this->user_circle,
				'user_circle_fillColor' => $this->user_circle_fillColor, //@since 3.0
				'user_circle_fillOpacity' => $this->user_circle_fillOpacity, //@since 3.0
				'user_circle_strokeColor' => $this->user_circle_strokeColor, //@since 3.0
				'user_circle_strokeOpacity' => $this->user_circle_strokeOpacity, //@since 3.0
				'user_circle_strokeWeight' => $this->user_circle_strokeWeight, //@since 3.0
				'recenter_map' => $this->recenter_map, //@since 3.0				
						
				/**
				 * Default map styles section */
				 
				'style_option' => $this->style_option,
				'map_style' => $this->map_style,
				'js_style_array' => $this->js_style_array,
				'custom_style_name' => $this->custom_style_name,
			
				/**
				 * Default Infobox settings
				 * @since 2.5 */
				
				'show_infobox' => $this->show_infobox,
				'infobox_type' => $this->infobox_type,
				'infobox_display_event' => $this->infobox_display_event,
				'infobox_external_link' => $this->infobox_external_link,
				'remove_infobox_on_mouseout' => $this->remove_infobox_on_mouseout,
						
				/**
				 * Troubleshooting & Configs
				 * @since 2.5
				 */
				 
				'outer_links_field_name' => $this->outer_links_field_name,
				'use_with_wpml' => $this->use_with_wpml,
				'combine_files' => $this->combine_files,
				'remove_bootstrap' => $this->remove_bootstrap,
				'remove_google_fonts' => $this->remove_google_fonts,
				'remove_gmaps_api' => $this->remove_gmaps_api,
				'custom_css' => $this->custom_css,
				'new_pin_method' => $this->new_pin_method, //@since 3.5
			
				/**
				 * Styling options 
				 * @since 3.8 */
				
				'main_rgb_color' => $this->main_rgb_color,
				'main_rgb_hover_color' => $this->main_rgb_hover_color,
				'main_hex_color' => $this->main_hex_color,
				'main_hex_hover_color' => $this->main_hex_hover_color,
				
			)); 

		}

  
		static function this(){
			
			return self::$_this;
			
		}


		function cspm_hooks(){
						
			/**
			 * Load plugin textdomain.
			 * @since 2.8 */
			 
			add_action('init', array(&$this, 'cspm_load_plugin_textdomain')); 

			if(is_admin()){
							
				/**
				 * Include and setup our custom post type */
				
				if(file_exists($this->plugin_path . 'cpt/inc/cspm-post-type.php')){
					
					require_once( $this->plugin_path . 'cpt/inc/cspm-post-type.php' );

					if(class_exists('CspmPostType')){
						
						$CspmPostType = new CspmPostType(array(
							'object_type' => $this->object_type,
						));
						
					}

				}
				
				/**
				 * Make sure to load our metaboxes only when the current post type ...
				 * ... matches our custom post type. This will prevent JS conflicts with other plugins.
				 * @since 3.1
				 * @updated 3.5 | Load "Add locations" metabox/widget in selected post types of plugin settings */
 
				$current_post_type = $this->cspm_get_current_post_type();		

				if($current_post_type == $this->object_type || in_array($current_post_type, $this->post_types)){
					
					/**
					 * Include and setup custom metaboxes and fields */
							
					if(file_exists($this->plugin_path . 'cpt/inc/cspm-metaboxes.php')){
						
						require_once( $this->plugin_path . 'cpt/inc/cspm-metaboxes.php' );
					
						if(class_exists('CspmMetaboxes')){
							
							new CspmMetaboxes(array(
								'plugin_path' => $this->plugin_path, 
								'plugin_url' => $this->plugin_url,
								'plugin_settings' => $this->shared_plugin_settings,
								'metafield_prefix' => $this->metafield_prefix,
								'object_type' => $this->object_type,
							));				
							
						}
						
					}
					
				}
				
				/**
				 * Ajax functions */
			
				add_action('wp_ajax_cspm_regenerate_markers', array(&$this, 'cspm_regenerate_markers'));
				 
				/**
				 * Add plugin menu */
				 
				add_action('admin_menu', array(&$this, 'cspm_admin_menu'));

				/**
				 * Add marker object to the option "cspm_markers_array" after saving or editing a post
				 * @since 3.5 */
				 
				add_action('wp_insert_post', array(&$this, 'cspm_save_marker_object'), 10, 2);
				
				/**
				 * Remove all metaboxes from our CPT except for the ones we built */
				 
				add_action('current_screen', array(&$this, 'cspm_remove_all_metaboxes'));
				
				/**
				 * Register new carousel image sizes */
				 			
				add_action('admin_init', array(&$this, 'cspm_add_carousel_image_sizes'));
					
				/**
				 * Add custom links to plugin instalation area */
				 
				add_filter('plugin_row_meta', array(&$this, 'cspm_plugin_meta_links'), 10, 2);
				add_filter('plugin_action_links_' . plugin_basename( __FILE__ ), array(&$this, 'cspm_add_plugin_action_links'));
						
				/**
				 * Alter the list of acceptable file extensions WordPress checks during media uploads
				 * @since 2.7 */
				 
				add_filter('upload_mimes', array(&$this, 'cspm_custom_upload_mimes'));

				/**
				 * Display a message in the admin to promote for Progress Map extensions
				 *
				 * @since 2.8
				 */
				 
				add_action( 'admin_notices', array(&$this, 'cspm_about_extensions') );	
				
				/**
				 * Get out if the loaded page is not our plguin settings page */
				 
				if (isset($_GET['page']) && $_GET['page'] == $this->plugin_get_var ){
		
					/**
					 * Call custom functions */
					 
					add_action('wpsf_before_settings', array(&$this, 'cspm_before_settings'));
					add_action('wpsf_after_settings', array(&$this, 'cspm_after_settings'));
			
					/**
					 * Add an optional settings validation filter (recommended) */
					 
					add_filter( $this->cspm_wpsf->cspm_get_option_group() .'_settings_validate', array(&$this, 'cspm_validate_settings') );		
			
				}
			
				/**
				 * Add a custom column on all posts list showing the coordinates of each post
				 * @since 2.6.3 */

				if($this->custom_list_columns == 'yes'){
					foreach($this->post_types as $post_type){
						if($post_type == 'page'){
							add_filter('manage_pages_columns', array(&$this, 'cspm_manage_posts_columns')); // @since 2.6.3
							add_action('manage_pages_custom_column', array(&$this, 'cspm_manage_posts_custom_column'), 10, 2); // @since 2.6.3	
						}else{
							add_filter('manage_'.$post_type.'_posts_columns', array(&$this, 'cspm_manage_posts_columns')); // @since 2.6.3
							add_action('manage_'.$post_type.'_posts_custom_column', array(&$this, 'cspm_manage_posts_custom_column'), 10, 2); // @since 2.6.3
						}
					}
				}

				/**
				 * Executed when activating the plugin in order to run any sync code needed for the latest version of the plugin 
				 * @since 2.4 */
				 
				register_activation_hook(__FILE__, array(&$this, 'cspm_sync_settings_for_latest_version'));
				
				/**
				 * Duplicate map "link", "action" & "link style"
				 * @since 3.2 */
				 				
				add_filter('post_row_actions', array(&$this, 'cspm_duplicate_map_link'), 10, 2);		
				add_action('admin_action_cspm_duplicate_map', array(&$this, 'cspm_duplicate_map'));
				add_action('admin_head', array(&$this, 'cspm_duplicate_map_link_style'));
					
			}else{
				
				/**
				 * Call .js and .css files */
				 
				add_action('wp_enqueue_scripts', array(&$this, 'cspm_register_styles'));
				add_action('wp_enqueue_scripts', array(&$this, 'cspm_register_scripts'));

			}
					
			/**
			 * Add Marker/Infobox Images Size */
			 
			if(function_exists('add_image_size')){
				add_image_size('cspm-marker-thumbnail', 100, 100, true);
				add_image_size('cspm-horizontal-thumbnail-map', 204, 150, true);
				add_image_size('cspm-vertical-thumbnail-map', 204, 120, true);
				add_image_size('cspm-modal-fullscreen', 1024, 1024, true); //@since 3.5
				add_image_size('cspm-modal-carousel-preview', 700, 300, true); //@since 3.5
				add_image_size('cspm-modal-single', 700, 400, true); //@since 3.5
				add_image_size('cspm-modal-carousel-thumb', 120, 80, true); //@since 3.5
				add_image_size('cspacing-horizontal-thumbnail', 204, 150, true ); //@deprecated since 3.0
				add_image_size('cspacing-vertical-thumbnail', 204, 120, true );	//@deprecated since 3.0				
			}
			
			/**
			 * Include and load the main map shortcode class */
			
			if(file_exists($this->plugin_path . 'shortcodes/cspm-main-map.php')){
				
				require_once( $this->plugin_path . 'shortcodes/cspm-main-map.php' );
				
				if(class_exists('CspmMainMap')){
					
					$CspmMainMap = new CspmMainMap(array(
						'init' => true, 
						'plugin_settings' => $this->shared_plugin_settings,
						'metafield_prefix' => $this->metafield_prefix,
						'object_type' => $this->object_type,
					));
				
					$CspmMainMap->cspm_hooks();
					
				}
					
			}
			
			/**
			 * Include and load all shortcodes/maps classes */
			
			$cspm_shortcodes_classes = array(
				'cspm_light_map' => 'shortcodes/cspm-light-map.php',
				'cspm_static_map' => 'shortcodes/cspm-static-map.php',
				'cspm_streetview_map' => 'shortcodes/cspm-streetview-map.php',
				'cspm_contact_map' => 'shortcodes/cspm-contact-map.php',
				'cspm_frontend_form' => 'shortcodes/cspm-frontend-form.php',
				'cspm_route_map' => 'shortcodes/cspm-route-map.php', // @since 3.6
			);
			
				foreach($cspm_shortcodes_classes as $class_key => $class_path){
					if(file_exists($this->plugin_path . $class_path))
						require_once($this->plugin_path . $class_path);
				}

		}


		/**
		 * Register & Enqueue CSS files 
		 *
		 * @updated 3.0
		 * @updated 3.5 [Changed files URLs]
		 */
		function cspm_register_styles(){
			
			do_action('cspm_before_register_style');
							
			$min_prefix = ($this->combine_files == 'seperate_minify' || $this->combine_files == "combine") ? '.min' : '';
			
			/**
			 * Font Style */
			
			if($this->remove_google_fonts == 'enable'){  	
				wp_register_style('cspm_font', '//fonts.googleapis.com/css?family=Source+Sans+Pro:400,200,200italic,300,300italic,400italic,600,600italic,700,700italic&subset=latin,vietnamese,latin-ext');				
			}

			/**
			 * icheck skins */
							
			$icheck_skins = array('flat', 'futurico', 'polaris', 'line', 'minimal', 'square');
			$icheck_skin_colors = array('black', 'red', 'green', 'blue', 'aero', 'grey', 'orange', 'yellow', 'pink', 'purple');
			
			foreach($icheck_skins as $skin){

				foreach($icheck_skin_colors as $color){
				
					$color_file_name = ($color == 'black') ? $skin : $color;
					$color_file_path = 'assets/css/icheck/'.$skin.'/'.$color_file_name.$min_prefix.'.css';
					
					if(file_exists($this->plugin_path . $color_file_path))
						wp_register_style('cspm_icheck_'.$skin.'_'.$color_file_name.'_css', $this->plugin_url.$color_file_path, array(), $this->plugin_version);
					
				}
				
			}
			
			if($this->combine_files == "combine"){
				
				$script_handle = 'cspm_combined_styles';
					
				wp_register_style($script_handle, $this->plugin_url .'assets/css/main/cspm_combined_styles.min.css', array(), $this->plugin_version);
				
			}else{
				
				/**
				 * Bootstrap */
				
				if($this->remove_bootstrap == 'enable')	
					wp_register_style('cspm_bootstrap_css', $this->plugin_url .'assets/css/bootstrap/bootstrap'.$min_prefix.'.css', array(), $this->plugin_version);
				
				/**
				 * jCarousel */
				 
				wp_register_style('cspm_carousel_css', $this->plugin_url .'assets/css/jCarousel/jcarousel'.$min_prefix.'.css', array(), $this->plugin_version);
				
				/**
				 * Custom Scroll bar */
				 
				wp_register_style('cspm_mCustomScrollbar_css', $this->plugin_url .'assets/css/customScroll/jquery.mCustomScrollbar'.$min_prefix.'.css', array(), $this->plugin_version);

				/**
				 * Range Slider */
				 				
				wp_register_style('cspm_rangeSlider_css', $this->plugin_url .'assets/css/rangeSlider/ion.rangeSlider'.$min_prefix.'.css', array(), $this->plugin_version);
				wp_register_style('cspm_rangeSlider_skin_css', $this->plugin_url .'assets/css/rangeSlider/ion.rangeSlider.skinFlat'.$min_prefix.'.css', array(), $this->plugin_version);
							
				/**
				 * iziModal
				 * @since 3.5 */
				 
				wp_register_style('cspm_izimodal_css', $this->plugin_url .'assets/css/izimodal/iziModal'.$min_prefix.'.css', array(), $this->plugin_version);

				/**
				 * iziToast 
				 * @since 3.5 */
				
				wp_register_style('cspm_izitoast_css', $this->plugin_url .'assets/css/izitoast/iziToast'.$min_prefix.'.css', array(), $this->plugin_version);
				
				/** 
				 * Progress Map styles */
				
				wp_register_style('cspm_nprogress_css', $this->plugin_url .'assets/css/nProgress/nprogress'.$min_prefix.'.css', array(), $this->plugin_version);
				
				wp_register_style('cspm_animate_css', $this->plugin_url .'assets/css/animate/animate'.$min_prefix.'.css', array(), $this->plugin_version);
				
				$script_handle = 'cspm_map_css';
					
				wp_register_style($script_handle, $this->plugin_url .'assets/css/main/style'.$min_prefix.'.css', array(), $this->plugin_version);
								
			}
			
			do_action('cspm_after_register_style');
		
			/**
			 * Add custom header script */
			
			wp_add_inline_style($script_handle, $this->cspm_main_colors().$this->custom_css);			
			
			/**
			 * Add custom header script */
			 
			add_filter('wp_head', array(&$this, 'cspm_header_script'));
			
		}	
		
		
		/**
		 * Register & Enqueue JS files 
		 *
		 * @updated 3.0
		 * @updated 3.5 [Changed files URLs]
		 */
		function cspm_register_scripts(){		
						
			if( class_exists( 'CspmMainMap' ) )
				$CspmMainMap = CspmMainMap::this();

			/**
			 * Localize the script with new data */
			 
			$wp_localize_script_args = array(
				
				'ajax_url' => admin_url('admin-ajax.php'),//get_bloginfo('url') . '/wp-admin/admin-ajax.php',
				'plugin_url' => $this->plugin_url,
			
				/**
				 * [@map_script_args] | Default settings to use for maps like "Light map", "Nearby map ext", etc...
				 * Note: we'll use the key "initial" to identify the default map settings! */
					
				'map_script_args' => array('initial' => array(
					
					/**
					 * Even empty, we need them inside AJAX functions */
					 
					'map_object_id' => '',
					'map_settings' => '',
								
					/**
					 * Map settings */
					 
					'center' => $this->center,
					'zoom' => $this->zoom,
					'scrollwheel' => $this->scrollwheel,
					'mapTypeControl' => $this->mapTypeControl,
					'streetViewControl' => $this->streetViewControl,
					'zoomControl' => $this->zoomControl,
					'zoomControlType' => $this->zoomControlType,
					'defaultMarker' => $this->defaultMarker,
					'marker_icon' => $this->marker_icon,
					'big_cluster_icon' => $this->big_cluster_icon,
					'big_cluster_size' => $CspmMainMap->cspm_get_image_size($CspmMainMap->cspm_get_image_path_from_url($this->big_cluster_icon), $this->retinaSupport),
					'medium_cluster_icon' => $this->medium_cluster_icon,
					'medium_cluster_size' => $CspmMainMap->cspm_get_image_size($CspmMainMap->cspm_get_image_path_from_url($this->medium_cluster_icon), $this->retinaSupport),
					'small_cluster_icon' => $this->small_cluster_icon,
					'small_cluster_size' => $CspmMainMap->cspm_get_image_size($CspmMainMap->cspm_get_image_path_from_url($this->small_cluster_icon), $this->retinaSupport),
					'cluster_text_color' => $this->cluster_text_color,
					'grid_size' => $this->gridSize,
					'retinaSupport' => $this->retinaSupport,
					'initial_map_style' => $this->initial_map_style,
					'markerAnimation' => $this->markerAnimation, // @since 2.5
					'marker_anchor_point_option' => $this->marker_anchor_point_option, //@since 2.6.1
					'marker_anchor_point' => $this->marker_anchor_point, //@since 2.6.1
					'map_draggable' => $this->map_draggable, //@since 2.6.3
					'min_zoom' => $this->min_zoom, //@since 2.6.3
					
					/**
					 * @max_zoom, since 2.6.3
					 * @updated 2.8 (Fix issue when min zoom is bigger than max zoom) */
					'max_zoom' => ($this->min_zoom > $this->max_zoom) ? 19 : $this->max_zoom,
					
					'zoom_on_doubleclick' => $this->zoom_on_doubleclick, //@since 2.6.3
	
					/**
					 * Geotarget
					 * @since 2.8 */
					 
					'geo' => $this->geoIpControl,
					'show_user' => $this->show_user,
					'user_marker_icon' => $this->user_marker_icon,
					'user_map_zoom' => $this->user_map_zoom,
					'user_circle' => $this->user_circle,
				
					/**
					 * Search form settings */
					 
					'before_search_address' => '', //@since 2.8, Add text before the search field value
					'after_search_address' => '', //@since 2.8, Add text after the search field value
				
				)),
				
				/**
				 * Geotarget
				 * @since 2.8 */
				 
				'geoErrorTitle' => esc_attr__('Give Maps permission to use your location!', 'cspm'),				
				'geoErrorMsg' => esc_attr__('If you can\'t center the map on your location, a couple of things might be going on. It\'s possible you denied Google Maps access to your location in the past, or your browser might have an error.', 'cspm'),				
				'geoDeprecateMsg' => esc_attr__('Browsers no longer supports obtaining the user\'s location using the HTML5 Geolocation API from pages delivered by non-secure connections. This means that the page that\'s making the Geolocation API call must be served from a secure context such as HTTPS.', 'cspm'), //@since 2.8.3
				
				/**
				 * Cluster text
				 * @since 2.8 */
				 
				'cluster_text' => esc_attr__('Click to view all markers in this area', 'cspm'),
				
				/**
				 * Map Messages
				 * @since 3.2 */
				 
				'new_marker_selected_msg' => esc_attr__('A new location has been selected and can be used to display nearby points of interest!', 'cspm'),	
				'no_marker_selected_msg' => esc_attr__('First, select a marker/location from the map!', 'cspm'),
				'circle_reached_max_msg' => esc_attr__('The circle has reached the maximum distance!', 'cspm'),
				'circle_reached_min_msg' => esc_attr__('The circle has reached the minimum distance!', 'cspm'),
				'no_route_found_msg' => esc_attr__('No {travel_mode} route could be found to your destination!', 'cspm'),
				'max_search_radius_msg' => esc_attr__('You have reached the maximum radius of search!', 'cspm'),
				'min_search_radius_msg' => esc_attr__('You have reached the minimum radius of search!', 'cspm'),
				'no_nearby_point_found' => esc_attr__('No nearby points of interest has been found!', 'cspm'),
				
				/**
				 * Draw search area text & messages
				 * @since 3.3 */
				
				'draw_search_area' => esc_attr__('Draw a search area', 'cspm'),
				'click_to_draw_search_area' => esc_attr__('Click and draw your search area', 'cspm'),
				'clear_search_area' => esc_attr__('Reset & Clear the search area', 'cspm'),
				
				/**
				 * The message to display to inform about hiding an image overlay
				 * @since 3.5 */
				 
				'hide_img_overlay_msg' => apply_filters('cspm_hide_img_overlay_msg', __('Click to hide & show the image overlay', 'cspm')),
				
				/**
				 * Messages to display to inform about hidden options
				 * @since 3.5 */
				
				'media_format_msg' => array(
					'format_all_msg' => apply_filters('cspm_format_all_msg', __('Click on the marker to pop-up the media files', 'cspm')),
					'format_gallery_msg' => apply_filters('cspm_format_gallery_msg', __('Click on the marker to pop-up the image gallery', 'cspm')),
					'format_image_msg' => apply_filters('cspm_format_image_msg', __('Click on the marker to pop-up the image', 'cspm')),
					'format_audio_msg' => apply_filters('cspm_format_audio_msg', __('Click on the marker to pop-up to the audio file', 'cspm')),
					'format_embed_msg' => apply_filters('cspm_format_embed_msg', __('Click on the marker to pop-up the visual file', 'cspm')),
					'format_link_msg' => apply_filters('cspm_format_link_msg', __('Click on the marker to pop-up the post details', 'cspm')), //@since 3.6
				),
				'broken_img_msg' => apply_filters('cspm_broken_img_msg', __('The image appears to be broken', 'cspm')),
				'resize_circle_msg' => apply_filters('cspm_resize_circle_msg', __('Resize the circle to show less or more results', 'cspm')),
				'show_nearby_details_msg' => apply_filters('cspm_show_nearby_details_msg', __('Click on the nearby marker to display the route and the place details', 'cspm')),
				'polyline_url_msg' => apply_filters('cspm_polyline_url_msg', __('Click on the polyline to open the polyline associated link', 'cspm')),
				'polygon_url_msg' => apply_filters('cspm_polygon_url_msg', __('Click on the polygon to open the polygon associated link', 'cspm')),
			);
			
			do_action('cspm_before_register_script');
						
			/**
			 * GMaps API */
			
			if(!in_array('disable_frontend', $this->remove_gmaps_api)){ 
			
				$gmaps_api_key = (!empty($this->api_key)) ? '&key='.$this->api_key : '';
				
				$gmap_libs = implode(',', array(
					'geometry',
					'places',
					'drawing', //@since 3.3
					'visualization', //@since 3.3
				));
				
				wp_register_script('cspm_google_maps_api', '//maps.google.com/maps/api/js?v=3.exp'.$gmaps_api_key.'&language='.$this->map_language.'&libraries='.$gmap_libs, array( 'jquery' ), false, true);

			}
			
			if($this->combine_files == "combine"){
			
				wp_register_script('cspm_combined_scripts', $this->plugin_url .'assets/js/main/cspm_combined_scripts.min.js', array( 'jquery' ), $this->plugin_version, true);
				
				$localize_script_handle = 'cspm_combined_scripts';
	
			}else{			
								
				$min_prefix = ($this->combine_files == 'seperate_minify') ? '.min' : '';
				
				/**
				 * ScrollTo jQuery Plugin
				 * Used for the extensions, "List & Filter" & "Nearby Places"
				 * @since 2.8.6 */
				
				if(class_exists('CspmListFilter') || class_exists('CspmNearbyMap'))
					wp_register_script('cspm_scrollTo_js', $this->plugin_url .'assets/js/scrollTo/jquery.scrollTo'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);
				
				/**
				 * GMap3 jQuery Plugin */
				 
				wp_register_script('cspm_gmap3_js', $this->plugin_url .'assets/js/gmap3/gmap3'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);		
													

				/**
				 * Live Query */
				 
				wp_register_script('cspm_livequery_js', $this->plugin_url .'assets/js/livequery/jquery.livequery'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);
				
				/**
				 * Marker Clusterer | No dependencies!  */
				 
				wp_register_script('cspm_markerclusterer_js', $this->plugin_url .'assets/js/markerClusterer/MarkerClustererPlus'.$min_prefix.'.js', array(), $this->plugin_version, true);
				
				/**
				 * Touche Swipe */
				 
				wp_register_script('cspm_touchSwipe_js', $this->plugin_url .'assets/js/toucheSwipe/jquery.touchSwipe'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);		
				
				/**
				 * jCarousel & jQuery Easing */
				 
				wp_register_script('cspm_jcarousel_js', $this->plugin_url .'assets/js/jCarousel/jquery.jcarousel'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);
				wp_register_script('cspm_easing', $this->plugin_url .'assets/js/easing/jquery.easing.1.3'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);
				
				/**
				 * Custom Scroll bar */
				 
				wp_register_script('cspm_mCustomScrollbar_js', $this->plugin_url .'assets/js/customScroll/jquery.mCustomScrollbar'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);		
				
				/**
				 * jQuery Mousewheel */
				 
				wp_register_script('cspm_jquery_mousewheel_js', $this->plugin_url .'assets/js/mouseWheel/jquery.mousewheel'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);		

				/**
				 * icheck */
				 				
				wp_register_script('cspm_icheck_js', $this->plugin_url .'assets/js/icheck/jquery.icheck'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);
				
				/**
				 * Progress Bar loader */
				 
				wp_register_script('cspm_nprogress_js', $this->plugin_url .'assets/js/nProgress/nprogress'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);

				/**
				 * Range Slider */
				
				wp_register_script('cspm_rangeSlider_js', $this->plugin_url .'assets/js/rangeSlider/ion.rangeSlider'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);
							
				/**
				 * iziModal
				 * @since 3.5 */
				 
				wp_register_script('cspm_izimodal_js', $this->plugin_url .'assets/js/izimodal/iziModal'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);

				/**
				 * iziToast | No dependencies! 
				 * @since 3.5 */
				
				wp_register_script('cspm_izitoast_js', $this->plugin_url .'assets/js/izitoast/iziToast'.$min_prefix.'.js', array(), $this->plugin_version, true);

				/**
				 * Siema | No dependencies!  
				 * @since 3.5 */
				
				wp_register_script('cspm_siema_js', $this->plugin_url .'assets/js/siema/siema.min.js', array(), $this->plugin_version, true);
				
				/**
				 * Progress Map Script */
				 
				wp_register_script('cspm_progress_map_js', $this->plugin_url .'assets/js/main/progress_map'.$min_prefix.'.js', array( 'jquery' ), $this->plugin_version, true);					
				 
				$localize_script_handle = 'cspm_progress_map_js';
	
			}
			
			/**
			 * Localize the script with new data */
 
			wp_localize_script($localize_script_handle, 'progress_map_vars', $wp_localize_script_args);

			do_action('cspm_after_register_script');
			
		}		
		
		/**
		 * Print Custom CSS/JS in the page header 
		 *
		 * @since 2.5
		 * @updated 2.8
		 */
		function cspm_header_script(){
			
			$header_script = '';
			
			/**
			 * Prevent $(document).ready from being fired twice */			 
			
			$header_script .= '<script type="text/javascript">var _CSPM_DONE = {}; var _CSPM_MAP_RESIZED = {}</script>';
			
			echo $header_script;
			
		}
		
		
		/**
		 * Get the value of a setting
		 *
		 * @since 2.4 
		 */
		function cspm_get_setting($section_id, $setting_id, $default_value = ''){
			
			return $this->cspm_setting_exists('cspm_'.$section_id.'_'.$setting_id.'', $this->plugin_settings, $default_value);
			
		}
		

		/**
		 * Check if array_key_exists and if empty() doesn't return false
		 * Replace the empty value with the default value if available 
		 * @empty() return false when the value is (null, 0, "0", "", 0.0, false, array())
		 *
		 * @since 2.4 
		 */
		function cspm_setting_exists($key, $array, $default = ''){
			
			$array_value = isset($array[$key]) ? $array[$key] : $default;
			
			$setting_value = empty($array_value) ? $default : $array_value;
			
			return $setting_value;
			
		}
		
		
		/**
		 * This will add any post coordinates to the markers object.
		 * This is necessary to display the location on the map!
		 *
		 * @since 3.5
		 */
		function cspm_save_marker_object($post_id, $post){
				
			$post_type = $post->post_type;
		
			if(empty($post_id) || empty($post_type))
				return;
				
			$markers_object = get_option('cspm_markers_array');
			$post_markers_object = array();
			
			$latitude = get_post_meta($post_id, CSPM_LATITUDE_FIELD, true);
			$longitude = get_post_meta($post_id, CSPM_LONGITUDE_FIELD, true);
			
			/**
			 * Save the Lat & Lng Fields */
				
			if(!empty($latitude) && !empty($longitude)){								  
				
				/**
				 * Get this post taxonomies terms */
				 
				$post_taxonomy_terms = array();
				
				$post_taxonomies = get_object_taxonomies($post_type, 'names');	
				
				foreach($post_taxonomies as $taxonomy_name)
					$post_taxonomy_terms[$taxonomy_name] = wp_get_post_terms($post_id, $taxonomy_name, array("fields" => "ids"));
				
				/**
				 * Build the marker object */
				 	
				$post_markers_object = array_merge(
					array(
						'lat' => $latitude,
						'lng' => $longitude,
						'post_id' => $post_id,
						'post_tax_terms' => $post_taxonomy_terms,
						'is_child' => 'no',
						'child_markers' => array(),
					),
					$this->cspm_get_post_media($post_id)
				);																 
				
				/**
				 * Secondary latLng */
				
				$secondary_latlng = get_post_meta($post_id, CSPM_SECONDARY_LAT_LNG_FIELD, true);
				
				if(!empty($secondary_latlng)){
					
					$child_markers = array();
						
					$j = 0;
									
					$lats_lngs = explode(']', $secondary_latlng);	
							
					foreach($lats_lngs as $single_coordinate){
					
						$strip_coordinates = str_replace(array('[', ']', ' '), '', $single_coordinate);
						
						$coordinates = explode(',', $strip_coordinates);
						
						if(isset($coordinates[0], $coordinates[1]) && !empty($coordinates[0]) && !empty($coordinates[1])){
							
							$lat = $coordinates[0];
							$lng = $coordinates[1];
							
							$child_markers[] = array(
								'lat' => $lat,
								'lng' => $lng,
								'post_id' => $post_id,
								'post_tax_terms' => $post_taxonomy_terms,
								'is_child' => 'yes_'.$j
							);
							
							$lat = '';
							$lng = '';
							$j++;
						
						} 
						
						$post_markers_object['child_markers'] = $child_markers;
						
					}
				
				}
				
				$markers_object[$post_type]['post_id_'.$post_id] = $post_markers_object;

				update_option('cspm_markers_array', $markers_object);

			}
					
		}

		
		/**
		 * This will return an array containing the post media format & files
		 *
		 * @since 3.5
		 */
		function cspm_get_post_media($post_id, $default = array()){
				
			extract( wp_parse_args( $default, array(
				'format' => get_post_meta($post_id, CSPM_FORMAT_FIELD, true),
				'gallery' => get_post_meta($post_id, CSPM_GALLERY_FIELD, true),	// Images URLs	
				'image_id' => get_post_meta($post_id, CSPM_IMAGE_FIELD.'_id', true), // Image URL
				'audio_url' => get_post_meta($post_id, CSPM_AUDIO_FIELD, true), // Audio URL
				'embed_url' => get_post_meta($post_id, CSPM_EMBED_FIELD, true), // Embed URL				
			)));

			if(empty($post_id))
				return array();
				
			/**
			 * Init the media array */
			 
			$media_array = array();
				
			/**
			 * Build this post gallery (Location format: Gallery)
			 * @since 3.5 */
			
			$post_gallery = $gallery;
				
			if(empty($post_gallery))
				$post_gallery = array();
				
			$gallery_imgs = array();
			
			foreach($post_gallery as $img_id => $img_url){
					
				$fullscreen_img = wp_get_attachment_image_src($img_id, 'full');
				$single_img = wp_get_attachment_image_src($img_id, 'cspm-modal-single');
				$preview_img = wp_get_attachment_image_src($img_id, 'cspm-modal-carousel-preview');
				$thumb_img = wp_get_attachment_image_src($img_id, 'cspm-modal-carousel-thumb');
				
				$gallery_imgs[] = array(
					'fullscreen' => $this->cspm_setting_exists(0, $fullscreen_img, ''),
					'single' => $this->cspm_setting_exists(0, $single_img, ''),
					'preview' => $this->cspm_setting_exists(0, $preview_img, ''),
					'thumb' => $this->cspm_setting_exists(0, $thumb_img, ''),
				);
				
			}
			
			/**
			 * Get this post image (Location format: Image)
			 * @since 3.5 */
							
			$post_image_id = $image_id;
			
			$post_image = array();
			
			if($post_image_id){
					
				$fullscreen_img = wp_get_attachment_image_src($post_image_id, 'full');
				$single_img = wp_get_attachment_image_src($post_image_id, 'cspm-modal-single');					
				$preview_img = wp_get_attachment_image_src($post_image_id, 'cspm-modal-carousel-preview');
				$thumb_img = wp_get_attachment_image_src($post_image_id, 'cspm-modal-carousel-thumb');
				
				$post_image = array(
					'fullscreen' => $this->cspm_setting_exists(0, $fullscreen_img, ''),
					'single' => $this->cspm_setting_exists(0, $single_img, ''),
					'preview' => $this->cspm_setting_exists(0, $preview_img, ''),						
					'thumb' => $this->cspm_setting_exists(0, $thumb_img, ''),
				);
				
			}
			
			/**
			 * Get the embed thumbnail and HTML
			 * @since 3.5 */
			
			$embed = array(
				'title' => '',
				'type' => '',
				'thumb' => '',
				'provider' => '',
				'html' => '',																
			);
			
			if(!empty($embed_url)){
				 
				$wp_oembed = _wp_oembed_get_object(); // Get the WP_oEmbed object			
				$embed_data = (array) $wp_oembed->get_data($embed_url); // Get the oEmbed data from the embed URL | Return false on failure!
			
				if($embed_data){
				
					$embed['title'] = $this->cspm_setting_exists('title', $embed_data);
					$embed['type'] = $this->cspm_setting_exists('type', $embed_data);
					$embed['thumb'] = $this->cspm_setting_exists('thumbnail_url', $embed_data);
					$embed['provider'] = $this->cspm_setting_exists('provider_name', $embed_data);
					$embed['html'] = esc_html($this->cspm_setting_exists('html', $embed_data));
				
				}else $embed['html'] = esc_html(wp_oembed_get($embed_url));
				
			}
			
			/**
			 * Build this post media array
			 * @since 3.5 */
			 
			$media_array = array(
				'media' => array(
					'format' => $format,					
					'gallery' => $gallery_imgs,
					'image' => $post_image,
					'audio' => $audio_url,
					'embed' => $embed,					
				),
			);
			
			/**
			 * Add single post link & title to media array
			 * @since 3.6 */
			 						
			if(class_exists('CspmMainMap')){
				$CspmMainMap = CspmMainMap::this();
				$media_array['media']['link'] = $CspmMainMap->cspm_get_permalink($post_id); //@since 3.6
			}
			
			return $media_array;
			
		}
		
			
		/**
		 * Add the Laitude & the Longitude custom columns to the post type list
		 *
		 * @since 2.6.3 
		 */
		function cspm_manage_posts_columns($columns){
			
			$columns['pm_coordinates'] = esc_html__('PM. Coordinates', 'cspm');
				
			return $columns;
			
		}
		
		
		/**
		 * fill our Latitude & Longitude columns with data
		 *
		 * @since 2.6.3 
		 */		 
		function cspm_manage_posts_custom_column( $column_name, $post_id ){
			
			switch( $column_name ) {

				case 'pm_coordinates':
					$latitude = get_post_meta( $post_id, CSPM_LATITUDE_FIELD, true );
					$longitude = get_post_meta( $post_id, CSPM_LONGITUDE_FIELD, true );
					if(!empty($latitude) && !empty($longitude))
						echo '<div id="pm-coordinates-'.$post_id.'">'.$latitude.', '.$longitude.'</div>';
					else echo 'None';
				break;
		
			}
			
		}
		
		
		/** 
		 * This will make sure only our Metaboxes will be displayed in our Custom Post Type
		 *
		 * @since 3.0
		 */
		function cspm_remove_all_metaboxes(){
			
			$type = $this->object_type;
			$metafield_prefix = $this->metafield_prefix;

			/**
			 * Note: Regarding the timing issue, best place to reset the variable [@wp_meta_boxes] is just before it is used. 
			 * Metaboxes are printed via "do_meta_boxes()" function and inside it there are no hooks, however it contains ...
			 * ... "get_user_option( "meta-box-order_$page" )" ...
			 * ... and "get_user_option()" fires the filter "get_user_option_{$option}" so we can use it to perform our cleaning. */

			add_filter('get_user_option_meta-box-order_'.$type, function() use($type, $metafield_prefix){
			  
				global $wp_meta_boxes;
				
				if(get_current_screen()->id === $type){

					/**
					 * Publish Metabox */
					 
					$publish_metabox = $wp_meta_boxes[$type]['side']['core']['submitdiv'];
					
					/**
					 * Author Metabox */
					 
					$author_metabox = $wp_meta_boxes[$type]['normal']['core']['authordiv'];
					
					/**
					 * Progress Map Metaboxes */
					
					$cspm_normal_core_metaboxes_arrays = array();
					
						$cspm_normal_core_metaboxes = apply_filters('cspm_normal_high_metaboxes', array(
							$metafield_prefix.'_pm_cpt_metabox',
							$metafield_prefix.'_pm_metabox',
						));
						
						foreach($cspm_normal_core_metaboxes as $cspm_metabox){
							if(isset($wp_meta_boxes[$type]['normal']['high'][$cspm_metabox]))
								$cspm_normal_core_metaboxes_arrays[] = $wp_meta_boxes[$type]['normal']['high'][$cspm_metabox];
						}
						
					$cspm_side_low_metaboxes_arrays = array();
					
						$cspm_side_low_metaboxes = apply_filters('cspm_side_low_metaboxes', array(
							$metafield_prefix.'_pm_shortcode_widget'
						));
						
						foreach($cspm_side_low_metaboxes as $cspm_metabox){
							if(isset($wp_meta_boxes[$type]['side']['low'][$cspm_metabox]))
								$cspm_side_low_metaboxes_arrays[] = $wp_meta_boxes[$type]['side']['low'][$cspm_metabox];
						}
						
					/**
					 * Edit [@wp_meta_boxes] */
					 
					$wp_meta_boxes[$type] = array(
						'advanced' => array(),
						'side' => array(
							'core' => array(
								'submitdiv' => $publish_metabox
							),
							'low' => $cspm_side_low_metaboxes_arrays,
						),
						'normal' => array(
							'core' => array(
								'authordiv' => $author_metabox
							),
							'high' => $cspm_normal_core_metaboxes_arrays,
						),
					);
					
					return array();
					
				}
			
				/**
				 * [PHP_INT_MAX] is the largest integer supported in this build of PHP. Usually int(2147483647. Available since PHP 5.0.5 */
				
			}, PHP_INT_MAX );
		  
		} 

						
		/**
		 * Add the plugin in the administration menu 
		 */
		function cspm_admin_menu(){	
			
			/**
			 * Plugin settings menu */
			 
			add_menu_page( __( 'Progress map', 'cspm' ), __( 'Progress map', 'cspm' ), 'manage_options', $this->plugin_get_var, array(&$this, 'cspm_settings_page'), $this->plugin_url.'settings/img/menu-icon.png', '99.2' );
			
			/**
			 * All maps submenu */
			 	
			add_submenu_page( $this->plugin_get_var, __( 'All maps', 'cspm' ), __( 'All maps', 'cspm' ), 'manage_options', 'edit.php?post_type='.$this->object_type, NULL );
			
			/**
			 * Add new map submenu */
			 
			add_submenu_page( $this->plugin_get_var, __( 'Add new map', 'cspm' ), __( 'Add new map', 'cspm' ), 'manage_options', 'post-new.php?post_type='.$this->object_type, NULL );
				
		}
		
		/**
		 * Load plugin text domain
		 *
		 * @since 2.8
		 */
		function cspm_load_plugin_textdomain(){
			
			/**
			 * To translate the plugin, create a new folder in "wp-content/languages" ...
			 * ... and name it "cs-progress-map". Inside "cs-progress-map", paste your .mo & .po files.
			 * The plugin will detect the language of your website and display the appropriate language. */
			 
			$domain = 'cspm';
			
			$locale = apply_filters('plugin_locale', get_locale(), $domain);
		
			load_textdomain($domain, WP_LANG_DIR.'/cs-progress-map/'.$domain.'-'.$locale.'.mo');
	
			load_plugin_textdomain($domain, FALSE, $this->plugin_path.'languages/');
			
		}


		/**
		 * This will display the plugin settings form 
		 */
		function cspm_settings_page(){
								
			/**
			 * Display the plugin settings form */
			 
			echo '<div class="wrap">';
				$this->cspm_wpsf->cspm_settings(); 
			echo '</div>';					
					
		}
		
		
		function cspm_validate_settings($input){	    
		
			// Do your settings validation here
			// Same as $sanitize_callback from http://codex.wordpress.org/Function_Reference/register_setting
			return $input;
			
		}	
		
				
		/**
		 * Add settings link to plugin instalation area 
		 */
		function cspm_add_plugin_action_links($links){
		 
			return array_merge(
				array(
					'settings' => '<a href="' . get_bloginfo( 'wpurl' ) . '/wp-admin/admin.php?page=cs_progress_map_plugin">Settings</a>'
				),
				$links
			);
		 
		}	
		
	
		/**
		 * Add plugin site link to plugin instalation area 
		 */
		function cspm_plugin_meta_links($links, $file){
		 
			$plugin = plugin_basename(__FILE__);
		 
			/**
			 * create the link */
			 
			if ( $file == $plugin ) {
				return array_merge(
					(array) $links,
					array(
						'extensions' => '<a target="_blank" href="https://codespacing.com/wordpress-plugins/progress-map/extensions/">'.esc_html__('Extensions', 'cspm').'</a>',
						'documentation' => '<a target="_blank" href="https://codespacing.com/wordpress-plugins/progress-map/documentation/">'.esc_html__('Documentation', 'cspm').'</a>'
					)
				);
			}
			
			return $links;
		 
		}


		/**
		 * Alter the list of acceptable file extensions WordPress checks during media uploads 
		 *
		 * @since 2.7 
		 */
		function cspm_custom_upload_mimes($existing_mimes = array()){
			
			$existing_mimes['kml'] = 'application/vnd.google-earth.kml+xml';			
			$existing_mimes['kmz'] = 'application/vnd.google-earth.kmz';
			
			return $existing_mimes;
			
		}
		
		
		/**
		 * Display messages in the admin to inform changes or infos about "Progress Map" extensions
		 *
		 * @since 3.0
		 */
		function cspm_about_extensions(){
			
			/**
			 * Make sure to use "List & Filter" 2.0 or upper */
			 	
			if (class_exists('ProgressMapList')){
				
				$ProgressMapList = ProgressMapList::this();
				
				$reflect = new ReflectionClass($ProgressMapList);
				
				$plugin_version = $reflect->getProperty('plugin_version');
				
				if(($plugin_version->isPublic() && $ProgressMapList->plugin_version < 2.0) || !$plugin_version->isPublic()){
				
					echo '<div class="update-nag"><p>';
						_e( '<strong><em><u>"Progress Map v'.$this->plugin_version.'"</u></em> requires that you upgrade the extension <em><u>"List & Filter"</u></em> to the version 2.0 or upper!</strong>', 'cspm' );
					echo '</p></div>';
			
				}
			
			}
	
			/**
			 * Make sure to use "Nearby Places" 2.0 or upper */
			 	
			if (class_exists('CspmNearbyMap')){
				
				$CspmNearbyMap = CspmNearbyMap::this();
				
				$reflect = new ReflectionClass($CspmNearbyMap);
				
				$plugin_version = $reflect->getProperty('plugin_version');
				
				if(($plugin_version->isPublic() && $CspmNearbyMap->plugin_version < 2.0) || !$plugin_version->isPublic()){
				
					echo '<div class="update-nag"><p>';
						_e( '<strong><em><u>"Progress Map v'.$this->plugin_version.'"</u></em> requires that you upgrade the extension <em><u>"Nearby Places"</u></em> to the version 2.0 or upper!</strong>', 'cspm' );
					echo '</p></div>';
			
				}
			
			}
	
		}


		function cspm_before_settings(){	
	
			global $wpsf_settings;
								
			$sections = array();
			
			echo '<div class="codespacing_container" style="padding:0px; margin-top:30px; height:auto; width:800px; position:relative; box-shadow:rgba(0,0,0,.298039) 0 1px 2px -1px">';
				
				echo '<div class="cspm_admin_square_loader"></div>';
				
				echo '<div class="codespacing_header"><img src="'.$this->plugin_url.'settings/img/progress-map.png" /></div>';
				
				echo '<div class="codespacing_menu_container" style="width:auto; float:left; height:auto;">';
					
					echo '<ul class="codespacing_menu">';
						
						if(!empty($wpsf_settings)){
							
							usort($wpsf_settings, array(&$this->cspm_wpsf, 'cspm_sort_array'));
							
							$first_section = $wpsf_settings[0]['section_id'];
							
							foreach($wpsf_settings as $section){
								
								if(isset($section['section_id']) && isset($section['section_title'])){
									
									echo '<li class="codespacing_li" id='.$section['section_id'].'>'.$section['section_title'].'</li>';
									
									$sections[$section['section_id']] = $section['section_title'];								
									
								}
								
							}
								
						}
					
					echo '</ul>';
					
				echo '</div>';
				 
				echo '<div style="width:539px; height:auto; min-height:570px; padding:30px; float:left; border-left: 1px solid #e8ebec; border-top:0px solid #008fed; background:#f7f8f8 url('.$this->plugin_url.'settings/img/bg.png) repeat;">';	
				
		}
		
		function cspm_after_settings(){
				
				echo '<div class="cspm_admin_btm_square_loader"></div>';
				
				echo '</div>';
				
				echo '<div style="clear:both"></div>';
				
			echo '</div>';	
			
			echo '<div class="codespacing_rates_fotter"><a target="_blank" href="http://codecanyon.net/item/progress-map-wordpress-plugin/5581719"><img src="'.$this->plugin_url.'settings/img/rates.jpg" /></a></div>';
			
			if(!class_exists('ProgressMapList') || !class_exists('CspmNearbyMap'))
			
			echo '<div><h3>Extend "Progress Map" with these awesome and powerful add-ons:</h3></div>';
			
			/**
			 * Progress Map List & Filter Ban */
			
			if(!class_exists('ProgressMapList'))
				echo '<div style="float:left; margin-right:20px;"><a target="_blank" href="http://codecanyon.net/item/progress-map-list-filter-wordpress-plugin/16134134?ref=codespacing"><img src="'.$this->plugin_url.'settings/img/list-and-filter-thumb.jpg" /></a></div>';
			
			/**
			 * Nearby Places Ban */
			
			if(!class_exists('CspmNearbyMap'))
				echo '<div style="float:left; margin-right:20px;"><a target="_blank" href="http://codecanyon.net/item/nearby-places-wordpress-plugin/15067875?ref=codespacing"><img src="'.$this->plugin_url.'settings/img/nearby-places-thumb.png" /></a></div>';
			
			echo '<div style="clear:both;"></div>';
			
			echo '<div class="codespacing_copyright">&copy; All rights reserved CodeSpacing. Progress Map '.$this->plugin_version.'</div>';
			
			echo '<div class="codespacing_copyright">&copy; <a target="_blank" href="https://www.freevectormaps.com/world-maps/WRLD-EPS-01-0002?ref=atr">Map of World with Regions - Single Color</a> by <a target="_blank" href="https://www.freevectormaps.com/?ref=atr">FreeVectorMaps.com</a></div>';

		}
		
				
		/**
		 * Register new carousel image sizes
		 *
		 * @since 3.0 
		 */				 			
		function cspm_add_carousel_image_sizes(){
			
			if(function_exists('add_image_size')){
					
				$args = array( 'post_type' => $this->object_type);
				
				$loop = new WP_Query( $args );
				
				while ( $loop->have_posts() ) : $loop->the_post();
					
					$object_id = get_the_id();
					
					$horizontal_image_size = explode(',', get_post_meta( $object_id, $this->metafield_prefix.'_horizontal_image_size', true ));
							
						$horizontal_image_width = isset($horizontal_image_size[0]) ? $horizontal_image_size[0] : 204;
						$horizontal_image_height = isset($horizontal_image_size[1]) ? $horizontal_image_size[1] : 150; 
		
						add_image_size('cspm-horizontal-thumbnail-map'.$object_id, $horizontal_image_width, $horizontal_image_height, true);
					
					$vertical_image_size = explode(',', get_post_meta( $object_id, $this->metafield_prefix.'_vertical_image_size', true ));
							
						$vertical_image_width = isset($vertical_image_size[0]) ? $vertical_image_size[0] : 204;
						$vertical_image_height = isset($vertical_image_size[1]) ? $vertical_image_size[1] : 120; 
					
						add_image_size('cspm-vertical-thumbnail-map'.$object_id, $vertical_image_width, $vertical_image_height, true);
	
				endwhile;
				
			}

		}
		
		
		/**
		 * Returns an element's ID in the current language or in another specified language.
		 *
		 * @since 2.5
		 * @updated 2.8.4
		 */
		function cspm_wpml_object_id($ID, $post_tag, $orginal_val = true, $lang_code = "", $use_with_wpml = "no"){
			
			if(!empty($lang_code))
				$lang_code = apply_filters('wpml_current_language', NULL);
			
			return ($use_with_wpml == 'yes') ? apply_filters('wpml_object_id', $ID, $post_tag, $orginal_val, $lang_code) : $ID;
			
		}
		
		
		/**
		 * Get the Default language of the website
		 *
		 * @since 2.5
		 * @updated 2.8.4
		 */	
		function cspm_wpml_default_lang($use_with_wpml = "no"){
			
			return ($use_with_wpml == 'yes') ? apply_filters('wpml_default_language', NULL ) : '';	
			
		}
		
		
		/**
		 * Register strings for WPML 
		 *
		 * @since 2.5
		 * @updated 2.8.4
		 */
		function cspm_wpml_register_string($name, $value, $use_with_wpml = "no"){
				
			if($use_with_wpml == 'yes' && !empty($name) && !empty($value))
				do_action('wpml_register_single_string', 'Progress map', $name, $value);
			
		}
		
		
		/**
		 * Get registered string from WPML DBB when displaying
		 *
		 * @since 2.5
		 * @updated 2.8.4
		 */
		function cspm_wpml_get_string($name, $value, $use_with_wpml = "no"){
		
			if($use_with_wpml == 'yes' && !empty($name) && !empty($value))
				return apply_filters('wpml_translate_single_string', $value, 'Progress map', $name);
			else return $value;
			
		}


		/**
		 * AJAX function
		 * Get all posts and create a JSON array of markers base on the ...
		 * ... custom fields latitude & longitude + Secondary lat & lng
		 *
		 * @since 2.5
		 * @updated 3.5 | Added the media files to markers
		 */
		function cspm_regenerate_markers($is_ajax = true){
						
			if( class_exists( 'CspmMainMap' ) )
				$CspmMainMap = CspmMainMap::this();
			
			$post_types = $this->post_types;
			
			$meta_values = array(
				CSPM_LATITUDE_FIELD, 
				CSPM_LONGITUDE_FIELD, 
				CSPM_SECONDARY_LAT_LNG_FIELD,
				CSPM_FORMAT_FIELD, //@since 3.5
				CSPM_AUDIO_FIELD, //@since 3.5
				CSPM_IMAGE_FIELD.'_id', //@since 3.5
				CSPM_EMBED_FIELD, //@since 3.5
				CSPM_GALLERY_FIELD, //@since 3.5
			);
			
			if(count($post_types) > 0){
				
				/**
				 * Init the array that will contain all markers of each post type */
				 
				$post_types_markers = array();
				
				/**
				 * Loop throught all post types selected in the plugin settings */
				 
				foreach($post_types as $post_type){
					
					$post_types_markers[$post_type] = array();
					
					/**
					 * Get all the values of the Latitude/Longitude/Secondary coordinates ...
					 * ... where each row in the array contains the value of the custom field and ...
					 * ... the post ID related to */
					 
					foreach($meta_values as $meta_value)
						$post_types_markers[$post_type][$meta_value] = $CspmMainMap->cspm_get_meta_values($meta_value, $post_type);
									
					$post_types_markers[$post_type] = array_merge_recursive(
						$post_types_markers[$post_type][CSPM_LATITUDE_FIELD], 
						$post_types_markers[$post_type][CSPM_LONGITUDE_FIELD],
						$post_types_markers[$post_type][CSPM_SECONDARY_LAT_LNG_FIELD],
						$post_types_markers[$post_type][CSPM_FORMAT_FIELD], //@since 3.5
						$post_types_markers[$post_type][CSPM_AUDIO_FIELD], //@since 3.5
						$post_types_markers[$post_type][CSPM_IMAGE_FIELD.'_id'], //@since 3.5
						$post_types_markers[$post_type][CSPM_EMBED_FIELD], //@since 3.5
						$post_types_markers[$post_type][CSPM_GALLERY_FIELD] //@since 3.5
					);								
																	   
				}
			
				global $wpdb;
				
				$markers_object = $post_taxonomy_terms = array();
				
				/**
				 * Create the map markers object for each post type */
				 
				foreach($post_types_markers as $post_type => $posts_and_coordinates){
					
					$i = $j = 0;						
					
					/**
					 * Get post type taxonomies */
					 
					$post_taxonomies = (array) get_object_taxonomies($post_type, 'names');
						if(($key = array_search('post_format', $post_taxonomies)) !== false) {
							unset($post_taxonomies[$key]);
						}
						
					/**
					 * Implode taxonomies to use them in the Mysql IN clause */
					 
					$taxonomies = "'" . implode("', '", $post_taxonomies) . "'";
					
					/**
					 * Directly querying the database is normally frowned upon, but all ...
					 * ... of the API functions will return the full post objects which will
					 * ... suck up lots of memory. This is best, just not as future proof */
					 
					$query = "SELECT t.term_id, tt.taxonomy, tr.object_id FROM $wpdb->terms AS t 
								INNER JOIN $wpdb->term_taxonomy AS tt 
									ON tt.term_id = t.term_id 
								INNER JOIN $wpdb->term_relationships AS tr 
									ON tr.term_taxonomy_id = tt.term_taxonomy_id 
								WHERE tt.taxonomy IN ($taxonomies)";
					
					/**
					 * Run the query. This will get an array of all terms where each term ...
					 * ... is listed with the taxonomy name and the post id */
					 
					$taxonomy_terms_and_posts = $wpdb->get_results( $query, ARRAY_A );
			
					/**
					 * Loop through the terms and order them in a way, the array will have the post_id as key ...
					 * ... inside that array, there will be another array with the key == taxonomy name ...
					 * ... inside that last array, there will be all the terms of a post */
					 
					foreach($taxonomy_terms_and_posts as $term)							
						$post_taxonomy_terms[$term['object_id']][$term['taxonomy']][] = $term['term_id'];
					
					/**
					 * Biuld the marker object of each post 
					 * @updated in 3.5 by adding the media files to the marker object */
					 
					foreach($posts_and_coordinates as $post_id => $post_coordinates){						
						
						if(isset($post_coordinates[CSPM_LATITUDE_FIELD]) && isset($post_coordinates[CSPM_LONGITUDE_FIELD])){
							
							$post_id = str_replace('post_id_', '', $post_id);							
							
							/**
							 * If a taxonomy is not set in the $post_taxonomy_terms array ...
							 * ... it means that the post has no terms available for that taxonomy ...
							 * ... but we still need to create an empty array for that taxonomy in order ...
							 * ... to use it with faceted search */
							 
							foreach($post_taxonomies as $taxonomy_name){
								
								/**
								 * Extend the $post_taxonomy_terms array with an empty array of the not existing taxonomy */
								 
								if(!isset($post_taxonomy_terms[$post_id][$taxonomy_name]))
									$post_taxonomy_terms[$post_id][$taxonomy_name] = array(); 
							
							}
							
							$markers_object[$post_type]['post_id_'.$post_id] = array_merge(
								array(
									'lat' => $post_coordinates[CSPM_LATITUDE_FIELD],
									'lng' => $post_coordinates[CSPM_LONGITUDE_FIELD],
									'post_id' => $post_id,
									'post_tax_terms' => $post_taxonomy_terms[$post_id],
									'is_child' => 'no',
									'child_markers' => array(),
								),
								
								/**
								 * Add post media to marker object 
								 * @since 3.5 */
								 
								$this->cspm_get_post_media($post_id, array(
									'format' => isset($post_coordinates[CSPM_FORMAT_FIELD]) ? $post_coordinates[CSPM_FORMAT_FIELD] : '',
									'gallery' => isset($post_coordinates[CSPM_GALLERY_FIELD]) ? maybe_unserialize($post_coordinates[CSPM_GALLERY_FIELD]) : array(),
									'image_id' => isset($post_coordinates[CSPM_IMAGE_FIELD.'_id']) ? $post_coordinates[CSPM_IMAGE_FIELD.'_id'] : '',
									'audio_url' => isset($post_coordinates[CSPM_AUDIO_FIELD]) ? $post_coordinates[CSPM_AUDIO_FIELD] : '',
									'embed_url' => isset($post_coordinates[CSPM_EMBED_FIELD]) ? $post_coordinates[CSPM_EMBED_FIELD] : '',
								))
							);																 
				
							$i++;
							
							/**
							 * Sencondary latLng */
							 
							if(isset($post_coordinates[CSPM_SECONDARY_LAT_LNG_FIELD]) && !empty($post_coordinates[CSPM_SECONDARY_LAT_LNG_FIELD])){
								
								$child_markers = array();
								
								$lats_lngs = explode(']', $post_coordinates[CSPM_SECONDARY_LAT_LNG_FIELD]);	
										
								foreach($lats_lngs as $single_coordinate){
								
									$strip_coordinates = str_replace(array('[', ']', ' '), '', $single_coordinate);
									
									$coordinates = explode(',', $strip_coordinates);
									
									if(isset($coordinates[0]) && isset($coordinates[1]) && !empty($coordinates[0]) && !empty($coordinates[1])){
										
										$lat = $coordinates[0];
										$lng = $coordinates[1];
										
										$child_markers[] = array(
											'lat' => $lat,
											'lng' => $lng,
											'post_id' => $post_id,
											'post_tax_terms' => $post_taxonomy_terms,
											'is_child' => 'yes_'.$j
										);
																														
										$lat = '';
										$lng = '';
										$j++;
									
									} 
									
									$i++;
									
								}
								
								$markers_object[$post_type]['post_id_'.$post_id]['child_markers'] = $child_markers;
							
							}								
																																					
						}
						
					}
					
				}
														
				/**
				 * Update settings */
				 
				if(count($markers_object) > 0){
					
					update_option('cspm_markers_array', $markers_object);
										
				}
				
			}
			
			if($is_ajax) die();
			
		}
		
		
		/**
		 * Run some settings updates to sync. with the latest version
		 *
		 * @since 2.4 
		 * @updated 3.0
		 * @updated 3.1 [check if it's plugin update or new installation]
		 * @updated 3.2 [fixed issue with "Post in" & "Post not in" + Marker categories images not been imported]
		 */
		function cspm_sync_settings_for_latest_version(){
				
			$opt_group = preg_replace("/[^a-z0-9]+/i", "", basename($this->plugin_path .'settings/cspm.php', '.php'));

			if($this->plugin_version >= 3.0){
				
				/**
				 * It's based on this options that we'll define if the below code has been executed before or not.
				 * The option "cspm_settings_v2" is a backup option for the settings of "Progress Map v2.+"
				 * 
				 * @udpated 3.1 --------
				 * 
				 * This will first check if it's a plugin update or a new installation by looking for the option "cspm_settings" ...
				 * ... then it'll look for the backup option "cspm_settings_v2" to define if we'll excute this code or not.
				 */
				 
				if(get_option($opt_group.'_settings') && !get_option($opt_group.'_settings_v2')){
					
					/**
					 * Get "PM. v2.+" settings */
					 
					$cspm_v2_options = get_option($opt_group.'_settings');
					
					/**
					 * Save/Backup "PM. v2.+" settings just in case */
						
					update_option($opt_group.'_settings_v2', $cspm_v2_options);
				
					/**
					 * Post types */
					
						/**
						 * Get post types selected in the v2.+ fields "Query settings => Main content type" ...
						 * ... & "Query settings => Secondary content types" */
						
						$main_post_type = $this->cspm_setting_exists('cspm_generalsettings_post_type', $cspm_v2_options, 'post');
						$secondary_post_types = $this->cspm_setting_exists('cspm_generalsettings_secondary_post_type', $cspm_v2_options, array());
						
						/**
						 * Save all post types in the new v3.0 field "Plugin settings => Post types" */
						
						$cspm_v2_options['cspm_pluginsettings_post_types'] = array_merge((array) $main_post_type, $secondary_post_types);
						
						/**
						 * Update v2.+ options.
						 * Now, in this step and with this update, we can concider these settings as compatible with "PM v3.0" */
						 
						update_option($opt_group.'_settings', $cspm_v2_options);
						
					/**
					 * == Create a new map with all v2.+ settings as new post of our CPT (Defined in [@object_type]) in v3.0 == */
																				
					/**
					 * Query settings */
					
					$query_settings = array(
						$this->metafield_prefix.'_number_of_items' => $this->cspm_setting_exists('cspm_generalsettings_number_of_items', $cspm_v2_options, ''), 
						$this->metafield_prefix.'_taxonomy_relation_param' => $this->cspm_setting_exists('cspm_generalsettings_taxonomy_relation_param', $cspm_v2_options, ''),
						$this->metafield_prefix.'_custom_fields' => ($this->cspm_setting_exists('cspm_generalsettings_custom_fields', $cspm_v2_options, '')),
						$this->metafield_prefix.'_custom_field_relation_param' => $this->cspm_setting_exists('cspm_generalsettings_custom_field_relation_param', $cspm_v2_options, ''),
						$this->metafield_prefix.'_cache_results' => $this->cspm_setting_exists('cspm_generalsettings_cache_results', $cspm_v2_options, ''),
						$this->metafield_prefix.'_update_post_meta_cache' => $this->cspm_setting_exists('cspm_generalsettings_update_post_meta_cache', $cspm_v2_options, ''),
						$this->metafield_prefix.'_update_post_term_cache' => $this->cspm_setting_exists('cspm_generalsettings_update_post_term_cache', $cspm_v2_options, ''),
						$this->metafield_prefix.'_authors_prefixing' => $this->cspm_setting_exists('cspm_generalsettings_authors_prefixing', $cspm_v2_options, ''),
						$this->metafield_prefix.'_authors' => $this->cspm_setting_exists('cspm_generalsettings_authors', $cspm_v2_options, ''),
						$this->metafield_prefix.'_orderby_param' => $this->cspm_setting_exists('cspm_generalsettings_orderby_param', $cspm_v2_options, ''),
						$this->metafield_prefix.'_orderby_meta_key' => $this->cspm_setting_exists('cspm_generalsettings_orderby_meta_key', $cspm_v2_options, ''),					
						$this->metafield_prefix.'_order_param' => $this->cspm_setting_exists('cspm_generalsettings_order_param', $cspm_v2_options, ''),
					);
						
						/**
						 * "Post In" and "Post not in" 
						 * @since 3.2 */
						 
						$post_in = $this->cspm_setting_exists('cspm_generalsettings_post_in', $cspm_v2_options, '');
						
						if(!empty($post_in))
							$query_settings[$this->metafield_prefix.'_post_in'] = explode(',', $post_in);
						 
						$post_not_in = $this->cspm_setting_exists('cspm_generalsettings_post_not_in', $cspm_v2_options, '');
						
						if(!empty($post_not_in))
							$query_settings[$this->metafield_prefix.'_post_not_in'] = explode(',', $post_not_in);
					
						/**
						 * Build Taxonomies */
						 
						$main_post_type_taxonomies = (array) get_object_taxonomies($main_post_type, 'objects');
							unset($main_post_type_taxonomies['post_format']);
							
						reset($main_post_type_taxonomies); // Set the cursor to 0
						
						if(is_array($main_post_type_taxonomies)){
							
							foreach($main_post_type_taxonomies as $single_taxonomy){
								
								if(isset($single_taxonomy->name)){
								
									$tax_name = $single_taxonomy->name;
									
									$query_settings[$this->metafield_prefix . '_taxonomie_'.$tax_name] = ($this->cspm_setting_exists('cspm_generalsettings_taxonomie_'.$tax_name, $cspm_v2_options, ''));
									$query_settings[$this->metafield_prefix.'_'.$tax_name.'_operator_param'] = $this->cspm_setting_exists('cspm_generalsettings_'.$tax_name.'_operator_param', $cspm_v2_options);
							
								}
								
							}
					
						}
						
						/**
						 * Build statuses */
						 
						$statuses = get_post_stati();
						
						$selected_statuses = array();
						
						if(is_array($statuses)){
							
							foreach($statuses as $status){	
								
								$status_name = $this->cspm_setting_exists('cspm_generalsettings_items_status_'.$status, $cspm_v2_options);
								
								if(!empty($status_name))
									$selected_statuses[] = $status_name;
							
							}
							
						}
						
						$query_settings[$this->metafield_prefix.'_items_status'] = $selected_statuses;
						
					/**
					 * Layout settings */
					
					$layout_settings = array( 
						$this->metafield_prefix.'_main_layout' => $this->cspm_setting_exists('cspm_layoutsettings_main_layout', $cspm_v2_options, ''),
						$this->metafield_prefix.'_layout_type' => $this->cspm_setting_exists('cspm_layoutsettings_layout_type', $cspm_v2_options, ''),
						$this->metafield_prefix.'_layout_fixed_width' => $this->cspm_setting_exists('cspm_layoutsettings_layout_fixed_width', $cspm_v2_options, ''),
						$this->metafield_prefix.'_layout_fixed_height' => $this->cspm_setting_exists('cspm_layoutsettings_layout_fixed_height', $cspm_v2_options, ''),
					);
										
					/**
					 * Map settings */
					 
					$map_settings = array( 
						$this->metafield_prefix.'_map_center' => $this->cspm_setting_exists('cspm_mapsettings_map_center', $cspm_v2_options, ''),
						$this->metafield_prefix.'_initial_map_style' => $this->cspm_setting_exists('cspm_mapsettings_initial_map_style', $cspm_v2_options, ''),
						$this->metafield_prefix.'_map_zoom' => $this->cspm_setting_exists('cspm_mapsettings_map_zoom', $cspm_v2_options, ''),
						$this->metafield_prefix.'_max_zoom' => $this->cspm_setting_exists('cspm_mapsettings_max_zoom', $cspm_v2_options, ''),
						$this->metafield_prefix.'_min_zoom' => $this->cspm_setting_exists('cspm_mapsettings_min_zoom', $cspm_v2_options, ''),
						$this->metafield_prefix.'_zoom_on_doubleclick' => $this->cspm_setting_exists('cspm_mapsettings_zoom_on_doubleclick', $cspm_v2_options, ''),
						$this->metafield_prefix.'_map_draggable' => $this->cspm_setting_exists('cspm_mapsettings_map_draggable', $cspm_v2_options, ''),
						$this->metafield_prefix.'_useClustring' => $this->cspm_setting_exists('cspm_mapsettings_useClustring', $cspm_v2_options, ''),
						$this->metafield_prefix.'_gridSize' => $this->cspm_setting_exists('cspm_mapsettings_gridSize', $cspm_v2_options, ''),
						$this->metafield_prefix.'_autofit' => $this->cspm_setting_exists('cspm_mapsettings_autofit', $cspm_v2_options, ''),
						$this->metafield_prefix.'_traffic_layer' => $this->cspm_setting_exists('cspm_mapsettings_traffic_layer', $cspm_v2_options, ''),
						$this->metafield_prefix.'_transit_layer' => $this->cspm_setting_exists('cspm_mapsettings_transit_layer', $cspm_v2_options, ''),
						$this->metafield_prefix.'_geoIpControl' => $this->cspm_setting_exists('cspm_mapsettings_geoIpControl', $cspm_v2_options, ''),
						$this->metafield_prefix.'_show_user' => $this->cspm_setting_exists('cspm_mapsettings_show_user', $cspm_v2_options, ''),
						$this->metafield_prefix.'_user_marker_icon' => $this->cspm_setting_exists('cspm_mapsettings_user_marker_icon', $cspm_v2_options, ''),
						$this->metafield_prefix.'_user_map_zoom' => $this->cspm_setting_exists('cspm_mapsettings_user_map_zoom', $cspm_v2_options, ''),
						$this->metafield_prefix.'_mapTypeControl' => $this->cspm_setting_exists('cspm_mapsettings_mapTypeControl', $cspm_v2_options, ''),
						$this->metafield_prefix.'_streetViewControl' => $this->cspm_setting_exists('cspm_mapsettings_streetViewControl', $cspm_v2_options, ''),
						$this->metafield_prefix.'_scrollwheel' => $this->cspm_setting_exists('cspm_mapsettings_scrollwheel', $cspm_v2_options, ''),
						$this->metafield_prefix.'_zoomControl' => $this->cspm_setting_exists('cspm_mapsettings_zoomControl', $cspm_v2_options, ''),
						$this->metafield_prefix.'_zoomControlType' => $this->cspm_setting_exists('cspm_mapsettings_zoomControlType', $cspm_v2_options, ''),
						$this->metafield_prefix.'_retinaSupport' => $this->cspm_setting_exists('cspm_mapsettings_retinaSupport', $cspm_v2_options, ''),
						$this->metafield_prefix.'_defaultMarker' => $this->cspm_setting_exists('cspm_mapsettings_defaultMarker', $cspm_v2_options, ''),
						$this->metafield_prefix.'_markerAnimation' => $this->cspm_setting_exists('cspm_mapsettings_markerAnimation', $cspm_v2_options, ''),
						$this->metafield_prefix.'_marker_icon' => $this->cspm_setting_exists('cspm_mapsettings_marker_icon', $cspm_v2_options, ''),
						$this->metafield_prefix.'_marker_anchor_point_option' => $this->cspm_setting_exists('cspm_mapsettings_marker_anchor_point_option', $cspm_v2_options, ''),
						$this->metafield_prefix.'_marker_anchor_point' => $this->cspm_setting_exists('cspm_mapsettings_marker_anchor_point', $cspm_v2_options, ''),
						$this->metafield_prefix.'_big_cluster_icon' => $this->cspm_setting_exists('cspm_mapsettings_big_cluster_icon', $cspm_v2_options, ''),
						$this->metafield_prefix.'_medium_cluster_icon' => $this->cspm_setting_exists('cspm_mapsettings_medium_cluster_icon', $cspm_v2_options, ''),
						$this->metafield_prefix.'_small_cluster_icon' => $this->cspm_setting_exists('cspm_mapsettings_small_cluster_icon', $cspm_v2_options, ''),
						$this->metafield_prefix.'_cluster_text_color' => $this->cspm_setting_exists('cspm_mapsettings_cluster_text_color', $cspm_v2_options, ''),
						$this->metafield_prefix.'_zoom_in_icon' => $this->cspm_setting_exists('cspm_mapsettings_zoom_in_icon', $cspm_v2_options, ''),
						$this->metafield_prefix.'_zoom_in_css' => $this->cspm_setting_exists('cspm_mapsettings_zoom_in_css', $cspm_v2_options, ''),
						$this->metafield_prefix.'_zoom_out_icon' => $this->cspm_setting_exists('cspm_mapsettings_zoom_out_icon', $cspm_v2_options, ''),
						$this->metafield_prefix.'_zoom_out_css' => $this->cspm_setting_exists('cspm_mapsettings_zoom_out_css', $cspm_v2_options, ''),
					);
								
					/**
					 * Map style settings */
					
					$map_style_settings = array(  
						$this->metafield_prefix.'_style_option' => $this->cspm_setting_exists('cspm_mapstylesettings_style_option', $cspm_v2_options, ''),
						$this->metafield_prefix.'_map_style' => $this->cspm_setting_exists('cspm_mapstylesettings_map_style', $cspm_v2_options, ''),
						$this->metafield_prefix.'_custom_style_name' => $this->cspm_setting_exists('cspm_mapstylesettings_custom_style_name', $cspm_v2_options, ''),
						$this->metafield_prefix.'_js_style_array' => $this->cspm_setting_exists('cspm_mapstylesettings_js_style_array', $cspm_v2_options, ''),
					);
					
					/** 
					 * Infobox settings */
					 
					$infobox_settings = array(
						$this->metafield_prefix.'_show_infobox' => $this->cspm_setting_exists('cspm_infoboxsettings_show_infobox', $cspm_v2_options, ''),
						$this->metafield_prefix.'_infobox_type' => $this->cspm_setting_exists('cspm_infoboxsettings_infobox_type', $cspm_v2_options, ''),
						$this->metafield_prefix.'_infobox_display_event' => $this->cspm_setting_exists('cspm_infoboxsettings_infobox_display_event', $cspm_v2_options, ''),
						$this->metafield_prefix.'_remove_infobox_on_mouseout' => $this->cspm_setting_exists('cspm_infoboxsettings_remove_infobox_on_mouseout', $cspm_v2_options, ''),
						$this->metafield_prefix.'_infobox_external_link' => $this->cspm_setting_exists('cspm_infoboxsettings_infobox_external_link', $cspm_v2_options, ''),
					);
					
					/**
					 * Marker categories settings */
					
					$selected_taxonomy = $this->cspm_setting_exists('cspm_markercategoriessettings_marker_taxonomies', $cspm_v2_options, '');
					
					$marker_categories_settings = array(  
						$this->metafield_prefix.'_marker_cats_settings' => $this->cspm_setting_exists('cspm_markercategoriessettings_marker_cats_settings', $cspm_v2_options, ''),
						$this->metafield_prefix.'_marker_categories_taxonomy' => $selected_taxonomy,					
					);
					
						if(!empty($selected_taxonomy)){
							
							$marker_categories_images_array = array();
							
							$marker_categories_images = (array) json_decode(str_replace('tag_', '', $this->cspm_setting_exists('cspm_markercategoriessettings_marker_category_'.$selected_taxonomy, $cspm_v2_options, '')));
							
							if(is_array($marker_categories_images)){
								
								foreach($marker_categories_images as $marker_image){
									
									if(count((array) $marker_image) > 0){
										
										$new_marker_imag = array();
										
										foreach((array) $marker_image as $key => $value)
											$new_marker_imag[$key.'_'.$selected_taxonomy] = $value;
											
									}
									
									$marker_categories_images_array[] = $new_marker_imag;
								
								}
								
							}
								
							$marker_categories_settings[$this->metafield_prefix.'_marker_categories_images'] = $marker_categories_images_array;
						
						}
					
					/**
					 * KML Layers settings */
					 
					$kml_layers_settings = array( 
						$this->metafield_prefix.'_use_kml' => $this->cspm_setting_exists('cspm_kmlsettings_use_kml', $cspm_v2_options, ''),					
					);
						
						$kml_url = $this->cspm_setting_exists('cspm_kmlsettings_kml_file', $cspm_v2_options, '');
						
						$kml_data_array = array(
							'kml_label' => (!empty($kml_url)) ? 'My KML Layer' : '',
							'kml_url' => $kml_url,
							'kml_suppressInfoWindows' => $this->cspm_setting_exists('cspm_kmlsettings_suppressInfoWindows', $cspm_v2_options, ''),
							'kml_preserveViewport' => $this->cspm_setting_exists('cspm_kmlsettings_preserveViewport', $cspm_v2_options, ''),
							'kml_visibility' => 'true',
						);
						
						$kml_layers_settings[$this->metafield_prefix.'_kml_layers'] = array(0 => $kml_data_array);
					
					/**
					 * Overlays (Polylines & Polygons) settings */
					
					$overlays_settings = array( 						
						$this->metafield_prefix.'_draw_polyline' => $this->cspm_setting_exists('cspm_overlayssettings_draw_polyline', $cspm_v2_options, ''),
						$this->metafield_prefix.'_draw_polygon' => $this->cspm_setting_exists('cspm_overlayssettings_draw_polygon', $cspm_v2_options, ''),
					);
						
						/**
						 * Polylines */
						 
						$polylines_array = array();
						
						$polylines = (array) json_decode(str_replace('tag_', '', $this->cspm_setting_exists('cspm_overlayssettings_polylines', $cspm_v2_options, '')));
						
						if(is_array($polylines)){
							
							foreach($polylines as $polyline){
								$polylines_array[] = (array) $polyline;
							}
							
						}
								
						$overlays_settings[$this->metafield_prefix.'_polylines'] = $polylines_array;
						
						/**
						 * Polygons */
						 
						$polygons_array = array();
						
						$polygons = (array) json_decode(str_replace('tag_', '', $this->cspm_setting_exists('cspm_overlayssettings_polygons', $cspm_v2_options, '')));
						
						if(is_array($polygons)){
							
							foreach($polygons as $polygon){
								$polygons_array[] = (array) $polygon;
							}
						
						}
						
						$overlays_settings[$this->metafield_prefix.'_polygons'] = $polygons_array;
					
					/**
					 * Carousel settings */
					
					$carousel_settings = array(  
						$this->metafield_prefix.'_show_carousel' => $this->cspm_setting_exists('cspm_carouselsettings_show_carousel', $cspm_v2_options, ''),
						$this->metafield_prefix.'_carousel_mode' => $this->cspm_setting_exists('cspm_carouselsettings_carousel_mode', $cspm_v2_options, ''),
						$this->metafield_prefix.'_carousel_scroll' => $this->cspm_setting_exists('cspm_carouselsettings_carousel_scroll', $cspm_v2_options, ''),
						$this->metafield_prefix.'_carousel_easing' => $this->cspm_setting_exists('cspm_carouselsettings_carousel_easing', $cspm_v2_options, ''),
						$this->metafield_prefix.'_carousel_animation' => $this->cspm_setting_exists('cspm_carouselsettings_carousel_animation', $cspm_v2_options, ''),
						$this->metafield_prefix.'_carousel_auto' => $this->cspm_setting_exists('cspm_carouselsettings_carousel_auto', $cspm_v2_options, ''),
						$this->metafield_prefix.'_carousel_wrap' => $this->cspm_setting_exists('cspm_carouselsettings_carousel_wrap', $cspm_v2_options, ''),
						$this->metafield_prefix.'_scrollwheel_carousel' => $this->cspm_setting_exists('cspm_carouselsettings_scrollwheel_carousel', $cspm_v2_options, ''),
						$this->metafield_prefix.'_touchswipe_carousel' => $this->cspm_setting_exists('cspm_carouselsettings_touchswipe_carousel', $cspm_v2_options, ''),
						$this->metafield_prefix.'_move_carousel_on' => array_merge(
							(array) $this->cspm_setting_exists('cspm_carouselsettings_move_carousel_on_marker_click', $cspm_v2_options, ''),
							(array) $this->cspm_setting_exists('cspm_carouselsettings_move_carousel_on_marker_hover', $cspm_v2_options, ''),
							(array) $this->cspm_setting_exists('cspm_carouselsettings_move_carousel_on_infobox_hover', $cspm_v2_options, '')
						),
						$this->metafield_prefix.'_carousel_map_zoom' => $this->cspm_setting_exists('cspm_carouselsettings_carousel_map_zoom', $cspm_v2_options, ''),
					);
					
					/**
					 * Carousel style settings */
					
					$carousel_style_settings = array( 
						$this->metafield_prefix.'_carousel_css' => $this->cspm_setting_exists('cspm_carouselstyle_carousel_css', $cspm_v2_options, ''), 
						$this->metafield_prefix.'_arrows_background' => $this->cspm_setting_exists('cspm_carouselstyle_arrows_background', $cspm_v2_options, ''),
						$this->metafield_prefix.'_items_background' => $this->cspm_setting_exists('key', $cspm_v2_options, ''),
						$this->metafield_prefix.'_items_hover_background' => $this->cspm_setting_exists('key', $cspm_v2_options, ''),
					);
					
					/**
					 * Carousel items settings */
					 
					$carousel_items_settings = array( 
						$this->metafield_prefix.'_items_view' => $this->cspm_setting_exists('key', $cspm_v2_options, ''),
						$this->metafield_prefix.'_horizontal_item_size' => $this->cspm_setting_exists('cspm_itemssettings_horizontal_item_size', $cspm_v2_options, ''),
						$this->metafield_prefix.'_horizontal_image_size' => $this->cspm_setting_exists('cspm_itemssettings_horizontal_image_size', $cspm_v2_options, ''),
						$this->metafield_prefix.'_horizontal_details_size' => $this->cspm_setting_exists('cspm_itemssettings_horizontal_details_size', $cspm_v2_options, ''),
						$this->metafield_prefix.'_vertical_item_size' => $this->cspm_setting_exists('cspm_itemssettings_vertical_item_size', $cspm_v2_options, ''),
						$this->metafield_prefix.'_vertical_image_size' => $this->cspm_setting_exists('cspm_itemssettings_vertical_image_size', $cspm_v2_options, ''),
						$this->metafield_prefix.'_vertical_details_size' => $this->cspm_setting_exists('cspm_itemssettings_vertical_details_size', $cspm_v2_options, ''),
						$this->metafield_prefix.'_show_details_btn' => $this->cspm_setting_exists('cspm_itemssettings_show_details_btn', $cspm_v2_options, ''),
						$this->metafield_prefix.'_details_btn_text' => $this->cspm_setting_exists('cspm_itemssettings_details_btn_text', $cspm_v2_options, ''),
						$this->metafield_prefix.'_click_on_title' => $this->cspm_setting_exists('cspm_itemssettings_click_on_title', $cspm_v2_options, ''),
						$this->metafield_prefix.'_external_link' => $this->cspm_setting_exists('cspm_itemssettings_external_link', $cspm_v2_options, ''),
						$this->metafield_prefix.'_items_details' => $this->cspm_setting_exists('cspm_itemssettings_items_details', $cspm_v2_options, ''),
					);
					
					/**
					 * Posts count settings */
					
					$posts_count_settings = array(  
						$this->metafield_prefix.'_show_posts_count' => $this->cspm_setting_exists('cspm_postscountsettings_show_posts_count', $cspm_v2_options, ''),
						$this->metafield_prefix.'_posts_count_clause' => $this->cspm_setting_exists('cspm_postscountsettings_posts_count_clause', $cspm_v2_options, ''),
						$this->metafield_prefix.'_posts_count_color' => $this->cspm_setting_exists('cspm_postscountsettings_posts_count_color', $cspm_v2_options, ''),
					);
					
					/**
					 * Faceted search settings */
					 
					$faceted_search_settings = array( 
						$this->metafield_prefix.'_faceted_search_option' => $this->cspm_setting_exists('cspm_facetedsearchsettings_faceted_search_option', $cspm_v2_options, ''),						
						$this->metafield_prefix.'_faceted_search_multi_taxonomy_option' => $this->cspm_setting_exists('cspm_facetedsearchsettings_faceted_search_multi_taxonomy_option', $cspm_v2_options, ''),
						$this->metafield_prefix.'_faceted_search_drag_map' => $this->cspm_setting_exists('cspm_facetedsearchsettings_faceted_search_drag_map', $cspm_v2_options, ''),
						$this->metafield_prefix.'_faceted_search_input_skin' => $this->cspm_setting_exists('cspm_facetedsearchsettings_faceted_search_input_skin', $cspm_v2_options, ''),
						$this->metafield_prefix.'_faceted_search_input_color' => $this->cspm_setting_exists('cspm_facetedsearchsettings_faceted_search_input_color', $cspm_v2_options, ''),
						$this->metafield_prefix.'_faceted_search_css' => $this->cspm_setting_exists('cspm_facetedsearchsettings_faceted_search_css', $cspm_v2_options, ''),
					);
					
						if(!empty($selected_taxonomy)){
						
							$faceted_search_settings[$this->metafield_prefix.'_faceted_search_taxonomy_'.$selected_taxonomy] = $this->cspm_setting_exists('cspm_facetedsearchsettings_faceted_search_taxonomy_'.$selected_taxonomy, $cspm_v2_options, '');
							
						}
					
					/**
					 * Search form settings */
					 
					$search_form_settings = array( 
						$this->metafield_prefix.'_search_form_option' => $this->cspm_setting_exists('cspm_searchformsettings_search_form_option', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_distance_unit' => $this->cspm_setting_exists('cspm_searchformsettings_sf_distance_unit', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_address_placeholder' => $this->cspm_setting_exists('cspm_searchformsettings_address_placeholder', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_slider_label' => $this->cspm_setting_exists('cspm_searchformsettings_slider_label', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_submit_text' => $this->cspm_setting_exists('cspm_searchformsettings_submit_text', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_search_form_bg_color' => $this->cspm_setting_exists('cspm_searchformsettings_search_form_bg_color', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_no_location_msg' => $this->cspm_setting_exists('cspm_searchformsettings_no_location_msg', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_bad_address_msg' => $this->cspm_setting_exists('cspm_searchformsettings_bad_address_msg', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_bad_address_sug_1' => $this->cspm_setting_exists('cspm_searchformsettings_bad_address_sug_1', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_bad_address_sug_2' => $this->cspm_setting_exists('cspm_searchformsettings_bad_address_sug_2', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_bad_address_sug_3' => $this->cspm_setting_exists('cspm_searchformsettings_bad_address_sug_3', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_circle_option' => $this->cspm_setting_exists('cspm_searchformsettings_circle_option', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_fillColor' => $this->cspm_setting_exists('cspm_searchformsettings_fillColor', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_fillOpacity' => $this->cspm_setting_exists('cspm_searchformsettings_fillOpacity', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_strokeColor' => $this->cspm_setting_exists('cspm_searchformsettings_strokeColor', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_strokeOpacity' => $this->cspm_setting_exists('cspm_searchformsettings_strokeOpacity', $cspm_v2_options, ''),
						$this->metafield_prefix.'_sf_strokeWeight' => $this->cspm_setting_exists('cspm_searchformsettings_strokeWeight', $cspm_v2_options, ''),
					);
					
						$distance = explode(',', $this->cspm_setting_exists('cspm_searchformsettings_sf_search_distances', $cspm_v2_options, array(3,15)));
						
						$search_form_settings[$this->metafield_prefix.'_sf_min_search_distances'] = $this->cspm_setting_exists(0, $distance, '3');
						$search_form_settings[$this->metafield_prefix.'_sf_max_search_distances'] = $this->cspm_setting_exists(1, $distance, '15');
					
					/**
					 * Merge all "Progress Map" settings arrays into one */
					
					$cspm_settings_arrays = array_merge(
						array($this->metafield_prefix.'_post_type' => $main_post_type),
						$query_settings,
						$layout_settings,
						$map_settings,
						$map_style_settings,
						$infobox_settings,
						$marker_categories_settings,
						$kml_layers_settings,
						$overlays_settings,
						$carousel_settings,
						$carousel_style_settings,
						$carousel_items_settings,
						$posts_count_settings,
						$faceted_search_settings,
						$search_form_settings
					);
					
					/**
					 * == List & filter Extension settings == */
					
					if(class_exists('ProgressMapList')){
						
						$cspml_v1_options = get_option('cspml_settings');
					
						/**
						 * Layout settings */
						  
						$list_layout_settings = array( 
							$this->metafield_prefix.'_list_layout' => $this->cspm_setting_exists('cspml_layout_list_layout', $cspml_v1_options, ''),
							$this->metafield_prefix.'_map_height' => $this->cspm_setting_exists('cspml_layout_map_height', $cspml_v1_options, ''),
							$this->metafield_prefix.'_list_height' => $this->cspm_setting_exists('cspml_layout_list_height', $cspml_v1_options, ''),
						);
						
						/**
						 * Options bar settings */
						 
						$options_bar_settings = array( 
							$this->metafield_prefix.'_show_options_bar' => $this->cspm_setting_exists('cspml_options_bar_show_options_bar', $cspml_v1_options, ''),
							$this->metafield_prefix.'_show_view_options' => $this->cspm_setting_exists('cspml_options_bar_show_view_options', $cspml_v1_options, ''),
							$this->metafield_prefix.'_default_view_option' => $this->cspm_setting_exists('cspml_options_bar_default_view_option', $cspml_v1_options, ''),
							$this->metafield_prefix.'_grid_cols' => $this->cspm_setting_exists('cspml_options_bar_grid_cols', $cspml_v1_options, ''),
							$this->metafield_prefix.'_cslf_show_posts_count' => $this->cspm_setting_exists('cspml_options_bar_show_posts_count', $cspml_v1_options, ''),
							$this->metafield_prefix.'_cslf_posts_count_clause' => $this->cspm_setting_exists('cspml_options_bar_posts_count_clause', $cspml_v1_options, ''),
						);
						
						/**
						 * List items settings */
		
						$list_items_settings = array( 
							$this->metafield_prefix.'_listings_title' => $this->cspm_setting_exists('cspml_list_items_listings_title', $cspml_v1_options, ''),					 
							$this->metafield_prefix.'_listings_details' => $this->cspm_setting_exists('cspml_list_items_listings_details', $cspml_v1_options, ''),
							$this->metafield_prefix.'_cslf_click_on_title' => $this->cspm_setting_exists('cspml_list_items_click_on_title', $cspml_v1_options, ''),
							$this->metafield_prefix.'_cslf_click_on_img' => $this->cspm_setting_exists('cspml_list_items_click_on_img', $cspml_v1_options, ''),
							$this->metafield_prefix.'_cslf_external_link' => $this->cspm_setting_exists('cspml_list_items_external_link', $cspml_v1_options, ''),
							$this->metafield_prefix.'_show_fire_pinpoint_btn' => $this->cspm_setting_exists('cspml_list_items_show_fire_pinpoint_btn', $cspml_v1_options, ''),
						);
						
						/**
						 * Sort options settings */
						
						$sort_options_settings = array(  
							$this->metafield_prefix.'_show_sort_option' => $this->cspm_setting_exists('cspml_sort_option_show_sort_option', $cspml_v1_options, ''),
							$this->metafield_prefix.'_sort_options' => $this->cspm_setting_exists('cspml_sort_option_sort_options', $cspml_v1_options, ''),
						);
							 
							$custom_sort_options_array = array();
							
							$custom_sort_options = (array) json_decode(str_replace('tag_', '', $this->cspm_setting_exists('cspml_sort_option_custom_sort_options', $cspml_v1_options, '')));
							
							if(is_array($custom_sort_options)){
								
								foreach($custom_sort_options as $custom_sort_option){
									$custom_sort_options_array[] = (array) $custom_sort_option;
								}
							
							}
							
							$sort_options_settings[$this->metafield_prefix.'_custom_sort_options'] = $custom_sort_options_array;
						
						/**
						 * Pagination settings */
						
						$pagination_settings = array( 
							$this->metafield_prefix.'_posts_per_page' => $this->cspm_setting_exists('cspml_pagiantion_posts_per_page', $cspml_v1_options, ''),						 
							$this->metafield_prefix.'_pagination_position' => $this->cspm_setting_exists('cspml_pagiantion_pagination_position', $cspml_v1_options, ''),
							$this->metafield_prefix.'_pagination_align' => $this->cspm_setting_exists('cspml_pagiantion_pagination_align', $cspml_v1_options, ''),
							$this->metafield_prefix.'_prev_page_text' => $this->cspm_setting_exists('cspml_pagiantion_prev_page_text', $cspml_v1_options, ''),
							$this->metafield_prefix.'_next_page_text' => $this->cspm_setting_exists('cspml_pagiantion_next_page_text', $cspml_v1_options, ''),
							$this->metafield_prefix.'_show_all' => $this->cspm_setting_exists('cspml_pagiantion_show_all', $cspml_v1_options, ''),
						);
						
						/**
						 * Filter search settings */
						
						$filter_search_settings = array(  
							$this->metafield_prefix.'_cslf_faceted_search_option' => $this->cspm_setting_exists('cspml_list_filter_faceted_search_option', $cspml_v1_options, ''),
							$this->metafield_prefix.'_faceted_search_position' => $this->cspm_setting_exists('cspml_list_filter_faceted_search_position', $cspml_v1_options, ''),
							$this->metafield_prefix.'_faceted_search_display_option' => $this->cspm_setting_exists('cspml_list_filter_filter_btns_position', $cspml_v1_options, ''),
							$this->metafield_prefix.'_filter_btns_position' => $this->cspm_setting_exists('key', $cspml_v1_options, ''),
							$this->metafield_prefix.'_cslf_taxonomy_relation_param' => $this->cspm_setting_exists('cspml_list_filter_taxonomy_relation_param', $cspml_v1_options, ''),
							$this->metafield_prefix.'_cslf_custom_field_relation_param' => $this->cspm_setting_exists('cspml_list_filter_custom_field_relation_param', $cspml_v1_options, ''),
							$this->metafield_prefix.'_cslf_filter_btn_text' => $this->cspm_setting_exists('cspml_list_filter_filter_btn_text', $cspml_v1_options, ''),
						);
							
							/**
							 * Taxonomies */
							  
							$taxonomies_array = array();
							
							$taxonomies = (array) json_decode(str_replace('tag_', '', $this->cspm_setting_exists('cspml_list_filter_taxonomies', $cspml_v1_options, '')));
							
							if(is_array($taxonomies)){
								
								foreach($taxonomies as $taxonomy){
									$taxonomies_array[] = (array) $taxonomy;
								}
								
							}
									
							$filter_search_settings[$this->metafield_prefix.'_cslf_taxonomies'] = $taxonomies_array;
							
							/**
							 * Custom Fields */
							  
							$custom_fields_array = array();
							
							$custom_fields = (array) json_decode(str_replace('tag_', '', $this->cspm_setting_exists('cspml_list_filter_custom_fields', $cspml_v1_options, '')));
							
							if(is_array($custom_fields)){
								
								foreach($custom_fields as $custom_field){
									$custom_fields_array[] = (array) $custom_field;
								}
							
							}
							
							$filter_search_settings[$this->metafield_prefix.'_cslf_custom_fields'] = $custom_fields_array;
						
						/**
						 * Merge all "List & Filter" settings arrays into one */
						
						$cspml_settings_arrays = array_merge(
							array($this->metafield_prefix.'_list_ext' => 'on'),					
							$list_layout_settings,
							$options_bar_settings,
							$list_items_settings,
							$sort_options_settings,
							$pagination_settings,
							$filter_search_settings
						);
					
					}else $cspml_settings_arrays = array();
					
					/**
					 * Build wp_insert_post() args */
					 
					$insert_post_args = array(
						'post_type' => $this->object_type,
						'post_status' => 'publish',
						'post_title' => 'Auto generated map based on v2 settings',
						'meta_input' => array_merge(						
							
							/**
							 * Progress Map settings */
							 
							$cspm_settings_arrays,
							
							/**
							 * List & filter settings */
							
							$cspml_settings_arrays
							
						),
					);
								
					wp_insert_post($insert_post_args);

					/**
					 * Regenerate Markers just in case */
					 
					$this->cspm_regenerate_markers(false);	
				
				}
				
			}
						 
		}
		
		
		/**
		 * This will get the current post type in the WordPress Admin
		 * 
		 * @since 3.1
		 */
		function cspm_get_current_post_type() {
			
			global $post, $typenow, $current_screen, $pagenow;
			
			/**
			 * we have a post so we can just get the post type from that */
			 
			if($post && $post->post_type)
				return $post->post_type;
			
			/**
			 * check the global $typenow - set in admin.php */
			 
			elseif($typenow)
				return $typenow;
			
			/**
			 * check the global $current_screen object - set in sceen.php */
			 
			elseif($current_screen && $current_screen->post_type)
				return $current_screen->post_type;
			
			/**
			 * check the post_type querystring */
			 
			elseif(isset($_REQUEST['post_type']))
				return sanitize_key($_REQUEST['post_type']);
			
			/**
			 * Check if post ID is in query string */
			 
			elseif(isset($_REQUEST['post']))
				return get_post_type($_REQUEST['post']);
			
			/**
			 * Detect the default post type "post" when adding new posts */
			 
			elseif($pagenow && $pagenow == 'post-new.php' && !isset($_REQUEST['post_type']))
				return 'post';
			
			/**
			 * we do not know the post type! */
			 
			else return '';
			
		}
		
 
		/*
		 * This will add a duplicate link to the "All maps" list
		 *
		 * @since 3.2
		 */
		function cspm_duplicate_map_link($actions, $post){
			
			if($post->post_type == $this->object_type && current_user_can('edit_posts')){
				
				$actions['duplicate'] = '<a href="' . wp_nonce_url('admin.php?action=cspm_duplicate_map&post=' . $post->ID, basename(__FILE__), 'duplicate_nonce' ) . '" title="Duplicate this map" rel="permalink" class="cspm_duplicate_map_link">Duplicate this map</a>';
				
			}
			
			return $actions;
			
		}
		
		
		/**
		 * A custom CSS style for our duplicate link
		 *
		 * @since 3.2
		 */
		function cspm_duplicate_map_link_style(){
			
			echo '<style>
				a.cspm_duplicate_map_link{
					padding: 5px 10px 7px 10px;
					background: #FE5E05;
					border-radius: 2px;
					color: #fff;
					box-shadow: rgba(0,0,0,.298039) 0 1px 4px -1px, inset 0 -1px 0 0 rgba(0,0,0,.24);
					display:inline-block;
					margin-top:5px;
				}				
				a.cspm_duplicate_map_link:hover{
					background:#FF3902;
				}
			</style>';
		  
		}


		/*
		 * Duplicate a map and redirect to the edit map screen
		 *
		 * @since 3.2
		 */
		function cspm_duplicate_map(){
			
			global $wpdb;
			
			if(!(isset($_GET['post']) || isset($_POST['post']) || (isset($_REQUEST['action']) && 'cspm_duplicate_map' == $_REQUEST['action'])))
				wp_die('No map to duplicate has been supplied!');
		 
			/*
			 * Nonce verification */
			 
			if(!isset($_GET['duplicate_nonce']) || !wp_verify_nonce($_GET['duplicate_nonce'], basename( __FILE__ )))
				return;
		 
			/*
			 * Get the original post id */
			 
			$post_id = (isset($_GET['post']) ? absint($_GET['post']) : absint($_POST['post']));
			
			/*
			 * Get all the original post data */
			 
			$post = get_post($post_id);
		 
			/*
			 * if you don't want current user to be the new post author,
			 * then change next couple of lines to this: $new_post_author = $post->post_author; */
			 
			$current_user = wp_get_current_user();
			$new_post_author = $current_user->ID;
		 
			/*
			 * if post data exists, create the post duplicate */
			 
			if(isset($post) && $post != null){
		 
				/*
				 * new post data array */
				 
				$args = array(
					'comment_status' => $post->comment_status,
					'ping_status'    => $post->ping_status,
					'post_author'    => $new_post_author,
					'post_content'   => $post->post_content,
					'post_excerpt'   => $post->post_excerpt,
					'post_name'      => $post->post_name,
					'post_parent'    => $post->post_parent,
					'post_password'  => $post->post_password,
					'post_status'    => 'publish',
					'post_title'     => 'Duplicate of, "'.$post->post_title.'"',
					'post_type'      => $post->post_type,
					'to_ping'        => $post->to_ping,
					'menu_order'     => $post->menu_order
				);
		 
				/*
				 * Insert the post by wp_insert_post() function */
				 
				$new_post_id = wp_insert_post( $args );
		 
				/*
				 * Duplicate all post meta just in two SQL queries */
				 
				$post_meta_infos = $wpdb->get_results("SELECT meta_key, meta_value FROM $wpdb->postmeta WHERE post_id=$post_id");
				
				if(count($post_meta_infos) != 0){
					
					$sql_query = "INSERT INTO $wpdb->postmeta (post_id, meta_key, meta_value) ";
					
					foreach ($post_meta_infos as $meta_info){
						
						$meta_key = $meta_info->meta_key;
						
						if($meta_key == '_wp_old_slug')
							continue;
						
						$meta_value = addslashes($meta_info->meta_value);
						
						$sql_query_sel[] = "SELECT $new_post_id, '$meta_key', '$meta_value'";
					
					}
					
					$sql_query .= implode(" UNION ALL ", $sql_query_sel);
					
					$wpdb->query($sql_query);
					
				}
		 
				/*
				 * Finally, redirect to the edit map screen */
				 
				wp_redirect(admin_url('post.php?action=edit&post='.$new_post_id));
				
				exit;
				
			}else wp_die('Map creation failed, could not find the original map: '.$post_id);
		
		}
		
		
		/**
		 * This contains needed CSS code to customize and change the main colors in the plugin
		 *
		 * @since 3.8
		 */
		function cspm_main_colors(){
			
			$main_rgb_color = $this->main_rgb_color;
			$main_rgb_hover_color = $this->main_rgb_hover_color;
			
			$main_hex_color = $this->main_hex_color;
			$main_hex_hover_color = $this->main_hex_hover_color;
			
			$main_colors_css = '
				
				.cspm_bg_rgb, .cspm_bg_rgb_hover, .cspm_bg_before_rgb:before, .cspm_bg_after_rgb:after{background-color: '.$main_rgb_color.' !important;}
				.cspm_bg_rgb_hover:hover, .cspm_bg_rgb_only_hover:hover{background-color: '.$main_rgb_hover_color.' !important;}	
				
				.cspm_bg_hex, .cspm_bg_hex_hover, .cspm_bg_before_hex:before, .cspm_bg_after_hex:after{background-color: '.$main_hex_color.' !important;}
				.cspm_bg_hex_hover:hover, .cspm_bg_hex_only_hover:hover{background-color: '.$main_hex_hover_color.' !important;}
				
				.cspm_border_rgb, .cspm_border_after_rgb:after, .cspm_border_before_rgb:before{border-color: '.$main_rgb_color.' !important;}
				.cspm_border_top_rgb, .cspm_border_top_after_rgb:after, .cspm_border_top_before_rgb:before{border-top-color: '.$main_rgb_color.' !important;}
				.cspm_border_bottom_rgb, .cspm_border_bottom_after_rgb:after, .cspm_border_bottom_before_rgb:before{border-bottom-color: '.$main_rgb_color.' !important;}
				.cspm_border_left_rgb, .cspm_border_left_after_rgb:after, .cspm_border_left_before_rgb:before{border-left-color: '.$main_rgb_color.' !important;}
				.cspm_border_right_rgb, .cspm_border_right_after_rgb:after, .cspm_border_right_before_rgb:before{border-right-color: '.$main_rgb_color.' !important;}
				
				.cspm_border_hex, .cspm_border_after_hex:after, .cspm_border_before_hex:before{border-color: '.$main_hex_color.' !important;}
				.cspm_border_top_hex, .cspm_border_top_after_hex:after, .cspm_border_top_before_hex:before{border-top-color: '.$main_hex_color.' !important;}
				.cspm_border_bottom_hex, .cspm_border_bottom_after_hex:after, .cspm_border_bottom_before_hex:before{border-bottom-color: '.$main_hex_color.' !important;}
				.cspm_border_left_hex, .cspm_border_left_after_hex:after, .cspm_border_left_before_hex:before{border-left-color: '.$main_hex_color.' !important;}
				.cspm_border_right_hex, .cspm_border_right_after_hex:after, .cspm_border_right_before_hex:before{border-right-color: '.$main_hex_color.' !important;}
				
				.cspm_txt_rgb, .cspm_link_rgb a, .cspm_txt_rgb_hover, .cspm_txt_rgb_hover a{color: '.$main_rgb_color.' !important;}
				.cspm_txt_rgb_hover:hover, .cspm_txt_rgb_hover a:hover{color: '.$main_rgb_hover_color.' !important;}
				
				.cspm_txt_hex, .cspm_link_hex a, .cspm_txt_hex_hover, .cspm_txt_hex_hover a{color: '.$main_hex_color.' !important;}
				.cspm_txt_hex_hover:hover, .cspm_txt_hex_hover a:hover{color: '.$main_hex_hover_color.' !important;}
				
			';
			
			return $main_colors_css;
			
		}


		/**
		 * This will convert a hexa decimal color code to its RGB equivalent
		 *
		 * @since 3.8 
		 */
		function cspm_hex2RGB($hexStr, $returnAsString = true, $seperator = ','){
			
			$hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
			
			$rgbArray = array();
			
			if(strlen($hexStr) == 6){ // If a proper hex code, convert using bitwise operation. No overhead... faster
				
				$colorVal = hexdec($hexStr);
				$rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
				$rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
				$rgbArray['blue'] = 0xFF & $colorVal;
				
			}elseif(strlen($hexStr) == 3){ // if shorthand notation, need some string manipulations
				
				$rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
				$rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
				$rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
			
			}else return false; // Invalid hex color code
			
			return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray; // returns the rgb string or the associative array
		
		}
		
				
	}
	
}

if(class_exists('CSProgressMap')){
	
	$CSProgressMap = new CSProgressMap();
	$CSProgressMap->cspm_hooks();
	
}
