<?php
	error_reporting(E_ERROR); // print all errors, edit E_ERROR into 0 to hide errors.  
    include('include/config.php');
	include('include/database.php');
    include('include/setting.php');
	include('include/functions.php');
	include('include/autoload.php'); // load the core classes 
    require_once('include/smarty/Smarty.class.php');
	// Smarty define class and options
    $smarty = new Smarty;
    $smarty->compile_check = false;
    $smarty->compile_dir = 'cache'; // it should be writable
    $smarty->force_compile = true;
    $smarty->template_dir = 'templates/'.$general_setting['site_template']; // $site_template variable is derived from database in include/setting.php
	// Assign include/setting.php variables
	$smarty->assign('avatar_image',$avatar_image);
	$smarty->assign('banner_image',$banner_image);
	foreach ($general_setting AS $key=>$value) {
	$smarty->assign("setting_$key",$value);
	}
	$smarty->assign("social",$social_networks);
	// retrive slider 
	$slider = new Slider;
	$slides_number = $slider->slides_number();
	$smarty->assign('slides_number',$slides_number);
	if ($slides_number > 0) {
	$slider_items = $slider->slider_items();
	$smarty->assign('slider',$slider_items);
	}
	// retrive portfolio categories and items
	$portfolio = new Portfolio;
	$smarty->assign('portfolio_items_number',$portfolio->portfolio_items_number());
	if ($portfolio->portfolio_items_number() > 0) {
	$smarty->assign('categories',$portfolio->portfolio_categories());
	$smarty->assign('works',$portfolio->portfolio_items());
	}
	analytics();
	$smarty->display('portfolio.html'); // display all the assigned data in a template 'portfolio.html'
?>