<?php
	error_reporting(E_ERROR); // print all errors, edit E_ERROR into 0 to hide errors.  
    include('include/config.php');
	include('include/database.php');
    include('include/setting.php');
	include('include/functions.php');
	include('include/autoload.php'); // load the core classes 
    require_once('include/smarty/Smarty.class.php');
	// Smarty define class and options
    $smarty = new Smarty;
    $smarty->compile_check = false;
    $smarty->compile_dir = 'cache'; // it should be writable
    $smarty->force_compile = true;
    $smarty->template_dir = 'templates/'.$general_setting['site_template']; // $site_template variable is derived from database in include/setting.php
	// Assign include/setting.php variables
	$smarty->assign('avatar_image',$avatar_image);
	$smarty->assign('banner_image',$banner_image);
	foreach ($general_setting AS $key=>$value) {
	$smarty->assign("setting_$key",$value);
	}
	$smarty->assign("social",$social_networks);
	// retrive slider 
	$slider = new Slider;
	$slides_number = $slider->slides_number();
	$smarty->assign('slides_number',$slides_number);
	if ($slides_number > 0) {
	$slider_items = $slider->slider_items();
	$smarty->assign('slider',$slider_items);
	}
	// retrive skills
	$skills = new Skills;
	$skills_number = $skills->skills_number();
	$smarty->assign('skills_number',$skills_number);
	if ($skills_number > 0) {
	$skills_items = $skills->skills_items();
	$smarty->assign('skills',$skills_items);
	}
	// grab rss blog latest posts
	if (!empty($general_setting['blog_rss_url']) AND !empty($general_setting['blog_posts_number'])) {
	require_once('include/simplepie/simplepie.inc');
	$feed = new SimplePie();
	$feed->set_useragent('gecko');
	$feed->set_feed_url($general_setting['blog_rss_url']);
	$feed->init(); 
	$feed->handle_content_type();
	$blog_feed = $feed->get_items(0,$general_setting['blog_posts_number']);
	foreach ($blog_feed AS $item) {
	$rssitem['title'] = $item->get_title();
	$rssitem['details'] = $item->get_description();
	$rssitem['datetime'] = $item->get_date();
	$rssitem['link'] = $item->get_permalink();
	$rssitems[] = $rssitem;
	}
	$smarty->assign('rssitems',$rssitems);
	}
	// grab and retrive your envato's item
	if (!empty($general_setting['envato_username']) AND !empty($general_setting['envato_items_number'])) {
	require 'include/Envato_marketplaces.php';
	$Envato = new Envato_marketplaces();
	$envate_files = $Envato->new_files_from_user($general_setting['envato_username'], $general_setting['envato_items_number']);
	$envato_items_number = count(objectToArray($envate_files));
	$smarty->assign('envato_items_number',$envato_items_number);
	if (count(objectToArray($envate_files)) > 0) {
	$smarty->assign('envate_files',objectToArray($envate_files));
	}
	}
	analytics(); // analytics function
	$smarty->display('index.html'); // display all the assigned data in a template 'index.html'
?>