﻿<?php
/*
Plugin Name: شمارشگر معکوس محصولات ووکامرس
Plugin URI: http://www.20script.ir/
Description: نمایش شمارنده معکوس برای محصولات ووکامرس
Version: 3.7.2
Author: حجت دهنوی (بیست اسکریپت)
Author URI: http://www.20script.ir
Text Domain: product-countdown
*/
/*  Copyright 2013  WP-Buddy  (email : info@wp-buddy.com)
*/

if( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * The autoloader class
 *
 * @param string $class_name
 *
 * @return bool
 * @since 1.0
 */
function wpbpc_autoloader( $class_name ) {
	$file = trailingslashit( dirname( __FILE__ ) ) . 'classes/' . strtolower( $class_name ) . '.php';
	if( is_file( $file ) ) {
		require_once( $file );
		return true;
	}

	$file = trailingslashit( dirname( __FILE__ ) ) . 'classes/widgets/' . strtolower( $class_name ) . '.php';
	if( is_file( $file ) ) {
		require_once( $file );
		return true;
	}

	return false;
}


// registering the autoloader function
try {
	spl_autoload_register( 'wpbpc_autoloader', true );
} catch( Exception $e ) {
	function __autoload( $class_name ) {
		wpbpc_autoloader( $class_name );
	}
}

$wpb_product_countdown = new WPB_Product_Countdown( __FILE__ );