<?php
User::check_permission(0);

if(!empty($_POST)) {
	/* Clean some posted variables */
	$_POST['name']		= filter_var($_POST['name'], FILTER_SANITIZE_STRING);
	$_POST['email']		= filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
	$_POST['website']	= filter_var($_POST['website'], FILTER_VALIDATE_URL);
	$_POST['location']	= filter_var($_POST['location'], FILTER_SANITIZE_STRING);
	$_POST['about']		= filter_var($_POST['about'], FILTER_SANITIZE_STRING);
	$_POST['facebook']	= filter_var($_POST['facebook'], FILTER_SANITIZE_STRING);
	$_POST['twitter']	= filter_var($_POST['twitter'], FILTER_SANITIZE_STRING);
	$_POST['googleplus']= filter_var($_POST['googleplus'], FILTER_SANITIZE_STRING);
	$_POST['private']	= (isset($_POST['private'])) ? 1 : 0;

	/* Check for any errors */
	if(strlen($_POST['name']) < 3 || strlen($_POST['name']) > 32) {
		$_SESSION['error'][] = $language->register->error_message->name_length;
	}
	if(filter_var($_POST['email'], FILTER_VALIDATE_EMAIL) == false) {
		$_SESSION['error'][] = $language->register->error_message->invalid_email;
	}
	if(User::x_exists('email', $_POST['email']) == true && $_POST['email'] !== $account->email) {
		$_SESSION['error'][] = $language->register->error_message->email_exists;
	}
	if(strlen($_POST['about']) > 128) {
		$_SESSION['error'][] = $language->register->error_message->long_about;
	}
	if(strlen($_POST['location']) > 64) {
		$_SESSION['error'][] = $language->register->error_message->long_location;
	}

	/* If there are no errors continue the updating process */
	if(empty($_SESSION['error'])) {
		/* Prepare the statement and execute query */
		$stmt = $database->prepare("UPDATE `users` SET `name` = ?, `email` = ?, `website` = ?, `location` = ?, `about` = ?, `facebook` = ?, `twitter` = ?, `googleplus` = ?, `private` = ? WHERE `user_id` = {$account_user_id}");
		$stmt->bind_param('sssssssss', $_POST['name'], $_POST['email'], $_POST['website'], $_POST['location'], $_POST['about'], $_POST['facebook'], $_POST['twitter'], $_POST['googleplus'], $_POST['private']);
		$stmt->execute(); 
		$stmt->close();

		/* Set the success message & Refresh users data */
		$_SESSION['success'][] = $language->profile_settings->success_message->profile_updated;
		$account = new User($account_user_id); 
	}
	
	display_notifications();
	
}

initiate_html_columns();

?>

<h3><?php echo $language->profile_settings->header; ?></h3>

<form action="" method="post" role="form">
	<div class="form-group">
		<label><?php echo $language->profile_settings->input->name; ?></label>
		<input type="text" name="name" class="form-control" value="<?php echo $account->name; ?>" />
	</div>

	<div class="form-group">
		<label><?php echo $language->profile_settings->input->email; ?></label>
		<input type="text" name="email" class="form-control" value="<?php echo $account->email; ?>" />
	</div>

	<div class="form-group">
		<label><?php echo $language->profile_settings->input->website; ?></label>
		<input type="text" name="website" class="form-control" value="<?php echo $account->website; ?>" />
	</div>

	<div class="form-group">
		<label><?php echo $language->profile_settings->input->location; ?></label>
		<input type="text" name="location" class="form-control" value="<?php echo $account->location; ?>" />
	</div>

	<div class="form-group">
		<label><?php echo $language->profile_settings->input->about; ?></label>
		<input type="text" name="about" class="form-control" value="<?php echo $account->about; ?>" />
	</div>

	<hr />

	<h3><?php echo $language->profile_settings->header2; ?></h3>
	<p class="help-block"><?php echo $language->profile_settings->header2_help; ?></p>

	<div class="form-group">
		<label><?php echo $language->profile_settings->input->facebook; ?></label>
		<input type="text" name="facebook" class="form-control" value="<?php echo $account->facebook; ?>" />
	</div>

	<div class="form-group">
		<label><?php echo $language->profile_settings->input->twitter; ?></label>
		<input type="text" name="twitter" class="form-control" value="<?php echo $account->twitter; ?>" />
	</div>

	<div class="form-group">
		<label><?php echo $language->profile_settings->input->googleplus ?></label>
		<input type="text" name="googleplus" class="form-control" value="<?php echo $account->googleplus; ?>" />
	</div>

	<hr />

	<div class="checkbox">
		<label>
			<?php echo $language->profile_settings->input->private ?><input type="checkbox" name="private" <?php if($account->private == 1) echo 'checked'; ?>>
		</label>
	</div>

	<div class="form-group">
		<button type="submit" name="submit" class="btn btn-primary col-lg-4"><?php echo $language->global->submit_button; ?></button><br /><br />
	</div>


</form>