<?php
require_once ('header.php');
?>


	<div class="page-header white-content">
		<h1>Admin -> Analytics API Setup</h1>

		<?php require_once 'admin-menu.php'; ?>

	</div>

	<div class="white-content">
		<?php if(isset($error)) echo $error; ?>

		<div class="alert alert-info">
			1. Go to <a href="https://console.developers.google.com/projectselector/apis/library" target="_blank">Google Project Console</a>
			<br />
			2. Select your existent project or create a new on<br />
			3. In the <strong>search box for API's, enter "analytics" keyword</strong><br />
			4. Select <strong>Google Analytics Reporting API, <span class="text text-danger">NOT Analytics API</span></strong><br/>
			5. Click <strong>Enable</strong><br/>
			6. Click <strong>Create Credentials</strong><br/>
			7. Click <strong>"What Credentials do I Need"</strong><br>
			8. Leave all empty excepting <strong>Authorized redirect URIs</strong><br/>
			Which is: <strong><span class="text text-danger"><?= base_url() ?>/home/ga</span></strong>
			<br />
			9. Click <strong>Create Client ID</strong><br />
			10. On product name enter any name you wish and hit <strong>Continue</strong><br />
			11. Now in the list under <strong>OAuth 2.0 client IDs</strong> click yours<br/>
			12. Final Step: <strong>Copy your client id and client secret</strong> and enter them into <strong>Admin Panel -> Analytics API</strong>
			<br />
		</div><!-- /.alert alert-info -->

		<form method="post" action="">
		<dl>
		<dt>Enable Analytics API?</dt>
		<dd>
		<input type="radio" name="enable_analytics" value="Yes" <?= get_option( 'enable_analytics','No' ) == 'Yes' ? 'checked': ''; ?>> Yes
		<input type="radio" name="enable_analytics" value="No" <?= get_option( 'enable_analytics','No' ) == 'No'? 'checked': ''; ?>> No
		</dd>
		<dt>Analytics API Client ID</dt>
		<dd><input type="text" name="analytics_clientID" value="<?= get_option('analytics_clientID') ?>"></dd>
		<dt>Analytics API Client Secret</dt>
		<dd><input type="text" name="analytics_clientSecret" value="<?= get_option('analytics_clientSecret') ?>"></dd>
		</dl>
		<input type="submit" name="sb" value="Save" class="btn btn-green"/>	
		</form>

	</div>


<?php
	require_once ('footer.php');
?>
