<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Home extends CI_Controller {

	public function index()
	{

	    $this->load->model('Listings');

	    $data = array();

        $listings = $this->db->query("SELECT listingID, listing_title, listing_url, bin,
	    									CONCAT('$', FORMAT(`bin`, 0)) as `starting_`, site_age, `starting_` as starting_bid,
	    									CONCAT('$', FORMAT(rev_avg, 0)) as rev_avg, list_date, list_expires,
	    									FORMAT(traffic_avg_visits, 0) as traffic_avg_visits, pagerank,
	    									PERIOD_DIFF(DATE_FORMAT(NOW(), '%Y%m'), FROM_UNIXTIME(site_age, '%Y%m')) AS diff

	    									FROM (`listings`)

	    									WHERE `listing_status` = 'active'
	    									AND `sold` = 'N'
	    									AND `featured` = 'Y'
	    									AND (list_type = 'website' OR list_type = 'domain')
	    									ORDER BY `listingID` DESC LIMIT 10");

        $data['listings'] = $listings->result();

		$this->load->view('home', $data);
	}


	public function tos() {
		$this->load->model("UsersModel");

		$tos = $this->db->get("tos", 1);
		$data['tos'] = $tos->row();
		$data['seo_title'] = 'Terms of Service  -  ' . get_option('seo_title');

		$this->load->view('tos', $data);
	}


	public function contact() {
		$this->load->model('UsersModel');

		$data = array();
		$data['seo_title'] = 'Contact  -  ' . get_option('seo_title');
		$this->load->view('contact', $data);
	}

	public function contactajax() {

		foreach($_POST as $k => $v) {
			$_POST[$k] = trim(strip_tags($v));
			if(empty($_POST[$k])) die('All fields are required');
		}

		$body = 'From: ' . $_POST['yname'];
		$body .= "\r\n";

		$body .= 'Email: ' . $_POST['yemail'];
		$body .= "\r\n";

		$body .= 'Subject: ' . $_POST['ysubject'];
		$body .= "\r\n";

		$body .= 'Message: ' . nl2br(str_replace("<br>", "\n\r", $_POST['ymessage']));

		if(mail(get_option('contact_email'), 'Contact Form', $body)) {
			echo '<div class="alert alert-success">Thanks for contacting us! We will get back to you soon.</div>';
			echo '<script>$("#contact-form").hide();</script>';
		}


	}


	public function searchautocomplete() {

		$q = $this->uri->segment(3);
		if(!$q) die();

		$string = trim(strip_tags($q));
		$db_string = urldecode($string);

		$this->db->select("listingID, listing_title, listing_url, listing_status");
		$this->db->like("listing_title", $db_string);
		$this->db->or_like("listing_url", $db_string);

		$listings = $this->db->get('listings', 10);


		if(!count($listings->result())) {
			die('No results');
		}

		?>

		<ul class="playlist">
		<?php
		foreach($listings->result() as $m) :
			if($m->listing_status != 'active' OR empty($m->listing_title)) continue;
		?>
		<li>
			<hr>

			<a href="<?php echo '/listings/'.$m->listingID.'/'.url_title($m->listing_title); ?>" class="url-listing-title" style="font-size:14px;">
			<i class="icon icon-tag"></i> <?php echo $m->listing_url; ?>
			</a>
			<br />
			<a href="<?php echo '/listings/'.$m->listingID.'/'.url_title($m->listing_title); ?>">
			<small><?php echo $m->listing_title; ?></small>
			</a>
		</li>
		<?php endforeach; ?>
		<li>&nbsp;</li>
		</ul>

		<?php

	}


	public function lostpassword() {

		$data = array( 'msg' => '');

		if($e = $this->input->post('ea')) {
			if(filter_var($e, FILTER_VALIDATE_EMAIL)) {

				// get this user details from db
				$query = $this->db->query("SELECT userID, username, email FROM users WHERE email = ? LIMIT 1", array($e));

				if ($query->num_rows() > 0)
				{
				   $row = $query->row();

				   $hash = md5($row->userID.$row->email);
				   $to = $row->email;
				   $subject = 'Password Reset Email';

				   $body = 'Hi there <srong>'.$row->username.'</strong>,<br/><br/>';

				   $body .= 'You have requested a password reset email:<br/>';
				   $body .= '<a href="'.base_url().'home/resetpwd?hash='.$hash.'">'.base_url().'/home/resetpwd?hash='.$hash.'</a>';

				   $body .= '<br/><br/>Ignore if it wasn\'t you to request this password reset email!';

				   // To send HTML mail, the Content-type header must be set
					$headers  = 'MIME-Version: 1.0' . "\r\n";
					$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

				    mail($to, $subject, $body, $headers);

				    $data['msg'] = '<div class="alert alert-success">Please check your inbox/spambox for the reset link!</div>';


				}else{
					$data['msg'] = '<div class="alert alert-danger">No such email in database.</div>';
				}

			}else{
				$data['msg'] = '<div class="alert alert-danger">Invalid email.</div>';
			}
		}

		$this->load->view('lost-password', $data);

	}


	public function resetpwd() {

		if($hash = $this->input->get('hash')) {

			$data['msg'] = '';

			$hash = trim(strip_tags($hash));

			// get this user details from db
			$query = $this->db->query("SELECT userID FROM users WHERE MD5(CONCAT(userID, email)) = ? LIMIT 1", array($hash));
			if ($query->num_rows() > 0)
			{
				$row = $query->row();

				if($new_pwd = $this->input->post('pn')) {

					if(empty($new_pwd)) die("No empty password allowed");

					$reset = $this->db->query("UPDATE users SET password = MD5(?) WHERE userID = ?", array($new_pwd, $row->userID));
					if ($this->db->affected_rows()) {
						$data['msg'] = '<div class="alert alert-success">Successfully reset password. You may now login with the new credentials!</div>';
					}

				}

			}else{
				die("Invalid hash!");
			}


			$this->load->view('reset-password', $data);

		}else{
			$this->load->view('404');
		}

	}


	// upgrade database table
	public function upgrade(  ) {

		$data['msg'] = '';
		$data['result'] = '';

		  if($this->input->post('key')) {

					$license_key = $this->input->post('key', true);

					$blogURL = base_url();
					$url = 'http://crivion.com/envato-licensing/index.php';

					if(empty($license_key))
						die('<div class="updated below-h2 updated-red">License code required</div>');

					//open connection
					$ch = curl_init();

					//set the url, number of POST vars, POST data
					curl_setopt($ch,CURLOPT_URL, $url);
					curl_setopt($ch,CURLOPT_POST, 2);
					curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
					curl_setopt($ch,CURLOPT_POSTFIELDS, 'product=Flippa+Clone&license_code=' . $license_key . '&blogURL=' . $blogURL);
					curl_setopt($ch,CURLOPT_USERAGENT, 'crivion/envato-license-checker-v1.0');

					//execute post
					$result = curl_exec($ch);

					//if LICENSE_VALID_AUTOUPDATE_ENABLED
					if( $result == 'LICENSE_VALID_AUTOUPDATE_ENABLED' ) {

						$data['result'] = 'Upgrading database tables structure: v1.5 to v1.6 <br/>';

						// users
						$this->db->query( "ALTER TABLE `users` ADD `isActive` ENUM('Yes','No') NOT NULL DEFAULT 'No'" );
						$data['result'] .= 'Upgrading users table: [OK]<br/>';

						// set users active
						$this->db->query( "UPDATE users SET isActive = 'Yes'" );
						$data['result'] .= 'Setting existent users as email confirmed: [OK]<br/>';

						// insert currency symbol
						$this->db->query( "INSERT INTO opts VALUES (NULL, 'currency_symbol', '$')" );
						$data['result'] .= 'Setting currency symbol to $: [OK]<br/>';

						// insert currency code
						$this->db->query( "INSERT INTO opts VALUES (NULL, 'currency_code', 'USD')" );
						$data['result'] .= 'Setting currency code to USD: [OK]<br/>';

						// insert listing duration
						$this->db->query( "INSERT INTO opts VALUES (NULL, 'listing_duration', '1 Month')" );
						$data['result'] .= 'Setting default listing duration to 1 Month: [OK]';

					}else{
						$data['result'] = '<div class="updated below-h2 updated-red">' . $result . '</div>';
					}

					//close connection
					curl_close($ch);

				}

			  $data['msg'] = <<<FORM

				<form method="POST">

				<h4>Please enter your license key.</h4>
				<a href="https://www.youtube.com/watch?v=5FUtvFe3YTM" target="_blank">How to find it!</a><br /><br />

				<input type="text" name="key" value="" required="required" class="form-control"/><br />
				<input type="submit" name="sbKey" value="Validate & Upgrade" class="btn btn-primary">

				</form>

FORM;

				$this->load->view('upgrade15to16', $data);

	}

	private static function prettyPrint( $var ) {
		echo '<pre>' . print_r( $var, 1 ) . '</pre>';
	}

	public function ga(  ) {

		try {


			// setup analytics params
			$ga_params = array(
						'applicationName' => $this->config->item('ga_api_applicationName'),
						'clientID' => get_option('analytics_clientID'),
						'clientSecret' => get_option('analytics_clientSecret'),
						'redirectUri' => $this->config->item('ga_api_redirectUri'),
						'developerKey' => $this->config->item('ga_api_developerKey'),
						'profileID' =>  ''
				 );

			// load analytics library
			$this->load->library('GoogleAnalytics', $ga_params);

			// setup initial data array
			$data = array( 'output' => '' );

			if ( $this->googleanalytics->access_token_ready ) {

				// get accounts list
				$profile_list = $this->googleanalytics->AccountList();
				$profiles     = $profile_list->items;

				if( !count( $profiles ) )
					throw new Exception("Error: No profiles found on your analytics account.", 1);


				if( !isset( $_GET[ 'accId' ] ) && !isset( $_GET[ 'profId' ] ) ) {

					$data['outut'] = 'Select Account<br /><ul>';

					foreach( $profiles as $prof ) {

						$name = $prof->name;
						$profId = $prof->id;

						$data['output'] .= '<li><a href="/home/ga?accId=' . $profId . '">' . $name . '</a></li>';
					}

					$data['output'] .= '</ul>';
				} // if(!$_GET['accId'])

				// web properties list
				if( isset( $_GET[ 'accId' ] ) ) {

					$profile_list = $this->googleanalytics->ProfileList($_GET[ 'accId' ]);
					$views        = $profile_list->items;

					if( !count( $profiles ) )
						throw new Exception("Error: No view profiles found for the profile selected.", 1);

					// set profile id
					$data['output'] = 'Select Profile<br /><ul>';

					foreach( $views as $prof ) {

						$name = $prof->name;
						$profId = $prof->id;

						$data['output'] .= '<li><a href="/home/ga?profId=' . $profId . '">' . $name . '</a></li>';
					}

					$data['output'] .= '</ul>';

				} // if isset($_GET['accId'])

				// get metrics based on profile
				if( isset( $_GET[ 'profId' ] ) ) {

					// set profile id
					$profileId = trim( strip_tags( $_GET[ 'profId' ] ) );
					$profileId = intval( $profileId );

					// get first day of 3 months ago
					$three_months_ago = strtotime( "-3 Months" );
					$date_start = date( "Y-m-", $three_months_ago ) . "01";

					// get last day of 1 month ago
					$one_month_ago = strtotime( "-1 Month" );
					$date_end = date( "Y-m-t", $one_month_ago );

					// users total & average
					$users_total = $this->googleanalytics->get_total('users', $profileId, $date_start, $date_end);
					$users_average = round($users_total/3);

					// views total & average
					$views_total = $this->googleanalytics->get_total('pageviews', $profileId, $date_start, $date_end);
					$views_average = round($views_total/3);

					$data['output'] = '<h4>Totals</h4>';

					// echo 1 month ago
					$data['output'] .= $date_start . ' to ' . $date_end . '<br>';
					$data['output'] .= 'Users/avg: ' . $users_average;
					$data['output'] .= '<br/>';
					$data['output'] .= 'Pageviews/avg: ' . $views_average;

					$data['output'] .= '<hr />';

					// set listing ID
					$lid = $this->session->userdata('listingID');

					if(!$lid || $lid < 1)
						throw new Exception("Invalid Listing ID", 1);

					// update in db
					$this->db->update('listings', array('traffic_avg_visits' => $users_average,
																							'traffic_avg_views' => $views_average ), array( 'listingID' => $lid ));

					set_option( 'verified_traffic_' . $lid, date('jS F Y H:ia') );

					$data['output']  = '<div class="alert alert-success">Successfully linked analytics data. <strong>Redirecting...</strong></div>';
					$data['output'] .= '<meta http-equiv="refresh" content="2;url=/users/newlisting">';



				} // if $_GET['profId']

			}//IF ANALYTICS READY

		} catch(\Exception $e) {

				$data['output'] = $e->getMessage();

			}

			// return view
			$this->load->view('analytics-select-profile', $data);



	}


}
