<?php 
/**
 * Changes in WooCommerce without removing or adding things
 * Using WooCommerce hooks
 *
 * 
 * @package    
 * @license    LICENSE.txt
 * @author     
 * @link       https://bitbucket.org/averta/
 * @copyright  (c) 2010-2018 
 */

/**
 * woocommerce_single_product_summary hook.
 *
 * @hooked woocommerce_template_single_title - 5
 * @hooked woocommerce_template_single_rating - 10
 * @hooked woocommerce_template_single_price - 10
 * @hooked woocommerce_template_single_excerpt - 20
 * @hooked woocommerce_template_single_add_to_cart - 30
 * @hooked woocommerce_template_single_meta - 40
 * @hooked woocommerce_template_single_sharing - 50
 */

add_action( 'init', 'auxshp_remove_woo_actions' );

function auxshp_remove_woo_actions() {

    remove_action( 'woocommerce_single_product_summary',        'woocommerce_template_single_rating',                   10 );
    remove_action( 'woocommerce_single_product_summary',        'woocommerce_template_single_meta',                     40 );
    remove_action( 'woocommerce_single_product_summary',        'woocommerce_template_single_sharing',                  50 );
    remove_action( 'woocommerce_after_shop_loop',               'woocommerce_pagination',                               10 );
    remove_action( 'woocommerce_after_shop_loop_item_title',    'woocommerce_template_loop_rating',                     5  );
    remove_action( 'woocommerce_after_shop_loop_item',          'woocommerce_template_loop_add_to_cart'                    );
    remove_action( 'woocommerce_after_shop_loop_item',          'woocommerce_template_loop_product_link_close',         10 );
    remove_action( 'woocommerce_before_shop_loop_item_title',   'woocommerce_template_loop_product_thumbnail',          10 );
    remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash',                  10 );
    remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_images',                      20 );
    remove_action( 'woocommerce_after_single_product_summary',  'woocommerce_output_product_data_tabs',                 10 );
    remove_action( 'woocommerce_after_single_product_summary',  'woocommerce_output_related_products',                  20 );
    remove_action( 'woocommerce_cart_collaterals',              'woocommerce_cross_sell_display'                           );
    remove_action( 'woocommerce_widget_shopping_cart_buttons',  'woocommerce_widget_shopping_cart_button_view_cart',    10 );
    remove_action( 'woocommerce_widget_shopping_cart_buttons',  'woocommerce_widget_shopping_cart_proceed_to_checkout', 20 );


    if ( class_exists('Dokan_Core') && dokan_is_store_page() ) {
        remove_action( 'auxin_after_inner_body_open', 'auxin_the_main_title_section'); 
    }

    $widget_area = auxin_get_option('product_index_custom_widget_area', 'no');

    if ( auxin_is_true( $widget_area ) ) {
        remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
        remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );

        add_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 20 );
        add_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 40 );
    }

}

// Add meta again, after sharing section in single product page
add_action( 'woocommerce_single_product_summary',                 'woocommerce_template_single_meta' ,   60 );
add_action( 'woocommerce_single_product_summary',                 'woocommerce_show_product_sale_flash',  8 );
add_action( 'woocommerce_before_shop_loop_item_title',            'woocommerce_template_loop_product_link_close', 12 );

// Disable description tab heading
add_filter( 'woocommerce_product_description_heading',            '__return_false' );
// Disable additional information tab heading
add_filter( 'woocommerce_product_additional_information_heading', '__return_false' );
// Disable WooCommerce Default styles
add_filter( 'woocommerce_enqueue_styles',                         '__return_false' );


add_action( 'quicklook_product_summary', 'woocommerce_template_single_rating', 5 );
add_action( 'quicklook_product_summary', 'woocommerce_template_single_title', 10 );
add_action( 'quicklook_product_summary', 'woocommerce_template_single_price', 10 );
add_action( 'quicklook_product_summary', 'woocommerce_template_single_excerpt', 20 );
add_action( 'quicklook_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
add_action( 'quicklook_product_summary', 'auxshp_single_product_meta', 40 );
add_action( 'quicklook_after_product_summary', 'auxshp_single_wishlist', 10 );
add_action( 'quicklook_after_product_summary', 'auxshp_single_share', 20 );

/**
 * Display Sales Badge as a Percentage
 */

function auxin_show_sale_percentage( $output, $post, $product ) {

    $custom_sales_badge = auxin_get_option('product_index_custom_sale_badge', '0');

    if ( $product->is_on_sale() &&  auxin_is_true( $custom_sales_badge ) ) {

        if ( $product->is_type( 'simple' ) ) {

            $sale_price    = $product->get_sale_price();
            $regular_price = $product->get_regular_price();
            $sale          = ceil(( ($regular_price - $sale_price) / $regular_price ) * 100);

            if ( !empty( $regular_price ) && !empty( $sale_price ) && $regular_price > $sale_price ) {
                $output = '<span class="auxin-onsale-badge">' . __('Sale ','auxin-shop' ) . $sale . '%</span>';
            }

        } else {
            $output = '<span class="auxin-onsale-badge">' . __('Sale ','auxin-shop' ) . '</span>';
        }

        return $output;

    } else {
        return $output;
    }

}

add_filter( 'woocommerce_sale_flash', 'auxin_show_sale_percentage', 10, 3 );

/**
 * Add Pagination to Woocommerce Loop 
 */

function auxshp_pagination() {
    auxin_the_paginate_nav(
        array( 'css_class' => esc_attr( auxin_get_option('product_index_pagination_skin') ) )
    );
}

add_action( 'woocommerce_after_shop_loop', 'auxshp_pagination', 10 );


/**
 * Change the Size avatar in Review Section
 */
 
function auxshp_review_avatar_size() {
    $size = auxin_get_option( 'product_single_review_avatar_size', '60' );
    return $size;
}

add_filter('woocommerce_review_gravatar_size', 'auxshp_review_avatar_size' );


/**
 * Load the Variation Swatch  in  quickview
 */
 

if ( class_exists('TA_WC_Variation_Swatches') ) { 
    add_filter( 'woocommerce_dropdown_variation_attribute_options_html', array('TA_WC_Variation_Swatches_Frontend', 'get_swatch_html'), 100, 2 );
    add_filter( 'tawcvs_swatch_html', array( 'TA_WC_Variation_Swatches_Frontend', 'swatch_html' ), 5, 4 );
}



/**
 * Change the request url for add to cart button in ajax requests
 */

function aux_ajax_add_to_cart_url_change( $url, $instance ) { 
    // make filter magic happen here... 
    if ( wp_doing_ajax() ) {
        $url = trim($url, '/wp-admin/admin-ajax.php') ;
        return $url;
    } else {
        return $url;
    }

}; 
         
add_filter( 'woocommerce_product_add_to_cart_url', 'aux_ajax_add_to_cart_url_change', 10, 2 ); 