<?php
namespace Auxin\Plugin\Pro\Elementor\Modules;

use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;


class Common {

    /**
     * Instance of this class.
     *
     * @var      object
     */
    protected static $instance = null;


    function __construct(){
        // Add new controls to advanced tab globally
        add_action( "elementor/element/after_section_end", array( $this, 'add_parallax_controls_section'   ), 15, 3 );
        add_action( "elementor/element/after_section_end", array( $this, 'add_transition_controls_section' ), 16, 3 );


        // Renders attributes for all Elementor Elements
        add_action( 'elementor/frontend/widget/before_render' , array( $this, 'render_attributes' ) );
        add_action( 'elementor/frontend/column/before_render' , array( $this, 'render_attributes' ) );
        add_action( 'elementor/frontend/section/before_render', array( $this, 'render_attributes' ) );
    }

    /**
     * Return an instance of this class.
     *
     * @return    object    A single instance of this class.
     */
    public static function get_instance() {
        // If the single instance hasn't been set, set it now.
        if ( null == self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    /**
     * Add transition controls to advanced section
     *
     * @return void
     */
    public function add_transition_controls_section( $widget, $section_id, $args ){

        // Anchor element sections
        $target_sections = array('section_custom_css');

        if( ! defined('ELEMENTOR_PRO_VERSION') ) {
            $target_sections[] = 'section_custom_css_pro';
        }

        if( ! in_array( $section_id, $target_sections ) ){
            return;
        }

        // Adds transition options to all elements
        // ---------------------------------------------------------------------
        $widget->start_controls_section(
            'aux_pro_common_inview_transition',
            array(
                'label'     => __( 'Entrance Animation Pro', PLUGIN_DOMAIN ),
                'tab'       => Controls_Manager::TAB_ADVANCED
            )
        );

        $widget->add_control(
            'aux_animation_name',
            array(
                'label'   => __( 'Animation', PLUGIN_DOMAIN ),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    ''                           => 'None',

                    'aux-fade-in'                => 'Fade In',
                    'aux-fade-in-down'           => 'Fade In Down',
                    'aux-fade-in-down-1'         => 'Fade In Down 1',
                    'aux-fade-in-down-2'         => 'Fade In Down 2',
                    'aux-fade-in-up'             => 'Fade In Up',
                    'aux-fade-in-up-1'           => 'Fade In Up 1',
                    'aux-fade-in-up-2'           => 'Fade In Up 2',
                    'aux-fade-in-left'           => 'Fade In Left',
                    'aux-fade-in-left-1'         => 'Fade In Left 1',
                    'aux-fade-in-left-2'         => 'Fade In Left 2',
                    'aux-fade-in-right'          => 'Fade In Right',
                    'aux-fade-in-right-1'        => 'Fade In Right 1',
                    'aux-fade-in-right-2'        => 'Fade In Right 2',

                    // Slide Animation
                    'aux-slide-from-right'       => 'Slide From Right',
                    'aux-slide-from-left'        => 'Slide From Left',
                    'aux-slide-from-top'         => 'Slide From Top',
                    'aux-slide-from-bot'         => 'Slide From Bottom',

                    // Mask Animation
                    'aux-mask-from-top'          => 'Mask From Top',
                    'aux-mask-from-bot'          => 'Mask From Bottom',
                    'aux-mask-from-left'         => 'Mask From Left',
                    'aux-mask-from-right'        => 'Mask From Right',

                    'aux-rotate-in'              => 'Rotate In',
                    'aux-rotate-in-down-left'    => 'Rotate In Down Left',
                    'aux-rotate-in-down-left-1'  => 'Rotate In Down Left 1',
                    'aux-rotate-in-down-left-2'  => 'Rotate In Down Left 2',
                    'aux-rotate-in-down-right'   => 'Rotate In Down Right',
                    'aux-rotate-in-down-right-1' => 'Rotate In Down Right 1',
                    'aux-rotate-in-down-right-2' => 'Rotate In Down Right 2',
                    'aux-rotate-in-up-left'      => 'Rotate In Up Left',
                    'aux-rotate-in-up-left-1'    => 'Rotate In Up Left 1',
                    'aux-rotate-in-up-left-2'    => 'Rotate In Up Left 2',
                    'aux-rotate-in-up-right'     => 'Rotate In Up Right',
                    'aux-rotate-in-up-right-1'   => 'Rotate In Up Right 1',
                    'aux-rotate-in-up-right-2'   => 'Rotate In Up Right 2',

                    'aux-zoom-in'                => 'Zoom In',
                    'aux-zoom-in-1'              => 'Zoom In 1',
                    'aux-zoom-in-2'              => 'Zoom In 2',
                    'aux-zoom-in-3'              => 'Zoom In 3',

                    'aux-scale-up'               => 'Scale Up',
                    'aux-scale-up-1'             => 'Scale Up 1',
                    'aux-scale-up-2'             => 'Scale Up 2',

                    'aux-scale-down'             => 'Scale Down',
                    'aux-scale-down-1'           => 'Scale Down 1',
                    'aux-scale-down-2'           => 'Scale Down 2',

                    'aux-flip-in-down'           => 'Flip In Down',
                    'aux-flip-in-down-1'         => 'Flip In Down 1',
                    'aux-flip-in-down-2'         => 'Flip In Down 2',
                    'aux-flip-in-up'             => 'Flip In Up',
                    'aux-flip-in-up-1'           => 'Flip In Up 1',
                    'aux-flip-in-up-2'           => 'Flip In Up 2',
                    'aux-flip-in-left'           => 'Flip In Left',
                    'aux-flip-in-left-1'         => 'Flip In Left 1',
                    'aux-flip-in-left-2'         => 'Flip In Left 2',
                    'aux-flip-in-left-3'         => 'Flip In Left 3',
                    'aux-flip-in-right'          => 'Flip In Right',
                    'aux-flip-in-right-1'        => 'Flip In Right 1',
                    'aux-flip-in-right-2'        => 'Flip In Right 2',
                    'aux-flip-in-right-3'        => 'Flip In Right 3',

                    'aux-pulse'                  => 'Pulse In 1' ,
                    'aux-pulse1'                 => 'Pulse In 2',
                    'aux-pulse2'                 => 'Pulse In 3',
                    'aux-pulse3'                 => 'Pulse In 4',
                    'aux-pulse4'                 => 'Pulse In 5',

                    'aux-pulse-out-1'            => 'Pulse Out 1' ,
                    'aux-pulse-out-2'            => 'Pulse Out 2' ,
                    'aux-pulse-out-3'            => 'Pulse Out 3' ,
                    'aux-pulse-out-4'            => 'Pulse Out 4' ,

                    // Specials
                    'aux-shake'                  => 'Shake',
                    'aux-bounce-in'              => 'Bounce In',
                    'aux-jack-in-box'            => 'Jack In the Box',


                ),
                'default'            => '',
                'prefix_class'       => 'aux-appear-watch-animation ',
                'label_block'        => false
            )
        );


        $widget->add_control(
            'aux_animation_duration',
            array(
                'label'     => __( 'Duration', PLUGIN_DOMAIN ) . ' (ms)',
                'type'      => Controls_Manager::NUMBER,
                'default'   => '',
                'min'       => 0,
                'step'      => 100,
                'selectors'    => array(
                    '{{WRAPPER}}' => 'animation-duration:{{SIZE}}ms;'
                ),
                'condition' => array(
                    'aux_animation_name!' => ''
                ),
                'render_type' => 'template'
            )
        );

        $widget->add_control(
            'aux_animation_delay',
            array(
                'label'     => __( 'Delay', PLUGIN_DOMAIN ) . ' (ms)',
                'type'      => Controls_Manager::NUMBER,
                'default'   => '',
                'min'       => 0,
                'step'      => 100,
                'selectors' => array(
                    '{{WRAPPER}}' => 'animation-delay:{{SIZE}}ms;'
                ),
                'condition' => array(
                    'aux_animation_name!' => ''
                )
            )
        );

        $widget->add_control(
            'aux_animation_easing',
            array(
                'label'   => __( 'Easing', PLUGIN_DOMAIN ),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    ''                       => 'Default',
                    'initial'                => 'Initial',

                    'linear'                 => 'Linear',
                    'ease-out'               => 'Ease Out',
                    '0.19,1,0.22,1'          => 'Ease In Out',

                    '0.47,0,0.745,0.715'     => 'Sine In',
                    '0.39,0.575,0.565,1'     => 'Sine Out',
                    '0.445,0.05,0.55,0.95'   => 'Sine In Out',

                    '0.55,0.085,0.68,0.53'   => 'Quad In',
                    '0.25,0.46,0.45,0.94'    => 'Quad Out',
                    '0.455,0.03,0.515,0.955' => 'Quad In Out',

                    '0.55,0.055,0.675,0.19'  => 'Cubic In',
                    '0.215,0.61,0.355,1'     => 'Cubic Out',
                    '0.645,0.045,0.355,1'    => 'Cubic In Out',

                    '0.895,0.03,0.685,0.22'  => 'Quart In',
                    '0.165,0.84,0.44,1'      => 'Quart Out',
                    '0.77,0,0.175,1'         => 'Quart In Out',

                    '0.895,0.03,0.685,0.22'  => 'Quint In',
                    '0.895,0.03,0.685,0.22'  => 'Quint Out',
                    '0.895,0.03,0.685,0.22'  => 'Quint In Out',

                    '0.95,0.05,0.795,0.035'  => 'Expo In',
                    '0.19,1,0.22,1'          => 'Expo Out',
                    '1,0,0,1'                => 'Expo In Out',

                    '0.6,0.04,0.98,0.335'    => 'Circ In',
                    '0.075,0.82,0.165,1'     => 'Circ Out',
                    '0.785,0.135,0.15,0.86'  => 'Circ In Out',

                    '0.6,-0.28,0.735,0.045'  => 'Back In',
                    '0.175,0.885,0.32,1.275' => 'Back Out',
                    '0.68,-0.55,0.265,1.55'  => 'Back In Out'
                ),
                'selectors' => array(
                    '{{WRAPPER}}' => 'animation-timing-function:cubic-bezier({{VALUE}});'
                ),
                'condition' => array(
                    'aux_animation_name!' => ''
                ),
                'default'      => '',
                'return_value' => ''
            )
        );

        $widget->add_control(
            'aux_animation_count',
            array(
                'label'   => __( 'Repeat Count', PLUGIN_DOMAIN ),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    ''  => __( 'Default', PLUGIN_DOMAIN ),
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    'infinite' => __( 'Infinite', PLUGIN_DOMAIN )
                ),
                'selectors' => array(
                    '{{WRAPPER}}' => 'animation-iteration-count:{{VALUE}};opacity:1;' // opacity is required to prevent flick between repetitions
                ),
                'condition' => array(
                    'aux_animation_name!' => ''
                ),
                'default'      => ''
            )
        );

        $widget->end_controls_section();
    }

    /**
     * Add extra controls to advanced section
     *
     * @return void
     */
    public function add_parallax_controls_section( $widget, $section_id, $args ){

        if( in_array( $widget->get_name(), array('section') ) ){
            return;
        }

        // Hook element section
        $target_sections = array('section_custom_css');

        if( ! defined('ELEMENTOR_PRO_VERSION') ) {
            $target_sections[] = 'section_custom_css_pro';
        }

        if( ! in_array( $section_id, $target_sections ) ){
            return;
        }


        // Adds parallax options to advanced section
        // ---------------------------------------------------------------------
        $widget->start_controls_section(
            'aux_pro_common_parallax_section',
            array(
                'label'     => __( 'Parallax Pro', PLUGIN_DOMAIN ),
                'tab'       => Controls_Manager::TAB_ADVANCED
            )
        );

        $widget->add_control(
            'aux_parallax_enabled',
            array(
                'label'        => __( 'Enable Parallax', PLUGIN_DOMAIN ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', PLUGIN_DOMAIN ),
                'label_off'    => __( 'Off', PLUGIN_DOMAIN ),
                'return_value' => 'yes',
                'default'      => 'no',
                'separator'    => 'before'
            )
        );

        $widget->add_control(
            'aux_parallax_el_origin',
            array(
                'label'   => __( 'Parallax Origin', PLUGIN_DOMAIN ),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'top'     => __( 'Top', PLUGIN_DOMAIN ),
                    'middle'  => __( 'Middle', PLUGIN_DOMAIN ),
                    'bottom'  => __( 'Bottom', PLUGIN_DOMAIN )
                ),
                'default'   => 'middle',
                'condition' => array(
                    'aux_parallax_enabled' => 'yes'
                )
            )
        );

        $widget->add_control(
            'aux_parallax_el_depth',
            array(
                'label'      => __('Parallax Velocity',PLUGIN_DOMAIN ),
                'type'       => Controls_Manager::SLIDER,
                'default'   => array(
                    'size' => 0.15,
                ),
                'range' => array(
                    'px' => array(
                        'min'  => -1,
                        'max'  => 1,
                        'step' => 0.01
                    )
                ),
                'condition' => array(
                    'aux_parallax_enabled' => 'yes'
                )
            )
        );

        $widget->add_control(
            'aux_parallax_disable_on',
            array(
                'label'   => __( 'Disable Parallax', PLUGIN_DOMAIN ),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'tablet'  => __( 'On Mobile and Tablet', PLUGIN_DOMAIN ),
                    'phone'   => __( 'On Mobile', PLUGIN_DOMAIN ),
                    'custom'  => __( 'Under a screen size', PLUGIN_DOMAIN )
                ),
                'default'   => 'tablet',
                'condition' => array(
                    'aux_parallax_enabled' => 'yes'
                ),
                'label_block' => true
            )
        );

        $widget->add_control(
            'aux_parallax_disable_under',
            array(
                'label'      => __('Disable under size',PLUGIN_DOMAIN ),
                'description'=> __('Specifies a screen width under which the parallax will be disabled automatically. (in pixels)',PLUGIN_DOMAIN ),
                'type'       => Controls_Manager::SLIDER,
                'default'    => array(
                    'size' => 767,
                ),
                'range' => array(
                    'px' => array(
                        'min'  => 0,
                        'max'  => 1400,
                        'step' => 1
                    )
                ),
                'condition' => array(
                    'aux_parallax_enabled'    => 'yes',
                    'aux_parallax_disable_on' => 'custom'
                )
            )
        );

        $widget->end_controls_section();
    }

    /**
     * Renders attributes
     *
     * @param  Widget_Base $widget Instance of widget
     *
     * @return void
     */
    public function render_attributes( $widget ){
        $settings = $widget->get_settings();

        // Add parallax attributes
        if( $this->setting_value( $settings, 'aux_parallax_enabled', 'yes' ) ){
            $widget->add_render_attribute( '_wrapper', 'class', 'aux-parallax-piece' );

            if( null !== $value = $this->setting_value( $settings, 'aux_parallax_el_origin' ) ){
                $widget->add_render_attribute( '_wrapper', 'data-parallax-origin', $value );
            }
            if( null !== $value = $this->setting_value( $settings, 'aux_parallax_el_depth' ) ){
                $widget->add_render_attribute( '_wrapper', 'data-parallax-depth', $value['size'] );
            }
            if( null !== $value = $this->setting_value( $settings, 'aux_parallax_disable_on' ) ){
                $breakpoint = 767;

                if( 'table' == $value ){
                    $breakpoint = 1023;
                } elseif( 'phone' == $value ){
                    $breakpoint = 767;
                } elseif( null !== $value = $this->setting_value( $settings, 'aux_parallax_disable_under' ) ){
                    $breakpoint = $value['size'];
                }
                $widget->add_render_attribute( '_wrapper', 'data-parallax-off', $breakpoint );
            }
        }

    }


    private function setting_value( $settings, $key, $value = null ){
        if( ! isset( $settings[ $key ] ) ){
            return;
        }
        // Retrieves the setting value
        if( is_null( $value ) ){
            return $settings[ $key ];
        }
        // Validates the setting value
        return ! empty( $settings[ $key ] ) && $value == $settings[ $key ];
    }

}
