<?php
/**
 * The default template for displaying content
 *
 * @author      Nanopeflican
 * @link        http://nanopeflican.co
 * @copyright   Copyright (c) 2015 Nanopeflican
 * @license     GPL v2
 */
$format = get_post_format();
$placeholder_image = get_template_directory_uri(). '/assets/images/layzyload-single.jpg';
//share
$share = get_theme_mod('peflican_post_meta_share', false);
?>

<article <?php post_class('post-item post-full clearfix'); ?>>
    <div class="article-full hover-share-item">
                <div class="article-header clearfix">
                    <span class="post-cat">
                        <?php echo peflican_category(' '); ?>
                    </span>
                    <span class="post-date">
                           <?php peflican_entry_date(); ?>
                     </span>

                    <div class="entry-header clearfix">
                        <?php the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
                    </div>
                    <div class="article-meta-group clearfix">
                        <div class="article-meta">
                            <?php peflican_entry_meta(); ?>
                        </div>
                        <?php
                        get_template_part('templates/share');
                        ?>
                    </div>
                </div>

                <?php if(has_post_thumbnail()) : ?>
                    <?php
                    $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), "peflican-single" );
                    ?>
                    <div class="post-image">
                        <a href="<?php echo get_permalink() ?>" class="bgr-item hidden-xs"></a>
                        <a href="<?php echo get_permalink();?>">
                            <img  class="lazy" src="<?php echo esc_url($placeholder_image);?>" data-src="<?php echo esc_attr($thumbnail_src[0]);?>" alt="post-image"/>
                        </a>
                        <?php if(has_post_format('video')) : ?>
                            <div class="post-video">
                                <?php if ( current_theme_supports( 'post-formats', $format ) ):?>
                                    <a  href="<?php echo get_post_format_link( $format ); ?>" class="post-format"><i class="ti-control-play"></i></a>
                                <?php endif;?>
                            </div>
                        <?php endif;?>
                    </div>
                <?php endif;?>

                <div class="article-content">
                    <div class="entry-content clearfix">
                            <?php
                                echo peflican_excerpt_content(150);
                            ?>
                    </div>
                    <span class="btn-rgb"></span>
                    <a  class="btn-read" href="<?php echo esc_url(get_permalink()); ?>">
                        <?php esc_html_e('Read More','peflican')?>
                    </a>

                </div>
    </div>

</article><!-- #post-## -->
