<?php
/**
 * @package     NA Core
 * @version     0.1
 * @author      Nanopeflican
 * @link        http://nanopeflican.co
 * @copyright   Copyright (c) 2015 Nanopeflican
 * @license     GPL v2
 */
if (!class_exists('peflican_Customize')) {
    class peflican_Customize
    {
        public $customizers = array();

        public $panels = array();

        public function init()
        {
            $this->customizer();
            add_action('customize_controls_enqueue_scripts', array($this, 'peflican_customizer_script'));
            add_action('customize_register', array($this, 'peflican_register_theme_customizer'));
            add_action('customize_register', array($this, 'remove_default_customize_section'), 20);
        }

        public static function &getInstance()
        {
            static $instance;
            if (!isset($instance)) {
                $instance = new peflican_Customize();
            }
            return $instance;
        }

        protected function customizer()
        {
            $this->panels = array(

                'site_panel' => array(
                    'title'             => esc_html__('Style Setting','peflican'),
                    'description'       => esc_html__('Style Setting >','peflican'),
                    'priority'          =>  101,
                ),
                'single_panel' => array(
                    'title'             => esc_html__('Blog Single','peflican'),
                    'description'       => esc_html__('Blog Single >','peflican'),
                    'priority'          =>  104,
                ),
                'woo_panel' => array(
                    'title'             => esc_html__('WooCommerce','peflican'),
                    'description'       => esc_html__('WooCommerce >','peflican'),
                    'priority'          =>  102,
                ),
                'peflican_option_panel' => array(
                    'title'             => esc_html__('Option','peflican'),
                    'description'       => '',
                    'priority'          => 104,
                ),
            );

            $this->customizers = array(
                'title_tagline' => array(
                    'title' => esc_html__('Site Identity', 'peflican'),
                    'priority'  =>  1,
                    'settings' => array(
                        'peflican_logo' => array(
                            'class' => 'image',
                            'label' => esc_html__('Logo', 'peflican'),
                            'description' => esc_html__('Upload Logo Image', 'peflican'),
                            'priority' => 12
                        ),
                    )
                ),
//2.General ============================================================================================================
                'peflican_general' => array(
                    'title' => esc_html__('General', 'peflican'),
                    'description' => '',
                    'priority' => 2,
                    'settings' => array(

                        'peflican_bg_body' => array(
                            'label'         => esc_html__('Background - Body', 'peflican'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 3,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                        'peflican_primary_body' => array(
                            'label'         => esc_html__('Primary - Color', 'peflican'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 1,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                        'peflican_title_color' => array(
                            'label'         => esc_html__('Widget Title - Color', 'peflican'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 2,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                    )
                ),
//3.Header =============================================================================================================
                'peflican_header' => array(
                    'title' => esc_html__('Header', 'peflican'),
                    'description' => '',
                    'priority' => 3,
                    'settings' => array(
                        //header
                        'peflican_header_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Header', 'peflican'),
                            'priority' => 0,
                        ),

                        'peflican_header' => array(
                            'class'=> 'layout',
                            'label' => esc_html__('Header Layout', 'peflican'),
                            'priority' =>1,
                            'choices' => array(
                                'simple'                   => get_template_directory_uri().'/assets/images/header/default.png',
                                'center'                   => get_template_directory_uri().'/assets/images/header/center.png',
                                'left'                     => get_template_directory_uri().'/assets/images/header/left.png',

                            ),
                            'params' => array(
                                'default' => 'simple',
                            ),
                        ),

                        'peflican_keep_menu' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Keep Menu','peflican'),
                            'priority' => 2,
                            'params' => array(
                                'default' => false,
                            ),
                        ),

                        'peflican_bg_header' => array(
                            'label'         => esc_html__('Background - Color', 'peflican'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 5,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),


                        'peflican_bg_header_image' => array(
                            'class'         => 'image',
                            'priority'      =>6,
                            'label'         => esc_html__('Background Image', 'peflican'),
                            'params'        => array(
                                'default'   => '',
                            ),
                            'sanitize_callback' =>0,
                        ),


                        'peflican_color_menu' => array(
                            'label'         => esc_html__('Color - Text', 'peflican'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 6,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                    )
                ),
//4.Footer =============================================================================================================
                'peflican_new_section_footer' => array(
                    'title' => esc_html__('Footer', 'peflican'),
                    'description' => '',
                    'priority' => 4,
                    'settings' => array(

                        'peflican_enable_footer' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__('Enable Footer', 'peflican'),
                            'description' => '',
                            'priority' => 0,
                            'params' => array(
                                'default' => '1',
                            ),
                        ),
                        'peflican_enable_footer_top' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__('Enable Footer Top', 'peflican'),
                            'description' => '',
                            'priority' => 0,
                            'params' => array(
                                'default' => '0',
                            ),
                        ),
                        'peflican_enable_copyright' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__('Enable Copyright', 'peflican'),
                            'description' => '',
                            'priority' => 0,
                            'params' => array(
                                'default' => '1',
                            ),
                        ),
                        'peflican_copyright_text' => array(
                            'type' => 'textarea',
                            'label' => esc_html__('Footer Copyright Text', 'peflican'),
                            'description' => '',
                            'priority' => 0,
                        ),

                        'peflican_bg_footer' => array(
                            'label'         => esc_html__('Background - Footer', 'peflican'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 5,
                            'params'        => array(
                                'default'   => '',
                            ),

                        ),
                        'peflican_color_footer' => array(
                            'label'         => esc_html__('Color - Text ', 'peflican'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 6,
                            'params'        => array(
                                'default'   => '',
                            ),

                        ),
                    )
                ),

//5.Categories Blog ====================================================================================================
                'peflican_blog' => array(
                    'title' => esc_html__('Blogs Categories', 'peflican'),
                    'description' => '',
                    'priority' => 103,
                    'settings' => array(

                        'peflican_sidebar_cat' => array(
                            'class'         => 'layout',
                            'label'         => esc_html__('Sidebar Layout', 'peflican'),
                            'priority'      =>3,
                            'choices'       => array(
                                'left'         => get_template_directory_uri().'/assets/images/left.png',
                                'right'        => get_template_directory_uri().'/assets/images/right.png',
                                'full'         => get_template_directory_uri().'/assets/images/full.png',
                            ),
                            'params' => array(
                                'default' => 'right',
                            ),
                        ),
                        'peflican_siderbar_cat_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'peflican'),
                            'description' => esc_html__( 'Please goto Appearance > Widgets > drop drag widget to the sidebar Article.', 'peflican' ),
                            'priority' => 4,
                        ),
                        //post-layout-cat
                        'peflican_title_cat_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Post Title Category', 'peflican'),
                            'priority' =>5,
                        ),
                        'peflican_post_title_heading' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Title Category ','peflican'),
                            'priority' => 6,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'peflican_cat_image' => array(
                            'class'         => 'image',
                            'priority'      =>6,
                            'label'         => esc_html__('Background Image', 'peflican'),
                            'params'        => array(
                                'default'   => '',
                            ),
                            'sanitize_callback' =>0,
                        ),
                        'peflican_cat_bg' => array(
                            'label'         => esc_html__('Background - Color', 'peflican'),
                            'description'   => '',
                            'class'         => 'color',
                            'priority'      => 6,
                            'params'        => array(
                                'default'   => '',
                            ),

                        ),

                        'peflican_post_cat_layout' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Category layout', 'peflican'),
                            'priority' =>8,
                        ),
                        'peflican_layout_cat_content' => array(
                            'class'         => 'layout',
                            'priority'      =>9,
                            'choices'       => array(
                                'list'        => get_template_directory_uri().'/assets/images/box-list.jpg',
                            ),
                            'params' => array(
                                'default' => 'list',
                            ),
                        ),
                        //post meta
                        'peflican_cat_meta' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Post meta', 'peflican'),
                            'priority' =>13,
                        ),
                        'peflican_post_meta_share' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share ','peflican'),
                            'priority' => 14,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'peflican_post_meta_author' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Author ','peflican'),
                            'priority' => 15,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'peflican_post_meta_date' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Date ','peflican'),
                            'priority' => 16,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'peflican_post_meta_comment' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Comment ','peflican'),
                            'priority' => 17,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'peflican_post_meta_view' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('View ','peflican'),
                            'priority' => 18,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                    ),
                ),
//6.Single blog ========================================================================================================
                'peflican_single_sidebar' => array(
                    'title' => esc_html__('Sidebar Layout', 'peflican'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        'peflican_sidebar_single' => array(
                            'class'         => 'layout',
                            'label'         => esc_html__('Sidebar Layout', 'peflican'),
                            'priority'      =>1,
                            'choices'       => array(
//                                'left'         => get_template_directory_uri().'/assets/images/left.png',
                                'right'        => get_template_directory_uri().'/assets/images/right.png',
//                                'full'         => get_template_directory_uri().'/assets/images/full.png',
                            ),
                            'params' => array(
                                'default' => 'right',
                            ),
                        ),
                        'peflican_siderbar_single_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'peflican'),
                            'description' => esc_html__( 'Please goto Appearance > Widgets > drop drag widget to the sidebar Blog .', 'peflican' ),
                            'priority' => 2,
                        ),

                        'peflican_single_own' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Use Single sidebar','peflican'),
                            'priority' => 3,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'peflican_siderbar_single2_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'peflican'),
                            'description' => esc_html__( 'When you active use Single sidebar , Please goto Appearance > Widgets > drop drag widget to the sidebar Single  not sidebar Blog.', 'peflican' ),
                            'priority' => 4,
                        ),
                    ),
                ),

                //Share
                'peflican_single_layout' => array(
                    'title' => esc_html__('Social Share', 'peflican'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        'peflican_share_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Options', 'peflican'),
                            'priority' =>18,
                        ),
                        'peflican_share_facebook' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Facebook  ','peflican'),
                            'priority' => 21,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'peflican_share_twitter' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Twitter  ','peflican'),
                            'priority' => 22,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'peflican_share_google' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Google  ','peflican'),
                            'priority' => 23,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'peflican_share_linkedin' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Linkedin  ','peflican'),
                            'priority' => 24,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'peflican_share_pinterest' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Share Pinterest  ','peflican'),
                            'priority' => 25,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                    ),
                ),
                //Comments
                'peflican_single_comments' => array(
                    'title' => esc_html__('Comments', 'peflican'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //comments
                        'peflican_comments' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Comments Box', 'peflican'),
                            'priority' =>16,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'peflican_comments_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Options', 'peflican'),
                            'priority' =>18,
                        ),
                        'peflican_comments_single_facebook' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Enable Facebook Comments ','peflican'),
                            'priority' => 29,
                            'params' => array(
                                'default' => false,
                            ),
                        ),

                        'peflican_comments_single' => array(
                            'type'          => 'text',
                            'label'         => esc_html__('Your app id :', 'peflican'),
                            'priority'      => 30,
                            'params'        => array(
                                'default'   => '',
                            ),
                        ),
                        'peflican_comments_single_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'peflican'),
                            'description' => esc_html__('If you want show notification on  your facebook , please input app id ...', 'peflican' ),
                            'priority' => 31,
                        ),
                    ),
                ),

                'peflican_single_meta' => array(
                    'title' => esc_html__('Meta', 'peflican'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //avatar-meta
                        'peflican_avatar_meta' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Author', 'peflican'),
                            'priority' =>1,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                        'peflican_avatar_meta_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'peflican'),
                            'description' => esc_html__( 'Show or Hidden  Author under the Title Post.If you want to disable/enable Author Box under Post , Please put or delete description in the User > Your profile > Biographical Info ', 'peflican' ),
                            'priority' => 2,
                        ),
                        //avatar-meta
                        'peflican_image_meta' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Featured Image', 'peflican'),
                            'priority' =>3,
                            'params' => array(
                                'default' => true,
                            ),
                        ),
                    ),
                ),
                'peflican_single_related' => array(
                    'title' => esc_html__('Related Box', 'peflican'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //related_posts
                        'peflican_related' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Related Posts', 'peflican'),
                            'priority' =>17,
                            'params' => array(
                                'default' => true,
                            ),
                        ),

                    ),
                ),

                'peflican_single_readmore' => array(
                    'title' => esc_html__('Read More Box', 'peflican'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 6,
                    'settings' => array(
                        //Read More
                        'peflican_readmore_box' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Read More Box', 'peflican'),
                            'priority' =>1,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'peflican_readmore_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Options', 'peflican'),
                            'priority' =>2,
                        ),
                        'peflican_readmore_cat' => array(
                            'class'          => 'multiple',
                            'label'         => esc_html__('Categories', 'peflican'),
                            'choices'       => peflican_get_categories_select(),
                            'priority'      => 3,
                            'params'        => array(
                                'default'       => esc_html__('', 'peflican'),
                            ),

                        ),
                        'peflican_readmore_layout' => array(
                            'class'         => 'layout',
                            'priority'      =>4,
                            'label'         => esc_html__('Layouts', 'peflican'),
                            'choices'       => array(
                                'full'        => get_template_directory_uri().'/assets/images/box-grid.jpg',
                                'list'        => get_template_directory_uri().'/assets/images/box-list.jpg',
                            ),
                            'params' => array(
                                'default' => 'full',
                            ),
                        ),
                        'peflican_readmore_show' => array(
                            'class' => 'slider',
                            'label' => esc_html__('Number of posts displayed on a page', 'peflican'),
                            'description' => '',
                            'priority' =>5,
                            'choices' => array(
                                'max' => 10,
                                'min' => 2,
                                'step' => 1
                            ),
                            'params'      => array(
                                'default' =>6
                            ),
                        ),
                    ),
                ),
//7.Adsense blog ========================================================================================================
                'peflican_ads' => array(
                    'title' => esc_html__('Adsense Setting', 'peflican'),
                    'description' => '',
                    'panel' =>'single_panel',
                    'priority' => 7,
                    'settings' => array(

                        'peflican_ads_rectangle' => array(
                            'type' => 'textarea',
                            'label' => esc_html__(' ADS Size: Large Rectangle', 'peflican'),
                            'description' => '',
                            'priority' => 1,
                        ),
                        'peflican_ads_rectangle_info' => array(
                            'class' => 'info',
                            'label' => esc_html__('Info', 'peflican'),
                            'description' => esc_html__('Add code ads by google with the size is:300x250', 'peflican' ),
                            'priority' => 2,
                        ),
                        'peflican_ads_leaderboard' => array(
                            'type' => 'textarea',
                            'label' => esc_html__('ADS Size: Leaderboard', 'peflican'),
                            'description' => 'Add code ads by google with the size is: 468x60 ,728x90, 920x180 ...',
                            'priority' => 3,
                        ),
                        'peflican_ads_bottom' => array(
                            'type' => 'textarea',
                            'label' => esc_html__('ADS Size:Billboard', 'peflican'),
                            'description' => 'You can place any size ad in this responsive area.',
                            'priority' => 5,
                        ),
                        'peflican_heading_ads_single' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Position AD', 'peflican'),
                            'priority' =>20,
                        ),
                        'peflican_ads_single_article' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Ad right of the post','peflican'),
                            'priority' => 21,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'peflican_ads_single_comment' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Ad located between the boxes','peflican'),
                            'priority' => 23,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'peflican_ads_single_top' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Ad  the top of the post','peflican'),
                            'priority' => 24,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                        'peflican_ads_single_bottom' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Ad Under the bottom of the post','peflican'),
                            'priority' => 25,
                            'params' => array(
                                'default' => false,
                            ),
                        ),
                    )
                ),

//9.Woocommerces Detail  ===============================================================================================
                'peflican_woo_detail' => array(
                    'title' => esc_html__('Product Detail', 'peflican'),
                    'description' => '',
                    'panel' =>'woo_panel',
                    'priority' => 9,
                    'settings' => array(
                        //siderbar
                        'peflican_sidebar_woo_single' => array(
                            'class'=> 'layout',
                            'label' => esc_html__('Sidebar', 'peflican'),
                            'priority' =>2,
                            'choices' => array(
                                'left'         => get_template_directory_uri().'/assets/images/left.png',
                                'full'         => get_template_directory_uri().'/assets/images/full.png',
                                'right'         => get_template_directory_uri().'/assets/images/right.png',
                            ),
                            'params' => array(
                                'default' => 'full',
                            ),
                        ),
                        'peflican_woo_related_products' => array(
                            'type'          => 'checkbox',
                            'label'         => __('Display Related Products', 'peflican'),
                            'priority'      => 24,
                            'params'        => array(
                                'default'   => true,
                            ),

                        ),
                        'peflican_woo_number_related_products' => array(
                            'type' => 'select',
                            'label' => __('Number Products Show', 'peflican'),
                            'description' => '',
                            'priority' => 25,
                            'choices' => array(
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5'
                            ),
                            'params' => array(
                                'default' => '4',
                            ),

                        ),
                        //Share products
                        'peflican_cat_content_heading' => array(
                            'class' => 'heading',
                            'label' => esc_html__('Share', 'peflican'),
                            'priority' =>25,
                        ),
                        'peflican_woo_share_facebook' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Facebook','peflican'),
                            'priority' => 26,
                            'params' => array(
                                'default' => false,
                            ),

                        ),
                        'peflican_woo_share_twitter' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Twitter','peflican'),
                            'priority' => 27,
                            'params' => array(
                                'default' => false,
                            ),

                        ),
                        'peflican_woo_share_pinterest' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Pinterest','peflican'),
                            'priority' => 28,
                            'params' => array(
                                'default' => false,
                            ),

                        ),
                        'peflican_woo_share_google' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('Google +','peflican'),
                            'priority' => 29,
                            'params' => array(
                                'default' => false,
                            ),

                        ),
                        'peflican_woo_share_linkedin' => array(
                            'class' => 'toggle',
                            'label' => esc_html__('linkedin','peflican'),
                            'priority' => 30,
                            'params' => array(
                                'default' => false,
                            ),

                        ),

                    ),
                ),
//Font   ===============================================================================================================
                'peflican_new_section_font_size' => array(
                    'title' => esc_html__('Font', 'peflican'),
                    'priority' => 5,
                    'settings' => array(
                        'peflican_body_font_google' => array(
                            'type'          => 'select',
                            'label'         => esc_html__('Use Google Font', 'peflican'),
                            'choices'       => peflican_googlefont(),
                            'priority'      => 0,
                            'params'        => array(
                                'default'       => 'Poppins',
                            ),

                        ),
                        'peflican_body_font_size' => array(
                            'class' => 'slider',
                            'label' => esc_html__('Font size ', 'peflican'),
                            'description' => '',
                            'priority' =>8,
                            'choices' => array(
                                'max' => 30,
                                'min' => 10,
                                'step' => 1
                            ),
                            'params'      => array(
                                'default' => 14,
                            ),
                        ),
                    )
                ),
//Style  ===============================================================================================================


            );
        }

        public function peflican_customizer_script()
        {
            // Register
            wp_enqueue_style('na-customize', get_template_directory_uri() . '/inc/customize/assets/css/customizer.css', array(),null);
            wp_enqueue_style('jquery-ui', get_template_directory_uri() . '/inc/customize/assets/css/jquery-ui.min.css', array(),null);
            wp_enqueue_script('na-customize', get_template_directory_uri() . '/inc/customize/assets/js/customizer.js', array('jquery'), null, true);
        }

        public function add_customize($customizers) {
            $this->customizers = array_merge($this->customizers, $customizers);
        }


        public function peflican_register_theme_customizer()
        {
            global $wp_customize;

            foreach ($this->customizers as $section => $section_params) {

                //add section
                $wp_customize->add_section($section, $section_params);
                if (isset($section_params['settings']) && count($section_params['settings']) > 0) {
                    foreach ($section_params['settings'] as $setting => $params) {

                        //add setting
                        $setting_params = array();
                        if (isset($params['params'])) {
                            $setting_params = $params['params'];
                            unset($params['params']);
                        }
                        $wp_customize->add_setting($setting, array_merge( array( 'sanitize_callback' => null ), $setting_params));
                        //Get class control
                        $class = 'WP_Customize_Control';
                        if (isset($params['class']) && !empty($params['class'])) {
                            $class = 'WP_Customize_' . ucfirst($params['class']) . '_Control';
                            unset($params['class']);
                        }

                        //add params section and settings
                        $params['section'] = $section;
                        $params['settings'] = $setting;

                        //add controll
                        $wp_customize->add_control(
                            new $class($wp_customize, $setting, $params)
                        );
                    }
                }
            }

            foreach($this->panels as $key => $panel){
                $wp_customize->add_panel($key, $panel);
            }

            return;
        }

        public function remove_default_customize_section()
        {
            global $wp_customize;
//            // Remove Sections
            $wp_customize->remove_section('header_image');
            $wp_customize->remove_section('nav');
            $wp_customize->remove_section('static_front_page');
            $wp_customize->remove_section('colors');
            $wp_customize->remove_section('background_image');
        }
    }
}