/*!
Video Controller by bqworks
https://github.com/bqworks/video-controller
*/
!function(a){"use strict";var b=window.navigator.userAgent.toLowerCase(),c=null!==b.match(/ipad/i)||null!==b.match(/ipod/i)||null!==b.match(/iphone/i),d=function(b,c){this.$video=a(b),this.options=c,this.settings={},this.player=null,this._init()};d.prototype={_init:function(){this.settings=a.extend({},this.defaults,this.options);var b=this,c=a.VideoController.players,d=this.$video.attr("id");for(var e in c)if("undefined"!=typeof c[e]&&c[e].isType(this.$video)){this.player=new c[e](this.$video);break}if(null!==this.player){var f=["ready","start","play","pause","ended"];a.each(f,function(c,e){var f="video"+e.charAt(0).toUpperCase()+e.slice(1);b.player.on(e,function(){b.trigger({type:f,video:d}),a.isFunction(b.settings[f])&&b.settings[f].call(b,{type:f,video:d})})})}},play:function(){c===!0&&this.player.isStarted()===!1||"playing"===this.player.getState()||this.player.play()},stop:function(){c===!0&&this.player.isStarted()===!1||"stopped"===this.player.getState()||this.player.stop()},pause:function(){c===!0&&this.player.isStarted()===!1||"paused"===this.player.getState()||this.player.pause()},replay:function(){(c!==!0||this.player.isStarted()!==!1)&&this.player.replay()},on:function(a,b){return this.$video.on(a,b)},off:function(a){return this.$video.off(a)},trigger:function(a){return this.$video.triggerHandler(a)},destroy:function(){this.player.isStarted()===!0&&this.stop(),this.player.off("ready"),this.player.off("start"),this.player.off("play"),this.player.off("pause"),this.player.off("ended")},defaults:{videoReady:function(){},videoStart:function(){},videoPlay:function(){},videoPause:function(){},videoEnded:function(){}}},a.VideoController={players:{},addPlayer:function(a,b){this.players[a]=b}},a.fn.videoController=function(b){var c=Array.prototype.slice.call(arguments,1);return this.each(function(){if("undefined"==typeof a(this).data("videoController")){var e=new d(this,b);a(this).data("videoController",e)}else if("undefined"!=typeof b){var f=a(this).data("videoController");"function"==typeof f[b]?f[b].apply(f,c):a.error(b+" does not exist in videoController.")}})};var e=function(b){this.$video=b,this.player=null,this.ready=!1,this.started=!1,this.state="",this.events=a({}),this._init()};e.prototype={_init:function(){},play:function(){},pause:function(){},stop:function(){},replay:function(){},isType:function(){},isReady:function(){return this.ready},isStarted:function(){return this.started},getState:function(){return this.state},on:function(a,b){return this.events.on(a,b)},off:function(a){return this.events.off(a)},trigger:function(a){return this.events.triggerHandler(a)}};var f={youtubeAPIAdded:!1,youtubeVideos:[]},g=function(b){this.init=!1;var c=window.YT&&window.YT.Player;if("undefined"!=typeof c)e.call(this,b);else if(f.youtubeVideos.push({video:b,scope:this}),f.youtubeAPIAdded===!1){f.youtubeAPIAdded=!0;var d=document.createElement("script");d.src="http://www.youtube.com/player_api";var g=document.getElementsByTagName("script")[0];g.parentNode.insertBefore(d,g),window.onYouTubePlayerAPIReady=function(){a.each(f.youtubeVideos,function(a,b){e.call(b.scope,b.video)})}}};g.prototype=new e,g.prototype.constructor=g,a.VideoController.addPlayer("YoutubeVideo",g),g.isType=function(a){if(a.is("iframe")){var b=a.attr("src");if(-1!==b.indexOf("youtube.com")||-1!==b.indexOf("youtu.be"))return!0}return!1},g.prototype._init=function(){this.init=!0,this._setup()},g.prototype._setup=function(){var a=this;this.player=new YT.Player(this.$video[0],{events:{onReady:function(){a.trigger({type:"ready"}),a.ready=!0},onStateChange:function(b){switch(b.data){case YT.PlayerState.PLAYING:a.started===!1&&(a.started=!0,a.trigger({type:"start"})),a.state="playing",a.trigger({type:"play"});break;case YT.PlayerState.PAUSED:a.state="paused",a.trigger({type:"pause"});break;case YT.PlayerState.ENDED:a.state="ended",a.trigger({type:"ended"})}}}})},g.prototype.play=function(){this.player.playVideo()},g.prototype.pause=function(){c===!0?this.stop():this.player.pauseVideo()},g.prototype.stop=function(){this.player.seekTo(1),this.player.stopVideo(),this.state="stopped"},g.prototype.replay=function(){this.player.seekTo(1),this.player.playVideo()},g.prototype.on=function(a,b){var c=this;if(this.init===!0)e.prototype.on.call(this,a,b);else var d=setInterval(function(){c.init===!0&&(clearInterval(d),e.prototype.on.call(c,a,b))},100)};var h={vimeoAPIAdded:!1,vimeoVideos:[]},i=function(b){if(this.init=!1,"undefined"!=typeof window.Froogaloop)e.call(this,b);else if(h.vimeoVideos.push({video:b,scope:this}),h.vimeoAPIAdded===!1){h.vimeoAPIAdded=!0;var c=document.createElement("script");c.src="http://a.vimeocdn.com/js/froogaloop2.min.js";var d=document.getElementsByTagName("script")[0];d.parentNode.insertBefore(c,d);var f=setInterval(function(){"undefined"!=typeof window.Froogaloop&&(clearInterval(f),a.each(h.vimeoVideos,function(a,b){e.call(b.scope,b.video)}))},100)}};i.prototype=new e,i.prototype.constructor=i,a.VideoController.addPlayer("VimeoVideo",i),i.isType=function(a){if(a.is("iframe")){var b=a.attr("src");if(-1!==b.indexOf("vimeo.com"))return!0}return!1},i.prototype._init=function(){this.init=!0,this._setup()},i.prototype._setup=function(){var a=this;this.player=$f(this.$video[0]),this.player.addEvent("ready",function(){a.ready=!0,a.trigger({type:"ready"}),a.player.addEvent("play",function(){a.started===!1&&(a.started=!0,a.trigger({type:"start"})),a.state="playing",a.trigger({type:"play"})}),a.player.addEvent("pause",function(){a.state="paused",a.trigger({type:"pause"})}),a.player.addEvent("finish",function(){a.state="ended",a.trigger({type:"ended"})})})},i.prototype.play=function(){this.player.api("play")},i.prototype.pause=function(){this.player.api("pause")},i.prototype.stop=function(){this.player.api("seekTo",0),this.player.api("pause"),this.state="stopped"},i.prototype.replay=function(){this.player.api("seekTo",0),this.player.api("play")},i.prototype.on=function(a,b){var c=this;if(this.init===!0)e.prototype.on.call(this,a,b);else var d=setInterval(function(){c.init===!0&&(clearInterval(d),e.prototype.on.call(c,a,b))},100)};var j=function(a){e.call(this,a)};j.prototype=new e,j.prototype.constructor=j,a.VideoController.addPlayer("HTML5Video",j),j.isType=function(a){return a.is("video")&&a.hasClass("video-js")===!1&&a.hasClass("sublime")===!1?!0:!1},j.prototype._init=function(){var a=this;this.player=this.$video[0],this.ready=!0,this.player.addEventListener("play",function(){a.started===!1&&(a.started=!0,a.trigger({type:"start"})),a.state="playing",a.trigger({type:"play"})}),this.player.addEventListener("pause",function(){a.state="paused",a.trigger({type:"pause"})}),this.player.addEventListener("ended",function(){a.state="ended",a.trigger({type:"ended"})})},j.prototype.play=function(){this.player.play()},j.prototype.pause=function(){this.player.pause()},j.prototype.stop=function(){this.player.currentTime=0,this.player.pause(),this.state="stopped"},j.prototype.replay=function(){this.player.currentTime=0,this.player.play()};var k=function(a){e.call(this,a)};k.prototype=new e,k.prototype.constructor=k,a.VideoController.addPlayer("VideoJSVideo",k),k.isType=function(a){return"undefined"==typeof a.attr("data-videojs-id")&&!a.hasClass("video-js")||"undefined"==typeof videojs?!1:!0},k.prototype._init=function(){var a=this,b=this.$video.hasClass("video-js")?this.$video.attr("id"):this.$video.attr("data-videojs-id");this.player=videojs(b),this.player.ready(function(){a.ready=!0,a.trigger({type:"ready"}),a.player.on("play",function(){a.started===!1&&(a.started=!0,a.trigger({type:"start"})),a.state="playing",a.trigger({type:"play"})}),a.player.on("pause",function(){a.state="paused",a.trigger({type:"pause"})}),a.player.on("ended",function(){a.state="ended",a.trigger({type:"ended"})})})},k.prototype.play=function(){this.player.play()},k.prototype.pause=function(){this.player.pause()},k.prototype.stop=function(){this.player.currentTime(0),this.player.pause(),this.state="stopped"},k.prototype.replay=function(){this.player.currentTime(0),this.player.play()};var l=function(a){e.call(this,a)};l.prototype=new e,l.prototype.constructor=l,a.VideoController.addPlayer("SublimeVideo",l),l.isType=function(a){return a.hasClass("sublime")&&"undefined"!=typeof sublime?!0:!1},l.prototype._init=function(){var a=this;sublime.ready(function(){a.player=sublime.player(a.$video.attr("id")),a.ready=!0,a.trigger({type:"ready"}),a.player.on("play",function(){a.started===!1&&(a.started=!0,a.trigger({type:"start"})),a.state="playing",a.trigger({type:"play"})}),a.player.on("pause",function(){a.state="paused",a.trigger({type:"pause"})}),a.player.on("stop",function(){a.state="stopped",a.trigger({type:"stop"})}),a.player.on("end",function(){a.state="ended",a.trigger({type:"ended"})})})},l.prototype.play=function(){this.player.play()},l.prototype.pause=function(){this.player.pause()},l.prototype.stop=function(){this.player.stop()},l.prototype.replay=function(){this.player.stop(),this.player.play()};var m=function(a){e.call(this,a)};m.prototype=new e,m.prototype.constructor=m,a.VideoController.addPlayer("JWPlayerVideo",m),m.isType=function(a){return"undefined"==typeof a.attr("data-jwplayer-id")&&!a.hasClass("jwplayer")&&0===a.find("object[data*='jwplayer']").length||"undefined"==typeof jwplayer?!1:!0},m.prototype._init=function(){var a,b=this;this.$video.hasClass("jwplayer")?a=this.$video.attr("id"):"undefined"!=typeof this.$video.attr("data-jwplayer-id")?a=this.$video.attr("data-jwplayer-id"):0!==this.$video.find("object[data*='jwplayer']").length&&(a=this.$video.find("object").attr("id")),this.player=jwplayer(a),this.player.onReady(function(){b.ready=!0,b.trigger({type:"ready"}),b.player.onPlay(function(){b.started===!1&&(b.started=!0,b.trigger({type:"start"})),b.state="playing",b.trigger({type:"play"})}),b.player.onPause(function(){b.state="paused",b.trigger({type:"pause"})}),b.player.onComplete(function(){b.state="ended",b.trigger({type:"ended"})})})},m.prototype.play=function(){this.player.play(!0)},m.prototype.pause=function(){this.player.pause(!0)},m.prototype.stop=function(){this.player.stop(),this.state="stopped"},m.prototype.replay=function(){this.player.seek(0),this.player.play(!0)}}(jQuery);