<?php
/**
 * The template for displaying Archive pages
 *
 * @author      NanoAgency
 * @link        http://nanoagency.co
 * @copyright   Copyright (c) 2015 NanoAgency
 * @license     GPL v2
 */
get_header();

$title                = get_theme_mod('peflican_post_title_heading',true);

$style_css                  ="";
$bg_header                  = get_theme_mod('peflican_cat_image');
$bg_header_color            = get_theme_mod('peflican_cat_bg');
if($bg_header){
    $cat_header           ="background-image:url('$bg_header')";
    $style_css            ='style = '.$cat_header.'';
}
if($bg_header_color){
    $cat_header           ="background:$bg_header_color";
    $style_css            ='style = '.$cat_header.'';
}

?>
    <div class="wrap-content" role="main">
        <?php if ($title): ?>
            <div class="cat-header clearfix" <?php echo esc_attr($style_css);?>>
                <div class="container">
                    <h1 class="title-page">
                        <?php the_archive_title();?>
                    </h1>
                    <div class="description-page">
                        <?php the_archive_description( '<div class="taxonomy-description">', '</div>' ); ?>
                    </div>
                </div>
            </div>
        <?php endif;?>
        <div class="container wrap-content-inner">
            <div class="row content-category">
                <?php do_action('archive-sidebar-left'); ?>
                <?php do_action('archive-content-before'); ?>
                <?php if ( have_posts() ) : ?>
                <div class="archive-blog row">
                    <div class="rows affect-isotopes">
                        <?php
                        // Start the Loop.
                        while ( have_posts() ) : the_post(); ?>
                            <div class="item-post col-item col-md-12">
                                <?php get_template_part( 'templates/layout/content-list'); ?>
                            </div>
                        <?php endwhile;

                        else :
                            // If no content, include the "No posts found" template.
                            get_template_part( 'content', 'none' );
                        endif;

                        ?>
                    </div>
                </div>
                <?php
                the_posts_pagination( array(
                    'prev_text'          => '<i class="fa fa-angle-left"></i>',
                    'next_text'          => '<i class="fa fa-angle-right"></i>',
                    'before_page_number' => '<span class="meta-nav screen-reader-text"></span>',
                ) );
                ?>
                <?php do_action('archive-content-after'); ?>

                <?php do_action('archive-sidebar-right'); ?>
            </div><!-- .content-area -->
        </div>
    </div>
<?php
get_footer();

