<?php
/////////////////////////////////////////////////////////////////////////
//
//    Ce programme est un logiciel libre : vous pouvez le redistribuer ou
//    le modifier selon les termes de la GNU General Public Licence tels
//    que publiés par la Free Software Foundation : à votre choix, soit la
//    version 3 de la licence, soit une version ultérieure quelle qu'elle
//    soit.
//
//    Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS
//    AUCUNE GARANTIE ; sans même la garantie implicite de QUALITÉ
//    MARCHANDE ou D'ADÉQUATION À UNE UTILISATION PARTICULIÈRE. Pour
//    plus de détails, reportez-vous à la GNU General Public License.
//
//    Vous devez avoir reçu une copie de la GNU General Public License
//    avec ce programme. Si ce n'est pas le cas, consultez
//    <http://www.gnu.org/licenses/>
//
/////////////////////////////////////////////////////////////////////////
//
// Website : http://php-pastebin.com/
// Contact : contact@php-pastebin.com
// 
/////////////////////////////////////////////////////////////////////////
//
// Dev     : Atmoner
// Website : http://atmoner.com
// Contact : contact@atmoner.com
// 
/////////////////////////////////////////////////////////////////////////

if (file_exists("install/index.php")) header("location:install/index.php"); // This line can be removed after install

$path = dirname(__FILE__);

define("IN_PASTE",true);

require($path.'/libs/Smarty.class.php');
require($path.'/libs/default.class.php'); 

$smarty = new Smarty;
$startUp = new pasteUsers; 
$conf = $startUp->getConfigs();
 
// Smarty config
$smarty->addPluginsDir($path.'/libs/plugins/');
// $smarty->template_dir = $path.'/themes/v2/';
$smarty->template_dir = $path.'/themes/'.$conf['theme']['value'].'/';
$smarty->compile_dir = $path.'/cache/compile_tpl/';
$smarty->cache_dir = $path.'/cache/';
$smarty->debugging = false;
$smarty->caching = $conf['cache']['value'];
$smarty->cache_lifetime = $conf['timecache']['value'];
$smarty->config_dir = 'libs/lang/';

 
$smarty->assign("Name",$conf['title']['value']);
$smarty->assign("getConfigs",$conf);
$smarty->assign("footer",$startUp->addFooter()); 
$smarty->assign("userId",$startUp->isLogged()); 
$smarty->assign("userName",$startUp->session_username);
$smarty->assign("Admin",$startUp->checkAdmin());
// Stats
$today = time() - (1 * 24 * 60 * 60);
$smarty->assign("getTotalpaste",$startUp->getTotalpaste());
$smarty->assign("getTotalpastetoday",$startUp->getTotalpaste($today));
$smarty->assign("getTotalusers",$startUp->getTotalusers());

$page = (isset($_GET["page"])?$_GET["page"]:"");

switch ($page){

        case 'admincp': 
                # admin panel
                include 'pages/admincp/admincp.index.php';
        break; 

        case 'paste': 
                # paste
                include 'pages/paste.php';
                $smarty->display('paste.html');
        break;    
 
        case 'last-pastes': 
                # laste paste
                include 'pages/lastpastes.php';
                $smarty->display('lastpastes.html');
        break; 
 
        case 'zone-login': 
                # login
                include 'pages/login.php';
                $smarty->display('login.html');
        break; 

        case 'registration': 
                # registration
                include 'pages/registration.php';
                $smarty->display('registration.html');
        break; 

        case 'account': 
                # account
                include 'pages/account.php';
                $smarty->display('account.html');
        break; 

        case 'premium': 
                # account
                include 'pages/premium.php';
                $smarty->display('premium.html');
        break; 

        case 'logout': 
                # logout
                include 'pages/logout.php';
        break;

        case 'sitemap': 
                # sitemap
                include 'pages/sitemap.php';
        break; 

        case 'error': 
                # error
                $smarty->display('error.html');
        break; 
                             
        default:
        case '':  
        case 'index': 
                # index
                include 'pages/main.php';
                $smarty->display('index.html');
        break;
}

?>
