<div class="modal fade flip-effect" id="profileCardModal" ng-controller="profileCardCtrl">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">×</button>
                <h4 class="modal-title"><i class="fa fa-user"></i> Profile Card</h4>
            </div>
            <div class="modal-body">
                <div ng-show="isSearching" class="text-center" style="padding: 25px;">
                    <i class="fa fa-spinner fa-spin fa-4x"></i>
                </div>
                <div ng-hide="isSearching">
                    <div class="profileHeaderCtr" style="background-image: url(uploads/{{ profile.header_img }});">
                        <div class="profileHeaderOverlay"></div>
                        <img class="img-circle" ng-src="uploads/{{ profile.profile_img }}">
                        <div class="profileHeaderInfo text-center">
                            <h3>{{ profile.username }}</h3>
                            <div class="profileStatus" ng-show="profile.profile_status">{{ profile.profile_status }}</div>
                            <span ng-show="profile.location">
                                <i class="fa fa-map-marker"></i> {{ profile.location }}
                            </span>
                        </div>
                    </div>
                    <div class="row profileBody">
                        <div class="col-md-8">
                            <h3>About</h3>
                            <p style="white-space: pre;">{{ profile.about }}</p>
                        </div>
                        <div class="col-md-4">
                            <h3>Basic Details</h3>
                            <ul class="list-unstyled">
                                <li ng-show="profile.age"><strong>Age:</strong> {{ profile.age }}</li>
                                <li ng-show="profile.gender"><strong>Gender:</strong> {{ profile.gender }}</li>
                            </ul>
                            <button type="button" class="btn btn-block" ng-click="addFriend()" ng-hide="isOwnProfile"
                                    ng-class="{ 'btn-green': !isFriend, 'btn-orange': isFriend }">
                                <i class="fa fa-user-plus" ng-class="{
                                        'fa-user-plus': !isFriend && !updatingFriendStatus,
                                        'fa-user-times': isFriend && !updatingFriendStatus,
                                        'fa-spin fa-spinner': updatingFriendStatus
                                    }"></i>
                                <span ng-hide="isFriend">Friend</span>
                                <span ng-show="isFriend">Unfriend</span>
                            </button>
                            <button type="button" class="btn btn-block" ng-hide="isOwnProfile" ng-click="toggleBlock()"
                                    ng-class="{ 'btn-red': !isBlocked, 'btn-green': isBlocked }">
                                <i class="fa"  ng-class="{
                                        'fa-ban': !isBlocked && !updatingBlockStatus,
                                        'fa-unlock': isBlocked && !updatingBlockStatus,
                                        'fa-spin fa-spinner': updatingBlockStatus
                                    }"></i>
                                <span ng-hide="isBlocked">Block User</span>
                                <span ng-show="isBlocked">Unblock User</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>