<div class="modal fade flip-effect" id="pollCenterModal" ng-controller="pollCenterCtrl">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">×</button>
                <h4 class="modal-title"><i class="fa fa-tasks"></i> Poll Center</h4>
            </div>
            <div class="modal-body">
                <div ng-hide="isCreatingPoll">
                    <h3>
                        <span class="lobster">My Polls</span>
                        <button type="button" class="btn btn-sm pull-right btn-sky" ng-click="isCreatingPoll = true">
                            <i class="fa fa-plus"></i> Create Poll
                        </button>
                    </h3>
                    <div class="fileCtr" ng-repeat="poll in polls">
                        <span>{{ poll.question }}</span>
                        <button type="button" class="btn btn-xs btn-danger pull-right btnTooltip" ng-click="deletePoll(poll, $index)"
                                data-toggle="tooltip" data-placement="top" title="Delete"><i class="fa fa-remove"></i></button>
                        <button type="button" class="btn btn-xs btn-success pull-right btnTooltip" ng-click="addPollToChat(poll)"
                                data-toggle="tooltip" data-placement="top" title="Add to chat"><i class="fa fa-plus"></i></button>
                    </div>
                </div>
                <div ng-show="isCreatingPoll">
                    <h3>
                        <span class="lobster">Create Poll</span>
                        <button type="button" class="btn btn-sm pull-right btn-orange" ng-click="isCreatingPoll = false">
                            <i class="fa fa-mail-reply"></i> Go back
                        </button>
                    </h3>
                    <div id="createPollStatus"></div>
                    <form id="createPollForm" name="createPollForm" ng-submit="createPoll()">
                        <div class="form-group">
                            <label>Question</label>
                            <input type="text" class="form-control" ng-model="createPollObj.question">
                        </div>
                        <h4>
                            <span class="lobster">Answers</span>
                            <button type="button" class="btn btn-violet btn-sm pull-right" ng-click="addAnswer()">
                                <i class="fa fa-plus"></i> Add Answer
                            </button>
                        </h4>
                        <div class="form-horizontal">
                            <div class="form-group" ng-repeat="answer in createPollObj.answers">
                                <label class="col-sm-2 control-label">Answer</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" placeholder="Answer"
                                           ng-model="answer.answer">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-block btn-sky">
                                <i class="fa fa-save"></i> Submit
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>