<div class="modal fade flip-effect" id="pollModal" ng-controller="pollCtrl">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">×</button>
                <h4 class="modal-title"><i class="fa fa-tasks"></i> Poll</h4>
            </div>
            <div class="modal-body">
                <div ng-show="isLoading" class="text-center" style="margin-top: 10px;">
                    <i class="fa fa-spinner fa-spin fa-4x"></i>
                </div>
                <div ng-hide="isLoading">
                    <h2 class="lobster text-center">{{ poll.question }}</h2>
                    <div class="pollAnswerCtr"
                         ng-repeat="answer in poll.answers"
                         ng-click="selectAnswer(answer, $index)"
                         ng-class="{
                            pollNotAnswered: !alreadyAnswered,
                            pollAlreadyAnswered: alreadyAnswered,
                            pollSelectedAnswer: $index === userAnswer
                         }" ng-mouseover="answer.isHovering = alreadyAnswered ? 0 : 1" ng-mouseleave="answer.isHovering = 0">
                        {{ answer.answer }}
                        <small ng-show="alreadyAnswered" ><em>({{ answer.total_votes }} votes)</em></small>
                        <i class="fa pull-right fa-circle-thin" ng-hide="alreadyAnswered" ng-class="{ 'fa-circle-thin': !answer.isHovering, 'fa-check': answer.isHovering }"></i>
                        <div ng-show="alreadyAnswered" class="pull-right">
                            {{ answer.percentage }}%
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>