<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 4/25/2015
 * Time: 5:30 PM
 */
class YoutubeEmbed extends JBBCode\CodeDefinition {
    public function __construct()
    {
        parent::__construct();
        $this->setTagName("yt");
    }

    public function asHtml(JBBCode\ElementNode $el)
    {
        $content = "";
        foreach($el->getChildren() as $child)
            $content .= $child->getAsBBCode();

        $foundMatch = preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $content, $matches);

        if(!$foundMatch)
            return $el->getAsBBCode();
        else
            return "<div class=\"col-xs-9 embed-responsive embed-responsive-16by9\"><iframe class=\"embed-responsive-item\" src=\"http://www.youtube.com/embed/".$matches[1]."\" allowfullscreen></iframe></div>";
    }
}