<?php

require( 'inc/db.php' );
require( 'inc/functions.php' );

if(!isset($_GET['id'])){
    die("Invalid Chat");
}

$cid                            =   intval($_GET['id']);
$chatQuery                      =   $db->prepare("SELECT * FROM chats WHERE id = :id");
$chatQuery->execute(array(
    ":id"                       =>  $cid
));

if($chatQuery->rowCount() === 0){
    die("Invalid Chat");
}

$chatRow                        =   $chatQuery->fetch(PDO::FETCH_ASSOC);
$emoticonsQuery =   $db->prepare("SELECT * FROM emotes");
$emoticonsQuery->execute();
$emoticonsRow   =   $emoticonsQuery->fetchAll();
?>

<!DOCTYPE html>
<html class="no-js" ng-app="owlChatEmbedApp">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title><?php echo $settings['site_name']; ?></title>
    <meta name="description" content="<?php echo $settings['site_desc']; ?>">
    <meta name="keywords" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

    <!-- Google webfont -->
    <link href='http://fonts.googleapis.com/css?family=Noto+Sans:400,700' rel='stylesheet' type='text/css'>
    <link href='http://fonts.googleapis.com/css?family=Lobster' rel='stylesheet' type='text/css'>
    <link href="//netdna.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet">

    <!-- Libraries -->
    <link rel="stylesheet" href="assets/bs/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/bs/css/extended.min.css">
    <link rel="stylesheet" href="assets/loading-bar/loading-bar.css">
    <link rel="stylesheet" href="assets/toastr/toastr.min.css">
    <link rel="stylesheet" href="assets/lightbox/css/lightbox.css">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/spectrum/spectrum.css">
    <link rel="stylesheet" href="assets/main/chat.css">
    <!--[if IE 8]>
    <script src="//cdnjs.cloudflare.com/ajax/libs/modernizr/2.8.1/modernizr.min.js"></script>
    <![endif]-->
</head>
<body ng-controller="chatController">

<div class="chatCtr" >
    <div class="chat_headerCtr" style="background-color: <?php echo $chatRow['header_bg']; ?>; color: <?php echo $chatRow['header_font']; ?>">
        <div class="chatTitle"><?php echo $chatRow['title']; ?></div>
        <div class="chatDesc"><?php echo $chatRow['chat_desc']; ?></div>
    </div>
    <div class="chat_bodyCtr" id="chat_bodyCtr" scroll-glue>
        <div class="chat_msgWrapper" ng-repeat="message in messages">
            <div class="chat_msgAvatar" ng-hide="chatSettings.show_avatar == 2">
                <a href data-toggle="modal" data-target="#profileCardModal"
                   ng-click="getProfile(message.submitted_by)">
                    <img ng-src="uploads/{{ message.profile_img }}">
                </a>
            </div>
            <div class="chat_msgCtr">
                <a href data-toggle="modal" data-target="#profileCardModal"
                   ng-click="getProfile(message.submitted_by)" class="chat_msgUsername">
                    {{ message.submitted_by }}
                </a>
                <div class="chat_msgText" ng-bind-html="message.message | rawHtml"></div>
                <i class="fa fa-remove text-danger removeMsgBtn" ng-show="canDelete"
                   ng-click="removeChatMsg(message, $index)"></i>
            </div>
            <div style="clear:both;"></div>
        </div>
    </div>
    <div class="chat_toolsCtr" ng-show="showRoom">
        <div class="chat_optsCtr">
            <select class="ct_select" ng-model="messageOpts.fontFamily"
                    ng-hide="settings.font_family_btn == 2 || chatSettings.font_enabled == 2">
                <option ng-value="font" ng-repeat="font in fonts">{{ font }}</option>
            </select>
            <input type="number" min="10" max="20" class="ct_fontSize" ng-model="messageOpts.fontSize"
                   ng-hide="chatSettings.size_enabled == 2">
            <input type="text" id="ct_fontColor"
                   ng-hide="settings.color_btn == 2 || chatSettings.color_enabled == 2">
            <button type="button" class="ct_btnDefault" ng-model="messageOpts.bold"
                    ng-click="messageOpts.bold = !messageOpts.bold"
                    ng-class="{ 'ct_btnActive': messageOpts.bold }"
                    ng-hide="settings.bold_btn == 2 || chatSettings.bold_enabled == 2"><i class="fa fa-bold"></i></button>
            <button type="button" class="ct_btnDefault" ng-model="messageOpts.italic"
                    ng-click="messageOpts.italic = messageOpts.italic ? false : true"
                    ng-class="{ 'ct_btnActive': messageOpts.italic }"
                    ng-hide="settings.italic_btn == 2 || chatSettings.italic_enabled == 2"><i class="fa fa-italic"></i></button>
            <button type="button" class="ct_btnDefault" style="color: #54BCD1;"
                    ng-hide="settings.emoticon_btn == 2 || chatSettings.emotes_enabled == 2"
                    data-toggle="modal" data-target="#emoticonModal"><i class="fa fa-heart"></i></button>
            <button type="button" class="ct_btnDefault"
                    ng-hide="settings.images_btn == 2 || chatSettings.images_enabled == 4"
                    ng-click="messageOpts.message =  messageOpts.message + '[img][/img]'"><i class="fa fa-file-image-o"></i></button>
            <button type="button" class="ct_btnDefault"
                    ng-hide="settings.url_btn == 2 || chatSettings.links_enabled == 2"
                    ng-click="messageOpts.message =  messageOpts.message + '[url][/url]'"><i class="fa fa-link"></i></button>
            <button type="button" class="ct_btnDefault"
                    ng-hide="settings.youtube_btn == 2 || chatSettings.youtube_enabled == 2"
                    ng-click="messageOpts.message =  messageOpts.message + '[yt][/yt]'"><i class="fa fa-youtube"></i></button>
        </div>
    </div>
    <form class="chat_messageForm" name="sendChatMsgForm" ng-show="showRoom"
          ng-submit="submitChatMessage(sendChatMsgForm.$valid)" novalidate>
                <textarea class="ct_textarea" ng-model="messageOpts.message" ng-minlength="1" required
                          ng-keydown="checkKeyCode($event, sendChatMsgForm.$valid)" ng-disabled="sendingMessage"></textarea>
        <button type="submit" class="ct_btnBlue" ng-disabled="sendingMessage">Submit</button>
        <div class="clearfix"></div>
    </form>
    <div class="chat_footerCtr" style="height: 30px; background-color: <?php echo $chatRow['footer_bg']; ?>; color: <?php echo $chatRow['footer_font']; ?>">
        <i class="fa pull-right volumeBtn" ng-click="toggleSound()" ng-class="{ 'fa-volume-up': playSound, 'fa-volume-off': !playSound }"></i>
    </div>
</div>

<div class="modal fade flip-effect" id="emoticonModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><i class="fa fa-smile-o"></i> Emoticons</h4>
            </div>
            <div class="modal-body">
                <div id="loginStatus"></div>
                <img ng-repeat="emote in emotes" ng-src="assets/emotes/{{ emote.img }}" class="emote-img"
                     data-dismiss="modal" ng-click="messageOpts.message = messageOpts.message + emote.e_cmd + ' '">
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<!-- Libraries -->
<script src="//ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
<script src="assets/bs/js/bootstrap.min.js"></script>
<script src="assets/bs/js/extended.min.js"></script>
<script src="assets/spectrum/spectrum.js"></script>
<script src="assets/howler/howler.min.js"></script>
<script src="assets/lightbox/js/lightbox.min.js"></script>

<script>
    // initialize Kanda extended script
    extended = new Extended();
    var alertSound      =   new Howl({
        urls: ['assets/main/beep.mp3']
    });
    var emotes          =   <?php echo json_encode($emoticonsRow); ?>;
    var cid = <?php echo $cid; ?>;
    var fonts           =   <?php echo json_encode($fontFamilyArr); ?>
</script>

<!-- Angular -->
<script src="assets/angular/angular.min.js"></script>
<script src="assets/angular/angular-sanitize.min.js"></script>
<script src="assets/angular/scrollglue.js"></script>
<script src="assets/angular/angular-cookies.min.js"></script>

<!-- App -->
<script src="app/embed.js"></script>

</body>
</html>