<div class="chatCtr">
    <div class="chat_headerCtr">
        <div class="chatTitle">Private Messaging {{ username }}</div>
        <div class="chatPrivateMessagesBtn" style="top:0;" ng-click="showPrivateMessages()"
             ng-class="{ chatPrivateMessagesBtn_active: pmUsers.length > 0 }"><i class="fa fa-list"></i></div>
        <div class="chatPrivateMessageUsersCtr">
            <a href="pm/{{pmUser.submitted_by }}" ng-repeat="pmUser in pmUsers">
                {{ pmUser.submitted_by }}
                <span class="pmLowCount pull-right"
                      ng-class="{
                        pmLowCount: pmUser.total < 5,
                        pmMidCount: pmUser.total < 12 && pmUser.total > 5,
                        pmHighCount: pmUser.total > 12
                    }">{{ pmUser.total }}</span>
            </a>
        </div>
    </div>
    <div class="chat_bodyCtr" id="chat_bodyCtr" scroll-glue>
        <div class="chat_msgWrapper" ng-repeat="message in messages">
            <div class="chat_msgAvatar"><img ng-src="uploads/{{ message.profile_img }}"></div>
            <div class="chat_msgCtr">
                <span class="chat_msgUsername">{{ message.submitted_by }}</span>
                <div class="chat_msgText" ng-bind-html="message.message | rawHtml"></div>
            </div>
            <div class="clearfix"></div>
        </div>
    </div>
    <div class="chat_toolsCtr">
        <select class="ct_select" ng-model="messageOpts.fontFamily" ng-show="settings.font_family_btn == 1">
            <option ng-value="font" ng-repeat="font in fonts">{{ font }}</option>
        </select>
        <input type="number" min="10" max="20" class="ct_fontSize" ng-model="messageOpts.fontSize">
        <input type="text" id="ct_fontColor" ng-show="settings.color_btn == 1">
        <button type="button" class="ct_btnDefault" ng-model="messageOpts.bold"
                ng-click="messageOpts.bold = !messageOpts.bold"
                ng-class="{ 'ct_btnActive': messageOpts.bold }"
                ng-show="settings.bold_btn == 1"><i class="fa fa-bold"></i></button>
        <button type="button" class="ct_btnDefault" ng-model="messageOpts.italic"
                ng-click="messageOpts.italic = messageOpts.italic ? false : true"
                ng-class="{ 'ct_btnActive': messageOpts.italic }"
                ng-show="settings.italic_btn == 1"><i class="fa fa-italic"></i></button>
        <button type="button" class="ct_btnDefault" style="color: #54BCD1;" ng-show="settings.emoticon_btn == 1"
                data-toggle="modal" data-target="#emoticonModal"><i class="fa fa-heart"></i></button>
        <button type="button" class="ct_btnDefault" ng-show="settings.images_btn == 1"
                ng-click="messageOpts.message =  messageOpts.message + '[img][/img]'"><i class="fa fa-file-image-o"></i></button>
        <button type="button" class="ct_btnDefault" ng-show="settings.url_btn == 1"
                ng-click="messageOpts.message =  messageOpts.message + '[url][/url]'"><i class="fa fa-link"></i></button>
        <button type="button" class="ct_btnDefault" ng-show="settings.youtube_btn == 1"
                ng-click="messageOpts.message =  messageOpts.message + '[yt][/yt]'"><i class="fa fa-youtube"></i></button>
        <button type="button" class="ct_btnDefault" data-toggle="modal" data-target="#filesModal"><i class="fa fa-cloud-upload"></i></button>
    </div>
    <form class="chat_messageForm" name="sendChatMsgForm"
          ng-submit="submitChatMessage(sendChatMsgForm.$valid)" novalidate>
        <textarea class="ct_textarea" ng-model="messageOpts.message" ng-minlength="1" required
                  ng-keydown="checkKeyCode($event, sendChatMsgForm.$valid)" ng-disabled="sendingMessage"></textarea>
        <button type="submit" class="ct_btnBlue" ng-disabled="sendingMessage">Submit</button>
        <div class="clearfix"></div>
    </form>
    <div class="chat_footerCtr">
        <a class="chat_usersOnlineLink" href="chat/{{ last_cid }}" ng-show="last_cid">Go Back</a>
    </div>
</div>
<div class="modal fade flip-effect" id="emoticonModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><i class="fa fa-smile-o"></i> Emoticons</h4>
            </div>
            <div class="modal-body">
                <div id="loginStatus"></div>
                <img ng-repeat="emote in emotes" ng-src="assets/emotes/{{ emote.img }}" class="emote-img"
                     data-dismiss="modal" ng-click="messageOpts.message = messageOpts.message + emote.e_cmd + ' '">
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>