<h1 class="lobster">Create Chat</h1>
<div class="row">
    <div class="col-md-5">
        <div id="createChatStatus"></div>
        <form id="createChatForm" name="createChatForm" ng-submit="createChat()">
            <tabset justified="true">
                <tab heading="Basic">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" class="form-control" ng-model="chat.name">
                    </div>
                    <div class="form-group">
                        <label>Description</label>
                        <textarea class="form-control" ng-model="chat.desc"></textarea>
                    </div>
                    <div class="checkbox">
                        <label>
                            <input type="checkbox" ng-model="chat.showAvatar"> Show Avatars
                        </label>
                    </div>
                    <div class="form-group">
                        <label>Bad words filter</label>
                        <textarea class="form-control" ng-model="chat.bad_words"></textarea>
                    </div>
                    <div class="form-group">
                        <label>Password</label>
                        <input type="text" class="form-control" ng-model="chat.password">
                        <p class="help-block">Leave empty if no password</p>
                    </div>
                </tab>
                <tab heading="Colors">
                    <div class="form-group">
                        <label>Color Schemes</label>
                        <select class="form-control" ng-options="scheme.name for scheme in colorSchemes"
                                ng-change="updateColorScheme()" ng-model="chat.currentScheme"></select>
                    </div>
                    <div class="form-group">
                        <label>Header Background Color</label>
                        <input type="text" id="inputHeaderBGColor">
                    </div>
                    <div class="form-group">
                        <label>Header Font Color</label>
                        <input type="text" id="inputHeaderFontColor">
                    </div>
                    <div class="form-group">
                        <label>Footer Background Color</label>
                        <input type="text" id="inputFooterBGColor">
                    </div>
                    <div class="form-group">
                        <label>Footer Font Color</label>
                        <input type="text" id="inputFooterFontColor">
                    </div>
                </tab>
                <tab heading="Advanced">
                    <div class="form-group">
                        <label>Image</label>
                        <select class="form-control" ng-model="chat.images">
                            <option value="1">Show images in chat</option>
                            <option value="2">Show images in lightbox</option>
                            <option value="3">Link images</option>
                            <option value="4">No images</option>
                        </select>
                    </div>
                    <div class="checkbox">
                        <label>
                            <input type="checkbox" ng-model="chat.fontFamily" ng-true-value="1" ng-false-value="2"> Font Family
                        </label>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" ng-model="chat.fontSize" ng-true-value="1" ng-false-value="2"> Font Size</label>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" ng-model="chat.fontColor" ng-true-value="1" ng-false-value="2"
                                ng-change="updateColorPicker()"> Color</label>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" ng-model="chat.bold" ng-true-value="1" ng-false-value="2"> Bold</label>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" ng-model="chat.italic" ng-true-value="1" ng-false-value="2"> Italic</label>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" ng-model="chat.emotes" ng-true-value="1" ng-false-value="2"> Emotes</label>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" ng-model="chat.links" ng-true-value="1" ng-false-value="2"> Links</label>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" ng-model="chat.youtube" ng-true-value="1" ng-false-value="2"> Youtube</label>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" ng-model="chat.files" ng-true-value="1" ng-false-value="2"> Files</label>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" ng-model="chat.polls" ng-true-value="1" ng-false-value="2"> Polls</label>
                    </div>
                </tab>
            </tabset>
            <div class="form-group">
                <button type="submit" class="btn btn-block btn-success">
                    <i class="fa fa-plus"></i> Create
                </button>
            </div>
        </form>
    </div>
    <div class="col-md-7">
        <div class="chatCtr">
            <div class="chat_headerCtr" style="background-color: {{ chat.header_bg_color }}; color: {{ chat.header_font_color }};">
                <div class="chatTitle">{{ chat.name }}</div>
                <div class="chatDesc">{{ chat.desc }}</div>
                <div class="chatPrivateMessagesBtn"><i class="fa fa-list"></i></div>
            </div>
            <div class="chat_bodyCtr" ng-class="{ 'chat_noAvatar': !chat.showAvatar }" scroll-glue>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="chat_msgWrapper">
                    <div class="chat_msgAvatar" ng-show="chat.showAvatar"><img src="http://placehold.it/150x150"></div>
                    <div class="chat_msgCtr">
                        <span class="chat_msgUsername">Admin</span>
                        <div class="chat_msgText">Bacon ipsum dolor amet andouille drumstick capicola shankle ham hock bacon venison ball tip leberkas swine.</div>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
            <div class="chat_toolsCtr">
                <div class="chat_optsCtr">
                    <select class="ct_select" id="ct_fontFamily" ng-show="chat.fontFamily == 1">
                        <option value="arial">Arial</option>
                        <option value="bookantiqua">Book Antiqua</option>
                        <option value="centurygothic">Century Gothic</option>
                        <option value="comicsansms">Comic Sans MS</option>
                        <option value="couriernew">Courier New</option>
                        <option value="fixedsys">Fixedsys</option>
                        <option value="franklingothicmedium">Franklin Gothic Medium</option>
                        <option value="garamond">Garamond</option>
                        <option value="georgia">Georgia</option>
                        <option value="impact">Impact</option>
                        <option value="lucidaconsole">Lucida Console</option>
                        <option value="microsoftsandsserif">Microsoft Sands Serif</option>
                        <option value="palatinolinotype">Palatino Linotype</option>
                        <option value="system">System</option>
                        <option value="tahoma">Tahoma</option>
                        <option value="timesnewroman">Times New Roman</option>
                        <option value="trehuchetms">Trebuchet MS</option>
                        <option value="verdana">Verdana</option>
                    </select>
                    <input type="number" value="12" min="10" max="16" class="ct_fontSize" ng-show="chat.fontSize == 1">
                    <input type="text" id="ct_fontColor" ng-show="chat.fontColor == 1">
                    <button type="button" class="ct_btnDefault" ng-show="chat.bold == 1"><i class="fa fa-bold"></i></button>
                    <button type="button" class="ct_btnDefault" ng-show="chat.italic == 1"><i class="fa fa-italic"></i></button>
                    <button type="button" class="ct_btnDefault" ng-show="chat.emotes == 1" style="color: #54BCD1;"><i class="fa fa-heart"></i></button>
                    <button type="button" class="ct_btnDefault" ng-hide="chat.images == 4"><i class="fa fa-file-image-o"></i></button>
                    <button type="button" class="ct_btnDefault" ng-show="chat.links == 1"><i class="fa fa-link"></i></button>
                    <button type="button" class="ct_btnDefault" ng-show="chat.youtube == 1"><i class="fa fa-youtube"></i></button>
                    <button type="button" class="ct_btnDefault" ng-show="chat.files == 1"><i class="fa fa-cloud-upload"></i></button>
                    <button type="button" class="ct_btnDefault" ng-show="chat.polls == 1"><i class="fa fa-tasks"></i></button>
                </div>
            </div>
            <form class="chat_messageForm">
                <textarea class="ct_textarea"></textarea>
                <button type="submit" class="ct_btnBlue">Submit</button>
                <div style="clear:both;"></div>
            </form>
            <div class="chat_footerCtr" style="background-color: {{ chat.footer_bg_color }};">
                <a class="chat_usersOnlineLink" href="#" style="color: {{ chat.footer_font_color }};">12 User(s) Online</a>
            </div>
        </div>
    </div>
</div>