/**
 * Created by jaskokoyn on 2/16/2015.
 */
owlChatApp.config(function($stateProvider, $urlRouterProvider, $locationProvider) {
    $locationProvider.html5Mode(true);

    // For any unmatched url, redirect to /state1
    $urlRouterProvider.otherwise("/");

    // Now set up the states
    $stateProvider
        .state('home', {
            url: "/",
            templateUrl: "app/views/home.php"
        })
        .state('create', {
            url: "/create",
            templateUrl: "app/views/create.php",
            controller: "createChatController"
        })
        .state('chat', {
            url: "/chat/:cid",
            templateUrl: "app/views/chat.php",
            controller: "chatController"
        })
        .state('private_message', {
            url: "/pm/:username",
            templateUrl: "app/views/pm.php",
            controller: "pmController"
        }).state('editProfile', {
            url: "/edit-profile",
            templateUrl: "app/views/edit-profile.php",
            controller: "editProfileController"
        })
        .state('forgot', {
            url: "/forgot/:code",
            templateUrl: "app/views/forgot.php",
            controller: "forgotPassController"
        })
        .state("logout", {
            url: "/logout",
            controller: function(){
                location.href   =   "logout.php";
            }
        });
});