/**
 * Created by jaskokoyn on 2/19/2015.
 */
owlChatApp.controller( "profileCardCtrl", ["$scope", "$rootScope", "$http", function($scope, $rootScope, $http){
    $scope.isSearching                      =   false;
    $scope.profile                          =   {};
    $scope.updatingFriendStatus             =   false;
    $scope.isFriend                         =   false;
    $scope.isOwnProfile                     =   false;
    $scope.isBlocked                        =   false;
    $scope.updatingBlockStatus              =   false;

    $rootScope.getProfile                   =   function(username){
        $("#friendsModal").modal('hide');
        $scope.isSearching          =   true;

        $http({
            url: "actions/users/get-profile.php",
            method: "POST",
            data:  {
                username: username
            }
        }).success(function(data, status, headers, config) {
            if(data.status == 1){
                $("#profileCardModal").modal('hide');
                return null;
            }

            if(data.u.gender == 1){
                data.u.gender       =   "Male";
            }else if(data.u.gender == 2){
                data.u.gender       =   "Female";
            }else{
                data.u.gender       =   null;
            }

            $scope.profile          =   data.u;
            $scope.isSearching      =   false;
            $scope.isFriend         =   data.isFriend;
            $scope.isOwnProfile     =   data.isOwn;
            $scope.isBlocked        =   data.isBlocked;
        });
    };

    $scope.addFriend                        =   function(){
        $scope.updatingFriendStatus         =   true;

        $http({
            method: 'POST',
            url: 'actions/users/toggle-friend.php',
            data: $scope.profile
        }).success(function(data,status,headers,config){
            $scope.updatingFriendStatus     =   false;
            $scope.isFriend                 =   !$scope.isFriend;
        });
    };

    $scope.toggleBlock                      =   function(){
        $scope.updatingBlockStatus         =   true;

        $http({
            method: 'POST',
            url: 'actions/users/toggle-block.php',
            data: $scope.profile
        }).success(function(data,status,headers,config){
            $scope.updatingBlockStatus     =   false;
            $scope.isBlocked               =   !$scope.isBlocked;
        });
    }
}]);