/**
 * Created by jaskokoyn on 2/17/2015.
 */
owlChatApp.controller( "loginController", ["$scope", "$http", function($scope, $http){
    $scope.loginUser            =   {};
    $scope.showLogin            =   true;

    $scope.login                =   function(){
        $("#loginForm").slideUp('fast', function(){
            $("#loginStatus").html(
                '<div class="alert alert-info"><strong>Please wait!</strong> We are logging you in.</div>'
            ).hide().slideDown('fast');

            $http({
                method: 'POST',
                url: 'actions/users/login.php',
                data: $scope.loginUser
            }).success(function(data,status,headers,config){
                if(data.status == 2){
                    $("#loginStatus").html(
                        '<div class="alert alert-success"><strong>Success!</strong></div>'
                    );
                    location.reload();
                }else{
                    $("#loginStatus").html(
                        '<div class="alert alert-warning"><strong>Warning!</strong> ' + data.message + '</div>'
                    );
                    $("#loginForm").slideDown('fast');
                }
            });
        });
    };

    $scope.showForgotPass       =   function(){
        $scope.showLogin    =   false;
    };
    $scope.showLoginForm        =   function(){
        $scope.showLogin    =   true;
    };

    $scope.submitForgotForm     =   function(isValid){
        console.log(isValid);
        if (!isValid) {
            return;
        }

        $("#forgotForm").slideUp('fast', function(){
            $("#forgotStatus").html(
                '<div class="alert alert-info"><strong>Please wait!</strong></div>'
            ).hide().slideDown('fast');

            $.post( "actions/forgot-password.php", $scope.forgotUser, function(res){
                if(res.status == 1){
                    $("#forgotStatus").html(
                        '<div class="alert alert-success"><strong>Success!</strong> ' + res.message + '</div>'
                    );
                }else{
                    $("#forgotStatus").html(
                        '<div class="alert alert-warning"><strong>Warning!</strong> ' + res.message + '</div>'
                    );
                }
                $("#forgotForm").slideDown('fast');
            }, "json").error(function(xhr){
                console.log(xhr);
            });
        });
    };
}]);