/**
 * Created by jaskokoyn on 2/24/2015.
 */
owlChatApp.controller("forgotPassController", ["$scope", "$stateParams", "$http", "$rootScope", "$location", function($scope, $stateParams, $http, $rootScope, $location){
    $scope.userChange   =   "";
    $http({
        url: "actions/check-forget.php",
        method: "POST",
        data: $stateParams,
        headers: {'Content-Type': 'application/x-www-form-urlencoded'}
    }).success(function(data, status, headers, config) {
        // this callback will be called asynchronously
        // when the response is available
        console.log(data);
        if(data.confirmed == 1){
            $location.path("/");
            return;
        }
        $scope.userChange   =   data.email;
    });
    $scope.submitNewPassForm    =   function(isValid){
        console.log(isValid);
        if (!isValid) {
            return;
        }

        $("#newPassForm").slideUp('fast', function(){
            $("#newPassStatus").html(
                '<div class="alert alert-info"><strong>Please wait!</strong> We are updating your password</div>'
            ).hide().slideDown('fast');

            $http({
                url: "actions/forgot-change-password.php",
                method: "POST",
                data: {
                    pass1: $scope.passUser.pass1,
                    pass2: $scope.passUser.pass2,
                    code: $stateParams.code
                },
                headers: {'Content-Type': 'application/x-www-form-urlencoded'}
            }).success(function(data, status, headers, config) {
                // this callback will be called asynchronously
                // when the response is available
                console.log(data);
                if(data.status == 1){
                    $("#newPassStatus").html(
                        '<div class="alert alert-success"><strong>Success!</strong> You can now login with your new password.</div>'
                    );
                }else{
                    $("#newPassStatus").html(
                        '<div class="alert alert-warning"><strong>Warning!</strong> Please make sure passwords match.</div>'
                    );
                }
                $("#newPassForm").slideDown('fast');
            });
        });
    };
}]);