/**
 * Created by jaskokoyn on 2/19/2015.
 */
owlChatApp.controller("editProfileController", ["$scope", "$http", "Upload", "$timeout",function($scope, $http, Upload, $timeout){
    $timeout(function(){
        $(".nav-tabs").addClass("sky");
    }, 500);

    $scope.profile                  =   {
        location:       "",
        age:            0,
        gender:         3,
        about:          "",
        profile_status: null
    };
    $scope.pass                     =   {
        pass1:                          null,
        pass2:                          null
    };

    $http({
        url: "actions/users/get-profile.php",
        method: "POST"
    }).success(function(data, status, headers, config) {
        $scope.profile              =   data.u;
    });

    $scope.basic                    =   function(){
        $("#basicStatus").html(
            '<div class="alert alert-info">Updating Profile. Please wait.</div>'
        );

        $("#basicForm").slideUp('fast', function(){
            $http({
                method: 'POST',
                url: "actions/users/update-profile.php",
                data: $scope.profile
            }).success(function(data, status, headers, config){
                $("#basicForm").slideDown('fast');
                if(data.status == 2){
                    $("#basicStatus").html(
                        '<div class="alert alert-success">Profile updated successfully!</div>'
                    );
                }else{
                    $("#basicStatus").html(
                        '<div class="alert alert-warning">Unable to update profile</div>'
                    );
                }
            });
        });
    };

    $scope.uploadProfileImg         =   function(files) {
        if (files && files.length) {
            var file                =   files[0];
            toastr.info("Uploading your image. Please wait.");
            Upload.upload({
                url: 'actions/users/update-profile-img.php',
                file: file,
                fileFormDataName: 'img'
            }).success(function (data, status, headers, config) {
                if(data.status == 2){
                    toastr.success("Profile image uploaded!", "Success!");
                    $scope.profile.profile_img  =   data.img;
                }else{
                    toastr.warning("Unable to upload profile image.", "Warning!");
                }
            });
        }
    };

    $scope.uploadHeaderImg          =   function(files) {
        if (files && files.length) {
            var file                =   files[0];
            toastr.info("Uploading your image. Please wait.");
            Upload.upload({
                url: 'actions/users/update-header-img.php',
                file: file,
                fileFormDataName: 'img'
            }).success(function (data, status, headers, config) {
                if(data.status == 2){
                    toastr.success("Header image uploaded!", "Success!");
                    $scope.profile.header_img  =   data.img;
                }else{
                    toastr.warning("Unable to upload header image.", "Warning!");
                }
            });
        }
    };

    $scope.changePass               =   function(isValid){
        $("#changePassForm").slideUp('fast', function(){
            $("#changePassStatus").html(
                '<div class="alert alert-info"><strong>Please wait!</strong> We are updating your password</div>'
            ).hide().slideDown('fast');

            $http({
                url: "actions/users/change-password.php",
                method: "POST",
                data: $scope.pass
            }).success(function(data, status, headers, config) {
                if(data.status == 2){
                    $("#changePassStatus").html(
                        '<div class="alert alert-success"><strong>Success!</strong> You can now login with your new password.</div>'
                    );
                }else{
                    $("#changePassStatus").html(
                        '<div class="alert alert-warning"><strong>Warning!</strong> Please make sure passwords match.</div>'
                    );
                }
                $("#changePassForm").slideDown('fast');
            });
        });
    };
}]);