/**
 * Created by jaskokoyn on 2/22/2015.
 */
owlChatApp.controller( "createChatController", ["$scope", "$state", "$rootScope", "$timeout", "$http", function($scope, $state, $rootScope, $timeout, $http){
    $timeout(function(){
        $(".nav-tabs").addClass("sky");
    }, 500);

    $scope.colorSchemes         =   [
        {
            name:                       'Default',
            header_bg_color:            '#54BCD1',
            header_font_color:          '#fff',
            footer_bg_color:            '#42B655',
            footer_font_color:          '#fff'
        },{
            name:                       'Sandy Stone',
            header_bg_color:            '#046380',
            header_font_color:          '#EFECCA',
            footer_bg_color:            '#002F2F',
            footer_font_color:          '#E6E2AF'
        },{
            name:                       'Honey Pot',
            header_bg_color:            '#DB9E36',
            header_font_color:          '#FFFAD5',
            footer_bg_color:            '#BD4932',
            footer_font_color:          '#FFFAD5'
        },{
            name:                       'Vitamin C',
            header_bg_color:            '#BEDB39',
            header_font_color:          '#004358',
            footer_bg_color:            '#FD7400',
            footer_font_color:          '#FFE11A'
        },{
            name:                       'Pink Galaxy',
            header_bg_color:            '#F94376',
            header_font_color:          '#D2FFFF',
            footer_bg_color:            '#9C4789',
            footer_font_color:          '#D2FFFF'
        },{
            name:                       'Starlight',
            header_bg_color:            '#BF3636',
            header_font_color:          '#F2C744',
            footer_bg_color:            '#283F4B',
            footer_font_color:          '#F2C744"'
        },{
            name:                       'Back in the Past',
            header_bg_color:            '#32BA82',
            header_font_color:          '#FF5B3B',
            footer_bg_color:            '#78BF73',
            footer_font_color:          '#80123A"'
        },{
            name:                       'Mitra',
            header_bg_color:            '#CB79D4',
            header_font_color:          '#F5F093',
            footer_bg_color:            '#CB79D4',
            footer_font_color:          '#ADCACC"'
        },{
            name:                       'HeavenKatana',
            header_bg_color:            '#664070',
            header_font_color:          '#E3755F',
            footer_bg_color:            '#8A586E',
            footer_font_color:          '#D6A47A"'
        },{
            name:                       'Sintonia Fina',
            header_bg_color:            '#73A5A4',
            header_font_color:          '#FEF8EA',
            footer_bg_color:            '#B2A94C',
            footer_font_color:          '#FEF8EA"'
        }
    ];
    $scope.chat                 =   {
        name:                       'Chat Title',
        desc:                       'Chat description here.',
        showAvatar:                 true,
        header_bg_color:            '#54BCD1',
        header_font_color:          '#fff',
        footer_bg_color:            '#42B655',
        footer_font_color:          '#fff',
        currentScheme:              $scope.colorSchemes[0],
        images:                     1,
        fontFamily:                 1,
        fontSize:                   1,
        fontColor:                  1,
        bold:                       1,
        italic:                     1,
        emotes:                     1,
        links:                      1,
        youtube:                    1,
        files:                      1,
        polls:                      1,
        bad_words:                  null,
        password:                   null
    };
    $scope.updateColorScheme    =   function(){
        $scope.chat.header_bg_color =   $scope.chat.currentScheme.header_bg_color;
        $scope.chat.header_font_color =   $scope.chat.currentScheme.header_font_color;
        $scope.chat.footer_bg_color =   $scope.chat.currentScheme.footer_bg_color;
        $scope.chat.footer_font_color =   $scope.chat.currentScheme.footer_font_color;

        $("#inputHeaderBGColor").spectrum("set",  $scope.chat.header_bg_color );
        $("#inputHeaderFontColor").spectrum("set",  $scope.chat.header_font_color );
        $("#inputFooterBGColor").spectrum("set",  $scope.chat.footer_bg_color );
        $("#inputFooterFontColor").spectrum("set",  $scope.chat.footer_font_color );
    };

    $scope.updateColorPicker    =   function(){
        if($scope.chat.fontColor == 1){
            $("#ct_fontColor").spectrum({
                color: "#333"
            });
        }else{
            $("#ct_fontColor").spectrum('destroy');
        }
    };

    $timeout(function(){
        $("#inputHeaderBGColor").spectrum({
            color: $scope.chat.header_bg_color,
            clickoutFiresChange: true,
            showInput: true,
            preferredFormat: "hex3",
            move: function(color){
                $scope.$apply(function(){
                    $scope.chat.header_bg_color     =   color.toHexString();
                });
            }
        });
        $("#inputHeaderFontColor").spectrum({
            color: $scope.chat.header_font_color,
            clickoutFiresChange: true,
            showInput: true,
            preferredFormat: "hex3",
            move: function(color){
                $scope.$apply(function(){
                    $scope.chat.header_font_color   =   color.toHexString();
                });
            }
        });
        $("#inputFooterBGColor").spectrum({
            color: $scope.chat.footer_bg_color,
            clickoutFiresChange: true,
            showInput: true,
            preferredFormat: "hex3",
            move: function(color){
                $scope.$apply(function(){
                    $scope.chat.footer_bg_color    =   color.toHexString();
                });
            }
        });
        $("#inputFooterFontColor").spectrum({
            color: $scope.chat.footer_font_color,
            clickoutFiresChange: true,
            showInput: true,
            preferredFormat: "hex3",
            move: function(color){
                $scope.$apply(function(){
                    $scope.chat.footer_font_color  =   color.toHexString();
                });
            }
        });
        $("#ct_fontColor").spectrum({
            color: "#333"
        });
    }, 100);

    $scope.createChat           =   function(){
        $("#createChatForm").slideUp('fast', function(){
            $("#createChatStatus").html(
                '<div class="alert alert-info"><strong>Please wait!</strong> Your chat is being created.</div>'
            ).hide().slideDown('fast');


            $http({
                method: 'POST',
                url: 'actions/chat/create.php',
                data: $scope.chat
            }).success(function(data,status,headers,config){
                console.log(data);
                if(data.status == 2){
                    $("#createChatStatus").html(
                        '<div class="alert alert-success"><strong>Success!</strong> Your chat was created.</div>'
                    );
                    $state.go("chat",{
                        cid: data.cid
                    });
                }else{
                    $("#createChatStatus").html(
                        '<div class="alert alert-danger"><strong>Error!</strong> Your chat could not be created.</div>'
                    );
                    $("#createChatForm").slideDown('fast');
                }
            });
        });
    };
}]);