/**
 * Created by jaskokoyn on 2/16/2015.
 */
var owlChatApp  =   angular.module( "owlChatApp", [
    'ngSanitize', 'ui.router', 'luegg.directives', 'cfp.loadingBar', 'ui.bootstrap',
    'ngFileUpload', 'ngCookies'
]);

owlChatApp.run(["$http", "$rootScope", "cfpLoadingBar", function($http, $rootScope, cfpLoadingBar){
    $rootScope.fonts                =   fonts;
    $rootScope.pmUsername           =   null;

    $http.post("actions/jumpstart.php").success(function(data, status, headers, config) {
        // this callback will be called asynchronously
        // when the response is available
        $rootScope.settings =   data;
    });

    $rootScope.$on('$stateChangeStart', function(){
        cfpLoadingBar.start();
    });

    $rootScope.$on('$stateChangeSuccess', function(){
        cfpLoadingBar.complete();
    });

    $rootScope.$on('$stateChangeError',  function(){
        cfpLoadingBar.complete();
    });
}]);

owlChatApp.filter('rawHtml', ['$sce', function($sce){
    return function(val) {
        return $sce.trustAsHtml(val);
    };
}]);