<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 2/19/2015
 * Time: 10:53 PM
 */
require( '../inc/db.php' );
include( '../inc/functions.php' );

if(!isset($_SESSION['loggedin']) || $user['mem_level'] != 2){
    header("location:../index.php");
    exit();
}

$page           =   (isset($_GET['page'])) ? intval($_GET['page']) : 1;
$offset         =   ($page * 25) - 25;
$mUsersQuery =   $db->prepare("SELECT * FROM users LIMIT 25 OFFSET " . $offset);
$mUsersQuery->execute();

include( 'inc/header.inc.php' );
?>

<div id="main">
    <div class="container">
        <div class="row">
            <div class="col-sm-4 col-md-3"><?php include( 'inc/side-nav.inc.php' ); ?></div>
            <div class="col-sm-8 col-md-9">
                <div class="panel orange">
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            <i class="fa fa-bookmark"></i> Manage Users
                        </h3>
                    </div>
                    <div class="panel-body">
                        <table class="table">
                            <thead>
                            <tr>
                                <td>ID</td>
                                <td>Username</td>
                                <td>E-mail</td>
                                <td>Level</td>
                                <td>Actions</td>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            while( $mUsersRow   =   $mUsersQuery->fetch() ){
                                if($mUsersRow['mem_level'] == 2){
                                    $level  =   "admin";
                                }else if($mUsersRow['mem_level'] == 3){
                                    $level  =   "moderator";
                                }else if($mUsersRow['mem_level'] == 4){
                                    $level  =   "banned";
                                }else{
                                    $level  =   "member";
                                }
                                ?>
                                <tr>
                                    <td><?php echo $mUsersRow['id']; ?></td>
                                    <td><?php echo $mUsersRow['username']; ?></td>
                                    <td><?php echo $mUsersRow['email']; ?></td>
                                    <td><?php echo $level; ?></td>
                                    <td>
                                        <a href="edit-user.php?id=<?php echo $mUsersRow['id']; ?>" class="btn btn-sm btn-primary"><i class="fa fa-cogs"></i></a>
                                        <button type="button" class="btn btn-sm btn-red delUserBtn"
                                                data-uid="<?php echo $mUsersRow['id']; ?>"><i class="fa fa-remove"></i></button>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                            </tbody>
                        </table>
                        <a href="?page=<?php echo $page + 1; ?>" class="btn btn-sky pull-right">Next</a>
                        <?php
                        if($page > 1){
                            echo '<a href="?page=' . ($page - 1) . '" class="btn btn-sky pull-right" style="margin-right:5px;">Previous</a>';
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php

include( 'inc/footer.inc.php' );

?>
<script src="assets/js/manage-users.js"></script>