<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 2/20/2015
 * Time: 1:17 PM
 */

require( '../inc/db.php' );
include( '../inc/functions.php' );

if(!isset($_SESSION['loggedin']) || $user['mem_level'] != 2){
    header("location:../index.php");
    exit();
}

$page           =   (isset($_GET['page'])) ? intval($_GET['page']) : 1;
$offset         =   ($page * 25) - 25;
$messagesQuery =   $db->prepare("SELECT * FROM messages LIMIT 25 OFFSET " . $offset);
$messagesQuery->execute();

include( 'inc/header.inc.php' );
?>

<div id="main">
    <div class="container">
        <div class="row">
            <div class="col-sm-4 col-md-3"><?php include( 'inc/side-nav.inc.php' ); ?></div>
            <div class="col-sm-8 col-md-9">
                <div class="panel orange">
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            <i class="fa fa-bookmark"></i> Manage Messages
                        </h3>
                    </div>
                    <div class="panel-body">
                        <table class="table">
                            <thead>
                            <tr>
                                <td>ID</td>
                                <td>Username</td>
                                <td>Message</td>
                                <td>Date</td>
                                <td>Actions</td>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            while( $messagesRow   =   $messagesQuery->fetch() ){
                                ?>
                                <tr>
                                    <td><?php echo $messagesRow['id']; ?></td>
                                    <td><?php echo $messagesRow['submitted_by']; ?></td>
                                    <td><?php echo $messagesRow['message']; ?></td>
                                    <td><?php echo @date( "M d, Y", $messagesRow['time_submitted']); ?></td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-red delMessageBtn"
                                                data-mid="<?php echo $messagesRow['id']; ?>"><i class="fa fa-remove"></i></button>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                            </tbody>
                        </table>
                        <a href="?page=<?php echo $page + 1; ?>" class="btn btn-sky pull-right">Next</a>
                        <?php
                        if($page > 1){
                            echo '<a href="?page=' . ($page - 1) . '" class="btn btn-sky pull-right" style="margin-right:5px;">Previous</a>';
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php

include( 'inc/footer.inc.php' );

?>
<script src="assets/js/manage-messages.js"></script>