<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 2/15/2015
 * Time: 9:40 PM
 */
require( '../inc/db.php' );
include( '../inc/functions.php' );

if(!isset($_SESSION['loggedin']) || $user['mem_level'] != 2){
    header("location:../index.php");
    exit();
}

$page           =   (isset($_GET['page'])) ? intval($_GET['page']) : 1;
$offset         =   ($page * 25) - 25;
$chatsQuery =   $db->prepare("SELECT * FROM chats  LIMIT 25 OFFSET " . $offset);
$chatsQuery->execute();

include( 'inc/header.inc.php' );
?>

    <div id="main">
        <div class="container">
            <div class="row">
                <div class="col-sm-4 col-md-3"><?php include( 'inc/side-nav.inc.php' ); ?></div>
                <div class="col-sm-8 col-md-9">
                    <div class="panel orange">
                        <div class="panel-heading">
                            <h3 class="panel-title">
                                <i class="fa fa-bookmark"></i> Manage Chatrooms
                                <a href="create-chat.php" class="btn btn-sm btn-violet pull-right"><i class="fa fa-plus"></i> Create</a>
                            </h3>
                        </div>
                        <div class="panel-body">
                            <table class="table">
                                <thead>
                                <tr>
                                    <td>ID</td>
                                    <td>Name</td>
                                    <td>Description</td>
                                    <td>Actions</td>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                while( $chatsRow   =   $chatsQuery->fetch() ){
                                    ?>
                                    <tr>
                                        <td><?php echo $chatsRow['id']; ?></td>
                                        <td><?php echo $chatsRow['title']; ?></td>
                                        <td><?php echo $chatsRow['chat_desc']; ?></td>
                                        <td>
                                            <a href="edit-chat.php?id=<?php echo $chatsRow['id']; ?>" class="btn btn-sm btn-primary"><i class="fa fa-cogs"></i></a>
                                            <button type="button" class="btn btn-sm btn-red delChatBtn"
                                                data-cid="<?php echo $chatsRow['id']; ?>"><i class="fa fa-remove"></i></button>
                                        </td>
                                    </tr>
                                    <?php
                                }
                                ?>
                                </tbody>
                            </table>
                            <a href="?page=<?php echo $page + 1; ?>" class="btn btn-sky pull-right">Next</a>
                            <?php
                            if($page > 1){
                                echo '<a href="?page=' . ($page - 1) . '" class="btn btn-sky pull-right" style="margin-right:5px;">Previous</a>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php

include( 'inc/footer.inc.php' );

?>
<script src="assets/js/manage-chats.js"></script>