<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 2/20/2015
 * Time: 3:43 PM
 */

require( '../inc/db.php' );
include( '../inc/functions.php' );

if(!isset($_SESSION['loggedin']) || $user['mem_level'] != 2){
    header("location:../index.php");
    exit();
}

include( 'inc/header.inc.php' );

$emotesQuery    =   $db->prepare("SELECT * FROM emotes");
$emotesQuery->execute();
?>

<div id="main">
    <div class="container">
        <div class="row">
            <div class="col-sm-4 col-md-3"><?php include( 'inc/side-nav.inc.php' ); ?></div>
            <div class="col-sm-8 col-md-9">
                <div class="panel orange">
                    <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-bookmark"></i> Settings</h3></div>
                    <div class="panel-body">
                        <ul id="settingsTabs" class="nav nav-tabs nav-justified red">
                            <li class="active"><a href="#general" data-toggle="tab">General</a></li>
                            <li><a href="#user" data-toggle="tab">User</a></li>
                            <li><a href="#chat" data-toggle="tab">Chat</a></li>
                            <li><a href="#emoticon" data-toggle="tab">Emoticons</a></li>
                        </ul>
                        <div id="settingsTabcontent" class="tab-content">
                            <div class="tab-pane fade in active" id="general">
                                <h3>General Settings</h3>
                                <div id="generalStatus"></div>
                                <form id="generalForm">
                                    <div class="form-group">
                                        <label>Site Name</label>
                                        <input type="text" class="form-control" id="inputSiteName"
                                            value="<?php echo $settings['site_name']; ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Site Description</label>
                                        <textarea class="form-control" id="inputSiteDesc"><?php echo $settings['site_desc']; ?></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label>Header Ad</label>
                                        <textarea class="form-control" id="inputHeaderAd"><?php echo $settings['header_ad']; ?></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label>Footer Ad</label>
                                        <textarea class="form-control" id="inputFooterAd"><?php echo $settings['footer_ad']; ?></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label>Sidebar Ad</label>
                                        <textarea class="form-control" id="inputSidebarAd"><?php echo $settings['sidebar_ad']; ?></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label>Bad Words Filter</label>
                                        <textarea class="form-control" id="inputBadWords"><?php echo $settings['bad_words']; ?></textarea>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-sky btn-block">Update</button>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane fade" id="user">
                                <h3>User Settings</h3>
                                <div id="userStatus"></div>
                                <form id="userForm">
                                    <div class="form-group">
                                        <label>Registration</label>
                                        <select class="form-control" id="regEnabled">
                                            <option value="1" <?php echo ($settings['registration'] == 1) ? "selected": ""; ?>>Enable</option>
                                            <option value="2" <?php echo ($settings['registration'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Max Upload Size(Kb)</label>
                                        <input type="number" class="form-control" id="inputMaxUploadSize"
                                            value="<?php echo $settings['max_upload_size']; ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Allow File Uploads</label>
                                        <select class="form-control" id="allowFileUpload">
                                            <option value="1">Enable</option>
                                            <option value="2" <?php echo ($settings['file_uploads'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Allow Poll Creation</label>
                                        <select class="form-control" id="allowPollCreation">
                                            <option value="1">Enable</option>
                                            <option value="2" <?php echo ($settings['create_polls'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-sky btn-block">Update</button>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane fade" id="chat">
                                <h3>Chat Settings</h3>
                                <div id="chatStatus"></div>
                                <form id="chatForm">
                                    <div class="form-group">
                                        <label>Auto Clean Database (hours)</label>
                                        <input type="number" class="form-control" id="inputACD"
                                               value="<?php echo $settings['auto_clean_db']; ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Regular Member Room Creation</label>
                                        <select class="form-control" id="inputRoomCreation">
                                            <option value="1" <?php echo ($settings['room_creation'] == 1) ? "selected": ""; ?>>Enable</option>
                                            <option value="2" <?php echo ($settings['room_creation'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Guests can Chat</label>
                                        <select class="form-control" id="inputGuestChat">
                                            <option value="1" <?php echo ($settings['guests_chat'] == 1) ? "selected": ""; ?>>Enable</option>
                                            <option value="2" <?php echo ($settings['guests_chat'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Font Family</label>
                                        <select class="form-control" id="inputFontFamily">
                                            <option value="1" <?php echo ($settings['font_family_btn'] == 1) ? "selected": ""; ?>>Enable</option>
                                            <option value="2" <?php echo ($settings['font_family_btn'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Color</label>
                                        <select class="form-control" id="inputColor">
                                            <option value="1" <?php echo ($settings['color_btn'] == 1) ? "selected": ""; ?>>Enable</option>
                                            <option value="2" <?php echo ($settings['color_btn'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Bold</label>
                                        <select class="form-control" id="inputBold">
                                            <option value="1" <?php echo ($settings['bold_btn'] == 1) ? "selected": ""; ?>>Enable</option>
                                            <option value="2" <?php echo ($settings['bold_btn'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Italic</label>
                                        <select class="form-control" id="inputItalic">
                                            <option value="1" <?php echo ($settings['italic_btn'] == 1) ? "selected": ""; ?>>Enable</option>
                                            <option value="2" <?php echo ($settings['italic_btn'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Emoticons</label>
                                        <select class="form-control" id="inputEmoticon">
                                            <option value="1" <?php echo ($settings['emoticon_btn'] == 1) ? "selected": ""; ?>>Enable</option>
                                            <option value="2" <?php echo ($settings['emoticon_btn'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Images</label>
                                        <select class="form-control" id="inputImages">
                                            <option value="1" <?php echo ($settings['images_btn'] == 1) ? "selected": ""; ?>>Enable</option>
                                            <option value="2" <?php echo ($settings['images_btn'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>URL</label>
                                        <select class="form-control" id="inputURL">
                                            <option value="1" <?php echo ($settings['url_btn'] == 1) ? "selected": ""; ?>>Enable</option>
                                            <option value="2" <?php echo ($settings['url_btn'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Youtube</label>
                                        <select class="form-control" id="inputYoutube">
                                            <option value="1" <?php echo ($settings['youtube_btn'] == 1) ? "selected": ""; ?>>Enable</option>
                                            <option value="2" <?php echo ($settings['youtube_btn'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Private Chat</label>
                                        <select class="form-control" id="inputPrivateChat">
                                            <option value="1" <?php echo ($settings['private_chat'] == 1) ? "selected": ""; ?>>Enable</option>
                                            <option value="2" <?php echo ($settings['private_chat'] == 2) ? "selected": ""; ?>>Disable</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-sky btn-block">Update</button>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane fade" id="emoticon">
                                <button type="button" class="btn btn-violet pull-right" data-target="#uploadEmoteModal"
                                    data-toggle="modal">
                                    <i class="fa fa-plus"></i> add
                                </button><br><br>
                                <table class="table table-bordered table-hover">
                                    <thead>
                                    <tr>
                                        <td>Image</td>
                                        <td>Name</td>
                                        <td>Command</td>
                                        <td>Actions</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    while($emotesRow    =   $emotesQuery->fetch()){
                                    ?>
                                    <tr>
                                        <td><img src="../assets/emotes/<?php echo $emotesRow['img']; ?>" class="img-responsive center-block"></td>
                                        <td><?php echo $emotesRow['img_name']; ?></td>
                                        <td><?php echo $emotesRow['e_cmd']; ?></td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-blue editEmoteBtn" data-toggle="modal"
                                                    data-eid="<?php echo $emotesRow['id']; ?>" data-target="#editEmoteModal"
                                                    data-ename="<?php echo $emotesRow['img_name']; ?>" data-ecmd="<?php echo $emotesRow['e_cmd']; ?>">
                                                <i class="fa fa-wrench"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-red delEmoteBtn"
                                                data-eid="<?php echo $emotesRow['id']; ?>">
                                                <i class="fa fa-remove"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade bottomin-effect" id="editEmoteModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title" id="mySmallModalLabel">Edit Emoticon</h4>
            </div>
            <div class="modal-body">
                <div id="editEmoteStatus"></div>
                <form id="editEmoteForm">
                    <input type="hidden" id="inputEditEmoteID">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" class="form-control" id="inputEditEmoteName">
                    </div>
                    <div class="form-group">
                        <label>Command</label>
                        <input type="text" class="form-control" id="inputEditEmoteCmd">
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-sky btn-block"><i class="fa fa-plus"></i> Update</button>
                    </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<div class="modal fade bottomin-effect" id="uploadEmoteModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title" id="mySmallModalLabel">Add Emoticon</h4>
            </div>
            <div class="modal-body">
                <div id="uploadEmoteStatus"></div>
                <form id="uploadEmoteForm">
                    <div class="form-group">
                        <label>Image</label>
                        <input type="file" id="addEmoteImg" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" class="form-control" id="inputEmoteName">
                    </div>
                    <div class="form-group">
                        <label>Command</label>
                        <input type="text" class="form-control" id="inputEmoteCmd">
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-sky btn-block"><i class="fa fa-plus"></i> Add</button>
                    </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<?php

include( 'inc/footer.inc.php' );

?>
<script src="assets/js/settings.js"></script>