<?php

if($settings['auto_clean_db'] > 0){
    $last_clean =   $settings['last_cleaned'];
    $next_clean =   $last_clean + ($settings['auto_clean_db'] * 3600);

    if(time() > $next_clean){
        $truncateTable  =   $db->prepare("TRUNCATE TABLE messages");
        $truncateTable->execute();

        $updateLastClean    =   $db->prepare("UPDATE settings SET last_cleaned = :lc WHERE id = :id");
        $updateLastClean->execute(array(
            ":lc"   =>  time(),
            ":id"   =>  1
        ));
    }
}

?>

<!DOCTYPE html>
<html class="no-js" ng-app="adminApp">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title><?php echo $settings['site_name']; ?> Admin</title>
    <meta name="description" content="<?php echo $settings['site_desc']; ?>">
    <meta name="keywords" content="">
	<link rel="canonical" href="http://www.bistscript.ir" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <!-- Google webfont -->
    <link href='http://fonts.googleapis.com/css?family=Noto+Sans:400,700' rel='stylesheet' type='text/css'>
    <link href='http://fonts.googleapis.com/css?family=Lobster' rel='stylesheet' type='text/css'>
    <!-- FontAwesome css -->
    <link href="//netdna.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet">
    <!-- Core bootstrap -->
    <link rel="stylesheet" href="../assets/bs/css/bootstrap.min.css">
    <!-- Kanda's extended style -->
    <link rel="stylesheet" href="../assets/bs/css/extended.min.css">
    <link rel="stylesheet" href="../assets/spectrum/spectrum.css">
    <link rel="stylesheet" href="../assets/main/main.css">
    <link rel="stylesheet" href="assets/css/admin.css">
    <link rel="stylesheet" href="../assets/main/chat.css">
    <!-- Modernizr -->
    <!--[if IE 8]>
    <script src="//cdnjs.cloudflare.com/ajax/libs/modernizr/2.8.1/modernizr.min.js"></script>
    <![endif]-->
</head>
<body id="admin-page">
<div id="header">
    <nav class="navbar navbar-static-top owlchat-navbar" role="navigation">
        <!-- Brand and toggle get grouped for better mobile display -->
        <div class="navbar-header">
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#oc-nav">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </button>
            <a class="logo text-center" ui-sref="home"><?php echo $settings['site_name']; ?></a>
        </div>
        <div class="container">
            <!-- Collect the nav links, forms, and other content for toggling -->
            <div class="collapse navbar-collapse pull-right" id="oc-nav">
                <ul>
                    <li><a href="../index.php"><i class="fa fa-home fa-fw"></i> Home</a></li>
                    <li><a href="index.php"><i class="fa fa-shield fa-fw"></i> Admin</a></li>
                    <li><a href="../logout.php"><i class="fa fa-sign-out fa-fw"></i> Logout</a></li>
                </ul>
            </div><!-- /.navbar-collapse -->
        </div><!-- /.container-fluid -->
    </nav>
</div>