<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 2/20/2015
 * Time: 12:39 PM
 */
require( '../inc/db.php' );
include( '../inc/functions.php' );

if(!isset($_SESSION['loggedin']) || $user['mem_level'] != 2){
    header("location:../index.php");
    exit();
}

$editUserQuery  =   $db->prepare("SELECT * FROM users WHERE id = :id");
$editUserQuery->execute(array(
    ":id"   =>  intval($_GET['id'])
));

if($editUserQuery->rowCount() === 0){
    header("location:manage-users.php");
    exit();
}
$editUserRow    =   $editUserQuery->fetch();

include( 'inc/header.inc.php' );
?>
<div id="main">
    <div class="container">
        <div class="row">
            <div class="col-sm-4 col-md-3"><?php include( 'inc/side-nav.inc.php' ); ?></div>
            <div class="col-sm-8 col-md-9">
                <div class="panel orange">
                    <div class="panel-heading">
                        <h3 class="panel-title"><i class="fa fa-bookmark"></i> Edit User - <?php echo $editUserRow['username']; ?></h3>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div id="updateUserStatus"></div>
                                <form id="updateUserForm">
                                    <input type="hidden" value="<?php echo $editUserRow['id']; ?>" id="inputUid">
                                    <div class="form-group">
                                        <label>Username</label>
                                        <input type="text" class="form-control" id="inputUsername"
                                               value="<?php echo $editUserRow['username']; ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input type="email" class="form-control" id="inputEmail"
                                               value="<?php echo $editUserRow['email']; ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Location</label>
                                        <input type="text" class="form-control" id="inputLoc"
                                               value="<?php echo $editUserRow['location']; ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Age</label>
                                        <input type="text" class="form-control" id="inputAge"
                                               value="<?php echo $editUserRow['age']; ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Gender</label>
                                        <select class="form-control" id="inputGender">
                                            <option value="1" <?php echo ($editUserRow['gender'] == 1) ? "SELECTED": ""; ?>>Male</option>
                                            <option value="2" <?php echo ($editUserRow['gender'] == 2) ? "SELECTED": ""; ?>>Female</option>
                                            <option value="3" <?php echo ($editUserRow['gender'] == 3) ? "SELECTED": ""; ?>>Hidden</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>About</label>
                                        <textarea class="form-control" id="inputAbout" rows="5"><?php echo $editUserRow['about']; ?></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label>Level</label>
                                        <select class="form-control" id="inputLevel">
                                            <option value="1" <?php echo ($editUserRow['mem_level'] == 1) ? "SELECTED": ""; ?>>Member</option>
                                            <option value="2" <?php echo ($editUserRow['mem_level'] == 2) ? "SELECTED": ""; ?>>Admin</option>
                                            <option value="3" <?php echo ($editUserRow['mem_level'] == 3) ? "SELECTED": ""; ?>>Super Mod</option>
                                            <option value="4" <?php echo ($editUserRow['mem_level'] == 4) ? "SELECTED": ""; ?>>Banned</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-block btn-success">
                                            <i class="fa fa-cogs"></i> Update
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php

include( 'inc/footer.inc.php' );

?>
<script src="assets/js/edit-user.js"></script>