<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 2/15/2015
 * Time: 9:44 PM
 */
require( '../inc/db.php' );
include( '../inc/functions.php' );

if(!isset($_SESSION['loggedin']) || $user['mem_level'] != 2){
    header("location:../index.php");
    exit();
}

$chatQuery  =   $db->prepare("SELECT * FROM chats WHERE id = :id");
$chatQuery->execute(array(
    ":id"   =>  intval($_GET['id'])
));

if($chatQuery->rowCount() === 0){
    header("location:manage-chats.php");
    exit();
}
$chatRow    =   $chatQuery->fetch();

include( 'inc/header.inc.php' );
?>
<script>
    var hbg =   '<?php echo $chatRow['header_bg']; ?>';
    var hfc =   '<?php echo $chatRow['header_font']; ?>';
    var fbg =   '<?php echo $chatRow['footer_bg']; ?>';
    var ffc =   '<?php echo $chatRow['footer_font']; ?>';

</script>
<div id="main">
    <div class="container">
        <div class="row">
            <div class="col-sm-4 col-md-3"><?php include( 'inc/side-nav.inc.php' ); ?></div>
            <div class="col-sm-8 col-md-9">
                <div class="panel orange">
                    <div class="panel-heading">
                        <h3 class="panel-title"><i class="fa fa-bookmark"></i> Chat Editor</h3>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-5">
                                <div id="createChatStatus"></div>
                                <form id="createChatForm">
                                    <input type="hidden" value="<?php echo $chatRow['id']; ?>" id="inputCid">
                                    <div class="form-group">
                                        <label>Name</label>
                                        <input type="text" class="form-control" id="inputChatName"
                                               value="<?php echo $chatRow['title']; ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea class="form-control" id="inputChatDesc"><?php echo $chatRow['chat_desc']; ?></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label>Header Background Color</label>
                                        <input type="text" id="inputHeaderBGColor">
                                    </div>
                                    <div class="form-group">
                                        <label>Header Font Color</label>
                                        <input type="text" id="inputHeaderFontColor">
                                    </div>
                                    <div class="form-group">
                                        <label>Footer Background Color</label>
                                        <input type="text" id="inputFooterBGColor">
                                    </div>
                                    <div class="form-group">
                                        <label>Footer Font Color</label>
                                        <input type="text" id="inputFooterFontColor">
                                    </div>
                                    <div class="checkbox">
                                        <label>
                                            <input type="checkbox" id="checkShowAvatar"
                                                <?php echo ($chatRow['show_avatar'] == 1) ? "checked": ""; ?>> Show Avatars
                                        </label>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-block btn-success">
                                            <i class="fa fa-cogs"></i> Update
                                        </button>
                                    </div>
                                </form>
                            </div>
                            <div class="col-md-7">
                                <div class="chatCtr">
                                    <div class="chat_headerCtr">
                                        <div class="chatTitle">Chat Title</div>
                                        <div class="chatDesc">Chat description here.</div>
                                        <div class="chatPrivateMessagesBtn"><i class="fa fa-list"></i></div>
                                    </div>
                                    <div class="chat_bodyCtr <?php echo ($chatRow['show_avatar'] == 2) ? "chat_noAvatar": ""; ?>">
                                        <div class="chat_msgWrapper">
                                            <?php
                                            if($chatRow['show_avatar'] == 1){
                                            ?>
                                                <div class="chat_msgAvatar"><img src="http://placehold.it/150x150"></div>
                                            <?php
                                            }
                                            ?>
                                            <div class="chat_msgCtr">
                                                <span class="chat_msgUsername">Admin</span>
                                                <div class="chat_msgText">Here's a really long message for you k</div>
                                            </div>
                                            <div style="clear:both;"></div>
                                        </div>
                                        <div class="chat_msgWrapper">
                                            <?php
                                            if($chatRow['show_avatar'] == 1){
                                                ?>
                                                <div class="chat_msgAvatar"><img src="http://placehold.it/150x150"></div>
                                            <?php
                                            }
                                            ?>
                                            <div class="chat_msgCtr">
                                                <span class="chat_msgUsername">Admin</span>
                                                <div class="chat_msgText">Here's a really long message for you k</div>
                                            </div>
                                            <div style="clear:both;"></div>
                                        </div>
                                        <div class="chat_msgWrapper">
                                            <?php
                                            if($chatRow['show_avatar'] == 1){
                                                ?>
                                                <div class="chat_msgAvatar"><img src="http://placehold.it/150x150"></div>
                                            <?php
                                            }
                                            ?>
                                            <div class="chat_msgCtr">
                                                <span class="chat_msgUsername">Admin</span>
                                                <div class="chat_msgText">Here's a really long message for you k</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="chat_toolsCtr">
                                        <div class="chat_optsCtr">
                                            <select class="ct_select" id="ct_fontFamily">
                                                <option value="arial">Arial</option>
                                                <option value="bookantiqua">Book Antiqua</option>
                                                <option value="centurygothic">Century Gothic</option>
                                                <option value="comicsansms">Comic Sans MS</option>
                                                <option value="couriernew">Courier New</option>
                                                <option value="fixedsys">Fixedsys</option>
                                                <option value="franklingothicmedium">Franklin Gothic Medium</option>
                                                <option value="garamond">Garamond</option>
                                                <option value="georgia">Georgia</option>
                                                <option value="impact">Impact</option>
                                                <option value="lucidaconsole">Lucida Console</option>
                                                <option value="microsoftsandsserif">Microsoft Sands Serif</option>
                                                <option value="palatinolinotype">Palatino Linotype</option>
                                                <option value="system">System</option>
                                                <option value="tahoma">Tahoma</option>
                                                <option value="timesnewroman">Times New Roman</option>
                                                <option value="trehuchetms">Trebuchet MS</option>
                                                <option value="verdana">Verdana</option>
                                            </select>
                                            <input type="text" id="ct_fontColor">
                                            <button type="button" class="ct_btnDefault"><i class="fa fa-bold"></i></button>
                                            <button type="button" class="ct_btnDefault"><i class="fa fa-italic"></i></button>
                                            <button type="button" class="ct_btnDefault" style="color: #54BCD1;"><i class="fa fa-heart"></i></button>
                                        </div>
                                    </div>
                                    <form class="chat_messageForm">
                                        <textarea class="ct_textarea"></textarea>
                                        <button type="submit" class="ct_btnBlue">Submit</button>
                                        <div style="clear:both;"></div>
                                    </form>
                                    <div class="chat_footerCtr">
                                        <a class="chat_usersOnlineLink" href="#">12 User(s) Online</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php

include( 'inc/footer.inc.php' );

?>
<script src="assets/js/edit-chat.js"></script>