/**
 * Created by jaskokoyn on 2/20/2015.
 */
jQuery(function($){
    $(document).on( "submit", "#generalForm", function(e){
        e.preventDefault();

        $(this).slideUp('fast', function(){
            $("#generalStatus").html(
                '<div class="alert alert-info"><strong>Please wait!</strong> Your settings are being updated</div>'
            ).hide().slideDown('fast');

            var formData    =   {
                name:          $("#inputSiteName").val(),
                desc:           $("#inputSiteDesc").val(),
                header:            $("#inputHeaderAd").val(),
                footer:            $("#inputFooterAd").val(),
                sidebar:            $("#inputSidebarAd").val(),
                bad_words:          $("#inputBadWords").val()
            };

            $.post( "actions/update-gen-settings.php", formData, function(res){
                if(res == "SUCCESS"){
                    $("#generalStatus").html(
                        '<div class="alert alert-success"><strong>Success!</strong> Your settings were updated.</div>'
                    );
                }else{
                    $("#generalStatus").html(
                        '<div class="alert alert-danger"><strong>Error!</strong> Your settings could not be updated.</div>'
                    );
                }
                $("#generalForm").slideDown('fast');
            });
        });
    });

    $(document).on( "submit", "#userForm", function(e){
        e.preventDefault();

        $(this).slideUp('fast', function(){
            $("#userStatus").html(
                '<div class="alert alert-info"><strong>Please wait!</strong> Your settings are being updated</div>'
            ).hide().slideDown('fast');

            var formData    =   {
                regEnabled:          $("#regEnabled").val(),
                upload_size:            $("#inputMaxUploadSize").val(),
                files:          $("#allowFileUpload").val(),
                polls:            $("#allowPollCreation").val()
            };

            $.post( "actions/update-user-settings.php", formData, function(res){
                if(res == "SUCCESS"){
                    $("#userStatus").html(
                        '<div class="alert alert-success"><strong>Success!</strong> Your settings were updated.</div>'
                    );
                }else{
                    $("#userStatus").html(
                        '<div class="alert alert-danger"><strong>Error!</strong> Your settings could not be updated.</div>'
                    );
                }
                $("#userForm").slideDown('fast');
            });
        });
    });

    $(document).on( "submit", "#chatForm", function(e){
        e.preventDefault();

        $(this).slideUp('fast', function(){
            $("#chatStatus").html(
                '<div class="alert alert-info"><strong>Please wait!</strong> Your settings are being updated</div>'
            ).hide().slideDown('fast');

            var formData    =   {
                auto_clean_hours:             $("#inputACD").val(),
                room_creation:      $("#inputRoomCreation").val(),
                guest_chat:            $("#inputGuestChat").val(),
                font_family:            $("#inputFontFamily").val(),
                color:            $("#inputColor").val(),
                bold:            $("#inputBold").val(),
                italic:            $("#inputItalic").val(),
                emoticon:            $("#inputEmoticon").val(),
                images:            $("#inputImages").val(),
                url:            $("#inputURL").val(),
                yt:            $("#inputYoutube").val(),
                private_chat:            $("#inputPrivateChat").val()
            };

            $.post( "actions/update-chat-settings.php", formData, function(res){
                if(res == "SUCCESS"){
                    $("#chatStatus").html(
                        '<div class="alert alert-success"><strong>Success!</strong> Your settings were updated.</div>'
                    );
                }else{
                    $("#chatStatus").html(
                        '<div class="alert alert-danger"><strong>Error!</strong> Your settings could not be updated.</div>'
                    );
                }
                $("#chatForm").slideDown('fast');
            });
        });
    });

    $(document).on( "submit", "#uploadEmoteForm", function(e){
        e.preventDefault();

        $(this).slideUp('fast', function(){
            $("#uploadEmoteStatus").html(
                '<div class="alert alert-info"><strong>Please wait!</strong> Your settings are being updated</div>'
            ).hide().slideDown('fast');

            var formData    =   new FormData();
            formData.append( "name", $("#inputEmoteName").val() );
            formData.append( "cmd", $("#inputEmoteCmd").val() );
            formData.append( "img", $("#addEmoteImg").prop("files")[0]);

            $.ajax({
                url: 'actions/upload-emoticon.php',
                type: 'POST',
                data: formData,
                // THIS MUST BE DONE FOR FILE UPLOADING
                cache: false,
                contentType: false,
                processData: false
                // ... Other options like success and etc
            }).success(function(res){
                console.log(res);
                if(res == "SUCCESS"){
                    $("#uploadEmoteStatus").html(
                        '<div class="alert alert-success"><strong>Success!</strong> Your settings were updated.</div>'
                    );
                    location.reload();
                }else{
                    $("#uploadEmoteStatus").html(
                        '<div class="alert alert-danger"><strong>Error!</strong> Your settings could not be updated.</div>'
                    );
                    $("#uploadEmoteForm").slideDown('fast');
                }
            });
        });
    });

    $(document).on( "click", ".delEmoteBtn", function(e){
        e.preventDefault();
        if(confirm("Are you sure you to delete this emote?")){
            $.post("actions/delete-emote.php", { eid: $(this).data('eid') }, function(res){
                $(e.target).closest("tr").fadeOut('fast', function(){
                    $(this).remove();
                });
            });
        }
    });

    $(document).on( "click", ".editEmoteBtn", function(e){
        e.preventDefault();
        $("#inputEditEmoteID").val( $(this).data('eid') );
        $("#inputEditEmoteName").val( $(this).data('ename') );
        $("#inputEditEmoteCmd").val( $(this).data('ecmd') );
    });

    $(document).on( "submit", "#editEmoteForm", function(e){
        e.preventDefault();

        $(this).slideUp('fast', function(){
            $("#editEmoteStatus").html(
                '<div class="alert alert-info"><strong>Please wait!</strong> This emote is being updated.</div>'
            ).hide().slideDown('fast');

            var formData    =   {
                id:            $("#inputEditEmoteID").val(),
                name:          $("#inputEditEmoteName").val(),
                cmd:           $("#inputEditEmoteCmd").val()
            };

            $.post( "actions/update-emote.php", formData, function(res){
                console.log(res);
                if(res == "SUCCESS"){
                    $("#editEmoteStatus").html(
                        '<div class="alert alert-success"><strong>Success!</strong> This emote has been updated.</div>'
                    );
                    location.reload();
                }else{
                    $("#editEmoteStatus").html(
                        '<div class="alert alert-danger"><strong>Error!</strong> This emote could not be updated.</div>'
                    );
                    $("#editEmoteForm").slideDown('fast');
                }
            });
        });
    })
});