/**
 * Created by jaskokoyn on 2/16/2015.
 */
jQuery(function($){
    $("#ct_fontColor").spectrum({
        color: "#f00"
    });
    $("#inputHeaderBGColor").spectrum({
        color: "#54BCD1",
        clickoutFiresChange: true,
        move: function(color){
            $(".chat_headerCtr").css( 'backgroundColor', color.toHexString() );
        }
    });
    $("#inputHeaderFontColor").spectrum({
        color: "#fff",
        clickoutFiresChange: true,
        move: function(color){
            $(".chat_headerCtr").css( 'color', color.toHexString() );
        }
    });
    $("#inputFooterBGColor").spectrum({
        color: "#42B655",
        clickoutFiresChange: true,
        move: function(color){
            $(".chat_footerCtr").css( 'backgroundColor', color.toHexString() );
        }
    });
    $("#inputFooterFontColor").spectrum({
        color: "#fff",
        clickoutFiresChange: true,
        move: function(color){
            $(".chat_footerCtr").css( 'color', color.toHexString() );
        }
    });

    $(document).on( "input", "#inputChatName", function(e){
        e.preventDefault();
        $(".chatTitle").text( $(this).val() );
    });
    $(document).on( "input", "#inputChatDesc", function(e){
        e.preventDefault();
        $(".chatDesc").text( $(this).val() );
    });
    $(document).on( "change", "#checkShowAvatar", function(e){
        e.preventDefault();
        if($(this).prop("checked")){
            $(".chat_bodyCtr").removeClass("chat_noAvatar");
            $(".chat_msgWrapper").prepend(
                '<div class="chat_msgAvatar"><img src="http://placehold.it/150x150"></div>'
            );
        }else{
            $(".chat_bodyCtr").addClass("chat_noAvatar");
            $(".chat_msgAvatar").remove();
        }
    });

    $(document).on( "submit", "#createChatForm", function(e){
        e.preventDefault();

        $(this).slideUp('fast', function(){
            $("#createChatStatus").html(
                '<div class="alert alert-info"><strong>Please wait!</strong> Your chat is being created.</div>'
            ).hide().slideDown('fast');

            var formData    =   {
                title:          $("#inputChatName").val(),
                desc:           $("#inputChatDesc").val(),
                showAvatar:     $("#checkShowAvatar").prop("checked"),
                headerBG:       $("#inputHeaderBGColor").spectrum("get").toRgbString(),
                headerColor:    $("#inputHeaderFontColor").spectrum("get").toRgbString(),
                footerBG:       $("#inputFooterBGColor").spectrum("get").toRgbString(),
                footerColor:    $("#inputFooterFontColor").spectrum("get").toRgbString()
            };

            $.post( "actions/create.php", formData, function(res){
                if(res == "SUCCESS"){
                    $("#createChatStatus").html(
                        '<div class="alert alert-success"><strong>Success!</strong> Your chat was created.</div>'
                    );
                    location.href   =   "manage-chats.php";
                }else{
                    $("#createChatStatus").html(
                        '<div class="alert alert-danger"><strong>Error!</strong> Your chat could not be created.</div>'
                    );
                    $("#createChatForm").slideDown('fast');
                }
            });
        });
    });
});