<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 2/19/2015
 * Time: 6:18 PM
 */

require('../../inc/db.php');
include('../../inc/functions.php');

$params             =   getParams();
$output             =   array('status' => 1, 'isOwn' => false, 'isFriend' => false, 'isBlocked' => false);
$uid                =   isset($_SESSION['loggedin']) ? $_SESSION['uid'] : 0;

if(isset($params['username'])){
    $username       =   secure($params['username']);
    $getUserQuery   =   $db->prepare("SELECT `id`,`username`,`location`,`age`,`gender`,`about`,`profile_img`,`header_img`,`profile_status`
                                      FROM users
                                      WHERE username = :username");
    $getUserQuery->execute(array(
        ":username" =>  $username
    ));

}else{
    $getUserQuery   =   $db->prepare("SELECT `id`,`username`,`location`,`age`,`gender`,`about`,`profile_img`,`header_img`,`profile_status`
                                      FROM users
                                      WHERE id = :uid");
    $getUserQuery->execute(array(
        ":uid"  =>  $_SESSION['uid']
    ));
}

if($getUserQuery->rowCount() === 0){
    dj($output);
}

$getUserRow         =   $getUserQuery->fetch(PDO::FETCH_ASSOC);

if(isset($_SESSION['loggedin']) && $getUserRow['username'] == $_SESSION['username']){
    $output['isOwn']    =   true;
}

$friendsQuery       =   $db->prepare("SELECT * FROM friends WHERE uid = :uid AND fid = :fid");
$friendsQuery->execute(array(
    ":uid"          =>  $uid,
    ":fid"          =>  $getUserRow['id']
));

if($friendsQuery->rowCount() === 1){
    $output['isFriend'] =   true;
}

$blockedQuery       =   $db->prepare("SELECT * FROM blocked_users WHERE uid = :uid AND bid = :bid");
$blockedQuery->execute(array(
    ":uid"          =>  $uid,
    ":bid"          =>  $getUserRow['id']
));

if($blockedQuery->rowCount() === 1){
    $output['isBlocked'] =   true;
}

$getUserRow['age']  =   intval($getUserRow['age']);
$output['u']        =   $getUserRow;
$output['status']   =   2;
dj($output);