<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 4/26/2015
 * Time: 2:07 PM
 */

require('../../inc/db.php');
include('../../inc/functions.php');

$params                         =   getParams();
$output                         =   array('status' => 1);

if( !isReady( $params, array("pid", "cid") ) ){
    dj($output);
}

$cid                            =   intval($params['cid']);
$pid                            =   intval($params['pid']);
$profile_img                    =   (isset($_SESSION['loggedin'])) ? $user['profile_img'] : "default.png";

// Chat Query
if($user['mem_level'] != 2 && $user['mem_level'] != 3){
    if($settings['create_polls'] == 2){
        dj($output);
    }

    $chatQuery                  =   $db->prepare("SELECT `polls_enabled` FROM chats WHERE id = :cid");
    $chatQuery->execute(array(":cid" => $cid));
    $chatRow                    =   $chatQuery->fetch();

    if($chatRow['polls_enabled'] == 2){
        dj($output);
    }
}

$pollsQuery                     =   $db->prepare("SELECT * FROM polls WHERE id = :id AND uid = :uid");
$pollsQuery->execute(array(
    ":id"                       =>  $pid,
    ":uid"                      =>  $_SESSION['uid']
));

if($pollsQuery->rowCount() === 0){
    dj($output);
}

$pollsRow                       =   $pollsQuery->fetch();

// Process Formatting
$font                           =   "font-family: 'Noto Sans';";
$size                           =   "font-size: 12px;";
$messageCtr                     =   '<span style="' . $font . $size  . '">';
$messageCtr                     .=  '<button type="button" class="btn btn-sm btn-pink btnOpenPoll" data-toggle="modal" data-target="#pollModal" data-pid="' . $pid . '"><i class="fa fa-bolt"></i> Vote in poll</button>';
$messageCtr                     .=   '</span>';

// Insert Into DB
$insertMessageQuery             =   $db->prepare("INSERT INTO messages(message,m_type,submitted_by,time_submitted,cid,profile_img)
                                                  VALUES( :m, :t, :u, :s, :cid, :pi )");
$insertMessageQuery->execute(array(
    ":m"                        =>  $messageCtr,
    ":t"                        =>  1,
    ":u"                        =>  $_SESSION['username'],
    ":s"                        =>  time(),
    ":cid"                      =>  $cid,
    ":pi"                       =>  $profile_img
));

$output['status']               =   2;
dj($output);