<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 2/19/2015
 * Time: 1:44 PM
 */

require('../../inc/db.php');
include('../../inc/functions.php');
include('../../inc/JBBCode/Parser.php');
include('../../inc/YoutubeEmbed.php');

$params                         =   getParams();
$output                         =   array('status' => 1);

if( !isReady( $params["opts"], array("fontFamily", "color", "message") ) || $user['mem_level'] == 4 || !isset($_SESSION['loggedin'])){
    dj($output);
}

if($settings['private_chat'] == 2){
    dj($output);
}

$profile_img                    =   (isset($_SESSION['loggedin'])) ? $user['profile_img'] : "default.png";
$recipient                      =   secure($params['username']);
$recipientQuery                 =   $db->prepare("SELECT `id` FROM users WHERE username = :username");
$recipientQuery->execute(array(":username" => $recipient));
$recipientRow                   =   $recipientQuery->fetch(PDO::FETCH_ASSOC);
$parser                         =   new JBBCode\Parser();
$message                        =   substr(secure($params['opts']['message']),0,500);

// Check if blocked
$checkBlockQuery                =   $db->prepare("SELECT * FROM blocked_users WHERE uid = :uid AND bid = :bid");
$checkBlockQuery->execute(array(
    ":uid"                      =>  $recipientRow['id'],
    ":bid"                      =>  $_SESSION['uid']
));
if($checkBlockQuery->rowCount() !== 0){
    dj($output);
}

// Process Emotes
$emotesQuery                    =   $db->prepare("SELECT `img`,`e_cmd` FROM emotes");
$emotesQuery->execute();
while($emotesRow                =   $emotesQuery->fetch()){
    $message                    =   str_replace( $emotesRow['e_cmd'], '<img src="assets/emotes/' . $emotesRow['img'] . '" width="18" height="18">', $message);
}

// Process BBCodes
if($settings['images_btn'] != 2){
    $img_html                   =   '<img src="{param}" class="img-responsive">';
    $img_builder                = new JBBCode\CodeDefinitionBuilder('img', $img_html);
    $parser->addCodeDefinition($img_builder->build());
}
if($settings['url_btn'] != 2){
    $link_builder               = new JBBCode\CodeDefinitionBuilder('url', '<a href="{param}" target="_blank">{param}</a>');
    $parser->addCodeDefinition($link_builder->build());
}
if($settings['youtube_btn'] != 2 ){
    $youtubeEmbed               = new YoutubeEmbed();
    $parser->addCodeDefinition($youtubeEmbed);
}

$parser->parse($message);
$parsed_message                 =   $parser->getAsHtml();

// Process Bad Words
$badWords                       =   explode(",", $settings['bad_words']);
$parsed_message                 =   str_replace( $badWords, '<span class="label inverse">****</span>', $parsed_message);

// Process Formatting
$font                           =   in_array($params['opts']['fontFamily'], $fontFamilyArr) ? "font-family: '" . secure($params['opts']['fontFamily']) . "';": "font-samily: 'Noto Sans';";
$size                           =   intval($params['opts']['fontSize']);
$size                           =   $size > 20 || $size < 10 ? "font-size: 12px;" : "font-size: " . $size . "px;";
$color                          =   checkHex($params['opts']['color']) ? "color: " . secure($params['opts']['color']) . ";" : "color: #33;";
$bold                           =   $params['opts']['bold'] ? "font-weight: bold;" : "";
$italic                         =   $params['opts']['italic'] ? "font-style: italic;" : "";
$messageCtr                     =   '<span style="' . $font . $size . $color . $bold . $italic . '">';
$messageCtr                    .=   $parsed_message . '</span>';

// Insert Into DB
$insertMessageQuery =   $db->prepare("INSERT INTO messages(message,m_type,submitted_by,time_submitted,recipient,profile_img)
                                      VALUES( :m, :t, :u, :s, :r, :pi )");
$insertMessageQuery->execute(array(
    ":m"    =>  $messageCtr,
    ":t"    =>  2,
    ":u"    =>  $_SESSION['username'],
    ":s"    =>  time(),
    ":r"    =>  $recipient,
    ":pi"   =>  $profile_img
));

$output['status']               =   2;
dj($output);