<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 4/25/2015
 * Time: 9:48 PM
 */

require('../../inc/db.php');
include('../../inc/functions.php');

$params                         =   getParams();
$output                         =   array('status' => 1);

if( !isReady( $params, array("fid") ) ){
    dj($output);
}

$cid                            =   intval($params['cid']);
$fid                            =   intval($params['fid']);
$profile_img                    =   (isset($_SESSION['loggedin'])) ? $user['profile_img'] : "default.png";

// Chat Query
if($user['mem_level'] != 2 && $user['mem_level'] != 3){
    if($settings['file_uploads'] == 2){
        dj($output);
    }

    $chatQuery                  =   $db->prepare("SELECT `files_enabled` FROM chats WHERE id = :cid");
    $chatQuery->execute(array(":cid" => $cid));
    $chatRow                    =   $chatQuery->fetch();

    if($chatRow['files_enabled'] == 2){
        dj($output);
    }
}

$fileQuery                      =   $db->prepare("SELECT * FROM user_files WHERE id = :id AND uid = :uid");
$fileQuery->execute(array(
    ":id"                       =>  $fid,
    ":uid"                      =>  $_SESSION['uid']
));

if($fileQuery->rowCount() === 0){
    dj($output);
}

$fileRow                        =   $fileQuery->fetch();

// Process Formatting
$font                           =   "font-family: 'Noto Sans';";
$size                           =   "font-size: 12px;";
$messageCtr                     =   '<span style="' . $font . $size  . '">';
$fid                            =   "'download.php?id=" . $fid . "'";
$messageCtr                     .=  '<button type="button" onclick="location.href =' . $fid . '" class="btn btn-sm btn-success"><i class="fa fa-download"></i> Download File - ' . $fileRow['original_file_name'] . '</button>';
$messageCtr                     .=   '</span>';

if(isset($params['username']) && !empty($params['username'])){
    // Insert Into DB
    $insertMessageQuery =   $db->prepare("INSERT INTO messages(message,m_type,submitted_by,time_submitted,recipient,profile_img)
                                      VALUES( :m, :t, :u, :s, :r, :pi )");
    $insertMessageQuery->execute(array(
        ":m"    =>  $messageCtr,
        ":t"    =>  2,
        ":u"    =>  $_SESSION['username'],
        ":s"    =>  time(),
        ":r"    =>  secure($params['username']),
        ":pi"   =>  $profile_img
    ));
}else{
    // Insert Into DB
    $insertMessageQuery             =   $db->prepare("INSERT INTO messages(message,m_type,submitted_by,time_submitted,cid,profile_img)
                                                  VALUES( :m, :t, :u, :s, :cid, :pi )");
    $insertMessageQuery->execute(array(
        ":m"                        =>  $messageCtr,
        ":t"                        =>  1,
        ":u"                        =>  $_SESSION['username'],
        ":s"                        =>  time(),
        ":cid"                      =>  $cid,
        ":pi"                       =>  $profile_img
    ));
}



$output['status']               =   2;
dj($output);