<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 2/17/2015
 * Time: 11:48 PM
 */

require('../../inc/db.php');
include('../../inc/functions.php');

$params                     =   getParams();
$output                     =   array('status' => 1);

if( !isReady( $params, array( 'cid' ) ) ){
    dj($output);
}

$uid                        =   (isset($_SESSION['uid'])) ? $_SESSION['uid'] : 0;
$username                   =   (isset($_SESSION['username'])) ? $_SESSION['username'] : "";
$cid                        =   intval($params['cid']);
$timeOnline                 =   time() - 300;
$canDelete                  =   false;

// Get Chat Settings
$chatQuery                  =   $db->prepare("SELECT * FROM chats WHERE id = :cid");
$chatQuery->execute(array(
    ":cid"                  =>  $cid
));

// Check if chat exists
if($chatQuery->rowCount() === 0){
    dj($output);
}

$chatRow                    =   $chatQuery->fetch(PDO::FETCH_ASSOC);

// Get Chat Messages
$messagesQuery              =   $db->prepare("SELECT * FROM messages WHERE cid = :cid ORDER BY `id` DESC LIMIT 50");
$messagesQuery->execute(array(
    ":cid"                  =>  $cid
));
$messagesRow                =   $messagesQuery->fetchAll(PDO::FETCH_ASSOC);

// Check if chat mod
$checkModQuery                  =   $db->prepare("SELECT * FROM chat_mods WHERE username = :u AND cid = :cid");
$checkModQuery->execute(array(
    ":u"                        =>  $_SESSION['username'],
    ":cid"                      =>  $cid
));

// Check if can delete
if(isset($_SESSION['loggedin']) && (
        $user['mem_level'] == 2 || $user['mem_level'] == 3 ||
        $chatRow['owner'] == $_SESSION['username'] || $checkModQuery->rowCount() > 0
    )){
    $canDelete              =   true;
}

// Check if insert is live then Insert User Online
$checkOnlineUserQuery   =   $db->prepare("SELECT * FROM users_online WHERE uid = :uid AND time_online > :t AND cid = :cid");
$checkOnlineUserQuery->execute(array(
    ":uid"  =>  $uid,
    ":t"    =>  $timeOnline,
    ":cid"  =>  $cid
));
if($checkOnlineUserQuery->rowCount() == 0 && isset($_SESSION['loggedin'])){
    $insertOnlineUserQuery  =   $db->prepare("INSERT INTO users_online(uid,username,cid,time_online,profile_img)
                                          VALUES( :uid, :username, :cid, :t, :pi)");
    $insertOnlineUserQuery->execute(array(
        ":uid"      =>  $uid,
        ":username" =>  $username,
        ":cid"      =>  $cid,
        ":t"        =>  time(),
        ":pi"       =>  $user['profile_img']
    ));
}

// Get Users Online
$usersOnlineQuery       =   $db->prepare("SELECT * FROM users_online
                                          WHERE cid = :cid AND time_online > :t
                                          ORDER BY `username`");
$usersOnlineQuery->execute(array(
    ":cid"  =>  $cid,
    ":t"    =>  $timeOnline
));
$usersOnlineRow         =   $usersOnlineQuery->fetchAll();

$output['status']           =   2;
$output['settings']         =   $chatRow;
$output['messages']         =   array_reverse($messagesRow);
$output['mid']              =   end($output['messages']);
$output['usersOnline']      =   $usersOnlineRow;
$output['canDelete']        =   $canDelete;
dj($output);


// OLD CHAT
// Get PMs
$getPMQuery =   $db->prepare("SELECT *, COUNT(*) as `total` FROM messages
                              WHERE m_type = :t AND recipient = :r AND isRead = :ir GROUP BY `submitted_by`");
$getPMQuery->execute(array(
    ":t"    =>  2,
    ":r"    =>  $_SESSION['username'],
    ":ir"   =>  1
));
$getPMRow   =   $getPMQuery->fetchAll();

$response['uo']         =   $usersOnlineRow;
$response['pmUsers']    =   $getPMRow;


die(json_encode($response));