<?php
/**
 * Created by PhpStorm.
 * User: jaskokoyn
 * Date: 2/18/2015
 * Time: 1:36 PM
 */

require('../../inc/db.php');
include('../../inc/functions.php');

$params                     =   getParams();
$output                     =   array('status' => 1);

if( !isReady( $params, array( "cid" ) ) ){
    dj($output);
}

$cid                        =   intval($params['cid']);
$mid                        =   intval($params['mid']);

$messagesQuery              =   $db->prepare("SELECT * FROM messages WHERE cid = :cid
                                              AND id > :mid ORDER BY `id` DESC LIMIT 50");
$messagesQuery->execute(array(
    ":cid"                  =>  $cid,
    ":mid"                  =>  $mid
));

if($messagesQuery->rowCount() > 0){
    $output['status']           =   2; // SUCCESS
}

// Get PMs
$getPMQuery =   $db->prepare("SELECT *, COUNT(*) as `total` FROM messages
                              WHERE m_type = :t AND recipient = :r AND isRead = :ir GROUP BY `submitted_by`");
$getPMQuery->execute(array(
    ":t"    =>  2,
    ":r"    =>  $_SESSION['username'],
    ":ir"   =>  1
));
$getPMRow   =   $getPMQuery->fetchAll(PDO::FETCH_ASSOC);

$messagesRow                =   $messagesQuery->fetchAll();
$output['messages']         =   array_reverse($messagesRow);
$output['mid']              =   end($output['messages']);
$output['pms']              =   $getPMRow;
dj($output);