<?php
	$_wp_column_headers['toplevel_page_otw-pm'] = array(
	'title' => __( 'Title', 'otw-portfolio-manager' ),
	'order' => __( 'Order', 'otw-portfolio-manager' )
);
	
	$message = '';
	$massages = array();
	$messages[1] = __( 'Detail saved.', 'otw-portfolio-manager' );
	$messages[2] = __( 'Detail deleted.', 'otw-portfolio-manager' );
	
	if( isset( $_GET['message'] ) && isset( $messages[ $_GET['message'] ] ) ){
		$message .= $messages[ $_GET['message'] ];
	}
	
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo $message; ?></p></div>
<?php
 endif; ?>
<div class="wrap">
	<div id="icon-options-general" class="icon32"></div>
	<h2><?php _e('Portfolio Items Details', 'otw-portfolio-manager'); ?>
		<a class="button add-new-h2" href="admin.php?page=otw-pm-details-add"><?php _e('Add New', 'otw-portfolio-manager') ?></a>
	</h2>
	<div id="icon-options-general" class="icon32"></div>
	<p class="description"><?php _e('The following details will be available for each of your portfolio items.', 'otw-portfolio-manager'); ?></p>
	<?php if( is_array( $details ) && count( $details ) ){?>
		<table class="widefat fixed" cellspacing="0">
			<thead>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-pm'] as $key => $name ){?>
						<th><?php echo $name?></th>
					<?php }?>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-pm'] as $key => $name ){?>
						<th><?php echo $name?></th>
					<?php }?>
				</tr>
			</tfoot>
			<tbody>
				<?php foreach( $details as $d_key => $d_item ){?>
					<tr>
						<?php foreach( $_wp_column_headers['toplevel_page_otw-pm'] as $column_name => $column_title ){
							
							$edit_link = admin_url( 'admin.php?page=otw-pm-details-edit&amp;detail='.$d_item['id'] );
							$delete_link = admin_url( 'admin.php?page=otw-pm-details-action&amp;detail='.$d_item['id'].'&amp;action=delete' );
							
							switch($column_name) {
								
								case 'title':
										echo '<td><strong><a href="'.$edit_link.'" title="'.esc_attr(sprintf(__('Edit &#8220;%s&#8221;', 'otw-portfolio-manager'), $d_item['title'])).'">'.$d_item['title'].'</a></strong><br />';
										echo '<div class="row-actions">';
											echo '<a href="'.$edit_link.'">' . __('Edit', 'otw-portfolio-manager') . '</a>';
											echo ' | <a href="'.$delete_link.'">' . __('Delete', 'otw-portfolio-manager'). '</a>';
											echo '</div>';
										echo '</td>';
									break;
								case 'order':
										echo '<td>'.$d_item['order'].'</td>';
									break;
							}?>
						<?php }?>
					</tr>
				<?php }?>
			</tbody>
		</table>
	<?php }else{?>
		<p><?php _e('No details available.', 'otw-portfolio-manager')?></p>
	<?php }?>
</div>