<!-- Portfolio Media -->
<?php
 
	$imgLink = $this->getLink( $post, 'media' );
	$permaLink = get_permalink( $post->ID );
	$itemMediaLink = $this->getListLink( $this->listOptions, $post, 'list_media' );
	
	if( !isset( $this->imageWidth ) || !strlen( $this->imageWidth ) ) { $this->imageWidth = 250; }
	if( !isset( $this->imageHeight ) || !strlen( $this->imageHeight ) ) { $this->imageHeight = 150; }
	
	$imageLightboxWidth = $this->lightboxImageWidth;
	$imageLightboxHeight = $this->lightboxImageHeight;
	$imageLightboxFormat = $this->lightboxImageFormat;
	
	
	$imageHover = $this->listOptions['image_hover'];
	
	$format = 'image';
	
	$icon = 'icon-camera';
	
	if( !isset( $postMetaData['media_type'] ) ){
		$postMetaData['media_type'] = '';
	}
	
	switch( $postMetaData['media_type'] ){
		case 'slider':
				$format = 'gallery';
			break;
	}
	
	$hoverMediaTypes = array( 'img', 'youtube', 'vimeo', 'soundcloud' );
	
	if( isset( $postMetaData['_otw_slider_image'] ) && $postMetaData['_otw_slider_image'] ){
		$hoverMediaTypes[] = 'slider';
		$format = 'image';
	}
	
?>
<figure class="otw_portfolio_manager-portfolio-media otw_portfolio_manager-format-<?php echo $format?>">
	<?php
	switch( $postMetaData['media_type'] ){
		
		case 'slider':
				$icon = 'icon-picture';
				$sliderImages = explode(',', $postMetaData['slider_url']);
				?>
				<?php if( isset( $postMetaData['_otw_slider_image'] ) && $postMetaData['_otw_slider_image'] ){?>
					<?php $imagePath = parse_url( $sliderImages[0] );?>
					<?php $attachmentMetaData = $this->getAttachmentMetaData( $sliderImages[0], $this->listOptions );?>
					<?php if( isset( $sliderImages[0] ) ){?>
						<?php if( isset( $this->listOptions['image_link'] ) && in_array( $this->listOptions['image_link'], array( 'lightbox' ) ) ){?>
							<?php $first_shown = false; ?>
							<?php foreach( $sliderImages as $sImage ){?>
								<?php $imagePath = parse_url( $sImage );?>
								<a href="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $imageLightboxWidth, $imageLightboxHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $imageLightboxFormat )?>" rel="otw_fslide_<?php echo $post->ID?>" title="<?php echo htmlentities( $post->post_title );?>" class="otw_in_slider otw_in_slider_<?php echo intval( $first_shown )?>" >
									<?php if( !$first_shown ){?>
										<img src="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $this->imageWidth, $this->imageHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $this->imageFormat )?>"  alt="<?php echo $attachmentMetaData['alt']?>"  title="<?php echo $attachmentMetaData['title']?>" />
									<?php } ?>
								</a>
								<?php $first_shown = true;?>
							<?php }?>
						<?php }elseif( isset( $this->listOptions['image_link'] ) && in_array( $this->listOptions['image_link'], array( 'single' ) ) ){?>
							<a href="<?php echo $permaLink?>">
								<img src="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $this->imageWidth, $this->imageHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $this->imageFormat )?>" alt="<?php echo $attachmentMetaData['alt']?>"  title="<?php echo $attachmentMetaData['title']?>" />
							</a>
						<?php }else{ ?>
							<img src="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $this->imageWidth, $this->imageHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $this->imageFormat )?>"  alt="<?php echo $attachmentMetaData['alt']?>"  title="<?php echo $attachmentMetaData['title']?>" />
						<?php }?>
					<?php }?>
				<?php }else{?>
					<div class="otw_portfolio_manager-slider" data-animation="slide">
						<ul class="slides otw_portfolio_ul_slider">
							<?php foreach( $sliderImages as $sliderImage ){?>
								<?php $attachmentMetaData = $this->getAttachmentMetaData( $sliderImage, $this->listOptions );?>
								<li>
								<?php
									$imagePath = parse_url($sliderImage);
									$sliderImgLink = false;
								?>
								<?php if( isset( $this->listOptions['image_link'] ) && in_array( $this->listOptions['image_link'], array( 'lightbox' ) ) ){ $sliderImgLink = true;?>
									<a href="<?php echo $sliderImage?>" rel="otw_fslide_<?php echo $post->ID?>" class="otw_portfolio_manager-fancybox-slider" title="<?php echo htmlentities( $post->post_title );?>">
								<?php }?>
								<?php if( isset( $this->listOptions['image_link'] ) && in_array( $this->listOptions['image_link'], array( 'single' ) ) ){ $sliderImgLink = true;?>
									<a href="<?php echo $imgLink?>" title="<?php echo $post->post_title;?>">
								<?php }?>
								<img src="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $this->imageWidth, $this->imageHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $this->imageFormat )?>"  alt="<?php echo $attachmentMetaData['alt']?>"  title="<?php echo $attachmentMetaData['title']?>" data-item="media">
								<?php if( $sliderImgLink ){?>
									</a>
								<?php }?>
								</li>
							<?php }?>
							</ul>
						</div>
					<?php }?>
					
				<?php
			break;
		case 'youtube':?>
				<?php if( isset( $this->listOptions['image_link'] ) && in_array( $this->listOptions['image_link'], array( 'lightbox' ) ) ){?>
					<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager_video_link otw_portfolio_manager-fancybox-movie-wrap" title="<?php echo htmlentities( $post->post_title );?>"></a>
				<?php }elseif( isset( $this->listOptions['image_link'] ) && in_array( $this->listOptions['image_link'], array( 'single' ) ) ){?>
					<a href="<?php echo $imgLink?>" class="otw_portfolio_manager_video_link"></a>
				<?php }elseif( $imageHover != 'hover-none' ){?>
					<a href="javascript:;" class="otw_portfolio_manager_video_link"></a>
				<?php }?>
				<?php echo $this->otwImageCrop->embed_resize( $this->oembed_get($postMetaData['youtube_url'], array('width' => $this->imageWidth)), $this->imageWidth, $this->imageHeight, $this->imageCrop );
				$icon = 'icon-facetime-video';
			break;
		case 'vimeo':?>
		
		
				<?php if( isset( $this->listOptions['image_link'] ) && in_array( $this->listOptions['image_link'], array( 'lightbox' ) ) ){?>
					<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager_video_link otw_portfolio_manager-fancybox-movie-wrap" title="<?php echo htmlentities( $post->post_title );?>"></a>
				<?php }elseif( isset( $this->listOptions['image_link'] ) && in_array( $this->listOptions['image_link'], array( 'single' ) ) ){?>
					<a href="<?php echo $imgLink?>" class="otw_portfolio_manager_video_link"></a>
				<?php }elseif( $imageHover != 'hover-none' ){?>
					<a href="javascript:;" class="otw_portfolio_manager_video_link"></a>
				<?php }?>
				<?php echo $this->otwImageCrop->embed_resize( $this->oembed_get($postMetaData['vimeo_url'], array('width' => $this->imageWidth)), $this->imageWidth, $this->imageHeight, $this->imageCrop );
				$icon = 'icon-facetime-video';
			break;
		case 'soundcloud':?>
				<?php if( isset( $this->listOptions['image_link'] ) && in_array( $this->listOptions['image_link'], array( 'lightbox' ) ) ){?>
					<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager_video_link otw_portfolio_manager-fancybox-movie-wrap" title="<?php echo htmlentities( $post->post_title );?>"></a>
				<?php }elseif( isset( $this->listOptions['image_link'] ) && in_array( $this->listOptions['image_link'], array( 'single' ) ) ){?>
					<a href="<?php echo $imgLink?>" class="otw_portfolio_manager_video_link"></a>
				<?php }elseif( $imageHover != 'hover-none' ){?>
					<a href="javascript:;" class="otw_portfolio_manager_video_link"></a>
				<?php } ?>
				<?php echo $this->otwImageCrop->embed_resize( $this->oembed_get($postMetaData['soundcloud_url'], array('width' => $this->imageWidth, 'height' => $this->imageHeight )), $this->imageWidth, $this->imageHeight, $this->imageCrop );
				
				$icon = 'icon-music';
			break;
		case 'img':
				$imagePath = parse_url($postMetaData['img_url']);
				
				$attachmentMetaData = $this->getAttachmentMetaData( $postMetaData['img_url'], $this->listOptions );
				
				if( !empty($imgLink) ){
					?>
						<a href="<?php echo $imgLink?>" title="<?php echo htmlentities( $post->post_title );?>">
							<img src="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $this->imageWidth, $this->imageHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $this->imageFormat )?>" alt="<?php echo $attachmentMetaData['alt']?>"  title="<?php echo $attachmentMetaData['title']?>" />
						</a>
					<?php
				}elseif( $imageHover != 'hover-none' ){
					?>
						<a href="javascript:;">
							<img src="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $this->imageWidth, $this->imageHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $this->imageFormat )?>"  alt="<?php echo $attachmentMetaData['alt']?>"  title="<?php echo $attachmentMetaData['title']?>" />
						</a>
					<?php
				}else{
					?>
					<img src="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $this->imageWidth, $this->imageHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $this->imageFormat )?>"  alt="<?php echo $attachmentMetaData['alt']?>"  title="<?php echo $attachmentMetaData['title']?>" />
					<?php
				}
			break;
	}
	?>
	<?php if( in_array( $postMetaData['media_type'], $hoverMediaTypes ) ){?>
		<?php switch( $imageHover ){
			
			case 'otw_portfolio_manager-hover-effect-1':
			case 'otw_portfolio_manager-hover-effect-2':?>
					<div class="otw_portfolio_manager-portfolio-overlay">
						<div class="otw_portfolio_manager-valign-middle">
							<!-- Portfolio Icons -->
							<div class="otw_portfolio_manager-portfolio-icon-wrapper">
								<a href="<?php echo $permaLink?>" class="icon-link"></a>
								<?php switch( $postMetaData['media_type'] ){
									case 'img':?>
										<a href="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $imageLightboxWidth, $imageLightboxHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $imageLightboxFormat )?>" class="otw_portfolio_manager-fancybox-img icon-search" title="<?php echo $post->post_title;?>"></a>
									<?php break;
									case 'slider':?>
										<?php $first_shown = false; ?>
										<?php foreach( $sliderImages as $sImage ){?>
											<?php $imagePath = parse_url( $sImage );?>
											<a href="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $imageLightboxWidth, $imageLightboxHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $imageLightboxFormat )?>" rel="otw_fslide_<?php echo $post->ID?>" title="<?php echo htmlentities( $post->post_title );?>" class="<?php echo ( ( !$first_shown ) ? 'icon-search ':'' )?>otw_in_slider otw_in_slider_<?php echo intval( $first_shown )?>" ></a>
											<?php $first_shown = true;?>
										<?php }?>
									<?php break;
									case 'youtube':?>
										<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager-fancybox-movie-wrap icon-search" title="<?php echo $post->post_title;?>"></a>
									<?php break;
									case 'vimeo':?>
										<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager-fancybox-movie-wrap icon-search" title="<?php echo $post->post_title;?>"></a>
									<?php break;
									case 'soundcloud':?>
										<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager-fancybox-movie-wrap icon-search" title="<?php echo $post->post_title;?>"></a>
									<?php break;
								}?>
							</div>
							<!-- End Portfolio Icons -->
							<!-- Portfolio Title & Info -->
							<div class="otw_portfolio_manager-portfolio-text">
								<h3 class="otw_portfolio_manager-portfolio-title"><?php echo $post->post_title;?></h3>
								<?php $catArray = wp_get_post_terms( $post->ID, $this->portfolio_category );?>
								<?php if( is_array( $catArray ) && count( $catArray ) ) {?>
									<div class="otw_portfolio_manager-portfolio-meta-item">
									<?php foreach( $catArray as $index => $cat ){ ?>
										<?php
											$category = get_term($cat, $this->portfolio_category);
											$catUrl = get_term_link( $category, $this->portfolio_category );
										?>
										<a href="<?php echo esc_url($catUrl);?>" rel="category" title="<?php _e('View all posts in ', 'otw-portfolio-manager'); echo $category->name;?>">
										<?php echo $category->name;?>
										</a>
										<?php if( $index < count( $catArray ) - 1 ) { echo ', '; }?>
									<?php }?>
									</div>
								<?php }?>
							</div>
							<!-- End Portfolio Title & Info -->
						</div>
					</div>
			<?php break;
			case 'otw_portfolio_manager-hover-effect-3':
			case 'otw_portfolio_manager-hover-effect-7':
			case 'otw_portfolio_manager-hover-effect-8':
			case 'otw_portfolio_manager-hover-effect-9':
			case 'otw_portfolio_manager-hover-effect-10':?>
					<div class="otw_portfolio_manager-portfolio-overlay">
						<div class="otw_portfolio_manager-valign-middle">
							<!-- Portfolio Icons -->
							<div class="otw_portfolio_manager-portfolio-icon-wrapper">
								<?php switch( $postMetaData['media_type'] ){
									case 'img':?>
										<a href="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $imageLightboxWidth, $imageLightboxHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $imageLightboxFormat )?>" class="otw_portfolio_manager-fancybox-img otw-bigplus" title="<?php echo $post->post_title;?>"></a>
									<?php break;
									case 'slider':?>
										<?php $first_shown = false; ?>
										<?php foreach( $sliderImages as $sImage ){?>
											<?php $imagePath = parse_url( $sImage );?>
											<a href="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $imageLightboxWidth, $imageLightboxHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $imageLightboxFormat )?>" rel="otw_fslide_<?php echo $post->ID?>" title="<?php echo htmlentities( $post->post_title );?>" class="<?php echo ( ( !$first_shown ) ? 'otw-bigplus ':'' )?>otw_in_slider otw_in_slider_<?php echo intval( $first_shown )?>" ></a>
											<?php $first_shown = true;?>
										<?php }?>
									<?php break;
									case 'youtube':?>
										<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw-bigplus otw_portfolio_manager-fancybox-movie-wrap" title="<?php echo $post->post_title;?>"></a>
									<?php break;
									case 'vimeo':?>
										<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw-bigplus otw_portfolio_manager-fancybox-movie-wrap" title="<?php echo $post->post_title;?>"></a>
									<?php break;
									case 'soundcloud':?>
										<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw-bigplus otw_portfolio_manager-fancybox-movie-wrap" title="<?php echo $post->post_title;?>"></a>
									<?php break;
								}?>
							</div>
						</div>
					</div>
			<?php break;
			case 'otw_portfolio_manager-hover-effect-4':
			case 'otw_portfolio_manager-hover-effect-6': ?>
					<div class="otw_portfolio_manager-portfolio-overlay">
						<div class="otw_portfolio_manager-valign-middle">
							<!-- Portfolio Icons -->
							<div class="otw_portfolio_manager-portfolio-icon-wrapper">
								<a href="<?php echo $permaLink?>" class="icon-link"></a>
								<?php switch( $postMetaData['media_type'] ){
									case 'img':?>
										<a href="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $imageLightboxWidth, $imageLightboxHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $imageLightboxFormat )?>" class="otw_portfolio_manager-fancybox-img icon-search" title="<?php echo $post->post_title;?>"></a>
									<?php break;
									case 'slider':?>
										<?php $first_shown = false; ?>
										<?php foreach( $sliderImages as $sImage ){?>
											<?php $imagePath = parse_url( $sImage );?>
											<a href="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $imageLightboxWidth, $imageLightboxHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $imageLightboxFormat )?>" rel="otw_fslide_<?php echo $post->ID?>" title="<?php echo htmlentities( $post->post_title );?>" class="<?php echo ( ( !$first_shown ) ? 'icon-search ':'' )?>otw_in_slider otw_in_slider_<?php echo intval( $first_shown )?>" ></a>
											<?php $first_shown = true;?>
										<?php }?>
									<?php break;
									case 'youtube':?>
										<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager-fancybox-movie-wrap icon-search" title="<?php echo $post->post_title;?>"></a>
									<?php break;
									case 'vimeo':?>
										<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager-fancybox-movie-wrap icon-search" title="<?php echo $post->post_title;?>"></a>
									<?php break;
									case 'soundcloud':?>
										<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager-fancybox-movie-wrap icon-search" title="<?php echo $post->post_title;?>"></a>
									<?php break;
								}?>
							</div>
							<!-- End Portfolio Icons -->
						</div>
					</div>
			<?php break;
			case 'otw_portfolio_manager-hover-effect-17':?>
						
					<!-- Portfolio Overlay -->
					<div class="otw_portfolio_manager-portfolio-overlay">
						<!-- Portfolio Title -->
						<div class="otw_portfolio_manager-portfolio-title-wrapper">
							<h3 class="otw_portfolio_manager-portfolio-title">
							<?php if( isset( $this->listOptions['title_link'] ) && in_array( $this->listOptions['title_link'], array( 'lightbox' ) ) ){?>
								<?php switch( $postMetaData['media_type'] ){
									case 'img':?>
										<a href="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $imageLightboxWidth, $imageLightboxHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $imageLightboxFormat )?>" class="otw_portfolio_manager-fancybox-img" title="<?php echo $post->post_title;?>"><?php echo $post->post_title;?></a>
									<?php break;
									case 'slider':?>
										<?php $first_shown = false; ?>
										<?php foreach( $sliderImages as $sImage ){?>
											<?php $imagePath = parse_url( $sImage );?>
											<a href="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $imageLightboxWidth, $imageLightboxHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $imageLightboxFormat )?>" rel="otw_fslide_<?php echo $post->ID?>" title="<?php echo htmlentities( $post->post_title );?>" class="otw_in_slider otw_in_slider_<?php echo intval( $first_shown )?>" >
											<?php if( !$first_shown ){?>
												<?php echo $post->post_title;?>
											<?php }?>
											</a>
											<?php $first_shown = true;?>
										<?php }?>
									<?php break;
									case 'youtube':?>
										<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager-fancybox-movie-wrap" title="<?php echo $post->post_title;?>"><?php echo $post->post_title;?></a>
									<?php break;
									case 'vimeo':?>
										<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager-fancybox-movie-wrap" title="<?php echo $post->post_title;?>"><?php echo $post->post_title;?></a>
									<?php break;
									case 'soundcloud':?>
										<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager-fancybox-movie-wrap" title="<?php echo $post->post_title;?>"><?php echo $post->post_title;?></a>
									<?php break;
								}?>
							<?php }elseif( isset( $this->listOptions['title_link'] ) && in_array( $this->listOptions['title_link'], array( 'single' ) ) ){?>
								<a href="<?php echo $permaLink?>"><?php echo $post->post_title;?></a>
							<?php }else{ ?>
							<?php echo $post->post_title;?>
							<?php } ?>
							
							</h3>
						</div>
						<!-- End Portfolio Title -->
						<!-- Portfolio Info -->
						<?php echo $this->buildInterfaceMetaItems( $this->metaItems, $post );?>
						<!-- End Portfolio Info -->
						<!-- Portfolio Content -->
						<div class="otw_portfolio_manager-portfolio-content">
							<p>
							<?php
								( !empty( $post->post_excerpt ) )? $postContentFull = $post->post_excerpt : $postContentFull = $post->post_content;
								
								$postContent = $postContentFull;
								
								$strip_tags = false;
								
								if( !isset( $this->listOptions['strip_tags'] ) || ( $this->listOptions['strip_tags'] != 'no' ) ){
									$postContent = strip_tags( $postContent );
									$strip_tags = true;
								}
								
								if( !isset( $this->listOptions['strip_shortcodes'] ) || ( $this->listOptions['strip_shortcodes'] != 'no' ) ){
									$postContent = strip_shortcodes( $postContent );
								}else{
									$postContent = do_shortcode($postContent);
								}
								
								if( !empty( $this->listOptions['excerpt_length'] ) ){
									$postContent = $this->excerptLength( $postContent, $this->listOptions['excerpt_length'], $strip_tags );
								}
								
								echo nl2br( $postContent );
							?>
							</p>
							<div class="pm_clear"></div>
							<?php (!empty($this->listOptions['continue_reading']))?  $read_link = $this->listOptions['continue_reading'] : $read_link = __('View project →', 'otw-portfolio-manager');?>
							<a href="<?php echo get_permalink($post->ID);?>" class="otw_portfolio_manager-portfolio-continue-reading"><?php echo $read_link?></a>
						</div>
						<!-- End Portfolio Content -->
					</div>
					<!-- End Portfolio Overlay -->
			<?php break;
			case 'otw_portfolio_manager-hover-effect-18':
			case 'otw_portfolio_manager-hover-effect-19':?>
					<!-- Portfolio Overlay -->
					<div class="otw_portfolio_manager-portfolio-overlay">
						<div class="otw_portfolio_manager-portfolio-title-with-meta">
							<!-- Portfolio Title -->
							<div class="otw_portfolio_manager-portfolio-title-wrapper">
								<h3 class="otw_portfolio_manager-portfolio-title">
								<?php if( isset( $this->listOptions['title_link'] ) && in_array( $this->listOptions['title_link'], array( 'lightbox' ) ) ){?>
									<?php switch( $postMetaData['media_type'] ){
										case 'img':?>
											<a href="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $imageLightboxWidth, $imageLightboxHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $imageLightboxFormat )?>" class="otw_portfolio_manager-fancybox-img" title="<?php echo $post->post_title;?>"><?php echo $post->post_title;?></a>
										<?php break;
										case 'slider':?>
											<?php $first_shown = false; ?>
											<?php foreach( $sliderImages as $sImage ){?>
												<?php $imagePath = parse_url( $sImage );?>
												<a href="<?php echo $this->otwImageCrop->resize( $imagePath['path'], $imageLightboxWidth, $imageLightboxHeight, $this->imageCrop, $this->imageWhiteSpaces, $this->imageBackground, $imageLightboxFormat )?>" rel="otw_fslide_<?php echo $post->ID?>" title="<?php echo htmlentities( $post->post_title );?>" class="otw_in_slider otw_in_slider_<?php echo intval( $first_shown )?>" >
												<?php if( !$first_shown ){?>
												<?php echo $post->post_title;?>
												<?php }?>
												</a>
												<?php $first_shown = true;?>
											<?php }?>
										<?php break;
										
										case 'youtube':?>
											<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager-fancybox-movie-wrap" title="<?php echo $post->post_title;?>"><?php echo $post->post_title;?></a>
										<?php break;
										case 'vimeo':?>
											<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager-fancybox-movie-wrap" title="<?php echo $post->post_title;?>"><?php echo $post->post_title;?></a>
										<?php break;
										case 'soundcloud':?>
											<a href="javascript:;" rel="<?php echo $itemMediaLink?>" class="otw_portfolio_manager-fancybox-movie-wrap" title="<?php echo $post->post_title;?>"><?php echo $post->post_title;?></a>
										<?php break;
									}?>
								<?php }elseif( isset( $this->listOptions['title_link'] ) && in_array( $this->listOptions['title_link'], array( 'single' ) ) ){?>
									<a href="<?php echo $permaLink?>"><?php echo $post->post_title;?></a>
								<?php }else{ ?>
								<?php echo $post->post_title;?>
								<?php } ?>
								</h3>
							</div>
							<!-- End Portfolio Title -->
							<!-- Portfolio Info -->
							<?php echo $this->buildInterfaceMetaItems( $this->metaItems, $post );?>
							<!-- End Portfolio Info -->
						</div>

						<!-- Portfolio Content -->
						<div class="otw_portfolio_manager-portfolio-content">
							<p>
							<?php
								( !empty( $post->post_excerpt ) )? $postContentFull = $post->post_excerpt : $postContentFull = $post->post_content;
								$postContent = $postContentFull;
								if( !empty($this->listOptions['excerpt_length']) ) {
									$postContent = $this->excerptLength( $postContentFull, $this->listOptions['excerpt_length'] );
								}
								echo nl2br( strip_tags($postContent) );
							?>
							</p>
						</div>
						<!-- End Portfolio Content -->
					</div>
					<!-- End Portfolio Overlay -->
			<?php break;
		}?>
	<?php }?>
	<?php if( $this->listOptions['show-post-icon'] ) : ?>
		<div class="otw_portfolio_manager-portfolio-type">
			<i class="<?php echo $icon;?>"></i>
		</div>
	<?php endif; ?>
</figure>
<div class="pm_clear"></div>