<?php

class OTW_Portfolio_Template_Shortcode_ContactUsPage extends OTW_Portfolio_Template_Shortcodes{

    public $form_name = 'otw-shortcode-contanct-form';
    public $form_anchor = 'otwcf-contact-us';
    private $sessions = array();

    public function __construct() {
        $this->has_custom_options = true;
        $this->get_sessions();
        parent::__construct();
        
        $this->shortcode_name = 'otw_shortcode_contactuspage';
    }

    private function get_sessions() {
        $sessions = get_option($this->form_name . '_sessions');
        if (!is_array($sessions)) {
            $sessions = array();
        }
        $this->sessions = array();
        foreach ($sessions as $session_time) {
            if ($session_time > strtotime('now -1 hour')) {
                $this->sessions[] = $session_time;
            }
        }
    }

    /**
     * register external libs
     */
    public function register_external_libs() {

        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 100);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/recaptcha.css', 'all', 110);
        $this->add_external_lib('js', 'otw-shortcode-core', $this->component_url . 'js/otw_shortcode_core.js', 'all', 99, array('jquery'));
        $this->add_external_lib('js', 'otw-shortcode', $this->component_url . 'js/otw_shortcode.js', 'front', 100);
        $this->add_external_lib('js', 'otw-shortcode_live_preview', $this->component_url . 'js/otw_shortcode_live_preview.js', 'live_preview', 200);
        $this->add_external_lib('css', 'otw-shortcode_scrolling', $this->component_url . 'css/scroll_for_preview.css', 'all', 130);
    }

    /**
     * apply settings
     */
    public function apply_settings() {

        $this->settings = array(
            'sendcopy' => array(
                'yes' => $this->get_label('yes(default)'),
                'no' => $this->get_label('no')
            ),
            'default_sendcopy' => 'yes',
            //aligment of content and content
            'vertical_align' => array(
                'otw-b-contact otw-b-contact-horizontal otw-b-contact-padding otw-row' => $this->get_label('Horizontal (default)'),
                'otw-b-contact otw-b-contact-vertical otw-b-contact-padding' => $this->get_label('Vertical')
            ),
            'default_vertical_align' => 'otw-b-contact otw-b-contact-horizontal otw-row',
            'recaptcha' => array(
                'yes' => $this->get_label('yes'),
                'no' => $this->get_label('no(default)')
            ),
            'default_recaptcha' => 'no',
            'default_success_msg' => 'Message sent.',
            'default_error_msg' => ' One or more errors found.',
            'default_field_error_msg' => 'Fill this field in'
        );
        $this->_applyBoxBackgroundPattern();
        $this->_applyBoxBackgrounds();
        $this->_applyBoxBorderColors();
        $this->_applyBoxBorderStyle();
        $this->_applyBoxBorderType();
        $this->_applyBoxBorderWidth();
        $this->_applyBoxRoundedCourners();
        $this->_applyBoxShadow();
        $this->_applyButtonBackgrounds();
        $this->_applyContentLinkColor();
    }

    /**
     * Shortcode admin interface
     */
    public function build_shortcode_editor_options() {

        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }
        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-vertical_align', 'label' => $this->get_label('Contact us Type'), 'description' => $this->get_label('Choose from Horizontal or Vertical contact us page.'), 'parse' => $source, 'options' => $this->settings['vertical_align'], 'value' => $this->settings['default_vertical_align']));
        $html .= $this->_generateTextArea('content', 'Content', 'The content text. HTML is allowed. ', $source);
        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-content_link_color', 'label' => $this->get_label('Button Text Color '), 'description' => $this->get_label('Choose button text color.'), 'parse' => $source, 'options' => $this->settings['content_link_color'], 'value' => $this->settings['default_content_link_color']));
        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-content_button_background', 'label' => $this->get_label('Button Color'), 'description' => $this->get_label('Choose button color.'), 'parse' => $source, 'options' => $this->settings['content_button_background'], 'value' => $this->settings['default_content_button_background']));
//        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-box_brd_width', 'label' => $this->get_label('Box Border Width'), 'description' => $this->get_label('Choose box border width.'), 'parse' => $source, 'options' => $this->settings['box_brd_width'], 'value' => $this->settings['default_box_brd_width']));
        //Choose Box Border Style.
        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-box_brd_style', 'label' => $this->get_label('Box Border Style'), 'description' => $this->get_label('Choose box border style.'), 'parse' => $source, 'options' => $this->settings['box_brd_style'], 'value' => $this->settings['default_box_brd_style']));
        //Choose Box Border Type.
        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-box_brd_type', 'label' => $this->get_label('Box Border Type'), 'description' => $this->get_label('Choose box border type.'), 'parse' => $source, 'options' => $this->settings['box_brd_type'], 'value' => $this->settings['default_box_brd_type']));
        //Choose Box Border Color.
        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-box_brd_color', 'label' => $this->get_label('Box Border Color'), 'description' => $this->get_label('Choose box border color.'), 'parse' => $source, 'options' => $this->settings['box_brd_color'], 'value' => $this->settings['default_box_brd_color']));
        //Choose Box Shadow.
        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-box_shadow', 'label' => $this->get_label('Box Shadow'), 'description' => $this->get_label('Choose box shadow.'), 'parse' => $source, 'options' => $this->settings['box_shadow'], 'value' => $this->settings['default_box_shadow']));
        //Choose Box Rounded Corners.
        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-box_rounded_corners', 'label' => $this->get_label('Box Rounded Corners'), 'description' => $this->get_label('Choose box rounded corners.'), 'parse' => $source, 'options' => $this->settings['box_rounded_corners'], 'value' => $this->settings['default_box_rounded_corners']));
        //Choose Box Background Color.
        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-box_bgr', 'label' => $this->get_label('Box Background Color'), 'description' => $this->get_label('Choose box background color.'), 'parse' => $source, 'options' => $this->settings['box_bgr'], 'value' => $this->settings['default_box_bgr']));

        //Choose Box Background Pattern. 
        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-box_bgr_pattern', 'label' => $this->get_label('Box Background Pattern'), 'description' => $this->get_label('Choose box background pattern.'), 'parse' => $source, 'options' => $this->settings['box_bgr_pattern'], 'value' => $this->settings['default_box_bgr_pattern']));

        $html .= OTW_Form::text_input(array('id' => 'otw-shortcode-element-sendfrom', 'label' => $this->get_label('Email to send from'), 'description' => $this->get_label('The email address to send mails from.'), 'parse' => $source));
        $html .= OTW_Form::text_input(array('id' => 'otw-shortcode-element-fromtext', 'label' => $this->get_label('From text'), 'description' => $this->get_label('Sender name.'), 'parse' => $source));
        $html .= OTW_Form::text_input(array('id' => 'otw-shortcode-element-sendfromto', 'label' => $this->get_label('Email to Send to'), 'description' => $this->get_label('The email address that will receive all mails that are send form the form.'), 'parse' => $source));
        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-sendcopy', 'label' => $this->get_label('Send copy'), 'description' => $this->get_label('Enable "Send a copy of this email to yourself" checkbox.'), 'parse' => $source, 'options' => $this->settings['sendcopy'], 'value' => $this->settings['default_sendcopy']));
        $html .= OTW_Form::select(array('id' => 'otw-shortcode-element-recaptcha', 'label' => $this->get_label('Enable reCAPTCHA'), 'description' => $this->get_label('Enables reCAPTCHA. More info on reCAPTCHA <a href="http://www.google.com/recaptcha">here</a>'), 'parse' => $source, 'options' => $this->settings['recaptcha'], 'value' => $this->settings['default_recaptcha']));
        $html .= OTW_Form::text_input(array('id' => 'otw-shortcode-element-recaptcha_public_key', 'label' => $this->get_label('reCAPTCHA public key'), 'description' => $this->get_label('Enter reCAPTCHA publick key'), 'parse' => $source));
        $html .= OTW_Form::text_input(array('id' => 'otw-shortcode-element-recaptcha_private_key', 'label' => $this->get_label('reCAPTCHA private key'), 'description' => $this->get_label('Enter reCAPTCHA private key'), 'parse' => $source));
        $html .= OTW_Form::text_input(array('id' => 'otw-shortcode-element-success_msg', 'label' => $this->get_label('Success Message'), 'description' => $this->get_label('Enter success message.'), 'parse' => $source, 'value' => $this->settings['default_success_msg']));
        $html .= OTW_Form::text_input(array('id' => 'otw-shortcode-element-error_msg', 'label' => $this->get_label('Error Message'), 'description' => $this->get_label('Enter error message.'), 'parse' => $source, 'value' => $this->settings['default_error_msg']));
        $html .= OTW_Form::text_input(array('id' => 'otw-shortcode-element-field_error_msg', 'label' => $this->get_label('Field Error'), 'description' => $this->get_label('Enter field error message.'), 'parse' => $source, 'value' => $this->settings['default_field_error_msg']));
        return $html;
    }

    /**
     * Shortcode admin interface custom options
     */
    public function build_shortcode_editor_custom_options() {

        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }
        $html .= OTW_Form::color_picker(array('id' => 'otw-shortcode-element-box_custom_border_color', 'label' => $this->get_label('Box Border Color Custom'), 'description' => $this->get_label('Choose a custom box border color.'), 'parse' => $source));
        $html .= OTW_Form::color_picker(array('id' => 'otw-shortcode-element-box_custom_bgr_color', 'label' => $this->get_label('Box Background Color Custom'), 'description' => $this->get_label('Choose a custom box background color.'), 'parse' => $source));
        $html .= OTW_Form::uploader(array('id' => 'otw-shortcode-element-box_custom_bgr_pattern', 'label' => $this->get_label('Box Background Pattern URL'), 'description' => $this->get_label('URL to a custom box background pattern. '), 'parse' => $source));
        $html .= OTW_Form::color_picker(array('id' => 'otw-shortcode-element-box_custom_button_color', 'label' => $this->get_label('Button Text Color Custom'), 'description' => $this->get_label('Choose a custom text color for submit button.'), 'parse' => $source));
        $html .= OTW_Form::color_picker(array('id' => 'otw-shortcode-element-box_custom_button_bg', 'label' => $this->get_label('Button Background Color Custom'), 'description' => $this->get_label('Choose a custom background color for submit button.'), 'parse' => $source));

        $html .= OTW_Form::text_input(array('id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label('CSS Class'), 'description' => $this->get_label('If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..'), 'parse' => $source));
        return $html;
    }

    /** build shortcode
     *
     *  @param array
     *  @return string
     */
    public function build_shortcode_code($attributes) {

        $code = '';

        if (!$this->has_error) {

            $code = '[otw_shortcode_contactuspage';
            $code .= $this->format_attribute('sendfrom', 'sendfrom', $attributes, false, '', true);
            $code .= $this->format_attribute('sendfromto', 'sendfromto', $attributes, false, '', true);
            $code .= $this->format_attribute('fromtext', 'fromtext', $attributes, false, '', true);
            $code .= $this->format_attribute('sendcopy', 'sendcopy', $attributes);
            $code .= $this->format_attribute('recaptcha', 'recaptcha', $attributes);
            $code .= $this->format_attribute('recaptcha_public_key', 'recaptcha_public_key', $attributes, false, '', true);
            $code .= $this->format_attribute('recaptcha_private_key', 'recaptcha_private_key', $attributes, false, '', true);
            $code .= $this->format_attribute('success_msg', 'success_msg', $attributes, false, '', true);
            $code .= $this->format_attribute('error_msg', 'error_msg', $attributes, false, '', true);
            $code .= $this->format_attribute('field_error_msg', 'field_error_msg', $attributes, false, '', true);
            //my owns
            $code .= $this->format_attribute('vertical_align', 'vertical_align', $attributes);
            $code .= $this->format_attribute('content_link_color', 'content_link_color', $attributes);
            $code .= $this->format_attribute('content_button_background', 'content_button_background', $attributes);
//            $code .= $this->format_attribute('box_brd_width', 'box_brd_width', $attributes);
            $code .= $this->format_attribute('box_brd_style', 'box_brd_style', $attributes);
            $code .= $this->format_attribute('box_brd_type', 'box_brd_type', $attributes);
            $code .= $this->format_attribute('box_brd_color', 'box_brd_color', $attributes);
            $code .= $this->format_attribute('box_shadow', 'box_shadow', $attributes);
            $code .= $this->format_attribute('box_rounded_corners', 'box_rounded_corners', $attributes);
            $code .= $this->format_attribute('box_bgr', 'box_bgr', $attributes);
            $code .= $this->format_attribute('box_bgr_pattern', 'box_bgr_pattern', $attributes);
            $code .= $this->format_attribute('content', 'content', $attributes, false, '', true);

            $code .= $this->format_attribute('box_custom_border_color', 'box_custom_border_color', $attributes, false);
            $code .= $this->format_attribute('box_custom_bgr_color', 'box_custom_bgr_color', $attributes, false);
            $code .= $this->format_attribute('box_custom_bgr_pattern', 'box_custom_bgr_pattern', $attributes, false);
            $code .= $this->format_attribute('box_custom_button_color', 'box_custom_button_color', $attributes, false);
            $code .= $this->format_attribute('box_custom_button_bg', 'box_custom_button_bg', $attributes, false);
            $code .= $this->format_attribute('css_class', 'css_class', $attributes, false);
            $code .= ']';
            $code .= '[/otw_shortcode_contactuspage]';
        }
        return $code;
    }

    /**
     * Display shortcode
     */
    public function display_shortcode($attributes, $content) {
        //default form element values
        $field_values = array();
        $field_values['contactName'] = '';
        $field_values['email'] = '';
        $field_values['subject'] = '';
        $field_values['comments'] = '';
        $field_values['sendCopy'] = false;

        //field errors
        $field_errors = array();
        $field_errors['contactName'] = '';
        $field_errors['email'] = '';
        $field_errors['subject'] = '';
        $field_errors['comments'] = '';
        $field_errors['sendCopy'] = '';
        $field_errors['recaptcha'] = '';

        if ($this->format_attribute('', 'recaptcha', $attributes, false, '') != 'no') {
            include_once( $this->component_path . 'libs/recaptcha-php-1.11/recaptchalib.php' );
        }

        $is_valid = true;
        $mail_sent = false;

        if (isset($_POST) && isset($_POST[$this->form_name]) && otw_validator::is_unsigned($_POST[$this->form_name]) && !in_array($_POST[$this->form_name], $this->sessions)) {

            if (isset($_POST['contactName'])) {
                $field_values['contactName'] = otw_stripslashes($_POST['contactName']);
            }
            if (isset($_POST['email'])) {
                $field_values['email'] = $_POST['email'];
            }
            if (isset($_POST['subject'])) {
                $field_values['subject'] = otw_stripslashes($_POST['subject']);
            }
            if (isset($_POST['comments'])) {
                $field_values['comments'] = otw_stripslashes($_POST['comments']);
            }
            if (isset($_POST['sendCopy'])) {
                $field_values['sendCopy'] = $_POST['sendCopy'];
            }
            if ($this->format_attribute('', 'recaptcha', $attributes, false, '') != 'no') {

                if (isset($_POST["recaptcha_challenge_field"])) {

                    $resp = recaptcha_check_answer($this->format_attribute('', 'recaptcha_private_key', $attributes, false, ''), $_SERVER["REMOTE_ADDR"], $_POST["recaptcha_challenge_field"], $_POST["recaptcha_response_field"]);

                    if (!$resp->is_valid) {
                        $is_valid = false;
                        $field_errors['recaptcha'] = $this->get_label('You entered an invalid captcha.');
                    }
                }
            }

            if (otw_validator::is_empty($field_values['contactName'])) {
                $is_valid = false;
                $field_errors['contactName'] = $this->format_attribute('', 'field_error_msg', $attributes, false, '');
            }
            if (otw_validator::is_empty($field_values['email'])) {
                $is_valid = false;
                $field_errors['email'] = $this->format_attribute('', 'field_error_msg', $attributes, false, '');
            } elseif (!otw_validator::is_email($field_values['email'])) {
                $is_valid = false;
                $field_errors['email'] = $this->get_label('You entered an invalid email address.');
            }
            if (otw_validator::is_empty($field_values['comments'])) {
                $is_valid = false;
                $field_errors['comments'] = $this->format_attribute('', 'field_error_msg', $attributes, false, '');
            }
            //sending of admin
            if ($is_valid) {
                $emailFrom = $this->format_attribute('', 'sendfrom', $attributes, false, '');
                $emailTo = $this->format_attribute('', 'sendfromto', $attributes, false, '');
                if (!otw_validator::is_empty($field_values['subject'])) {
                    $subject = $field_values['subject'];
                } else {
                    $subject = $this->get_label('Contact from') . ' ' . get_bloginfo('title');
                }
                $body = $this->get_label('Name:') . ' ' . $field_values['contactName'];
                $body .= "\n\n" . $this->get_label('Email:') . ' ' . $field_values['email'];
                $body .= "\n\n" . $this->get_label('Comments:') . ' ' . $field_values['comments'];
                $fromtext = $this->format_attribute('', 'fromtext', $attributes, false, '');
                //chose name;
                if (strlen($fromtext) > 0) {
                    $name = $fromtext;
                } else {
                    $name = get_bloginfo('title');
                }
                $name = '=?utf-8?B?' . base64_encode($name) . '?=';
                $subject = '=?utf-8?B?' . base64_encode($subject) . '?=';
                $field_values['contactName'] = '=?utf-8?B?' . base64_encode($field_values['contactName']) . '?=';
                $headers = array();
                $headers[] = 'From: ' . $name . ' <' . $emailFrom . '>';
                $headers[] = 'Reply-To:' . $field_values['contactName'] . ' <' . $field_values['email'] . '>';

                wp_mail($emailTo, $subject, $body, $headers);

                $mail_sent = true;

                if ($field_values['sendCopy']) {
                    $headers = array();
                    if (strlen($fromtext) > 0) {
                        $name = $fromtext;
                    } else {
                        $name = get_bloginfo('title');
                    }
                    $subject = $this->get_label('You mailed ' . get_bloginfo('title') . ': ') . $field_values['subject'];
                    $headers[] = 'From: ' . $name . ' <' . $emailFrom . '>';
                    $headers[] = 'Reply-To:' . $name . ' <' . $emailTo . '> ';

                    wp_mail($field_values['email'], $subject, $body, $headers);
                }

                $this->sessions[] = $_POST[$this->form_name];

                update_option($this->form_name . '_sessions', $this->sessions);

                $field_values['contactName'] = '';
                $field_values['email'] = '';
                $field_values['subject'] = '';
                $field_values['comments'] = '';
                $field_values['sendCopy'] = false;
            }
        }

        $html = '';
        if (!$is_valid) {
            if ($error_msg = $this->format_attribute('', 'error_msg', $attributes, false, '')) {
                $html .= '<div class="otw-row">';
                $html .= otw_form::message('error', $this->get_label('Error'), $error_msg);
                $html .= '</div>';
            }
        }

        if ($mail_sent) {
            if ($success_msg = $this->format_attribute('', 'success_msg', $attributes, false, '')) {
                $html .= '<div class="otw-row">';
                $html .= otw_form::message('success', $this->get_label('Success'), $success_msg);
                $html .= '</div>';
            }
        }

        $html .= '<div';
        /* class attributes */
        $class = 'otw-sc-contact-form';
        $class .= $this->format_attribute('', 'css_class', $attributes, false, $class);
//        $class = $this->append_attribute($class, $this->format_attribute('', 'box_brd_width', $attributes));
        if (strlen($this->format_attribute('', 'box_brd_style', $attributes)) > 0 && strlen($this->format_attribute('', 'box_brd_type', $attributes)) > 0) {
            $class = $this->append_attribute($class, $this->format_attribute('', 'box_brd_style', $attributes));
            $class = $this->append_attribute($class, $this->format_attribute('', 'box_brd_type', $attributes));
        }
        $class = $this->append_attribute($class, $this->format_attribute('', 'box_brd_color', $attributes));
        $class = $this->append_attribute($class, $this->format_attribute('', 'box_shadow', $attributes));
        $class = $this->append_attribute($class, $this->format_attribute('', 'box_rounded_corners', $attributes));
        $class = $this->append_attribute($class, $this->format_attribute('', 'box_bgr', $attributes));
        $class = $this->append_attribute($class, $this->format_attribute('', 'box_bgr_pattern', $attributes));
        if (strlen($class)) {
            $html .= ' class="' . $class . '"';
        }
        /* end class attributes */

        /* style attribute */
        $style = '';
        if (strlen($this->format_attribute('', 'box_custom_border_color', $attributes)) > 0) {
            $style = $this->append_attribute($style, 'border-color: ' . $this->format_attribute('', 'box_custom_border_color', $attributes) . '!important;');
        }
        if (strlen($this->format_attribute('', 'box_custom_bgr_color', $attributes)) > 0) {
            $style = $this->append_attribute($style, 'background-color: ' . $this->format_attribute('', 'box_custom_bgr_color', $attributes) . '!important;');
        }
        if (strlen($this->format_attribute('', 'box_custom_bgr_pattern', $attributes)) > 0) {
            $style = $this->append_attribute($style, 'background-image: url(' . $this->format_attribute('', 'box_custom_bgr_pattern', $attributes) . ')!important;');
        }
        if (strlen($style) > 0) {
            $html .= ' style="' . $style . '"';
        }
        $html .= '>';

        $html .= '<a id="' . $this->form_anchor . '" id="' . $this->form_anchor . '"></a>';

        $masterclass = '';
        $masterclass = $this->append_attribute($masterclass, $this->format_attribute('', 'vertical_align', $attributes));


        //open general dom of shrotcode container
        $html .= '<div class="' . $masterclass . '">';

        $content_classes = '';
        $form_content_classes = '';
        $leftfield_class = '';
        $rightfield_class = '';
        $bottom_class = '';
        //open dom for content container
        if ($this->format_attribute('', 'vertical_align', $attributes) == 'otw-b-contact otw-b-contact-horizontal otw-b-contact-padding otw-row') {
            $content_classes = 'otw-eight otw-columns';
            $form_content_classes = 'otw-sixteen otw-columns otw-row';
            $leftfield_class = 'otw-twelve otw-columns';
            $rightfield_class = 'otw-twelve otw-columns';
            $bottom_class = 'otw-twentyfour otw-columns';
        }
        $html .= '<div class="' . $content_classes . '">';
        $html .= otw_htmlentities_decode($this->format_attribute('', 'content', $attributes));
        $html .= '</div>';

        //open dom for form container 
        $html .= '<div class="' . $form_content_classes . '">';

        $html .= '<form method="post" id="' . $this->form_name . '" action="#' . $this->form_anchor . '">';
        $html .= '<input type="hidden" name="' . $this->form_name . '" value="' . time() . '"/>';

        //contact name form element DOM
        $html .= '<div class="' . $leftfield_class . '">';
        $html .= '<label for="contactName">Name<span class="additional required">*</span>';
        $html .= '</label>';
        $html .= '<input type="text" class="txt requiredField" name="contactName" id="contactName" value="' . otw_htmlentities($field_values['contactName']) . '" >';
        if ($field_errors['contactName']) {
            $html .= otw_form::message('red_text', $this->get_label('Error'), $field_errors['contactName']);
        }
        $html .= '</div>';

        //email value form DOM element
        $html .= '<div class="' . $rightfield_class . '">';
        $html .= '<label for="email">Email<span class="additional required">*</span></label>';
        $html .= '<input type="text" name="email" id="email" value="' . otw_htmlentities($field_values['email']) . '" class="txt requiredField email" .>';
        if ($field_errors['email']) {
            $html .= otw_form::message('red_text', $this->get_label('Error'), $field_errors['email']);
        }
        $html .= '</div>';

        //subject and other element container DOM 
        $html .= '<div class="' . $bottom_class . '">';
        $html .= '<label for="subject">Subject<span class="additional">(optional)</span></label>';
        $html .= '<input type="text" name="subject" id="subject" value="' . otw_htmlentities($field_values['subject']) . '" class="txt requiredField email" />';
        if ($field_errors['subject']) {
            $html .= otw_form::message('red_text', $this->get_label('Error'), $field_errors['subject']);
        }
        //textarea form DOM for  comment
        $html .= '<label for="commentsText">Message<span class="additional required">*</span></label>';
        $html .= '<textarea name="comments" id="commentsText" rows="8" cols="30" class="requiredField">' . $field_values['comments'] . '</textarea>';
        if ($field_errors['comments']) {
            $html .= otw_form::message('red_text', $this->get_label('Error'), $field_errors['comments']);
        }

        //if isset recaptcha add DOM
        if ($this->format_attribute('', 'recaptcha', $attributes, false, '') != 'no') {
            $html .= '<div id="recaptcha_widget" class="otw_recaptcha_conteniner">';
            
            $html .= recaptcha_get_html($this->format_attribute('', 'recaptcha_public_key', $attributes, false, ''));
            if ($field_errors['recaptcha']) {
                $html .= otw_form::message('red_text', $this->get_label('Error'), $field_errors['recaptcha']);
            }
            $html .= '</div>';
        }
        //additional form DOM features
        $html .= '<span class="additional required">* this field is mandatory</span>';
        if ($this->format_attribute('', 'sendcopy', $attributes, false, '') != 'no') {
            $html .= '<input type="checkbox" class="checkbox" name="sendCopy" ' . ( $field_values['sendCopy'] ? ' checked="checked"' : '' ) . ' id="sendCopy" value="true"><label class="inline" for="sendCopy">' . $this->get_label('Send a copy of this email to yourself') . '</label>';
        }
        $html .= '</label>';

        $button_style = '';
        if (strlen($this->format_attribute('', 'box_custom_button_color', $attributes)) > 0) {
            $button_style = $this->append_attribute($button_style, 'color: ' . $this->format_attribute('', 'box_custom_button_color', $attributes) . '!important;');
        }
        if (strlen($this->format_attribute('', 'box_custom_button_bg', $attributes)) > 0) {
            $button_style = $this->append_attribute($button_style, 'background-color: ' . $this->format_attribute('', 'box_custom_button_bg', $attributes) . '!important;');
        }

        //setup call to action submit button
        $button_class = 'radius otw-button button';
        $button_class = $this->append_attribute($button_class, $this->format_attribute('', 'content_link_color', $attributes));
        $button_class = $this->append_attribute($button_class, $this->format_attribute('', 'content_button_background', $attributes));
        $html .= '<button style="' . $button_style . '" type="submit" class="' . $button_class . '">Submit</button>';
        $html .= '</div>';
        $html .= '</form>';
        $html .= '</div>';

        $html .= '</div>';
        $html .= '</div>';


        return $this->format_shortcode_output($html);
    }

}
