<?php
/**
 * The template for displaying paging style navigation
 *
 * @package WordPress
 * @subpackage Theme_Name
 * @since Theme_Version 1.0
 */
global $wp_query, $wp_rewrite;
$paged = get_query_var('paged') ? intval(get_query_var('paged')) : 1;
$pagenum_link = html_entity_decode(get_pagenum_link());
$query_args = array();
$url_parts = explode('?', $pagenum_link);

if (isset($url_parts[1])) {
    wp_parse_str($url_parts[1], $query_args);
}

$pagenum_link = esc_url(remove_query_arg(array_keys($query_args), $pagenum_link));
$pagenum_link = trailingslashit($pagenum_link) . '%_%';

$format = $wp_rewrite->using_index_permalinks() && !strpos($pagenum_link, 'index.php') ? 'index.php/' : '';
$format .= $wp_rewrite->using_permalinks() ? user_trailingslashit($wp_rewrite->pagination_base . '/%#%', 'paged') : '?paged=%#%';

?>
<div class="paging-navigation-wrap clearfix">
    <?php
    $posts_per_page = get_option('posts_per_page');
    $count_posts = wp_count_posts();
    $published_posts = $count_posts->publish;
    if(!isset($max_items)) {
        $max_items = $published_posts;
    }
    if(!empty($items_per_page)) {
        $posts_per_page = $items_per_page;
    }
    $found_post = $wp_query->found_posts;
    if(!empty($max_items) && $found_post < $max_items) {
        $max_items = $found_post;
    } else {
        $wp_query->found_posts = $max_items;
    }
    $total_nav = ceil($max_items/$posts_per_page);
    if($paged == $total_nav) {
        $posts_per_page = $max_items%$posts_per_page == 0 ? $posts_per_page : $max_items%$posts_per_page;
    }
    ?>
    <div class="posts-per-page">
        <?php echo wp_kses_post(__('Show ', 'g5-organiz')) . '<span>' . $posts_per_page . wp_kses_post(__(' Items', 'g5-organiz')) . '</span>' . wp_kses_post(__(' of ', 'g5-organiz')) . $max_items . wp_kses_post(__(' Items', 'g5-organiz')) ?>
    </div>
    <div class="paging-navigation">
        <?php echo paginate_links(array(
            'base'      => $pagenum_link,
            'format'    => $format,
            'total'     => $total_nav,
            'current'   => $paged,
            'mid_size'  => 1,
            'add_args'  => array_map('urlencode', $query_args),
            'prev_text' => wp_kses_post(__('<i class="fa fa-angle-left"></i>', 'g5-organiz')),
            'next_text' => wp_kses_post(__('<i class="fa fa-angle-right"></i>', 'g5-organiz')),
        )); ?>
    </div>
</div>
